/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log;

import java.util.Arrays;
import java.util.List;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordReader;
import org.apache.hudi.common.table.log.KeySpec;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.expression.Expression;
import org.apache.hudi.expression.Literal;
import org.apache.hudi.expression.Predicates;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestHoodieMergedLogRecordReader {
    TestHoodieMergedLogRecordReader() {
    }

    @Test
    void testCreateKeySpecWithEmptyOutput() {
        Option r = HoodieMergedLogRecordReader.createKeySpec((Option)Option.empty());
        Assertions.assertTrue((boolean)r.isEmpty());
    }

    @Test
    void testCreateKeySpecWithKeys() {
        Literal left = Literal.from((Object)"key1");
        List<Expression> right = Arrays.asList(Literal.from((Object)"key1"), Literal.from((Object)"key2"));
        Predicates.In predicate = Predicates.in((Expression)left, right);
        Option r = HoodieMergedLogRecordReader.createKeySpec((Option)Option.of((Object)predicate));
        Assertions.assertTrue((boolean)r.isPresent());
        Assertions.assertTrue((boolean)((KeySpec)r.get()).isFullKey());
        Assertions.assertEquals(Arrays.asList("key1", "key2"), (Object)((KeySpec)r.get()).getKeys());
    }

    @Test
    void testCreateKeySpecWithKeyPrefixes() {
        Literal left = Literal.from((Object)"key1");
        List<Expression> right = Arrays.asList(Literal.from((Object)"key_prefix1"), Literal.from((Object)"key_prefix2"));
        Predicates.StringStartsWithAny predicate = Predicates.startsWithAny((Expression)left, right);
        Option r = HoodieMergedLogRecordReader.createKeySpec((Option)Option.of((Object)predicate));
        Assertions.assertTrue((boolean)r.isPresent());
        Assertions.assertFalse((boolean)((KeySpec)r.get()).isFullKey());
        Assertions.assertEquals(Arrays.asList("key_prefix1", "key_prefix2"), (Object)((KeySpec)r.get()).getKeys());
    }
}

