/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log.block;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.apache.avro.SchemaBuilder;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.log.block.HoodieAvroDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.io.ByteBufferBackedInputStream;
import org.apache.hudi.io.ByteArraySeekableDataInputStream;
import org.apache.hudi.io.SeekableDataInputStream;
import org.apache.hudi.storage.HoodieStorage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class TestHoodieLogBlock {
    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3})
    public void testErrorHandlingInInflate(int numReadFailTimes) throws IOException {
        int position = 20;
        int blockSize = 1000;
        SeekableDataInputStream stream = this.prepareMockedLogInputStream(blockSize, numReadFailTimes);
        Supplier<SeekableDataInputStream> inputStreamSupplier = () -> stream;
        HoodieAvroDataBlock dataBlock = new HoodieAvroDataBlock(inputStreamSupplier, Option.empty(), true, new HoodieLogBlock.HoodieLogBlockContentLocation((HoodieStorage)Mockito.mock(HoodieStorage.class), new HoodieLogFile("log_file"), (long)position, (long)blockSize, (long)(position + blockSize)), Option.of((Object)SchemaBuilder.builder().record("test_schema").fields().endRecord()), Collections.emptyMap(), Collections.emptyMap(), "key");
        Assertions.assertFalse((boolean)dataBlock.getContent().isPresent());
        dataBlock.inflate();
        byte[] expected = this.expectedContent(blockSize);
        Option actual = dataBlock.getContent();
        Assertions.assertTrue((boolean)actual.isPresent());
        Assertions.assertArrayEquals((byte[])expected, (byte[])((byte[])actual.get()));
    }

    @Test
    public void testHeaderMetadata() throws IOException {
        HashMap<HoodieLogBlock.HeaderMetadataType, String> a = new HashMap<HoodieLogBlock.HeaderMetadataType, String>();
        a.put(HoodieLogBlock.HeaderMetadataType.INSTANT_TIME, "100");
        a.put(HoodieLogBlock.HeaderMetadataType.TARGET_INSTANT_TIME, "1");
        a.put(HoodieLogBlock.HeaderMetadataType.SCHEMA, "{}");
        a.put(HoodieLogBlock.HeaderMetadataType.COMMAND_BLOCK_TYPE, "rollback");
        a.put(HoodieLogBlock.HeaderMetadataType.COMPACTED_BLOCK_TIMES, "1");
        a.put(HoodieLogBlock.HeaderMetadataType.RECORD_POSITIONS, "");
        a.put(HoodieLogBlock.HeaderMetadataType.BLOCK_IDENTIFIER, "1");
        a.put(HoodieLogBlock.HeaderMetadataType.IS_PARTIAL, "true");
        byte[] bytes = HoodieLogBlock.getHeaderMetadataBytes(a);
        Map b = HoodieLogBlock.getHeaderMetadata((SeekableDataInputStream)new ByteArraySeekableDataInputStream(new ByteBufferBackedInputStream(bytes)));
        Assertions.assertEquals((Object)"100", b.get(HoodieLogBlock.HeaderMetadataType.INSTANT_TIME));
        Assertions.assertEquals((Object)"1", b.get(HoodieLogBlock.HeaderMetadataType.TARGET_INSTANT_TIME));
        Assertions.assertEquals((Object)"{}", b.get(HoodieLogBlock.HeaderMetadataType.SCHEMA));
        Assertions.assertEquals((Object)"rollback", b.get(HoodieLogBlock.HeaderMetadataType.COMMAND_BLOCK_TYPE));
        Assertions.assertEquals((Object)"1", b.get(HoodieLogBlock.HeaderMetadataType.COMPACTED_BLOCK_TIMES));
        Assertions.assertEquals((Object)"", b.get(HoodieLogBlock.HeaderMetadataType.RECORD_POSITIONS));
        Assertions.assertEquals((Object)"1", b.get(HoodieLogBlock.HeaderMetadataType.BLOCK_IDENTIFIER));
        Assertions.assertEquals((Object)"true", b.get(HoodieLogBlock.HeaderMetadataType.IS_PARTIAL));
    }

    private SeekableDataInputStream prepareMockedLogInputStream(int contentSize, int numReadFailTimes) throws IOException {
        IOException exception = new IOException("Read content from log file fails");
        Answer<Integer> mockedContentAnswer = this.modifyContentWithRead(contentSize);
        InputStream stream = (InputStream)Mockito.mock(InputStream.class);
        switch (numReadFailTimes) {
            case 0: {
                Mockito.when((Object)stream.read((byte[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)contentSize))).thenAnswer(mockedContentAnswer);
                break;
            }
            case 1: {
                Mockito.when((Object)stream.read((byte[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)contentSize))).thenThrow(new Throwable[]{exception}).thenAnswer(mockedContentAnswer);
                break;
            }
            case 2: {
                Mockito.when((Object)stream.read((byte[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)contentSize))).thenThrow(new Throwable[]{exception}).thenThrow(new Throwable[]{exception}).thenAnswer(mockedContentAnswer);
                break;
            }
            case 3: {
                Mockito.when((Object)stream.read((byte[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)contentSize))).thenThrow(new Throwable[]{exception}).thenThrow(new Throwable[]{exception}).thenThrow(new Throwable[]{exception}).thenAnswer(mockedContentAnswer);
                break;
            }
            default: {
                throw new IllegalArgumentException("This mock does not support more than 3 failed read calls");
            }
        }
        return new SeekableDataInputStream(stream){

            public long getPos() throws IOException {
                return 0L;
            }

            public void seek(long pos) throws IOException {
            }
        };
    }

    private Answer<Integer> modifyContentWithRead(int contentSize) {
        return invocation -> {
            Object[] args = invocation.getArguments();
            byte[] content = (byte[])args[0];
            byte[] expected = this.expectedContent(contentSize);
            System.arraycopy(expected, 0, content, 0, content.length);
            return contentSize;
        };
    }

    private byte[] expectedContent(int contentSize) {
        byte[] content = new byte[contentSize];
        IntStream.range(0, contentSize).forEach(i -> {
            content[i] = (byte)(i % 256);
        });
        return content;
    }
}

