/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.engine.RecordContext;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.table.read.FileGroupReaderSchemaHandler;
import org.apache.hudi.common.table.read.ParquetRowIndexBasedSchemaHandler;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.util.DefaultJavaTypeConverter;
import org.apache.hudi.common.util.JavaTypeConverter;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.provider.Arguments;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public abstract class SchemaHandlerTestBase {
    protected static final Schema DATA_SCHEMA = HoodieAvroUtils.addMetadataFields((Schema)HoodieTestDataGenerator.AVRO_SCHEMA);
    protected static final Schema DATA_SCHEMA_NO_DELETE = SchemaHandlerTestBase.generateProjectionSchema((String[])DATA_SCHEMA.getFields().stream().map(Schema.Field::name).filter(f -> !f.equals("_hoodie_is_deleted")).toArray(String[]::new));
    protected static final Schema DATA_COLS_ONLY_SCHEMA = SchemaHandlerTestBase.generateProjectionSchema("begin_lat", "tip_history", "rider");
    protected static final Schema META_COLS_ONLY_SCHEMA = SchemaHandlerTestBase.generateProjectionSchema("_hoodie_commit_seqno", "_hoodie_record_key");
    protected final HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
    protected final HoodieTableConfig hoodieTableConfig = (HoodieTableConfig)Mockito.mock(HoodieTableConfig.class);

    @BeforeEach
    void setup() {
        Mockito.when((Object)this.metaClient.getTableConfig()).thenReturn((Object)this.hoodieTableConfig);
    }

    static Stream<Arguments> testMorParams(boolean supportsParquetRowIndex) {
        Stream.Builder<Arguments> b = Stream.builder();
        for (boolean mergeUseRecordPosition : new boolean[]{true, false}) {
            for (boolean hasBuiltInDelete : new boolean[]{true, false}) {
                b.add(Arguments.of((Object[])new Object[]{RecordMergeMode.EVENT_TIME_ORDERING, true, false, mergeUseRecordPosition, supportsParquetRowIndex, hasBuiltInDelete}));
                b.add(Arguments.of((Object[])new Object[]{RecordMergeMode.EVENT_TIME_ORDERING, false, false, mergeUseRecordPosition, supportsParquetRowIndex, hasBuiltInDelete}));
                b.add(Arguments.of((Object[])new Object[]{RecordMergeMode.COMMIT_TIME_ORDERING, false, false, mergeUseRecordPosition, supportsParquetRowIndex, hasBuiltInDelete}));
                b.add(Arguments.of((Object[])new Object[]{RecordMergeMode.CUSTOM, false, true, mergeUseRecordPosition, supportsParquetRowIndex, hasBuiltInDelete}));
                b.add(Arguments.of((Object[])new Object[]{RecordMergeMode.CUSTOM, false, false, mergeUseRecordPosition, supportsParquetRowIndex, hasBuiltInDelete}));
            }
        }
        return b.build();
    }

    public void testMor(RecordMergeMode mergeMode, boolean hasPrecombine, boolean isProjectionCompatible, boolean mergeUseRecordPosition, boolean supportsParquetRowIndex, boolean hasBuiltInDelete) throws IOException {
        String[] stringArray;
        Schema dataSchema = hasBuiltInDelete ? DATA_SCHEMA : DATA_SCHEMA_NO_DELETE;
        SchemaHandlerTestBase.setupMORTable(mergeMode, hasPrecombine, this.hoodieTableConfig);
        if (isProjectionCompatible) {
            String[] stringArray2 = new String[4];
            stringArray2[0] = "begin_lat";
            stringArray2[1] = "begin_lon";
            stringArray2[2] = "_hoodie_record_key";
            stringArray = stringArray2;
            stringArray2[3] = "timestamp";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "begin_lat";
            stringArray3[1] = "begin_lon";
            stringArray = stringArray3;
            stringArray3[2] = "timestamp";
        }
        HoodieRecordMerger merger = SchemaHandlerTestBase.mockRecordMerger(isProjectionCompatible, stringArray);
        HoodieReaderContext<String> readerContext = SchemaHandlerTestBase.createReaderContext(this.hoodieTableConfig, supportsParquetRowIndex, true, false, mergeUseRecordPosition, merger);
        readerContext.setRecordMerger(Option.of((Object)merger));
        Schema requestedSchema = dataSchema;
        FileGroupReaderSchemaHandler schemaHandler = this.createSchemaHandler(readerContext, dataSchema, requestedSchema, supportsParquetRowIndex);
        Schema expectedRequiredFullSchema = supportsParquetRowIndex && mergeUseRecordPosition ? ParquetRowIndexBasedSchemaHandler.addPositionalMergeCol((Schema)requestedSchema) : requestedSchema;
        Assertions.assertEquals((Object)expectedRequiredFullSchema, (Object)schemaHandler.getRequiredSchema());
        Assertions.assertFalse((boolean)readerContext.getNeedsBootstrapMerge());
        requestedSchema = DATA_COLS_ONLY_SCHEMA;
        schemaHandler = this.createSchemaHandler(readerContext, dataSchema, requestedSchema, supportsParquetRowIndex);
        Schema expectedRequiredSchema = mergeMode == RecordMergeMode.EVENT_TIME_ORDERING && hasPrecombine ? SchemaHandlerTestBase.generateProjectionSchema(hasBuiltInDelete, "begin_lat", "tip_history", "rider", "_hoodie_record_key", "timestamp") : (mergeMode == RecordMergeMode.EVENT_TIME_ORDERING || mergeMode == RecordMergeMode.COMMIT_TIME_ORDERING ? SchemaHandlerTestBase.generateProjectionSchema(hasBuiltInDelete, "begin_lat", "tip_history", "rider", "_hoodie_record_key") : (mergeMode == RecordMergeMode.CUSTOM && isProjectionCompatible ? SchemaHandlerTestBase.generateProjectionSchema("begin_lat", "tip_history", "rider", "begin_lon", "_hoodie_record_key", "timestamp") : dataSchema));
        if (supportsParquetRowIndex && mergeUseRecordPosition) {
            expectedRequiredSchema = ParquetRowIndexBasedSchemaHandler.addPositionalMergeCol((Schema)expectedRequiredSchema);
        }
        Assertions.assertEquals((Object)expectedRequiredSchema, (Object)schemaHandler.getRequiredSchema());
        Assertions.assertFalse((boolean)readerContext.getNeedsBootstrapMerge());
    }

    public void testMorBootstrap(RecordMergeMode mergeMode, boolean hasPrecombine, boolean isProjectionCompatible, boolean mergeUseRecordPosition, boolean supportsParquetRowIndex, boolean hasBuiltInDelete) throws IOException {
        Schema dataSchema = hasBuiltInDelete ? DATA_SCHEMA : DATA_SCHEMA_NO_DELETE;
        SchemaHandlerTestBase.setupMORTable(mergeMode, hasPrecombine, this.hoodieTableConfig);
        HoodieRecordMerger merger = SchemaHandlerTestBase.mockRecordMerger(isProjectionCompatible, new String[]{"begin_lat", "begin_lon", "timestamp"});
        HoodieReaderContext<String> readerContext = SchemaHandlerTestBase.createReaderContext(this.hoodieTableConfig, supportsParquetRowIndex, true, true, mergeUseRecordPosition, merger);
        readerContext.setRecordMerger(Option.of((Object)merger));
        Schema requestedSchema = dataSchema;
        FileGroupReaderSchemaHandler schemaHandler = this.createSchemaHandler(readerContext, dataSchema, requestedSchema, supportsParquetRowIndex);
        Schema expectedRequiredFullSchema = supportsParquetRowIndex && mergeUseRecordPosition ? ParquetRowIndexBasedSchemaHandler.addPositionalMergeCol((Schema)requestedSchema) : requestedSchema;
        Assertions.assertEquals((Object)expectedRequiredFullSchema, (Object)schemaHandler.getRequiredSchema());
        Assertions.assertTrue((boolean)readerContext.getNeedsBootstrapMerge());
        Pair bootstrapFields = schemaHandler.getBootstrapRequiredFields();
        Pair expectedBootstrapFields = FileGroupReaderSchemaHandler.getDataAndMetaCols((Schema)expectedRequiredFullSchema);
        if (supportsParquetRowIndex) {
            ((List)expectedBootstrapFields.getLeft()).add(ParquetRowIndexBasedSchemaHandler.getPositionalMergeField());
            ((List)expectedBootstrapFields.getRight()).add(ParquetRowIndexBasedSchemaHandler.getPositionalMergeField());
        }
        Assertions.assertEquals((Object)expectedBootstrapFields.getLeft(), (Object)bootstrapFields.getLeft());
        Assertions.assertEquals((Object)expectedBootstrapFields.getRight(), (Object)bootstrapFields.getRight());
        requestedSchema = SchemaHandlerTestBase.generateProjectionSchema("begin_lat", "tip_history", "_hoodie_record_key", "rider");
        schemaHandler = this.createSchemaHandler(readerContext, dataSchema, requestedSchema, supportsParquetRowIndex);
        Schema expectedRequiredSchema = mergeMode == RecordMergeMode.EVENT_TIME_ORDERING && hasPrecombine ? SchemaHandlerTestBase.generateProjectionSchema(hasBuiltInDelete, "_hoodie_record_key", "begin_lat", "tip_history", "rider", "timestamp") : (mergeMode == RecordMergeMode.EVENT_TIME_ORDERING || mergeMode == RecordMergeMode.COMMIT_TIME_ORDERING ? SchemaHandlerTestBase.generateProjectionSchema(hasBuiltInDelete, "_hoodie_record_key", "begin_lat", "tip_history", "rider") : (mergeMode == RecordMergeMode.CUSTOM && isProjectionCompatible ? SchemaHandlerTestBase.generateProjectionSchema("_hoodie_record_key", "begin_lat", "tip_history", "rider", "begin_lon", "timestamp") : dataSchema));
        if (supportsParquetRowIndex && mergeUseRecordPosition) {
            expectedRequiredSchema = ParquetRowIndexBasedSchemaHandler.addPositionalMergeCol((Schema)expectedRequiredSchema);
        }
        Assertions.assertEquals((Object)expectedRequiredSchema, (Object)schemaHandler.getRequiredSchema());
        Assertions.assertTrue((boolean)readerContext.getNeedsBootstrapMerge());
        bootstrapFields = schemaHandler.getBootstrapRequiredFields();
        expectedBootstrapFields = FileGroupReaderSchemaHandler.getDataAndMetaCols((Schema)expectedRequiredSchema);
        if (supportsParquetRowIndex) {
            ((List)expectedBootstrapFields.getLeft()).add(ParquetRowIndexBasedSchemaHandler.getPositionalMergeField());
            ((List)expectedBootstrapFields.getRight()).add(ParquetRowIndexBasedSchemaHandler.getPositionalMergeField());
        }
        Assertions.assertEquals((Object)expectedBootstrapFields.getLeft(), (Object)bootstrapFields.getLeft());
        Assertions.assertEquals((Object)expectedBootstrapFields.getRight(), (Object)bootstrapFields.getRight());
        requestedSchema = DATA_COLS_ONLY_SCHEMA;
        schemaHandler = this.createSchemaHandler(readerContext, dataSchema, requestedSchema, supportsParquetRowIndex);
        if (mergeMode == RecordMergeMode.EVENT_TIME_ORDERING && hasPrecombine) {
            expectedRequiredSchema = SchemaHandlerTestBase.generateProjectionSchema(hasBuiltInDelete, "_hoodie_record_key", "begin_lat", "tip_history", "rider", "timestamp");
            Assertions.assertTrue((boolean)readerContext.getNeedsBootstrapMerge());
        } else if (mergeMode == RecordMergeMode.EVENT_TIME_ORDERING || mergeMode == RecordMergeMode.COMMIT_TIME_ORDERING) {
            expectedRequiredSchema = SchemaHandlerTestBase.generateProjectionSchema(hasBuiltInDelete, "_hoodie_record_key", "begin_lat", "tip_history", "rider");
            Assertions.assertTrue((boolean)readerContext.getNeedsBootstrapMerge());
        } else if (mergeMode == RecordMergeMode.CUSTOM && isProjectionCompatible) {
            expectedRequiredSchema = SchemaHandlerTestBase.generateProjectionSchema("begin_lat", "tip_history", "rider", "begin_lon", "timestamp");
            Assertions.assertFalse((boolean)readerContext.getNeedsBootstrapMerge());
        } else {
            Assertions.assertTrue((boolean)readerContext.getNeedsBootstrapMerge());
            expectedRequiredSchema = dataSchema;
        }
        if (supportsParquetRowIndex && mergeUseRecordPosition) {
            expectedRequiredSchema = ParquetRowIndexBasedSchemaHandler.addPositionalMergeCol((Schema)expectedRequiredSchema);
        }
        Assertions.assertEquals((Object)expectedRequiredSchema, (Object)schemaHandler.getRequiredSchema());
        bootstrapFields = schemaHandler.getBootstrapRequiredFields();
        expectedBootstrapFields = FileGroupReaderSchemaHandler.getDataAndMetaCols((Schema)expectedRequiredSchema);
        if (supportsParquetRowIndex) {
            if (mergeMode == RecordMergeMode.CUSTOM && isProjectionCompatible) {
                if (mergeUseRecordPosition) {
                    ((List)expectedBootstrapFields.getRight()).add(ParquetRowIndexBasedSchemaHandler.getPositionalMergeField());
                }
            } else {
                ((List)expectedBootstrapFields.getLeft()).add(ParquetRowIndexBasedSchemaHandler.getPositionalMergeField());
                ((List)expectedBootstrapFields.getRight()).add(ParquetRowIndexBasedSchemaHandler.getPositionalMergeField());
            }
        }
        Assertions.assertEquals((Object)expectedBootstrapFields.getLeft(), (Object)bootstrapFields.getLeft());
        Assertions.assertEquals((Object)expectedBootstrapFields.getRight(), (Object)bootstrapFields.getRight());
        requestedSchema = META_COLS_ONLY_SCHEMA;
        schemaHandler = this.createSchemaHandler(readerContext, dataSchema, requestedSchema, supportsParquetRowIndex);
        if (mergeMode == RecordMergeMode.EVENT_TIME_ORDERING && hasPrecombine) {
            expectedRequiredSchema = SchemaHandlerTestBase.generateProjectionSchema(hasBuiltInDelete, "_hoodie_commit_seqno", "_hoodie_record_key", "timestamp");
            Assertions.assertTrue((boolean)readerContext.getNeedsBootstrapMerge());
        } else if (mergeMode == RecordMergeMode.EVENT_TIME_ORDERING || mergeMode == RecordMergeMode.COMMIT_TIME_ORDERING) {
            expectedRequiredSchema = SchemaHandlerTestBase.generateProjectionSchema(hasBuiltInDelete, "_hoodie_commit_seqno", "_hoodie_record_key");
            Assertions.assertEquals((Object)hasBuiltInDelete, (Object)readerContext.getNeedsBootstrapMerge());
        } else if (mergeMode == RecordMergeMode.CUSTOM && isProjectionCompatible) {
            expectedRequiredSchema = SchemaHandlerTestBase.generateProjectionSchema("_hoodie_commit_seqno", "_hoodie_record_key", "begin_lat", "begin_lon", "timestamp");
            Assertions.assertTrue((boolean)readerContext.getNeedsBootstrapMerge());
        } else {
            expectedRequiredSchema = dataSchema;
            Assertions.assertTrue((boolean)readerContext.getNeedsBootstrapMerge());
        }
        if (supportsParquetRowIndex && mergeUseRecordPosition) {
            expectedRequiredSchema = ParquetRowIndexBasedSchemaHandler.addPositionalMergeCol((Schema)expectedRequiredSchema);
        }
        Assertions.assertEquals((Object)expectedRequiredSchema, (Object)schemaHandler.getRequiredSchema());
        bootstrapFields = schemaHandler.getBootstrapRequiredFields();
        expectedBootstrapFields = FileGroupReaderSchemaHandler.getDataAndMetaCols((Schema)expectedRequiredSchema);
        if (supportsParquetRowIndex) {
            if (!((List)expectedBootstrapFields.getRight()).isEmpty()) {
                ((List)expectedBootstrapFields.getLeft()).add(ParquetRowIndexBasedSchemaHandler.getPositionalMergeField());
                ((List)expectedBootstrapFields.getRight()).add(ParquetRowIndexBasedSchemaHandler.getPositionalMergeField());
            } else if (mergeUseRecordPosition) {
                ((List)expectedBootstrapFields.getLeft()).add(ParquetRowIndexBasedSchemaHandler.getPositionalMergeField());
            }
        }
        Assertions.assertEquals((Object)expectedBootstrapFields.getLeft(), (Object)bootstrapFields.getLeft());
        Assertions.assertEquals((Object)expectedBootstrapFields.getRight(), (Object)bootstrapFields.getRight());
    }

    private static void setupMORTable(RecordMergeMode mergeMode, boolean hasPrecombine, HoodieTableConfig hoodieTableConfig) {
        Mockito.when((Object)hoodieTableConfig.populateMetaFields()).thenReturn((Object)true);
        Mockito.when((Object)hoodieTableConfig.getRecordMergeMode()).thenReturn((Object)mergeMode);
        Mockito.when((Object)hoodieTableConfig.getTableVersion()).thenReturn((Object)HoodieTableVersion.current());
        if (hasPrecombine) {
            Mockito.when((Object)hoodieTableConfig.getOrderingFieldsStr()).thenReturn((Object)Option.of((Object)"timestamp"));
            Mockito.when((Object)hoodieTableConfig.getOrderingFields()).thenReturn(Collections.singletonList("timestamp"));
        } else {
            Mockito.when((Object)hoodieTableConfig.getOrderingFieldsStr()).thenReturn((Object)Option.empty());
            Mockito.when((Object)hoodieTableConfig.getOrderingFields()).thenReturn(Collections.emptyList());
        }
        if (mergeMode == RecordMergeMode.CUSTOM) {
            Mockito.when((Object)hoodieTableConfig.getRecordMergeStrategyId()).thenReturn((Object)"asdf");
        }
    }

    private static HoodieRecordMerger mockRecordMerger(boolean isProjectionCompatible, String[] mandatoryFields) throws IOException {
        HoodieRecordMerger merger = (HoodieRecordMerger)Mockito.mock(HoodieRecordMerger.class);
        Mockito.when((Object)merger.isProjectionCompatible()).thenReturn((Object)isProjectionCompatible);
        Mockito.when((Object)merger.merge((BufferedRecord)ArgumentMatchers.any(), (BufferedRecord)ArgumentMatchers.any(), (RecordContext)ArgumentMatchers.any(), (TypedProperties)ArgumentMatchers.any())).thenReturn(null);
        Mockito.when((Object)merger.getMandatoryFieldsForMerging((Schema)ArgumentMatchers.any(), (HoodieTableConfig)ArgumentMatchers.any(), (TypedProperties)ArgumentMatchers.any())).thenReturn((Object)mandatoryFields);
        return merger;
    }

    static HoodieReaderContext<String> createReaderContext(HoodieTableConfig hoodieTableConfig, boolean supportsParquetRowIndex, boolean hasLogFiles, boolean hasBootstrapBaseFile, boolean mergeUseRecordPosition, HoodieRecordMerger merger) {
        StubbedReaderContext readerContext = new StubbedReaderContext(hoodieTableConfig, supportsParquetRowIndex);
        readerContext.setHasLogFiles(hasLogFiles);
        readerContext.setHasBootstrapBaseFile(hasBootstrapBaseFile);
        readerContext.setShouldMergeUseRecordPosition(mergeUseRecordPosition);
        readerContext.setRecordMerger(Option.ofNullable((Object)merger));
        return readerContext;
    }

    abstract FileGroupReaderSchemaHandler createSchemaHandler(HoodieReaderContext<String> var1, Schema var2, Schema var3, boolean var4);

    static Schema generateProjectionSchema(String ... fields) {
        return HoodieAvroUtils.generateProjectionSchema((Schema)DATA_SCHEMA, Arrays.asList(fields));
    }

    private static Schema generateProjectionSchema(boolean hasBuiltInDelete, String ... fields) {
        List<String> fieldList = Arrays.asList(fields);
        if (hasBuiltInDelete) {
            fieldList = new ArrayList<String>(fieldList);
            fieldList.add("_hoodie_is_deleted");
        }
        return HoodieAvroUtils.generateProjectionSchema((Schema)DATA_SCHEMA, fieldList);
    }

    Schema.Field getField(String fieldName) {
        return DATA_SCHEMA.getField(fieldName);
    }

    static class StubbedReaderContext
    extends HoodieReaderContext<String> {
        protected StubbedReaderContext(HoodieTableConfig hoodieTableConfig, final boolean supportsParquetRowIndex) {
            super(null, hoodieTableConfig, Option.empty(), Option.empty(), (RecordContext)new RecordContext<String>(hoodieTableConfig, (JavaTypeConverter)new DefaultJavaTypeConverter()){

                public boolean supportsParquetRowIndex() {
                    return supportsParquetRowIndex;
                }

                public String convertAvroRecord(IndexedRecord avroRecord) {
                    return "";
                }

                public GenericRecord convertToAvroRecord(String record, Schema schema) {
                    return null;
                }

                public String getDeleteRow(String recordKey) {
                    return "";
                }

                public Object getValue(String record, Schema schema, String fieldName) {
                    return null;
                }

                public String getMetaFieldValue(String record, int pos) {
                    return "";
                }

                public HoodieRecord<String> constructHoodieRecord(BufferedRecord<String> bufferedRecord, String partitionPath) {
                    return null;
                }

                public String mergeWithEngineRecord(Schema schema, Map<Integer, Object> updateValues, BufferedRecord<String> baseRecord) {
                    return "";
                }

                public String constructEngineRecord(Schema recordSchema, Object[] fieldValues) {
                    return "";
                }

                public String seal(String record) {
                    return "";
                }

                public String toBinaryRow(Schema avroSchema, String record) {
                    return "";
                }

                public UnaryOperator<String> projectRecord(Schema from, Schema to, Map<String, String> renamedColumns) {
                    return null;
                }
            });
        }

        public ClosableIterator<String> getFileRecordIterator(StoragePath filePath, long start, long length, Schema dataSchema, Schema requiredSchema, HoodieStorage storage) throws IOException {
            return null;
        }

        public Option<HoodieRecordMerger> getRecordMerger(RecordMergeMode mergeMode, String mergeStrategyId, String mergeImplClasses) {
            return null;
        }

        public ClosableIterator<String> mergeBootstrapReaders(ClosableIterator<String> skeletonFileIterator, Schema skeletonRequiredSchema, ClosableIterator<String> dataFileIterator, Schema dataRequiredSchema, List<Pair<String, Object>> requiredPartitionFieldAndValues) {
            return null;
        }
    }
}

