/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import org.apache.hudi.common.engine.RecordContext;
import org.apache.hudi.common.model.DeleteRecord;
import org.apache.hudi.common.util.OrderingValues;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class TestBufferedRecords {
    TestBufferedRecords() {
    }

    @Test
    void testGetOrderingValueFromDeleteRecord() {
        RecordContext recordContext = (RecordContext)Mockito.mock(RecordContext.class);
        Mockito.when((Object)recordContext.getOrderingValue((DeleteRecord)ArgumentMatchers.any(DeleteRecord.class))).thenCallRealMethod();
        DeleteRecord deleteRecord = (DeleteRecord)Mockito.mock(DeleteRecord.class);
        this.mockDeleteRecord(deleteRecord, null);
        Assertions.assertEquals((Object)OrderingValues.getDefault(), (Object)recordContext.getOrderingValue(deleteRecord));
        this.mockDeleteRecord(deleteRecord, OrderingValues.getDefault());
        Assertions.assertEquals((Object)OrderingValues.getDefault(), (Object)recordContext.getOrderingValue(deleteRecord));
        String orderingValue = "xyz";
        String convertedValue = "_xyz";
        this.mockDeleteRecord(deleteRecord, (Comparable)((Object)orderingValue));
        Mockito.when((Object)recordContext.convertOrderingValueToEngineType((Comparable)((Object)orderingValue))).thenReturn((Object)convertedValue);
        Assertions.assertEquals((Object)convertedValue, (Object)recordContext.getOrderingValue(deleteRecord));
    }

    private void mockDeleteRecord(DeleteRecord deleteRecord, Comparable orderingValue) {
        Mockito.when((Object)deleteRecord.getOrderingValue()).thenReturn((Object)orderingValue);
    }
}

