/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.model.OverwriteNonDefaultsWithLatestAvroPayload;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.read.DeleteContext;
import org.apache.hudi.common.table.read.FileGroupReaderSchemaHandler;
import org.apache.hudi.common.table.read.SchemaHandlerTestBase;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.util.InternalSchemaCache;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.Type;
import org.apache.hudi.internal.schema.Types;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;
import org.apache.hudi.storage.StoragePath;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class TestFileGroupReaderSchemaHandler
extends SchemaHandlerTestBase {
    @Test
    public void testCow() {
        Mockito.when((Object)this.hoodieTableConfig.populateMetaFields()).thenReturn((Object)true);
        HoodieReaderContext<String> readerContext = TestFileGroupReaderSchemaHandler.createReaderContext(this.hoodieTableConfig, false, false, false, false, null);
        Schema requestedSchema = DATA_SCHEMA;
        FileGroupReaderSchemaHandler schemaHandler = this.createSchemaHandler(readerContext, DATA_SCHEMA, requestedSchema, false);
        Assertions.assertEquals((Object)requestedSchema, (Object)schemaHandler.getRequiredSchema());
        requestedSchema = TestFileGroupReaderSchemaHandler.generateProjectionSchema("begin_lat", "tip_history", "rider");
        schemaHandler = this.createSchemaHandler(readerContext, DATA_SCHEMA, requestedSchema, false);
        Assertions.assertEquals((Object)requestedSchema, (Object)schemaHandler.getRequiredSchema());
        Assertions.assertFalse((boolean)readerContext.getNeedsBootstrapMerge());
    }

    @Test
    public void testCowBootstrap() {
        Mockito.when((Object)this.hoodieTableConfig.populateMetaFields()).thenReturn((Object)true);
        HoodieReaderContext<String> readerContext = TestFileGroupReaderSchemaHandler.createReaderContext(this.hoodieTableConfig, false, false, true, false, null);
        Schema requestedSchema = TestFileGroupReaderSchemaHandler.generateProjectionSchema("begin_lat", "tip_history", "_hoodie_record_key", "rider");
        FileGroupReaderSchemaHandler schemaHandler = this.createSchemaHandler(readerContext, DATA_SCHEMA, requestedSchema, false);
        Assertions.assertTrue((boolean)readerContext.getNeedsBootstrapMerge());
        Schema expectedRequiredSchema = TestFileGroupReaderSchemaHandler.generateProjectionSchema("_hoodie_record_key", "begin_lat", "tip_history", "rider");
        Assertions.assertEquals((Object)expectedRequiredSchema, (Object)schemaHandler.getRequiredSchema());
        Pair bootstrapFields = schemaHandler.getBootstrapRequiredFields();
        Assertions.assertEquals(Collections.singletonList(this.getField("_hoodie_record_key")), (Object)bootstrapFields.getLeft());
        Assertions.assertEquals(Arrays.asList(this.getField("begin_lat"), this.getField("tip_history"), this.getField("rider")), (Object)bootstrapFields.getRight());
    }

    @Test
    void testGetRequiredSchemaForFileAndRenameColumns() {
        Mockito.when((Object)this.hoodieTableConfig.populateMetaFields()).thenReturn((Object)true);
        HoodieReaderContext<String> readerContext = TestFileGroupReaderSchemaHandler.createReaderContext(this.hoodieTableConfig, false, false, true, false, null);
        Schema requestedSchema = TestFileGroupReaderSchemaHandler.generateProjectionSchema("_hoodie_record_key", "timestamp", "rider");
        InternalSchema internalSchema = AvroInternalSchemaConverter.convert((Schema)DATA_SCHEMA);
        InternalSchema originalSchema = new InternalSchema(Types.RecordType.get(internalSchema.columns().stream().map(field -> {
            if (field.name().equals("timestamp")) {
                return Types.Field.get((int)field.fieldId(), (String)"ts", (Type)Types.IntType.get());
            }
            return field;
        }).collect(Collectors.toList())));
        FileGroupReaderSchemaHandler schemaHandler = new FileGroupReaderSchemaHandler(readerContext, DATA_SCHEMA, requestedSchema, Option.of((Object)internalSchema), new TypedProperties(), this.metaClient);
        try (MockedStatic mockedStatic = Mockito.mockStatic(InternalSchemaCache.class);){
            String instantTime = "20231010101010";
            mockedStatic.when(() -> InternalSchemaCache.searchSchemaAndCache((long)Long.parseLong(instantTime), (HoodieTableMetaClient)this.metaClient)).thenReturn((Object)originalSchema);
            StoragePath filePath = new StoragePath("/2023-01-01/" + FSUtils.makeBaseFileName((String)instantTime, (String)"1-0-1", (String)UUID.randomUUID().toString(), (String)HoodieFileFormat.PARQUET.getFileExtension()));
            Pair requiredSchemaAndRenamedFields = schemaHandler.getRequiredSchemaForFileAndRenamedColumns(filePath);
            Assertions.assertEquals(Collections.singletonMap("timestamp", "ts"), (Object)requiredSchemaAndRenamedFields.getRight());
            Assertions.assertEquals((Object)requestedSchema, (Object)requiredSchemaAndRenamedFields.getLeft());
        }
    }

    private static Stream<Arguments> testMorParams() {
        return TestFileGroupReaderSchemaHandler.testMorParams(false);
    }

    @Override
    @ParameterizedTest
    @MethodSource(value={"testMorParams"})
    public void testMor(RecordMergeMode mergeMode, boolean hasPrecombine, boolean isProjectionCompatible, boolean mergeUseRecordPosition, boolean supportsParquetRowIndex, boolean hasBuiltInDelete) throws IOException {
        super.testMor(mergeMode, hasPrecombine, isProjectionCompatible, mergeUseRecordPosition, supportsParquetRowIndex, hasBuiltInDelete);
    }

    @Override
    @ParameterizedTest
    @MethodSource(value={"testMorParams"})
    public void testMorBootstrap(RecordMergeMode mergeMode, boolean hasPrecombine, boolean isProjectionCompatible, boolean mergeUseRecordPosition, boolean supportsParquetRowIndex, boolean hasBuiltInDelete) throws IOException {
        super.testMorBootstrap(mergeMode, hasPrecombine, isProjectionCompatible, mergeUseRecordPosition, supportsParquetRowIndex, hasBuiltInDelete);
    }

    @Override
    FileGroupReaderSchemaHandler createSchemaHandler(HoodieReaderContext<String> readerContext, Schema dataSchema, Schema requestedSchema, boolean supportsParquetRowIndex) {
        return new FileGroupReaderSchemaHandler(readerContext, dataSchema, requestedSchema, Option.empty(), new TypedProperties(), this.metaClient);
    }

    @ParameterizedTest
    @CsvSource(value={"true, true, true, EVENT_TIME_ORDERING, false, EIGHT, eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", "true, false, false, EVENT_TIME_ORDERING, false, EIGHT, eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", "false, true, false, EVENT_TIME_ORDERING, false, EIGHT, eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", "false, false, true, EVENT_TIME_ORDERING, false, EIGHT, eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", "true, true, true, COMMIT_TIME_ORDERING, false, EIGHT, ce9acb64-bde0-424c-9b91-f6ebba25356d", "true, false, false, COMMIT_TIME_ORDERING, false, EIGHT, ce9acb64-bde0-424c-9b91-f6ebba25356d", "false, true, false, COMMIT_TIME_ORDERING, false, EIGHT, ce9acb64-bde0-424c-9b91-f6ebba25356d", "false, false, true, COMMIT_TIME_ORDERING, false, EIGHT, ce9acb64-bde0-424c-9b91-f6ebba25356d", "true, true, true, CUSTOM, false, EIGHT, 00000000-0000-0000-0000-000000000000", "true, false, false, CUSTOM, false, EIGHT, 00000000-0000-0000-0000-000000000000", "false, true, false, CUSTOM, false, EIGHT, 00000000-0000-0000-0000-000000000000", "false, false, true, CUSTOM, false, EIGHT, 00000000-0000-0000-0000-000000000000", "true, true, true, , false, EIGHT, 00000000-0000-0000-0000-000000000000", "true, false, false, , false, EIGHT, 00000000-0000-0000-0000-000000000000", "false, true, false, , false, EIGHT, 00000000-0000-0000-0000-000000000000", "false, false, true, , false, EIGHT, 00000000-0000-0000-0000-000000000000", "true, true, true, EVENT_TIME_ORDERING, false, SIX, eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", "true, false, false, EVENT_TIME_ORDERING, false, SIX, eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", "false, true, false, EVENT_TIME_ORDERING, false, SIX, eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", "false, false, true, EVENT_TIME_ORDERING, false, SIX, eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", "true, true, true, COMMIT_TIME_ORDERING, false, SIX, ce9acb64-bde0-424c-9b91-f6ebba25356d", "true, false, false, COMMIT_TIME_ORDERING, false, SIX, ce9acb64-bde0-424c-9b91-f6ebba25356d", "false, true, false, COMMIT_TIME_ORDERING, false, SIX, ce9acb64-bde0-424c-9b91-f6ebba25356d", "false, false, true, COMMIT_TIME_ORDERING, false, SIX, ce9acb64-bde0-424c-9b91-f6ebba25356d", "true, true, true, CUSTOM, false, SIX, 00000000-0000-0000-0000-000000000000", "true, false, false, CUSTOM, false, SIX, 00000000-0000-0000-0000-000000000000", "false, true, false, CUSTOM, false, SIX, 00000000-0000-0000-0000-000000000000", "false, false, true, CUSTOM, false, SIX, 00000000-0000-0000-0000-000000000000", "true, true, true, , false, SIX, 00000000-0000-0000-0000-000000000000", "true, false, false, , false, SIX, 00000000-0000-0000-0000-000000000000", "false, true, false, , false, SIX, 00000000-0000-0000-0000-000000000000", "false, false, true, , false, SIX, 00000000-0000-0000-0000-000000000000", "true, true, true, COMMIT_TIME_ORDERING, true, SIX, eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"})
    public void testSchemaForMandatoryFields(boolean setPrecombine, boolean addHoodieIsDeleted, boolean addCustomDeleteMarker, RecordMergeMode mergeMode, boolean isProjectionCompatible, HoodieTableVersion tableVersion, String mergeStrategyId) {
        HoodieReaderContext readerContext = (HoodieReaderContext)Mockito.mock(HoodieReaderContext.class);
        Mockito.when((Object)readerContext.getInstantRange()).thenReturn((Object)Option.empty());
        Mockito.when((Object)readerContext.getHasBootstrapBaseFile()).thenReturn((Object)false);
        Mockito.when((Object)readerContext.getHasLogFiles()).thenReturn((Object)true);
        HoodieRecordMerger recordMerger = (HoodieRecordMerger)Mockito.mock(HoodieRecordMerger.class);
        Mockito.when((Object)readerContext.getRecordMerger()).thenReturn((Object)Option.of((Object)recordMerger));
        Mockito.when((Object)recordMerger.isProjectionCompatible()).thenReturn((Object)isProjectionCompatible);
        String preCombineField = "ts";
        String customDeleteKey = "colC";
        String customDeleteValue = "D";
        ArrayList<String> dataSchemaFields = new ArrayList<String>();
        dataSchemaFields.addAll(Arrays.asList(HoodieRecord.RECORD_KEY_METADATA_FIELD, HoodieRecord.PARTITION_PATH_METADATA_FIELD, preCombineField, "colA", "colB", "colC", "colD"));
        if (addHoodieIsDeleted) {
            dataSchemaFields.add("_hoodie_is_deleted");
        }
        Schema dataSchema = SchemaTestUtil.getSchemaFromFields(dataSchemaFields);
        Schema requestedSchema = SchemaTestUtil.getSchemaFromFields(Arrays.asList(HoodieRecord.RECORD_KEY_METADATA_FIELD, HoodieRecord.PARTITION_PATH_METADATA_FIELD));
        Mockito.when((Object)this.hoodieTableConfig.getRecordMergeMode()).thenReturn((Object)mergeMode);
        Mockito.when((Object)this.hoodieTableConfig.populateMetaFields()).thenReturn((Object)true);
        Mockito.when((Object)this.hoodieTableConfig.getOrderingFieldsStr()).thenReturn((Object)Option.of((Object)(setPrecombine ? preCombineField : "")));
        Mockito.when((Object)this.hoodieTableConfig.getOrderingFields()).thenReturn(setPrecombine ? Collections.singletonList(preCombineField) : Collections.emptyList());
        Mockito.when((Object)this.hoodieTableConfig.getTableVersion()).thenReturn((Object)tableVersion);
        if (this.hoodieTableConfig.getTableVersion() == HoodieTableVersion.SIX) {
            if (mergeMode == RecordMergeMode.EVENT_TIME_ORDERING) {
                Mockito.when((Object)this.hoodieTableConfig.getPayloadClass()).thenReturn((Object)DefaultHoodieRecordPayload.class.getName());
            } else if (mergeMode == RecordMergeMode.COMMIT_TIME_ORDERING) {
                Mockito.when((Object)this.hoodieTableConfig.getPayloadClass()).thenReturn((Object)OverwriteWithLatestAvroPayload.class.getName());
            } else {
                Mockito.when((Object)this.hoodieTableConfig.getPayloadClass()).thenReturn((Object)OverwriteNonDefaultsWithLatestAvroPayload.class.getName());
            }
        }
        if (mergeMode != null) {
            Mockito.when((Object)this.hoodieTableConfig.getRecordMergeStrategyId()).thenReturn((Object)mergeStrategyId);
        }
        TypedProperties props = new TypedProperties();
        if (addCustomDeleteMarker) {
            props.setProperty("hoodie.payload.delete.field", customDeleteKey);
            props.setProperty("hoodie.payload.delete.marker", customDeleteValue);
        }
        ArrayList<String> expectedFields = new ArrayList<String>();
        expectedFields.add(HoodieRecord.RECORD_KEY_METADATA_FIELD);
        expectedFields.add(HoodieRecord.PARTITION_PATH_METADATA_FIELD);
        if (addCustomDeleteMarker) {
            expectedFields.add(customDeleteKey);
        }
        if (setPrecombine && mergeMode != RecordMergeMode.COMMIT_TIME_ORDERING) {
            expectedFields.add(preCombineField);
        }
        if (addHoodieIsDeleted) {
            expectedFields.add("_hoodie_is_deleted");
        }
        Schema expectedSchema = mergeMode == RecordMergeMode.CUSTOM && !isProjectionCompatible ? dataSchema : SchemaTestUtil.getSchemaFromFields(expectedFields);
        Mockito.when((Object)recordMerger.getMandatoryFieldsForMerging(dataSchema, this.hoodieTableConfig, props)).thenReturn((Object)expectedFields.toArray(new String[0]));
        DeleteContext deleteContext = new DeleteContext((Properties)props, dataSchema);
        Assertions.assertEquals((Object)addHoodieIsDeleted, (Object)deleteContext.hasBuiltInDeleteField());
        Assertions.assertEquals((Object)(addCustomDeleteMarker ? Option.of((Object)Pair.of((Object)customDeleteKey, (Object)customDeleteValue)) : Option.empty()), (Object)deleteContext.getCustomDeleteMarkerKeyValue());
        FileGroupReaderSchemaHandler fileGroupReaderSchemaHandler = new FileGroupReaderSchemaHandler(readerContext, dataSchema, requestedSchema, Option.empty(), props, this.metaClient);
        Schema actualSchema = fileGroupReaderSchemaHandler.generateRequiredSchema(deleteContext);
        Assertions.assertEquals((Object)expectedSchema, (Object)actualSchema);
    }
}

