/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieMemoryConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.HoodieReaderConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.engine.RecordContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.SerializableIndexedRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.serialization.CustomSerializer;
import org.apache.hudi.common.serialization.DefaultSerializer;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.table.read.BufferedRecords;
import org.apache.hudi.common.table.read.FileGroupReaderSchemaHandler;
import org.apache.hudi.common.table.read.HoodieFileGroupReader;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.DefaultSizeEstimator;
import org.apache.hudi.common.util.HoodieRecordSizeEstimator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.OrderingValues;
import org.apache.hudi.common.util.SizeEstimator;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.storage.StorageConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;

public abstract class TestHoodieFileGroupReaderBase<T> {
    private static final List<HoodieFileFormat> DEFAULT_SUPPORTED_FILE_FORMATS = Arrays.asList(HoodieFileFormat.PARQUET, HoodieFileFormat.ORC);
    protected static List<HoodieFileFormat> supportedFileFormats;
    private static final String KEY_FIELD_NAME = "_row_key";
    protected static final String ORDERING_FIELD_NAME = "timestamp";
    private static final String PARTITION_FIELD_NAME = "partition_path";
    private static final String RIDER_FIELD_NAME = "rider";
    @TempDir
    protected Path tempDir;

    public abstract StorageConfiguration<?> getStorageConf();

    public abstract String getBasePath();

    public abstract HoodieReaderContext<T> getHoodieReaderContext(String var1, Schema var2, StorageConfiguration<?> var3, HoodieTableMetaClient var4);

    public abstract String getCustomPayload();

    public abstract void commitToTable(List<HoodieRecord> var1, String var2, boolean var3, Map<String, String> var4, String var5);

    public void commitToTable(List<HoodieRecord> recordList, String operation, boolean firstCommit, Map<String, String> writeConfigs) {
        this.commitToTable(recordList, operation, firstCommit, writeConfigs, "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}");
    }

    public abstract void assertRecordsEqual(Schema var1, T var2, T var3);

    public abstract void assertRecordMatchesSchema(Schema var1, T var2);

    public abstract HoodieTestDataGenerator.SchemaEvolutionConfigs getSchemaEvolutionConfigs();

    private static Stream<Arguments> supportedBaseFileFormatArgs() {
        return supportedFileFormats.stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    private static Stream<Arguments> testArguments() {
        boolean supportsORC = supportedFileFormats.contains(HoodieFileFormat.ORC);
        return Stream.of(Arguments.arguments((Object[])new Object[]{RecordMergeMode.COMMIT_TIME_ORDERING, supportsORC ? HoodieFileFormat.ORC : HoodieFileFormat.PARQUET, "avro", false}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.COMMIT_TIME_ORDERING, HoodieFileFormat.PARQUET, "parquet", true}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.EVENT_TIME_ORDERING, supportsORC ? HoodieFileFormat.ORC : HoodieFileFormat.PARQUET, "avro", true}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.EVENT_TIME_ORDERING, HoodieFileFormat.PARQUET, "parquet", true}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.CUSTOM, HoodieFileFormat.PARQUET, "avro", false}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.CUSTOM, HoodieFileFormat.PARQUET, "parquet", true}));
    }

    @BeforeAll
    public static void setUpClass() throws IOException {
        supportedFileFormats = new ArrayList<HoodieFileFormat>(DEFAULT_SUPPORTED_FILE_FORMATS);
    }

    @ParameterizedTest
    @MethodSource(value={"testArguments"})
    public void testReadFileGroupInMergeOnReadTable(RecordMergeMode recordMergeMode, HoodieFileFormat baseFileFormat, String logDataBlockFormat, boolean populateMetaFields) throws Exception {
        HashMap<String, String> writeConfigs = new HashMap<String, String>(this.getCommonConfigs(recordMergeMode, populateMetaFields));
        writeConfigs.put(HoodieStorageConfig.LOGFILE_DATA_BLOCK_FORMAT.key(), logDataBlockFormat);
        writeConfigs.put(HoodieTableConfig.BASE_FILE_FORMAT.key(), baseFileFormat.name());
        try (HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator(57071L);){
            List<HoodieRecord> initialRecords = dataGen.generateInserts("001", 100);
            this.commitToTable(initialRecords, WriteOperationType.INSERT.value(), true, writeConfigs);
            this.validateOutputFromFileGroupReader(this.getStorageConf(), this.getBasePath(), true, 0, recordMergeMode, initialRecords, initialRecords, new String[]{ORDERING_FIELD_NAME});
            List<HoodieRecord> updates = dataGen.generateUniqueUpdates("002", 50);
            List<HoodieRecord> allRecords = this.mergeRecordLists(updates, initialRecords);
            List unmergedRecords = CollectionUtils.combine(initialRecords, updates);
            this.commitToTable(updates, WriteOperationType.UPSERT.value(), false, writeConfigs);
            this.validateOutputFromFileGroupReader(this.getStorageConf(), this.getBasePath(), true, 1, recordMergeMode, allRecords, unmergedRecords, new String[]{ORDERING_FIELD_NAME});
            List<HoodieRecord> updates2 = dataGen.generateUniqueUpdates("003", 100);
            List<HoodieRecord> finalRecords = this.mergeRecordLists(updates2, allRecords);
            this.commitToTable(updates2, WriteOperationType.UPSERT.value(), false, writeConfigs);
            this.validateOutputFromFileGroupReader(this.getStorageConf(), this.getBasePath(), true, 2, recordMergeMode, finalRecords, CollectionUtils.combine((List)unmergedRecords, updates2), new String[]{ORDERING_FIELD_NAME});
        }
    }

    @Test
    public void testReadFileGroupWithMultipleOrderingFields() throws Exception {
        RecordMergeMode recordMergeMode = RecordMergeMode.EVENT_TIME_ORDERING;
        HashMap<String, String> writeConfigs = new HashMap<String, String>(this.getCommonConfigs(recordMergeMode, true));
        writeConfigs.put(HoodieStorageConfig.LOGFILE_DATA_BLOCK_FORMAT.key(), "avro");
        writeConfigs.put("hoodie.datasource.write.table.type", HoodieTableType.MERGE_ON_READ.name());
        String orderingFields = "timestamp,rider";
        writeConfigs.put(HoodieTableConfig.ORDERING_FIELDS.key(), orderingFields);
        writeConfigs.put("hoodie.payload.ordering.field", orderingFields);
        try (HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator(57071L);){
            List<HoodieRecord> initialRecords = dataGen.generateInserts("002", 100);
            long initialTs = (Long)((GenericRecord)initialRecords.get(0).getData()).get(ORDERING_FIELD_NAME);
            this.commitToTable(initialRecords, WriteOperationType.INSERT.value(), true, writeConfigs);
            this.validateOutputFromFileGroupReader(this.getStorageConf(), this.getBasePath(), true, 0, recordMergeMode, initialRecords, initialRecords, orderingFields.split(","));
            List<HoodieRecord> updates = dataGen.generateUniqueUpdates("001", (Integer)5, initialTs);
            List<HoodieRecord> allRecords = initialRecords;
            List unmergedRecords = CollectionUtils.combine(updates, allRecords);
            this.commitToTable(updates, WriteOperationType.UPSERT.value(), false, writeConfigs);
            this.validateOutputFromFileGroupReader(this.getStorageConf(), this.getBasePath(), true, 1, recordMergeMode, allRecords, unmergedRecords, orderingFields.split(","));
            List<HoodieRecord> updates2 = dataGen.generateUniqueUpdates("003", (Integer)10, initialTs);
            List<HoodieRecord> finalRecords = this.mergeRecordLists(updates2, allRecords);
            this.commitToTable(updates2, WriteOperationType.UPSERT.value(), false, writeConfigs);
            this.validateOutputFromFileGroupReader(this.getStorageConf(), this.getBasePath(), true, 2, recordMergeMode, finalRecords, CollectionUtils.combine((List)unmergedRecords, updates2), orderingFields.split(","));
        }
    }

    private static Stream<Arguments> logFileOnlyCases() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{RecordMergeMode.COMMIT_TIME_ORDERING, "avro"}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.EVENT_TIME_ORDERING, "parquet"}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.CUSTOM, "avro"}));
    }

    @ParameterizedTest
    @MethodSource(value={"logFileOnlyCases"})
    public void testReadLogFilesOnlyInMergeOnReadTable(RecordMergeMode recordMergeMode, String logDataBlockFormat) throws Exception {
        HashMap<String, String> writeConfigs = new HashMap<String, String>(this.getCommonConfigs(recordMergeMode, true));
        writeConfigs.put(HoodieStorageConfig.LOGFILE_DATA_BLOCK_FORMAT.key(), logDataBlockFormat);
        writeConfigs.put("hoodie.index.type", "INMEMORY");
        try (HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator(57071L);){
            List<HoodieRecord> initialRecords = dataGen.generateInserts("001", 100);
            this.commitToTable(initialRecords, WriteOperationType.INSERT.value(), true, writeConfigs);
            this.validateOutputFromFileGroupReader(this.getStorageConf(), this.getBasePath(), false, 1, recordMergeMode, initialRecords, initialRecords, new String[]{ORDERING_FIELD_NAME});
            List<HoodieRecord> updates = dataGen.generateUniqueUpdates("002", 50);
            List<HoodieRecord> allRecords = this.mergeRecordLists(updates, initialRecords);
            this.commitToTable(updates, WriteOperationType.INSERT.value(), false, writeConfigs);
            this.validateOutputFromFileGroupReader(this.getStorageConf(), this.getBasePath(), false, 2, recordMergeMode, allRecords, CollectionUtils.combine(initialRecords, updates), new String[]{ORDERING_FIELD_NAME});
        }
    }

    protected static List<Pair<String, IndexedRecord>> hoodieRecordsToIndexedRecords(List<HoodieRecord> hoodieRecords, Schema schema) {
        return hoodieRecords.stream().map(r -> {
            try {
                Option avroIndexedRecordOption = r.toIndexedRecord(schema, CollectionUtils.emptyProps());
                if (avroIndexedRecordOption.isPresent()) {
                    ((HoodieAvroIndexedRecord)avroIndexedRecordOption.get()).getData().get(0);
                }
                return avroIndexedRecordOption;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).filter(Option::isPresent).map(Option::get).map(r -> Pair.of((Object)r.getRecordKey(), (Object)((SerializableIndexedRecord)r.getData()).getData())).collect(Collectors.toList());
    }

    @ParameterizedTest
    @MethodSource(value={"supportedBaseFileFormatArgs"})
    public void testSchemaEvolutionWhenBaseFilesWithDifferentSchema(HoodieFileFormat fileFormat) throws Exception {
        HashMap<String, String> writeConfigs = new HashMap<String, String>(this.getCommonConfigs(RecordMergeMode.EVENT_TIME_ORDERING, true));
        HoodieTestDataGenerator.SchemaEvolutionConfigs schemaEvolutionConfigs = this.getSchemaEvolutionConfigs();
        writeConfigs.put(HoodieTableConfig.BASE_FILE_FORMAT.key(), fileFormat.name());
        if (fileFormat == HoodieFileFormat.ORC) {
            schemaEvolutionConfigs.floatToDoubleSupport = false;
            schemaEvolutionConfigs.floatToStringSupport = false;
        }
        try (HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}", 57071L);){
            dataGen.extendSchemaBeforeEvolution(schemaEvolutionConfigs);
            List<HoodieRecord> firstRecords = dataGen.generateInsertsForPartition("001", 5, "any_partition");
            List<Pair<String, IndexedRecord>> firstIndexedRecords = TestHoodieFileGroupReaderBase.hoodieRecordsToIndexedRecords(firstRecords, dataGen.getExtendedSchema());
            this.commitToTable(firstRecords, WriteOperationType.INSERT.value(), true, writeConfigs, dataGen.getExtendedSchema().toString());
            this.validateOutputFromFileGroupReaderWithNativeRecords(this.getStorageConf(), this.getBasePath(), true, 0, RecordMergeMode.EVENT_TIME_ORDERING, firstIndexedRecords);
            dataGen.extendSchemaAfterEvolution(schemaEvolutionConfigs);
            List<HoodieRecord> secondRecords = dataGen.generateInsertsForPartition("002", 5, "new_partition");
            List<Pair<String, IndexedRecord>> secondIndexedRecords = TestHoodieFileGroupReaderBase.hoodieRecordsToIndexedRecords(secondRecords, dataGen.getExtendedSchema());
            this.commitToTable(secondRecords, WriteOperationType.INSERT.value(), false, writeConfigs, dataGen.getExtendedSchema().toString());
            List mergedRecords = CollectionUtils.combine(firstIndexedRecords, secondIndexedRecords);
            this.validateOutputFromFileGroupReaderWithNativeRecords(this.getStorageConf(), this.getBasePath(), true, 0, RecordMergeMode.EVENT_TIME_ORDERING, mergedRecords);
        }
    }

    private static Stream<Arguments> testArgsForDifferentBaseAndLogFormats() {
        boolean supportsORC = supportedFileFormats.contains(HoodieFileFormat.ORC);
        ArrayList<Arguments> args = new ArrayList<Arguments>();
        if (supportsORC) {
            args.add(Arguments.arguments((Object[])new Object[]{HoodieFileFormat.ORC, "avro"}));
        }
        args.add(Arguments.arguments((Object[])new Object[]{HoodieFileFormat.PARQUET, "avro"}));
        args.add(Arguments.arguments((Object[])new Object[]{HoodieFileFormat.PARQUET, "parquet"}));
        return args.stream();
    }

    @ParameterizedTest
    @MethodSource(value={"testArgsForDifferentBaseAndLogFormats"})
    public void testSchemaEvolutionWhenBaseFileHasDifferentSchemaThanLogFiles(HoodieFileFormat fileFormat, String logFileFormat) throws Exception {
        HashMap<String, String> writeConfigs = new HashMap<String, String>(this.getCommonConfigs(RecordMergeMode.EVENT_TIME_ORDERING, true));
        writeConfigs.put(HoodieTableConfig.BASE_FILE_FORMAT.key(), fileFormat.name());
        writeConfigs.put(HoodieTableConfig.LOG_FILE_FORMAT.key(), logFileFormat);
        HoodieTestDataGenerator.SchemaEvolutionConfigs schemaEvolutionConfigs = this.getSchemaEvolutionConfigs();
        if (fileFormat == HoodieFileFormat.ORC) {
            schemaEvolutionConfigs.floatToDoubleSupport = false;
            schemaEvolutionConfigs.floatToStringSupport = false;
        }
        try (HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}", 57071L);){
            dataGen.extendSchemaBeforeEvolution(schemaEvolutionConfigs);
            List<HoodieRecord> firstRecords = dataGen.generateInsertsForPartition("001", 10, "any_partition");
            List<Pair<String, IndexedRecord>> firstIndexedRecords = TestHoodieFileGroupReaderBase.hoodieRecordsToIndexedRecords(firstRecords, dataGen.getExtendedSchema());
            this.commitToTable(firstRecords, WriteOperationType.INSERT.value(), true, writeConfigs, dataGen.getExtendedSchema().toString());
            this.validateOutputFromFileGroupReaderWithNativeRecords(this.getStorageConf(), this.getBasePath(), true, 0, RecordMergeMode.EVENT_TIME_ORDERING, firstIndexedRecords);
            List<HoodieRecord> secondRecords = dataGen.generateUniqueUpdates("002", 5);
            List<Pair<String, IndexedRecord>> secondIndexedRecords = TestHoodieFileGroupReaderBase.hoodieRecordsToIndexedRecords(secondRecords, dataGen.getExtendedSchema());
            this.commitToTable(secondRecords, WriteOperationType.UPSERT.value(), false, writeConfigs, dataGen.getExtendedSchema().toString());
            List mergedRecords = this.mergeIndexedRecordLists(secondIndexedRecords, firstIndexedRecords);
            this.validateOutputFromFileGroupReaderWithNativeRecords(this.getStorageConf(), this.getBasePath(), true, 1, RecordMergeMode.EVENT_TIME_ORDERING, mergedRecords);
            dataGen.extendSchemaAfterEvolution(schemaEvolutionConfigs);
            List<HoodieRecord> thirdRecords = dataGen.generateInsertsForPartition("003", 5, "new_partition");
            List<Pair<String, IndexedRecord>> thirdIndexedRecords = TestHoodieFileGroupReaderBase.hoodieRecordsToIndexedRecords(thirdRecords, dataGen.getExtendedSchema());
            this.commitToTable(thirdRecords, WriteOperationType.INSERT.value(), false, writeConfigs, dataGen.getExtendedSchema().toString());
            mergedRecords = CollectionUtils.combine(mergedRecords, thirdIndexedRecords);
            this.validateOutputFromFileGroupReaderWithNativeRecords(this.getStorageConf(), this.getBasePath(), true, -1, RecordMergeMode.EVENT_TIME_ORDERING, mergedRecords);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"supportedBaseFileFormatArgs"})
    public void testSchemaEvolutionWhenLogFilesWithDifferentSchema(HoodieFileFormat fileFormat) throws Exception {
        HashMap<String, String> writeConfigs = new HashMap<String, String>(this.getCommonConfigs(RecordMergeMode.EVENT_TIME_ORDERING, true));
        writeConfigs.put(HoodieTableConfig.BASE_FILE_FORMAT.key(), fileFormat.name());
        HoodieTestDataGenerator.SchemaEvolutionConfigs schemaEvolutionConfigs = this.getSchemaEvolutionConfigs();
        if (fileFormat == HoodieFileFormat.ORC) {
            schemaEvolutionConfigs.floatToDoubleSupport = false;
            schemaEvolutionConfigs.floatToStringSupport = false;
        }
        try (HoodieTestDataGenerator baseFileDataGen = new HoodieTestDataGenerator("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}", 57071L);){
            baseFileDataGen.extendSchemaBeforeEvolution(schemaEvolutionConfigs);
            List<HoodieRecord> firstRecords = baseFileDataGen.generateInserts("001", 100);
            List<Pair<String, IndexedRecord>> firstIndexedRecords = TestHoodieFileGroupReaderBase.hoodieRecordsToIndexedRecords(firstRecords, baseFileDataGen.getExtendedSchema());
            this.commitToTable(firstRecords, WriteOperationType.INSERT.value(), true, writeConfigs, baseFileDataGen.getExtendedSchema().toString());
            this.validateOutputFromFileGroupReaderWithNativeRecords(this.getStorageConf(), this.getBasePath(), true, 0, RecordMergeMode.EVENT_TIME_ORDERING, firstIndexedRecords);
            List<HoodieRecord> secondRecords = baseFileDataGen.generateUniqueUpdates("002", 50);
            List<Pair<String, IndexedRecord>> secondIndexedRecords = TestHoodieFileGroupReaderBase.hoodieRecordsToIndexedRecords(secondRecords, baseFileDataGen.getExtendedSchema());
            this.commitToTable(secondRecords, WriteOperationType.UPSERT.value(), false, writeConfigs, baseFileDataGen.getExtendedSchema().toString());
            List<Pair<String, IndexedRecord>> mergedRecords = this.mergeIndexedRecordLists(secondIndexedRecords, firstIndexedRecords);
            this.validateOutputFromFileGroupReaderWithNativeRecords(this.getStorageConf(), this.getBasePath(), true, 1, RecordMergeMode.EVENT_TIME_ORDERING, mergedRecords);
            baseFileDataGen.extendSchemaAfterEvolution(schemaEvolutionConfigs);
            List<HoodieRecord> thirdRecords = baseFileDataGen.generateUniqueUpdates("003", 50);
            List<Pair<String, IndexedRecord>> thirdIndexedRecords = TestHoodieFileGroupReaderBase.hoodieRecordsToIndexedRecords(thirdRecords, baseFileDataGen.getExtendedSchema());
            this.commitToTable(thirdRecords, WriteOperationType.UPSERT.value(), false, writeConfigs, baseFileDataGen.getExtendedSchema().toString());
            mergedRecords = this.mergeIndexedRecordLists(thirdIndexedRecords, mergedRecords);
            this.validateOutputFromFileGroupReaderWithNativeRecords(this.getStorageConf(), this.getBasePath(), true, 2, RecordMergeMode.EVENT_TIME_ORDERING, mergedRecords);
        }
    }

    @Test
    public void testSchemaEvolutionWhenLogFilesWithDifferentSchemaAndTableSchemaDiffers() throws Exception {
        HashMap<String, String> writeConfigs = new HashMap<String, String>(this.getCommonConfigs(RecordMergeMode.EVENT_TIME_ORDERING, true));
        try (HoodieTestDataGenerator baseFileDataGen = new HoodieTestDataGenerator("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}", 57071L);){
            baseFileDataGen.extendSchemaBeforeEvolution(this.getSchemaEvolutionConfigs());
            List<HoodieRecord> firstRecords = baseFileDataGen.generateInserts("001", 100);
            List<Pair<String, IndexedRecord>> firstIndexedRecords = TestHoodieFileGroupReaderBase.hoodieRecordsToIndexedRecords(firstRecords, baseFileDataGen.getExtendedSchema());
            this.commitToTable(firstRecords, WriteOperationType.INSERT.value(), true, writeConfigs, baseFileDataGen.getExtendedSchema().toString());
            this.validateOutputFromFileGroupReaderWithNativeRecords(this.getStorageConf(), this.getBasePath(), true, 0, RecordMergeMode.EVENT_TIME_ORDERING, firstIndexedRecords);
            List<HoodieRecord> secondRecords = baseFileDataGen.generateUniqueUpdates("002", 50);
            List<Pair<String, IndexedRecord>> secondIndexedRecords = TestHoodieFileGroupReaderBase.hoodieRecordsToIndexedRecords(secondRecords, baseFileDataGen.getExtendedSchema());
            this.commitToTable(secondRecords, WriteOperationType.UPSERT.value(), false, writeConfigs, baseFileDataGen.getExtendedSchema().toString());
            List mergedRecords = this.mergeIndexedRecordLists(secondIndexedRecords, firstIndexedRecords);
            this.validateOutputFromFileGroupReaderWithNativeRecords(this.getStorageConf(), this.getBasePath(), true, 1, RecordMergeMode.EVENT_TIME_ORDERING, mergedRecords);
            HoodieTestDataGenerator.SchemaEvolutionConfigs schemaEvolutionConfigs = this.getSchemaEvolutionConfigs();
            boolean addNewFieldSupport = schemaEvolutionConfigs.addNewFieldSupport;
            schemaEvolutionConfigs.addNewFieldSupport = false;
            baseFileDataGen.extendSchemaAfterEvolution(schemaEvolutionConfigs);
            List<HoodieRecord> thirdRecords = baseFileDataGen.generateUniqueUpdates("003", 50);
            List<Pair<String, IndexedRecord>> thirdIndexedRecords = TestHoodieFileGroupReaderBase.hoodieRecordsToIndexedRecords(thirdRecords, baseFileDataGen.getExtendedSchema());
            this.commitToTable(thirdRecords, WriteOperationType.UPSERT.value(), false, writeConfigs, baseFileDataGen.getExtendedSchema().toString());
            mergedRecords = this.mergeIndexedRecordLists(thirdIndexedRecords, mergedRecords);
            this.validateOutputFromFileGroupReaderWithNativeRecords(this.getStorageConf(), this.getBasePath(), true, 2, RecordMergeMode.EVENT_TIME_ORDERING, mergedRecords);
            schemaEvolutionConfigs = this.getSchemaEvolutionConfigs();
            schemaEvolutionConfigs.addNewFieldSupport = addNewFieldSupport;
            baseFileDataGen.extendSchemaAfterEvolution(schemaEvolutionConfigs);
            List<HoodieRecord> fourthRecords = baseFileDataGen.generateInsertsForPartition("004", 5, "new_partition");
            List<Pair<String, IndexedRecord>> fourthIndexedRecords = TestHoodieFileGroupReaderBase.hoodieRecordsToIndexedRecords(fourthRecords, baseFileDataGen.getExtendedSchema());
            this.commitToTable(fourthRecords, WriteOperationType.INSERT.value(), false, writeConfigs, baseFileDataGen.getExtendedSchema().toString());
            mergedRecords = CollectionUtils.combine(mergedRecords, fourthIndexedRecords);
            this.validateOutputFromFileGroupReaderWithNativeRecords(this.getStorageConf(), this.getBasePath(), true, -1, RecordMergeMode.EVENT_TIME_ORDERING, mergedRecords);
        }
    }

    @Test
    public void testSchemaEvolutionWhenBaseFilesWithDifferentSchemaFromLogFiles() throws Exception {
        HashMap<String, String> writeConfigs = new HashMap<String, String>(this.getCommonConfigs(RecordMergeMode.EVENT_TIME_ORDERING, true));
        try (HoodieTestDataGenerator baseFileDataGen = new HoodieTestDataGenerator("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}", 57071L);){
            baseFileDataGen.extendSchemaBeforeEvolution(this.getSchemaEvolutionConfigs());
            List<HoodieRecord> firstRecords = baseFileDataGen.generateInserts("001", 100);
            List<Pair<String, IndexedRecord>> firstIndexedRecords = TestHoodieFileGroupReaderBase.hoodieRecordsToIndexedRecords(firstRecords, baseFileDataGen.getExtendedSchema());
            this.commitToTable(firstRecords, WriteOperationType.INSERT.value(), true, writeConfigs, baseFileDataGen.getExtendedSchema().toString());
            this.validateOutputFromFileGroupReaderWithNativeRecords(this.getStorageConf(), this.getBasePath(), true, 0, RecordMergeMode.EVENT_TIME_ORDERING, firstIndexedRecords);
            baseFileDataGen.extendSchemaAfterEvolution(this.getSchemaEvolutionConfigs());
            List<HoodieRecord> secondRecords = baseFileDataGen.generateUniqueUpdates("002", 50);
            List<Pair<String, IndexedRecord>> secondIndexedRecords = TestHoodieFileGroupReaderBase.hoodieRecordsToIndexedRecords(secondRecords, baseFileDataGen.getExtendedSchema());
            this.commitToTable(secondRecords, WriteOperationType.UPSERT.value(), false, writeConfigs, baseFileDataGen.getExtendedSchema().toString());
            List<Pair<String, IndexedRecord>> mergedRecords = this.mergeIndexedRecordLists(secondIndexedRecords, firstIndexedRecords);
            this.validateOutputFromFileGroupReaderWithNativeRecords(this.getStorageConf(), this.getBasePath(), true, 1, RecordMergeMode.EVENT_TIME_ORDERING, mergedRecords);
        }
    }

    @Test
    public void testReadFileGroupInBootstrapMergeOnReadTable() throws Exception {
        Path zipOutput = Paths.get(new URI(this.getBasePath()));
        HoodieTestUtils.extractZipToDirectory("file-group-reader/bootstrap_data.zip", zipOutput, this.getClass());
        ObjectMapper objectMapper = new ObjectMapper();
        Path basePath = zipOutput.resolve("bootstrap_data");
        ArrayList<HoodieTestDataGenerator.RecordIdentifier> expectedRecords = new ArrayList();
        objectMapper.reader().forType(HoodieTestDataGenerator.RecordIdentifier.class).readValues(basePath.resolve("merged_records.json").toFile()).forEachRemaining(expectedRecords::add);
        ArrayList<HoodieTestDataGenerator.RecordIdentifier> expectedUnMergedRecords = new ArrayList();
        objectMapper.reader().forType(HoodieTestDataGenerator.RecordIdentifier.class).readValues(basePath.resolve("unmerged_records.json").toFile()).forEachRemaining(expectedUnMergedRecords::add);
        expectedRecords = expectedRecords.stream().map(recordIdentifier -> HoodieTestDataGenerator.RecordIdentifier.clone(recordIdentifier, recordIdentifier.getOrderingVal())).collect(Collectors.toList());
        expectedUnMergedRecords = expectedUnMergedRecords.stream().map(recordIdentifier -> HoodieTestDataGenerator.RecordIdentifier.clone(recordIdentifier, recordIdentifier.getOrderingVal())).collect(Collectors.toList());
        this.validateOutputFromFileGroupReaderWithExistingRecords(this.getStorageConf(), basePath.toString(), true, 1, RecordMergeMode.EVENT_TIME_ORDERING, expectedRecords, expectedUnMergedRecords);
    }

    @ParameterizedTest
    @EnumSource(value=ExternalSpillableMap.DiskMapType.class)
    public void testSpillableMapUsage(ExternalSpillableMap.DiskMapType diskMapType) throws Exception {
        HashMap<String, String> writeConfigs = new HashMap<String, String>(this.getCommonConfigs(RecordMergeMode.COMMIT_TIME_ORDERING, true));
        try (HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator(57071L);){
            List<HoodieRecord> recordList = dataGen.generateInserts("001", 100);
            long timestamp = (Long)((GenericRecord)recordList.get(0).getData()).get(ORDERING_FIELD_NAME);
            this.commitToTable(recordList, WriteOperationType.INSERT.value(), true, writeConfigs);
            String baseMapPath = Files.createTempDirectory(null, new FileAttribute[0]).toString();
            HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient(this.getStorageConf(), this.getBasePath());
            Schema avroSchema = new TableSchemaResolver(metaClient).getTableAvroSchema();
            List<FileSlice> fileSlices = this.getFileSlicesToRead(this.getStorageConf(), this.getBasePath(), metaClient, true, 0);
            List<T> records = this.readRecordsFromFileGroup(this.getStorageConf(), this.getBasePath(), metaClient, fileSlices, avroSchema, RecordMergeMode.COMMIT_TIME_ORDERING, false, false);
            HoodieReaderContext<T> readerContext = this.getHoodieReaderContext(this.getBasePath(), avroSchema, this.getStorageConf(), metaClient);
            boolean[] blArray = new boolean[]{true, false};
            int n = blArray.length;
            for (int i = 0; i < n; ++i) {
                Boolean isCompressionEnabled = blArray[i];
                try (ExternalSpillableMap spillableMap = new ExternalSpillableMap(16L, baseMapPath, (SizeEstimator)new DefaultSizeEstimator(), (SizeEstimator)new HoodieRecordSizeEstimator(avroSchema), diskMapType, (CustomSerializer)new DefaultSerializer(), isCompressionEnabled.booleanValue(), this.getClass().getSimpleName());){
                    Long l;
                    String recordKey;
                    Long position = 0L;
                    for (T record : records) {
                        recordKey = readerContext.getRecordContext().getRecordKey(record, avroSchema);
                        BufferedRecord bufferedRecord = BufferedRecords.fromEngineRecord(record, (Schema)avroSchema, (RecordContext)readerContext.getRecordContext(), Collections.singletonList(ORDERING_FIELD_NAME), (boolean)false);
                        spillableMap.put((Serializable)((Object)recordKey), (Object)bufferedRecord.toBinary(readerContext.getRecordContext()));
                        Long l2 = position;
                        l = position = Long.valueOf(position + 1L);
                        spillableMap.put((Serializable)l2, (Object)bufferedRecord.toBinary(readerContext.getRecordContext()));
                    }
                    Assertions.assertEquals((int)(records.size() * 2), (int)spillableMap.size());
                    position = 0L;
                    for (T record : records) {
                        recordKey = readerContext.getRecordContext().getRecordKey(record, avroSchema);
                        BufferedRecord keyBased = (BufferedRecord)spillableMap.get((Object)recordKey);
                        Assertions.assertNotNull((Object)keyBased);
                        l = position;
                        Long l3 = position = Long.valueOf(position + 1L);
                        BufferedRecord positionBased = (BufferedRecord)spillableMap.get((Object)l);
                        Assertions.assertNotNull((Object)positionBased);
                        this.assertRecordsEqual(avroSchema, record, keyBased.getRecord());
                        this.assertRecordsEqual(avroSchema, record, positionBased.getRecord());
                        Assertions.assertEquals((Object)keyBased.getRecordKey(), (Object)recordKey);
                        Assertions.assertEquals((Object)positionBased.getRecordKey(), (Object)recordKey);
                        Assertions.assertEquals((Object)avroSchema, (Object)readerContext.getRecordContext().getSchemaFromBufferRecord(keyBased));
                        Assertions.assertEquals((Object)readerContext.getRecordContext().convertValueToEngineType((Comparable)Long.valueOf(timestamp)), (Object)positionBased.getOrderingValue());
                    }
                    continue;
                }
            }
        }
    }

    protected Map<String, String> getCommonConfigs(RecordMergeMode recordMergeMode, boolean populateMetaFields) {
        HashMap<String, String> configMapping = new HashMap<String, String>();
        configMapping.put(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), KEY_FIELD_NAME);
        configMapping.put(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), PARTITION_FIELD_NAME);
        configMapping.put(HoodieTableConfig.ORDERING_FIELDS.key(), recordMergeMode != RecordMergeMode.COMMIT_TIME_ORDERING ? ORDERING_FIELD_NAME : "");
        configMapping.put("hoodie.payload.ordering.field", ORDERING_FIELD_NAME);
        configMapping.put("hoodie.table.name", "hoodie_test");
        configMapping.put("hoodie.insert.shuffle.parallelism", "4");
        configMapping.put("hoodie.upsert.shuffle.parallelism", "4");
        configMapping.put("hoodie.bulkinsert.shuffle.parallelism", "2");
        configMapping.put("hoodie.delete.shuffle.parallelism", "1");
        configMapping.put("hoodie.merge.small.file.group.candidates.limit", "0");
        configMapping.put("hoodie.compact.inline", "false");
        configMapping.put("hoodie.write.record.merge.mode", recordMergeMode.name());
        if (recordMergeMode.equals((Object)RecordMergeMode.CUSTOM)) {
            configMapping.put("hoodie.datasource.write.payload.class", this.getCustomPayload());
        }
        configMapping.put("hoodie.populate.meta.fields", Boolean.toString(populateMetaFields));
        return configMapping;
    }

    private void validateOutputFromFileGroupReaderWithNativeRecords(StorageConfiguration<?> storageConf, String tablePath, boolean containsBaseFile, int expectedLogFileNum, RecordMergeMode recordMergeMode, List<Pair<String, IndexedRecord>> expectedRecords) throws Exception {
        HashSet metaCols = new HashSet(HoodieRecord.HOODIE_META_COLUMNS);
        HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient(storageConf, tablePath);
        TableSchemaResolver resolver = new TableSchemaResolver(metaClient);
        Schema avroSchema = resolver.getTableAvroSchema();
        Schema avroSchemaWithoutMeta = resolver.getTableAvroSchema(false);
        HoodieReaderContext readerContext = this.getHoodieReaderContext(tablePath, avroSchema, this.getStorageConf(), metaClient);
        List<FileSlice> fileSlices = this.getFileSlicesToRead(storageConf, tablePath, metaClient, containsBaseFile, expectedLogFileNum);
        boolean sortOutput = !containsBaseFile;
        List<Object> actualRecordList = this.readRecordsFromFileGroup(storageConf, tablePath, metaClient, fileSlices, avroSchema, recordMergeMode, false, sortOutput);
        Assertions.assertEquals((int)expectedRecords.size(), (int)actualRecordList.size());
        actualRecordList.forEach(r -> this.assertRecordMatchesSchema(avroSchema, r));
        Set<GenericRecord> actualRecordSet = actualRecordList.stream().map(r -> readerContext.getRecordContext().convertToAvroRecord(r, avroSchema)).map(r -> HoodieAvroUtils.removeFields((GenericRecord)r, (Set)metaCols)).collect(Collectors.toSet());
        Set<GenericRecord> expectedRecordSet = expectedRecords.stream().map(r -> TestHoodieFileGroupReaderBase.resetByteBufferPosition((IndexedRecord)((GenericRecord)r.getRight()))).map(r -> HoodieAvroUtils.rewriteRecordWithNewSchema((IndexedRecord)r, (Schema)avroSchemaWithoutMeta)).collect(Collectors.toSet());
        this.compareRecordSets(expectedRecordSet, actualRecordSet);
    }

    private void compareRecordSets(Set<GenericRecord> expectedRecordSet, Set<GenericRecord> actualRecordSet) {
        HashMap<String, GenericRecord> expectedMap = new HashMap<String, GenericRecord>(expectedRecordSet.size());
        for (GenericRecord expectedRecord : expectedRecordSet) {
            expectedMap.put(expectedRecord.get(KEY_FIELD_NAME).toString(), expectedRecord);
        }
        HashMap<String, GenericRecord> actualMap = new HashMap<String, GenericRecord>(actualRecordSet.size());
        for (GenericRecord actualRecord : actualRecordSet) {
            actualMap.put(actualRecord.get(KEY_FIELD_NAME).toString(), actualRecord);
        }
        Assertions.assertEquals(expectedMap.keySet(), actualMap.keySet());
        for (String key : actualMap.keySet()) {
            GenericRecord expectedRecord = (GenericRecord)expectedMap.get(key);
            GenericRecord actualRecord = (GenericRecord)actualMap.get(key);
            Assertions.assertEquals((Object)expectedRecord, (Object)actualRecord);
        }
    }

    protected void validateOutputFromFileGroupReader(StorageConfiguration<?> storageConf, String tablePath, boolean containsBaseFile, int expectedLogFileNum, RecordMergeMode recordMergeMode, List<HoodieRecord> expectedHoodieRecords, List<HoodieRecord> expectedHoodieUnmergedRecords, String[] orderingFields) throws Exception {
        HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient(storageConf, tablePath);
        Schema avroSchema = new TableSchemaResolver(metaClient).getTableAvroSchema();
        expectedHoodieRecords = TestHoodieFileGroupReaderBase.getExpectedHoodieRecordsWithOrderingValue(expectedHoodieRecords, metaClient, avroSchema);
        expectedHoodieUnmergedRecords = TestHoodieFileGroupReaderBase.getExpectedHoodieRecordsWithOrderingValue(expectedHoodieUnmergedRecords, metaClient, avroSchema);
        List<HoodieTestDataGenerator.RecordIdentifier> expectedRecords = this.convertHoodieRecords(expectedHoodieRecords, avroSchema, orderingFields);
        List<HoodieTestDataGenerator.RecordIdentifier> expectedUnmergedRecords = this.convertHoodieRecords(expectedHoodieUnmergedRecords, avroSchema, orderingFields);
        this.validateOutputFromFileGroupReaderWithExistingRecords(storageConf, tablePath, containsBaseFile, expectedLogFileNum, recordMergeMode, expectedRecords, expectedUnmergedRecords);
    }

    private static List<HoodieRecord> getExpectedHoodieRecordsWithOrderingValue(List<HoodieRecord> expectedHoodieRecords, HoodieTableMetaClient metaClient, Schema avroSchema) {
        return expectedHoodieRecords.stream().map(rec -> {
            List orderingFields = metaClient.getTableConfig().getOrderingFields();
            HoodieAvroIndexedRecord avroRecord = (HoodieAvroIndexedRecord)rec;
            Comparable orderingValue = OrderingValues.create((List)orderingFields, field -> (Comparable)avroRecord.getColumnValueAsJava(avroSchema, field, (Properties)new TypedProperties()));
            return new HoodieAvroIndexedRecord(rec.getKey(), avroRecord.getData(), orderingValue);
        }).collect(Collectors.toList());
    }

    private void validateOutputFromFileGroupReaderWithExistingRecords(StorageConfiguration<?> storageConf, String tablePath, boolean containsBaseFile, int expectedLogFileNum, RecordMergeMode recordMergeMode, List<HoodieTestDataGenerator.RecordIdentifier> expectedRecords, List<HoodieTestDataGenerator.RecordIdentifier> expectedUnmergedRecords) throws Exception {
        HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient(storageConf, tablePath);
        Schema avroSchema = new TableSchemaResolver(metaClient).getTableAvroSchema();
        HoodieReaderContext<T> readerContext = this.getHoodieReaderContext(tablePath, avroSchema, this.getStorageConf(), metaClient);
        List<FileSlice> fileSlices = this.getFileSlicesToRead(storageConf, tablePath, metaClient, containsBaseFile, expectedLogFileNum);
        boolean sortOutput = !containsBaseFile;
        List<HoodieTestDataGenerator.RecordIdentifier> actualRecordList = this.convertEngineRecords(this.readRecordsFromFileGroup(storageConf, tablePath, metaClient, fileSlices, avroSchema, recordMergeMode, false, sortOutput), avroSchema, readerContext, metaClient.getTableConfig().getOrderingFields());
        Assertions.assertEquals((int)expectedRecords.size(), (int)actualRecordList.size());
        Assertions.assertEquals(new HashSet<HoodieTestDataGenerator.RecordIdentifier>(expectedRecords), new HashSet<HoodieTestDataGenerator.RecordIdentifier>(actualRecordList));
        actualRecordList = this.convertHoodieRecords(this.readHoodieRecordsFromFileGroup(storageConf, tablePath, metaClient, fileSlices, avroSchema, recordMergeMode), avroSchema, readerContext, metaClient.getTableConfig().getOrderingFields());
        Assertions.assertEquals((int)expectedRecords.size(), (int)actualRecordList.size());
        Assertions.assertEquals(new HashSet<HoodieTestDataGenerator.RecordIdentifier>(expectedRecords), new HashSet<HoodieTestDataGenerator.RecordIdentifier>(actualRecordList));
        actualRecordList = this.convertEngineRecords(this.readRecordsFromFileGroup(storageConf, tablePath, metaClient, fileSlices, avroSchema, recordMergeMode, true, false), avroSchema, readerContext, metaClient.getTableConfig().getOrderingFields());
        Assertions.assertEquals((int)expectedUnmergedRecords.size(), (int)actualRecordList.size());
        Assertions.assertEquals(new HashSet<HoodieTestDataGenerator.RecordIdentifier>(expectedUnmergedRecords), new HashSet<HoodieTestDataGenerator.RecordIdentifier>(actualRecordList));
    }

    private List<FileSlice> getFileSlicesToRead(StorageConfiguration<?> storageConf, String tablePath, HoodieTableMetaClient metaClient, boolean containsBaseFile, int expectedLogFileNum) {
        HoodieLocalEngineContext engineContext = new HoodieLocalEngineContext(storageConf);
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().build();
        FileSystemViewManager viewManager = FileSystemViewManager.createViewManager((HoodieEngineContext)engineContext, (HoodieMetadataConfig)metadataConfig, (FileSystemViewStorageConfig)FileSystemViewStorageConfig.newBuilder().build(), (HoodieCommonConfig)HoodieCommonConfig.newBuilder().build(), arg_0 -> TestHoodieFileGroupReaderBase.lambda$getFileSlicesToRead$8baefedc$1(metaClient, (HoodieEngineContext)engineContext, metadataConfig, tablePath, arg_0));
        HoodieTableFileSystemView fsView = (HoodieTableFileSystemView)viewManager.getFileSystemView(metaClient);
        List relativePartitionPathList = FSUtils.getAllPartitionPaths((HoodieEngineContext)engineContext, (HoodieTableMetaClient)metaClient, (HoodieMetadataConfig)metadataConfig);
        List<FileSlice> fileSlices = relativePartitionPathList.stream().flatMap(arg_0 -> ((HoodieTableFileSystemView)fsView).getAllFileSlices(arg_0)).collect(Collectors.toList());
        fileSlices.forEach(fileSlice -> {
            if (fileSlice.hasBootstrapBase()) {
                HoodieBaseFile baseFile = (HoodieBaseFile)fileSlice.getBaseFile().get();
                String bootstrapPath = ((BaseFile)baseFile.getBootstrapBaseFile().get()).getPath();
                String newBootstrapPath = tablePath + "/" + bootstrapPath.substring(bootstrapPath.indexOf("bootstrap_table"));
                baseFile.setBootstrapBaseFile(new BaseFile(newBootstrapPath));
            }
            List<String> logFilePathList = HoodieTestUtils.getLogFileListFromFileSlice(fileSlice);
            if (expectedLogFileNum >= 0) {
                Assertions.assertEquals((int)expectedLogFileNum, (int)logFilePathList.size());
            }
            Assertions.assertEquals((Object)containsBaseFile, (Object)fileSlice.getBaseFile().isPresent());
        });
        return fileSlices;
    }

    private List<T> readRecordsFromFileGroup(StorageConfiguration<?> storageConf, String tablePath, HoodieTableMetaClient metaClient, List<FileSlice> fileSlices, Schema avroSchema, RecordMergeMode recordMergeMode, boolean isSkipMerge, boolean sortOutput) {
        ArrayList actualRecordList = new ArrayList();
        TypedProperties props = this.buildProperties(metaClient, recordMergeMode);
        if (isSkipMerge) {
            props.setProperty(HoodieReaderConfig.MERGE_TYPE.key(), "skip_merge");
        }
        fileSlices.forEach(fileSlice -> {
            if (this.shouldValidatePartialRead((FileSlice)fileSlice, avroSchema)) {
                Assertions.assertThrows(IllegalArgumentException.class, () -> this.getHoodieFileGroupReader(storageConf, tablePath, metaClient, avroSchema, (FileSlice)fileSlice, 1, props, sortOutput));
            }
            try (HoodieFileGroupReader<T> fileGroupReader = this.getHoodieFileGroupReader(storageConf, tablePath, metaClient, avroSchema, (FileSlice)fileSlice, 0, props, sortOutput);){
                this.readWithFileGroupReader(fileGroupReader, actualRecordList, avroSchema, this.getHoodieReaderContext(tablePath, avroSchema, storageConf, metaClient), sortOutput);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        });
        return actualRecordList;
    }

    private HoodieFileGroupReader<T> getHoodieFileGroupReader(StorageConfiguration<?> storageConf, String tablePath, HoodieTableMetaClient metaClient, Schema avroSchema, FileSlice fileSlice, int start, TypedProperties props, boolean sortOutput) {
        return HoodieFileGroupReader.newBuilder().withReaderContext(this.getHoodieReaderContext(tablePath, avroSchema, storageConf, metaClient)).withHoodieTableMetaClient(metaClient).withLatestCommitTime(((HoodieInstant)metaClient.getActiveTimeline().lastInstant().get()).requestedTime()).withFileSlice(fileSlice).withDataSchema(avroSchema).withRequestedSchema(avroSchema).withProps(props).withStart((long)start).withLength(fileSlice.getTotalFileSize()).withShouldUseRecordPosition(false).withAllowInflightInstants(false).withSortOutput(sortOutput).build();
    }

    protected void readWithFileGroupReader(HoodieFileGroupReader<T> fileGroupReader, List<T> recordList, Schema avroSchema, HoodieReaderContext<T> readerContext, boolean sortOutput) throws IOException {
        String lastKey = null;
        try (ClosableIterator fileGroupReaderIterator = fileGroupReader.getClosableIterator();){
            while (fileGroupReaderIterator.hasNext()) {
                Object next = fileGroupReaderIterator.next();
                if (sortOutput) {
                    String currentKey = readerContext.getRecordContext().getRecordKey(next, avroSchema);
                    Assertions.assertTrue((lastKey == null || lastKey.compareTo(currentKey) < 0 ? 1 : 0) != 0, (String)"Record keys should be sorted within the file group");
                    lastKey = currentKey;
                }
                recordList.add(next);
            }
        }
    }

    private List<HoodieRecord<T>> readHoodieRecordsFromFileGroup(StorageConfiguration<?> storageConf, String tablePath, HoodieTableMetaClient metaClient, List<FileSlice> fileSlices, Schema avroSchema, RecordMergeMode recordMergeMode) {
        ArrayList<HoodieRecord<T>> actualRecordList = new ArrayList<HoodieRecord<T>>();
        TypedProperties props = this.buildProperties(metaClient, recordMergeMode);
        fileSlices.forEach(fileSlice -> {
            try (HoodieFileGroupReader<T> fileGroupReader = this.getHoodieFileGroupReader(storageConf, tablePath, metaClient, avroSchema, (FileSlice)fileSlice, 0, props, false);
                 ClosableIterator iter = fileGroupReader.getClosableHoodieRecordIterator();){
                while (iter.hasNext()) {
                    actualRecordList.add((HoodieRecord<T>)iter.next());
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        });
        return actualRecordList;
    }

    private TypedProperties buildProperties(HoodieTableMetaClient metaClient, RecordMergeMode recordMergeMode) {
        TypedProperties props = new TypedProperties();
        props.setProperty(HoodieTableConfig.ORDERING_FIELDS.key(), (String)metaClient.getTableConfig().getOrderingFieldsStr().orElse((Object)""));
        props.setProperty("hoodie.payload.ordering.field", (String)metaClient.getTableConfig().getOrderingFieldsStr().orElse((Object)""));
        props.setProperty(HoodieTableConfig.RECORD_MERGE_MODE.key(), recordMergeMode.name());
        if (recordMergeMode.equals((Object)RecordMergeMode.CUSTOM)) {
            props.setProperty(HoodieTableConfig.RECORD_MERGE_STRATEGY_ID.key(), "00000000-0000-0000-0000-000000000000");
            props.setProperty(HoodieTableConfig.PAYLOAD_CLASS_NAME.key(), this.getCustomPayload());
        }
        props.setProperty(HoodieMemoryConfig.MAX_MEMORY_FOR_MERGE.key(), String.valueOf(HoodieMemoryConfig.MAX_MEMORY_FOR_MERGE.defaultValue()));
        props.setProperty(HoodieMemoryConfig.SPILLABLE_MAP_BASE_PATH.key(), metaClient.getTempFolderPath());
        props.setProperty(HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE.key(), ExternalSpillableMap.DiskMapType.ROCKS_DB.name());
        props.setProperty(HoodieCommonConfig.DISK_MAP_BITCASK_COMPRESSION_ENABLED.key(), "false");
        if (metaClient.getTableConfig().contains(HoodieTableConfig.PARTITION_FIELDS)) {
            props.setProperty(HoodieTableConfig.PARTITION_FIELDS.key(), metaClient.getTableConfig().getString(HoodieTableConfig.PARTITION_FIELDS));
        }
        return props;
    }

    private boolean shouldValidatePartialRead(FileSlice fileSlice, Schema requestedSchema) {
        if (fileSlice.getLogFiles().findAny().isPresent()) {
            return true;
        }
        if (((HoodieBaseFile)fileSlice.getBaseFile().get()).getBootstrapBaseFile().isPresent()) {
            Pair dataAndMetaCols = FileGroupReaderSchemaHandler.getDataAndMetaCols((Schema)requestedSchema);
            return !((List)dataAndMetaCols.getLeft()).isEmpty() && !((List)dataAndMetaCols.getRight()).isEmpty();
        }
        return false;
    }

    protected List<Pair<String, IndexedRecord>> mergeIndexedRecordLists(List<Pair<String, IndexedRecord>> updates, List<Pair<String, IndexedRecord>> existing) {
        Set updatedKeys = updates.stream().map(Pair::getLeft).collect(Collectors.toSet());
        return Stream.concat(updates.stream(), existing.stream().filter(record -> !updatedKeys.contains(record.getLeft()))).collect(Collectors.toList());
    }

    protected List<HoodieRecord> mergeRecordLists(List<HoodieRecord> updates, List<HoodieRecord> existing) {
        Set updatedKeys = updates.stream().map(HoodieRecord::getRecordKey).collect(Collectors.toSet());
        return Stream.concat(updates.stream(), existing.stream().filter(record -> !updatedKeys.contains(record.getRecordKey()))).collect(Collectors.toList());
    }

    private List<HoodieTestDataGenerator.RecordIdentifier> convertHoodieRecords(List<HoodieRecord> records, Schema schema, String[] orderingFields) {
        return records.stream().map(record -> HoodieTestDataGenerator.RecordIdentifier.fromTripTestPayload((HoodieAvroIndexedRecord)record, orderingFields)).collect(Collectors.toList());
    }

    private List<HoodieTestDataGenerator.RecordIdentifier> convertEngineRecords(List<T> records, Schema schema, HoodieReaderContext<T> readerContext, List<String> preCombineFields) {
        return records.stream().map(record -> new HoodieTestDataGenerator.RecordIdentifier(readerContext.getRecordContext().getValue(record, schema, KEY_FIELD_NAME).toString(), readerContext.getRecordContext().getValue(record, schema, PARTITION_FIELD_NAME).toString(), OrderingValues.create((List)preCombineFields, field -> (Comparable)readerContext.getRecordContext().getValue(record, schema, field)).toString(), readerContext.getRecordContext().getValue(record, schema, RIDER_FIELD_NAME).toString())).collect(Collectors.toList());
    }

    private List<HoodieTestDataGenerator.RecordIdentifier> convertHoodieRecords(List<HoodieRecord<T>> records, Schema schema, HoodieReaderContext<T> readerContext, List<String> orderingFields) {
        TypedProperties props = new TypedProperties();
        props.setProperty(HoodieTableConfig.ORDERING_FIELDS.key(), String.join((CharSequence)",", orderingFields));
        return records.stream().map(record -> {
            Object data = readerContext.getRecordContext().extractDataFromRecord(record, schema, (Properties)props);
            return new HoodieTestDataGenerator.RecordIdentifier(record.getRecordKey(), TestHoodieFileGroupReaderBase.removeHiveStylePartition(record.getPartitionPath()), record.getOrderingValue(schema, (Properties)props, orderingFields.toArray(new String[0])).toString(), readerContext.getRecordContext().getValue(data, schema, RIDER_FIELD_NAME).toString());
        }).collect(Collectors.toList());
    }

    private static String removeHiveStylePartition(String partitionPath) {
        int indexOf = partitionPath.indexOf("=");
        if (indexOf > 0) {
            return partitionPath.substring(indexOf + 1);
        }
        return partitionPath;
    }

    private static IndexedRecord resetByteBufferPosition(IndexedRecord record) {
        for (Schema.Field field : record.getSchema().getFields()) {
            Object value = record.get(field.pos());
            TestHoodieFileGroupReaderBase.resetByteBufferField(value, field.schema());
        }
        return record;
    }

    private static void resetByteBufferField(Object value, Schema fieldSchema) {
        if (value == null) {
            return;
        }
        Schema.Type fieldType = HoodieAvroUtils.unwrapNullable((Schema)fieldSchema).getType();
        if (fieldType == Schema.Type.BYTES || fieldType == Schema.Type.FIXED) {
            if (value instanceof ByteBuffer) {
                ((ByteBuffer)value).rewind();
            }
        } else if (fieldType == Schema.Type.RECORD) {
            TestHoodieFileGroupReaderBase.resetByteBufferPosition((IndexedRecord)value);
        } else if (fieldType == Schema.Type.ARRAY) {
            ((List)value).forEach(element -> TestHoodieFileGroupReaderBase.resetByteBufferField(element, fieldSchema.getElementType()));
        } else if (fieldType == Schema.Type.MAP) {
            ((Map)value).values().forEach(element -> TestHoodieFileGroupReaderBase.resetByteBufferField(element, fieldSchema.getValueType()));
        }
    }

    private static /* synthetic */ HoodieTableMetadata lambda$getFileSlicesToRead$8baefedc$1(HoodieTableMetaClient metaClient, HoodieEngineContext engineContext, HoodieMetadataConfig metadataConfig, String tablePath, HoodieTableMetaClient mc) {
        return metaClient.getTableFormat().getMetadataFactory().create(engineContext, mc.getStorage(), metadataConfig, tablePath);
    }
}

