/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.table.read.FileGroupReaderSchemaHandler;
import org.apache.hudi.common.table.read.ParquetRowIndexBasedSchemaHandler;
import org.apache.hudi.common.table.read.SchemaHandlerTestBase;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

public class TestParquetRowIndexBasedSchemaHandler
extends SchemaHandlerTestBase {
    @Test
    public void testCowBootstrapWithPositionMerge() {
        Mockito.when((Object)this.hoodieTableConfig.populateMetaFields()).thenReturn((Object)true);
        HoodieReaderContext<String> readerContext = TestParquetRowIndexBasedSchemaHandler.createReaderContext(this.hoodieTableConfig, true, false, true, false, null);
        Schema requestedSchema = TestParquetRowIndexBasedSchemaHandler.generateProjectionSchema("begin_lat", "tip_history", "_hoodie_record_key", "rider");
        FileGroupReaderSchemaHandler schemaHandler = this.createSchemaHandler(readerContext, DATA_SCHEMA, requestedSchema, true);
        Assertions.assertTrue((boolean)readerContext.getNeedsBootstrapMerge());
        Schema expectedRequiredSchema = TestParquetRowIndexBasedSchemaHandler.generateProjectionSchema("_hoodie_record_key", "begin_lat", "tip_history", "rider");
        Assertions.assertEquals((Object)expectedRequiredSchema, (Object)schemaHandler.getRequiredSchema());
        Pair bootstrapFields = schemaHandler.getBootstrapRequiredFields();
        Assertions.assertEquals(Arrays.asList(this.getField("_hoodie_record_key"), ParquetRowIndexBasedSchemaHandler.getPositionalMergeField()), (Object)bootstrapFields.getLeft());
        Assertions.assertEquals(Arrays.asList(this.getField("begin_lat"), this.getField("tip_history"), this.getField("rider"), ParquetRowIndexBasedSchemaHandler.getPositionalMergeField()), (Object)bootstrapFields.getRight());
        schemaHandler = this.createSchemaHandler(readerContext, DATA_SCHEMA, DATA_COLS_ONLY_SCHEMA, true);
        Assertions.assertFalse((boolean)readerContext.getNeedsBootstrapMerge());
        Assertions.assertEquals((Object)DATA_COLS_ONLY_SCHEMA, (Object)schemaHandler.getRequiredSchema());
        bootstrapFields = schemaHandler.getBootstrapRequiredFields();
        Assertions.assertTrue((boolean)((List)bootstrapFields.getLeft()).isEmpty());
        Assertions.assertEquals(Arrays.asList(this.getField("begin_lat"), this.getField("tip_history"), this.getField("rider")), (Object)bootstrapFields.getRight());
        schemaHandler = this.createSchemaHandler(readerContext, DATA_SCHEMA, META_COLS_ONLY_SCHEMA, true);
        Assertions.assertFalse((boolean)readerContext.getNeedsBootstrapMerge());
        Assertions.assertEquals((Object)META_COLS_ONLY_SCHEMA, (Object)schemaHandler.getRequiredSchema());
        bootstrapFields = schemaHandler.getBootstrapRequiredFields();
        Assertions.assertEquals(Arrays.asList(this.getField("_hoodie_commit_seqno"), this.getField("_hoodie_record_key")), (Object)bootstrapFields.getLeft());
        Assertions.assertTrue((boolean)((List)bootstrapFields.getRight()).isEmpty());
    }

    private static Stream<Arguments> testMorParams() {
        return TestParquetRowIndexBasedSchemaHandler.testMorParams(true);
    }

    @Override
    @ParameterizedTest
    @MethodSource(value={"testMorParams"})
    public void testMor(RecordMergeMode mergeMode, boolean hasPrecombine, boolean isProjectionCompatible, boolean mergeUseRecordPosition, boolean supportsParquetRowIndex, boolean hasBuiltInDelete) throws IOException {
        super.testMor(mergeMode, hasPrecombine, isProjectionCompatible, mergeUseRecordPosition, supportsParquetRowIndex, hasBuiltInDelete);
    }

    @Override
    @ParameterizedTest
    @MethodSource(value={"testMorParams"})
    public void testMorBootstrap(RecordMergeMode mergeMode, boolean hasPrecombine, boolean isProjectionCompatible, boolean mergeUseRecordPosition, boolean supportsParquetRowIndex, boolean hasBuiltInDelete) throws IOException {
        super.testMorBootstrap(mergeMode, hasPrecombine, isProjectionCompatible, mergeUseRecordPosition, supportsParquetRowIndex, hasBuiltInDelete);
    }

    @Override
    FileGroupReaderSchemaHandler createSchemaHandler(HoodieReaderContext<String> readerContext, Schema dataSchema, Schema requestedSchema, boolean supportsParquetRowIndex) {
        return new ParquetRowIndexBasedSchemaHandler(readerContext, dataSchema, requestedSchema, Option.empty(), new TypedProperties(), this.metaClient);
    }
}

