/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.util.Map;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.table.read.PartialUpdateHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestPartialUpdateHandler {
    TestPartialUpdateHandler() {
    }

    @Test
    void testEmptyProperties() {
        TypedProperties props = new TypedProperties();
        Map result = PartialUpdateHandler.parseMergeProperties((TypedProperties)props);
        Assertions.assertTrue((boolean)result.isEmpty());
    }

    @Test
    void testNonEmptyProperties() {
        TypedProperties props = new TypedProperties();
        props.put((Object)"hoodie.record.merge.property.hoodie.write.partial.update.unavailable.value", (Object)"__debezium_unavailable_value");
        Map result = PartialUpdateHandler.parseMergeProperties((TypedProperties)props);
        Assertions.assertTrue((boolean)result.containsKey("hoodie.write.partial.update.unavailable.value"));
        Assertions.assertEquals((Object)"__debezium_unavailable_value", result.get("hoodie.write.partial.update.unavailable.value"));
    }

    @Test
    void testDirectMatch() {
        Schema stringSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        Assertions.assertTrue((boolean)PartialUpdateHandler.hasTargetType((Schema)stringSchema, (Schema.Type)Schema.Type.STRING));
    }

    @Test
    void testUnionWithTargetType() {
        Schema unionSchema = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.BOOLEAN), Schema.create((Schema.Type)Schema.Type.STRING)});
        Assertions.assertTrue((boolean)PartialUpdateHandler.hasTargetType((Schema)unionSchema, (Schema.Type)Schema.Type.STRING));
    }

    @Test
    void testUnionWithoutTargetType() {
        Schema unionSchema = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.BOOLEAN), Schema.create((Schema.Type)Schema.Type.INT)});
        Assertions.assertFalse((boolean)PartialUpdateHandler.hasTargetType((Schema)unionSchema, (Schema.Type)Schema.Type.STRING));
    }

    @Test
    void testNonUnionNonTargetType() {
        Schema intSchema = Schema.create((Schema.Type)Schema.Type.INT);
        Assertions.assertFalse((boolean)PartialUpdateHandler.hasTargetType((Schema)intSchema, (Schema.Type)Schema.Type.STRING));
    }
}

