/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.io.IOException;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.engine.RecordContext;
import org.apache.hudi.common.model.BaseAvroPayload;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.SerializableIndexedRecord;
import org.apache.hudi.common.table.read.BaseFileUpdateCallback;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.table.read.HoodieReadStats;
import org.apache.hudi.common.table.read.UpdateProcessor;
import org.apache.hudi.common.util.Option;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class TestUpdateProcessor {
    private final HoodieReaderContext<IndexedRecord> readerContext = (HoodieReaderContext)Mockito.mock(HoodieReaderContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private final RecordContext<IndexedRecord> recordContext = (RecordContext)Mockito.mock(RecordContext.class);
    private static final String KEY = "key";
    private static final Schema SCHEMA = (Schema)SchemaBuilder.record((String)"TestRecord").fields().name("key").type().stringType().noDefault().name("value").type().stringType().noDefault().endRecord();

    TestUpdateProcessor() {
    }

    private static Stream<Arguments> handleEmitDeletes() {
        BufferedRecord<IndexedRecord> previous = TestUpdateProcessor.getRecord("value1", null);
        BufferedRecord<IndexedRecord> merged = TestUpdateProcessor.getRecord("value2", null);
        BufferedRecord<IndexedRecord> mergedWithUpdateBefore = TestUpdateProcessor.getRecord("value2", HoodieOperation.UPDATE_BEFORE);
        BufferedRecord mergedWithEmpty = new BufferedRecord(KEY, (Comparable)Integer.valueOf(1), null, Integer.valueOf(0), null);
        BufferedRecord<IndexedRecord> expected = TestUpdateProcessor.getRecord("value2", HoodieOperation.DELETE);
        BufferedRecord<IndexedRecord> expectedWithUpdateBefore = TestUpdateProcessor.getRecord("value2", HoodieOperation.UPDATE_BEFORE);
        return Stream.of(Arguments.of((Object[])new Object[]{previous, merged, expected, true}), Arguments.of((Object[])new Object[]{previous, merged, expected, false}), Arguments.of((Object[])new Object[]{previous, mergedWithUpdateBefore, expectedWithUpdateBefore, true}), Arguments.of((Object[])new Object[]{previous, mergedWithUpdateBefore, expectedWithUpdateBefore, false}), Arguments.of((Object[])new Object[]{previous, mergedWithEmpty, null, true}), Arguments.of((Object[])new Object[]{previous, mergedWithEmpty, null, false}));
    }

    @ParameterizedTest
    @MethodSource(value={"handleEmitDeletes"})
    void testHandleEmitDeletes(BufferedRecord<IndexedRecord> previous, BufferedRecord<IndexedRecord> merged, BufferedRecord<IndexedRecord> expected, boolean usePayload) {
        if (merged.getRecord() == null) {
            Mockito.when((Object)this.readerContext.getRecordContext()).thenReturn(this.recordContext);
        }
        HoodieReadStats readStats = new HoodieReadStats();
        BaseFileUpdateCallback updateCallback = (BaseFileUpdateCallback)Mockito.mock(BaseFileUpdateCallback.class);
        Object delegate = usePayload ? new UpdateProcessor.PayloadUpdateProcessor(readStats, this.readerContext, true, new Properties(), "org.apache.hudi.common.testutils.DummyPayload") : new UpdateProcessor.StandardUpdateProcessor(readStats, this.readerContext, true);
        UpdateProcessor.CallbackProcessor updateProcessor = new UpdateProcessor.CallbackProcessor(updateCallback, (UpdateProcessor)delegate);
        BufferedRecord result = updateProcessor.processUpdate(KEY, previous, merged, true);
        Assertions.assertEquals(expected, (Object)result);
        this.verifyReadStats(readStats, 0, 0, 1);
        if (merged.getRecord() == null) {
            ((RecordContext)Mockito.verify(this.recordContext)).getDeleteRow(KEY);
        }
        ((BaseFileUpdateCallback)Mockito.verify((Object)updateCallback)).onDelete(KEY, previous, merged.getHoodieOperation());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testHandleDelete(boolean usePayload) {
        BufferedRecord<IndexedRecord> previous = TestUpdateProcessor.getRecord("value1", null);
        BufferedRecord<IndexedRecord> merged = TestUpdateProcessor.getRecord("value2", null);
        HoodieReadStats readStats = new HoodieReadStats();
        BaseFileUpdateCallback updateCallback = (BaseFileUpdateCallback)Mockito.mock(BaseFileUpdateCallback.class);
        Object delegate = usePayload ? new UpdateProcessor.PayloadUpdateProcessor(readStats, this.readerContext, false, new Properties(), "org.apache.hudi.common.testutils.DummyPayload") : new UpdateProcessor.StandardUpdateProcessor(readStats, this.readerContext, false);
        UpdateProcessor.CallbackProcessor updateProcessor = new UpdateProcessor.CallbackProcessor(updateCallback, (UpdateProcessor)delegate);
        BufferedRecord result = updateProcessor.processUpdate(KEY, previous, merged, true);
        Assertions.assertNull((Object)result);
        this.verifyReadStats(readStats, 0, 0, 1);
        ((BaseFileUpdateCallback)Mockito.verify((Object)updateCallback)).onDelete(KEY, previous, merged.getHoodieOperation());
    }

    @Test
    void testHandleInsert() {
        Mockito.when((Object)this.readerContext.getRecordContext()).thenReturn(this.recordContext);
        Mockito.when((Object)this.recordContext.seal(ArgumentMatchers.any())).thenAnswer(invocationOnMock -> invocationOnMock.getArgument(0));
        BufferedRecord previous = null;
        BufferedRecord<IndexedRecord> merged = TestUpdateProcessor.getRecord("value2", null);
        BufferedRecord<IndexedRecord> expected = TestUpdateProcessor.getRecord("value2", HoodieOperation.INSERT);
        HoodieReadStats readStats = new HoodieReadStats();
        BaseFileUpdateCallback updateCallback = (BaseFileUpdateCallback)Mockito.mock(BaseFileUpdateCallback.class);
        UpdateProcessor.CallbackProcessor updateProcessor = new UpdateProcessor.CallbackProcessor(updateCallback, (UpdateProcessor)new UpdateProcessor.StandardUpdateProcessor(readStats, this.readerContext, false));
        BufferedRecord result = updateProcessor.processUpdate(KEY, previous, merged, false);
        Assertions.assertEquals(expected, (Object)result);
        this.verifyReadStats(readStats, 1, 0, 0);
        ((BaseFileUpdateCallback)Mockito.verify((Object)updateCallback)).onInsert(KEY, merged);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testHandleInsertWithPayload(boolean shouldIgnore) {
        Mockito.when((Object)this.readerContext.getRecordContext()).thenReturn(this.recordContext);
        Mockito.when((Object)this.recordContext.seal(ArgumentMatchers.any())).thenAnswer(invocationOnMock -> invocationOnMock.getArgument(0));
        BufferedRecord previous = null;
        BufferedRecord<IndexedRecord> merged = TestUpdateProcessor.getRecord("value2", null);
        BufferedRecord<IndexedRecord> expected = TestUpdateProcessor.getRecord("value2", HoodieOperation.INSERT);
        HoodieReadStats readStats = new HoodieReadStats();
        BaseFileUpdateCallback updateCallback = (BaseFileUpdateCallback)Mockito.mock(BaseFileUpdateCallback.class);
        UpdateProcessor.CallbackProcessor updateProcessor = new UpdateProcessor.CallbackProcessor(updateCallback, (UpdateProcessor)new UpdateProcessor.PayloadUpdateProcessor(readStats, this.readerContext, false, new Properties(), DummyPayload.class.getName()));
        Mockito.when((Object)this.recordContext.decodeAvroSchema((Object)merged.getSchemaId())).thenReturn((Object)SCHEMA);
        Mockito.when((Object)this.recordContext.convertToAvroRecord(merged.getRecord(), SCHEMA)).thenReturn((Object)((GenericRecord)((SerializableIndexedRecord)merged.getRecord()).getData()));
        if (shouldIgnore) {
            Mockito.when((Object)this.recordContext.convertToAvroRecord(merged.getRecord(), SCHEMA)).thenReturn((Object)HoodieRecord.SENTINEL);
        } else {
            Mockito.when((Object)this.recordContext.convertToAvroRecord(merged.getRecord(), SCHEMA)).thenReturn((Object)((GenericRecord)((SerializableIndexedRecord)merged.getRecord()).getData()));
            Mockito.when((Object)this.readerContext.getSchemaHandler().getRequestedSchema()).thenReturn((Object)SCHEMA);
            Mockito.when((Object)this.recordContext.convertAvroRecord((IndexedRecord)ArgumentMatchers.any())).thenAnswer(invocationOnMock -> invocationOnMock.getArgument(0));
        }
        BufferedRecord result = updateProcessor.processUpdate(KEY, previous, merged, false);
        if (shouldIgnore) {
            Assertions.assertNull((Object)result);
            this.verifyReadStats(readStats, 0, 0, 0);
            Mockito.verifyNoInteractions((Object[])new Object[]{updateCallback});
        } else {
            Assertions.assertEquals(expected, (Object)result);
            this.verifyReadStats(readStats, 1, 0, 0);
            ((BaseFileUpdateCallback)Mockito.verify((Object)updateCallback)).onInsert(KEY, merged);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testHandleNoUpdate(boolean usePayload) {
        BufferedRecord<IndexedRecord> previous;
        Mockito.when((Object)this.readerContext.getRecordContext()).thenReturn(this.recordContext);
        Mockito.when((Object)this.recordContext.seal(ArgumentMatchers.any())).thenAnswer(invocationOnMock -> invocationOnMock.getArgument(0));
        BufferedRecord<IndexedRecord> merged = previous = TestUpdateProcessor.getRecord("value2", null);
        HoodieReadStats readStats = new HoodieReadStats();
        BaseFileUpdateCallback updateCallback = (BaseFileUpdateCallback)Mockito.mock(BaseFileUpdateCallback.class);
        Object delegate = usePayload ? new UpdateProcessor.PayloadUpdateProcessor(readStats, this.readerContext, false, new Properties(), "org.apache.hudi.common.testutils.DummyPayload") : new UpdateProcessor.StandardUpdateProcessor(readStats, this.readerContext, false);
        UpdateProcessor.CallbackProcessor updateProcessor = new UpdateProcessor.CallbackProcessor(updateCallback, (UpdateProcessor)delegate);
        BufferedRecord result = updateProcessor.processUpdate(KEY, previous, merged, false);
        Assertions.assertEquals(merged, (Object)result);
        this.verifyReadStats(readStats, 0, 0, 0);
        Mockito.verifyNoInteractions((Object[])new Object[]{updateCallback});
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testHandleUpdate(boolean usePayload) {
        Mockito.when((Object)this.readerContext.getRecordContext()).thenReturn(this.recordContext);
        Mockito.when((Object)this.recordContext.seal(ArgumentMatchers.any())).thenAnswer(invocationOnMock -> invocationOnMock.getArgument(0));
        BufferedRecord<IndexedRecord> previous = TestUpdateProcessor.getRecord("value1", null);
        BufferedRecord<IndexedRecord> merged = TestUpdateProcessor.getRecord("value2", null);
        BufferedRecord<IndexedRecord> expected = TestUpdateProcessor.getRecord("value2", HoodieOperation.UPDATE_AFTER);
        HoodieReadStats readStats = new HoodieReadStats();
        BaseFileUpdateCallback updateCallback = (BaseFileUpdateCallback)Mockito.mock(BaseFileUpdateCallback.class);
        Object delegate = usePayload ? new UpdateProcessor.PayloadUpdateProcessor(readStats, this.readerContext, false, new Properties(), "org.apache.hudi.common.testutils.DummyPayload") : new UpdateProcessor.StandardUpdateProcessor(readStats, this.readerContext, false);
        UpdateProcessor.CallbackProcessor updateProcessor = new UpdateProcessor.CallbackProcessor(updateCallback, (UpdateProcessor)delegate);
        BufferedRecord result = updateProcessor.processUpdate(KEY, previous, merged, false);
        Assertions.assertEquals(expected, (Object)result);
        this.verifyReadStats(readStats, 0, 1, 0);
        ((BaseFileUpdateCallback)Mockito.verify((Object)updateCallback)).onUpdate(KEY, previous, merged);
    }

    private void verifyReadStats(HoodieReadStats readStats, int numInserts, int numUpdates, int numDeletes) {
        Assertions.assertEquals((long)numInserts, (long)readStats.getNumInserts());
        Assertions.assertEquals((long)numUpdates, (long)readStats.getNumUpdates());
        Assertions.assertEquals((long)numDeletes, (long)readStats.getNumDeletes());
    }

    private static BufferedRecord<IndexedRecord> getRecord(String value, HoodieOperation operation) {
        GenericData.Record record = new GenericData.Record(SCHEMA);
        record.put(KEY, (Object)KEY);
        record.put("value", (Object)value);
        return new BufferedRecord(KEY, (Comparable)Integer.valueOf(1), (Object)SerializableIndexedRecord.createInstance((IndexedRecord)record), Integer.valueOf(0), operation);
    }

    public static class DummyPayload
    extends BaseAvroPayload
    implements HoodieRecordPayload<DummyPayload> {
        private final boolean isSentinel;

        public DummyPayload(GenericRecord record, Comparable orderingVal) {
            super(record == HoodieRecord.SENTINEL ? null : record, orderingVal);
            this.isSentinel = record == HoodieRecord.SENTINEL;
        }

        public boolean canProduceSentinel() {
            return true;
        }

        public DummyPayload preCombine(DummyPayload oldValue) {
            return null;
        }

        public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord currentValue, Schema schema) throws IOException {
            return null;
        }

        public Option<IndexedRecord> getInsertValue(Schema schema) throws IOException {
            if (this.isSentinel) {
                return Option.of((Object)HoodieRecord.SENTINEL);
            }
            return this.getRecord(schema);
        }
    }
}

