/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read.buffer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.engine.RecordContext;
import org.apache.hudi.common.model.BaseAvroPayload;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieEmptyRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.SerializableIndexedRecord;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.table.read.BufferedRecords;
import org.apache.hudi.common.table.read.DeleteContext;
import org.apache.hudi.common.table.read.FileGroupReaderSchemaHandler;
import org.apache.hudi.common.table.read.HoodieReadStats;
import org.apache.hudi.common.table.read.InputSplit;
import org.apache.hudi.common.table.read.ReaderParameters;
import org.apache.hudi.common.table.read.UpdateProcessor;
import org.apache.hudi.common.table.read.buffer.FileGroupRecordBuffer;
import org.apache.hudi.common.table.read.buffer.FileGroupRecordBufferLoader;
import org.apache.hudi.common.table.read.buffer.KeyBasedFileGroupRecordBuffer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.OrderingValues;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.internal.schema.InternalSchema;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class BaseTestFileGroupRecordBuffer {
    protected static final Schema SCHEMA = Schema.createRecord((String)"test_record", null, (String)"namespace", (boolean)false, Arrays.asList(new Schema.Field("record_key", Schema.create((Schema.Type)Schema.Type.STRING)), new Schema.Field("counter", Schema.create((Schema.Type)Schema.Type.INT)), new Schema.Field("ts", Schema.create((Schema.Type)Schema.Type.LONG))));

    protected static GenericRecord createTestRecord(String recordKey, int counter, long ts) {
        GenericData.Record record = new GenericData.Record(SCHEMA);
        record.put("record_key", (Object)recordKey);
        record.put("counter", (Object)counter);
        record.put("ts", (Object)ts);
        return record;
    }

    protected static List<HoodieRecord> convertToHoodieRecordsList(List<IndexedRecord> indexedRecords) {
        return indexedRecords.stream().map(rec -> new HoodieAvroIndexedRecord(new HoodieKey(rec.get(0).toString(), ""), rec)).collect(Collectors.toList());
    }

    protected static List<HoodieRecord> convertToHoodieRecordsListForDeletes(List<IndexedRecord> indexedRecords, boolean defaultOrderingValue) {
        return indexedRecords.stream().map(rec -> new HoodieEmptyRecord(new HoodieKey(rec.get(0).toString(), ""), HoodieOperation.DELETE, (Comparable)(defaultOrderingValue ? Integer.valueOf(0) : (Comparable)rec.get(2)), HoodieRecord.HoodieRecordType.AVRO)).collect(Collectors.toList());
    }

    protected SerializableIndexedRecord getSerializableIndexedRecord(IndexedRecord indexedRecord) {
        return SerializableIndexedRecord.createInstance((IndexedRecord)indexedRecord);
    }

    protected List<SerializableIndexedRecord> convertGenRecordsToSerializableIndexedRecords(Stream<IndexedRecord> indexedRecordStream) {
        return indexedRecordStream.map(record -> this.getSerializableIndexedRecord((IndexedRecord)record)).collect(Collectors.toList());
    }

    protected static KeyBasedFileGroupRecordBuffer<IndexedRecord> buildKeyBasedFileGroupRecordBuffer(HoodieReaderContext<IndexedRecord> readerContext, HoodieTableConfig tableConfig, HoodieReadStats readStats, HoodieRecordMerger recordMerger, RecordMergeMode recordMergeMode, List<String> orderingFieldNames, Option<Pair<String, String>> deleteMarkerKeyValue) {
        TypedProperties props = new TypedProperties();
        deleteMarkerKeyValue.ifPresent(markerKeyValue -> {
            props.setProperty("hoodie.payload.delete.field", (String)markerKeyValue.getLeft());
            props.setProperty("hoodie.payload.delete.marker", (String)markerKeyValue.getRight());
        });
        FileGroupReaderSchemaHandler fileGroupReaderSchemaHandler = (FileGroupReaderSchemaHandler)Mockito.mock(FileGroupReaderSchemaHandler.class);
        Mockito.when((Object)fileGroupReaderSchemaHandler.getRequiredSchema()).thenReturn((Object)SCHEMA);
        Mockito.when((Object)fileGroupReaderSchemaHandler.getInternalSchema()).thenReturn((Object)InternalSchema.getEmptyInternalSchema());
        Mockito.when((Object)fileGroupReaderSchemaHandler.getDeleteContext()).thenReturn((Object)new DeleteContext((Properties)props, SCHEMA));
        readerContext.setSchemaHandler(fileGroupReaderSchemaHandler);
        return BaseTestFileGroupRecordBuffer.buildKeyBasedFileGroupRecordBuffer(readerContext, tableConfig, readStats, recordMerger, recordMergeMode, orderingFieldNames, props, (Option<Iterator<HoodieRecord>>)Option.empty());
    }

    protected static KeyBasedFileGroupRecordBuffer<IndexedRecord> buildKeyBasedFileGroupRecordBuffer(HoodieReaderContext<IndexedRecord> readerContext, HoodieTableConfig tableConfig, HoodieReadStats readStats, HoodieRecordMerger recordMerger, RecordMergeMode recordMergeMode, List<String> orderingFieldNames, TypedProperties props, Option<Iterator<HoodieRecord>> fileGroupRecordBufferItrOpt) {
        readerContext.setRecordMerger(Option.ofNullable((Object)recordMerger));
        HoodieTableMetaClient mockMetaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockMetaClient.getTableConfig()).thenReturn((Object)tableConfig);
        UpdateProcessor updateProcessor = UpdateProcessor.create((HoodieReadStats)readStats, readerContext, (boolean)false, (Option)Option.empty(), (TypedProperties)props);
        if (fileGroupRecordBufferItrOpt.isEmpty()) {
            return new KeyBasedFileGroupRecordBuffer(readerContext, mockMetaClient, recordMergeMode, Option.empty(), props, orderingFieldNames, updateProcessor);
        }
        FileGroupRecordBufferLoader recordBufferLoader = FileGroupRecordBufferLoader.createStreamingRecordsBufferLoader();
        InputSplit inputSplit = (InputSplit)Mockito.mock(InputSplit.class);
        Mockito.when((Object)inputSplit.hasNoRecordsToMerge()).thenReturn((Object)false);
        Mockito.when((Object)inputSplit.getRecordIterator()).thenReturn(fileGroupRecordBufferItrOpt.get());
        ReaderParameters readerParameters = (ReaderParameters)Mockito.mock(ReaderParameters.class);
        Mockito.when((Object)readerParameters.sortOutputs()).thenReturn((Object)false);
        return (KeyBasedFileGroupRecordBuffer)recordBufferLoader.getRecordBuffer(readerContext, mockMetaClient.getStorage(), inputSplit, orderingFieldNames, mockMetaClient, props, readerParameters, readStats, Option.empty()).getKey();
    }

    protected static List<IndexedRecord> getActualRecords(FileGroupRecordBuffer<IndexedRecord> fileGroupRecordBuffer) throws IOException {
        ArrayList<IndexedRecord> actualRecords = new ArrayList<IndexedRecord>();
        while (fileGroupRecordBuffer.hasNext()) {
            actualRecords.add((IndexedRecord)fileGroupRecordBuffer.next().getRecord());
        }
        return actualRecords;
    }

    public static class CustomMerger
    implements HoodieRecordMerger {
        private final String strategy = UUID.randomUUID().toString();

        public <T> BufferedRecord<T> merge(BufferedRecord<T> older, BufferedRecord<T> newer, RecordContext<T> recordContext, TypedProperties props) throws IOException {
            if (newer.isDelete()) {
                return newer;
            }
            GenericRecord olderData = recordContext.convertToAvroRecord(older.getRecord(), recordContext.getSchemaFromBufferRecord(older));
            GenericRecord newerData = recordContext.convertToAvroRecord(newer.getRecord(), recordContext.getSchemaFromBufferRecord(newer));
            if (olderData.get(2).equals(newerData.get(2))) {
                return older;
            }
            int result = (Integer)olderData.get(1) + (Integer)newerData.get(1);
            if (result > 2) {
                return BufferedRecords.fromEngineRecord((Object)newer.getRecord(), (Schema)recordContext.getSchemaFromBufferRecord(newer), recordContext, (Comparable)newer.getOrderingValue(), (String)newer.getRecordKey(), (boolean)true);
            }
            Object mergedRecord = recordContext.convertAvroRecord((IndexedRecord)BaseTestFileGroupRecordBuffer.createTestRecord(newer.getRecordKey(), result, (Long)newerData.get(2)));
            return BufferedRecords.fromEngineRecord((Object)mergedRecord, (Schema)recordContext.getSchemaFromBufferRecord(newer), recordContext, (Comparable)newer.getOrderingValue(), (String)newer.getRecordKey(), (boolean)false);
        }

        public HoodieRecord.HoodieRecordType getRecordType() {
            return HoodieRecord.HoodieRecordType.AVRO;
        }

        public String getMergingStrategy() {
            return this.strategy;
        }
    }

    public static class CustomPayload
    extends BaseAvroPayload
    implements HoodieRecordPayload<CustomPayload> {
        private final GenericRecord payloadRecord;

        public CustomPayload(GenericRecord record, Comparable orderingVal) {
            super(record, orderingVal);
            this.payloadRecord = record;
        }

        public CustomPayload(Option<GenericRecord> record) {
            super((GenericRecord)record.orElse(null), OrderingValues.getDefault());
            this.payloadRecord = (GenericRecord)record.orElse(null);
        }

        public CustomPayload preCombine(CustomPayload oldValue) {
            return this;
        }

        public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord currentValue, Schema schema) throws IOException {
            if (this.payloadRecord == null) {
                return Option.empty();
            }
            if (currentValue.get(2).equals(this.payloadRecord.get(2))) {
                return Option.of((Object)currentValue);
            }
            int result = (Integer)currentValue.get(1) + (Integer)this.payloadRecord.get(1);
            if (result > 2) {
                return Option.empty();
            }
            return Option.of((Object)BaseTestFileGroupRecordBuffer.createTestRecord(currentValue.get(0).toString(), result, (Long)this.payloadRecord.get(2)));
        }

        public Option<IndexedRecord> getInsertValue(Schema schema) throws IOException {
            return Option.ofNullable((Object)this.payloadRecord);
        }

        public Option<IndexedRecord> getIndexedRecord(Schema schema, Properties properties) {
            return Option.ofNullable((Object)this.payloadRecord);
        }

        public Comparable<?> getOrderingValue() {
            return null;
        }
    }
}

