/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read.buffer;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.engine.RecordContext;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.serialization.DefaultSerializer;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.table.read.BufferedRecords;
import org.apache.hudi.common.table.read.DeleteContext;
import org.apache.hudi.common.table.read.FileGroupReaderSchemaHandler;
import org.apache.hudi.common.table.read.IteratorMode;
import org.apache.hudi.common.table.read.UpdateProcessor;
import org.apache.hudi.common.table.read.buffer.KeyBasedFileGroupRecordBuffer;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.util.DefaultSizeEstimator;
import org.apache.hudi.common.util.Option;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class TestFileGroupRecordBuffer {
    private String schemaString = "{\"type\": \"record\",\"name\": \"EventRecord\",\"namespace\": \"com.example.avro\",\"fields\": [{\"name\": \"id\", \"type\": \"string\"},{\"name\": \"ts\", \"type\": \"long\"},{\"name\": \"op\", \"type\": \"string\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\"}]}";
    private Schema schema = new Schema.Parser().parse(this.schemaString);
    private final HoodieReaderContext readerContext = (HoodieReaderContext)Mockito.mock(HoodieReaderContext.class);
    private final RecordContext recordContext = (RecordContext)Mockito.mock(RecordContext.class);
    private final FileGroupReaderSchemaHandler schemaHandler = (FileGroupReaderSchemaHandler)Mockito.mock(FileGroupReaderSchemaHandler.class);
    private final UpdateProcessor updateProcessor = (UpdateProcessor)Mockito.mock(UpdateProcessor.class);
    private HoodieTableMetaClient hoodieTableMetaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
    private TypedProperties props;

    TestFileGroupRecordBuffer() {
    }

    @BeforeEach
    void setUp() {
        this.props = new TypedProperties();
        Mockito.when((Object)this.readerContext.getRecordContext()).thenReturn((Object)this.recordContext);
        Mockito.when((Object)this.readerContext.getSchemaHandler()).thenReturn((Object)this.schemaHandler);
        Mockito.when((Object)this.schemaHandler.getRequiredSchema()).thenReturn((Object)this.schema);
        Mockito.when((Object)this.schemaHandler.getDeleteContext()).thenReturn((Object)new DeleteContext((Properties)this.props, this.schema));
        Mockito.when((Object)this.readerContext.getRecordMerger()).thenReturn((Object)Option.empty());
        Mockito.when((Object)this.readerContext.getRecordSerializer()).thenReturn((Object)new DefaultSerializer());
        Mockito.when((Object)this.readerContext.getRecordSizeEstimator()).thenReturn((Object)new DefaultSizeEstimator());
        Mockito.when((Object)this.readerContext.getIteratorMode()).thenReturn((Object)IteratorMode.ENGINE_RECORD);
    }

    @ParameterizedTest
    @CsvSource(value={"true,false", "false,true"})
    void testInvalidCustomDeleteConfigs(boolean configureCustomDeleteKey, boolean configureCustomDeleteMarker) {
        String customDeleteKey = "colC";
        String customDeleteValue = "D";
        ArrayList<String> dataSchemaFields = new ArrayList<String>(Arrays.asList(HoodieRecord.RECORD_KEY_METADATA_FIELD, HoodieRecord.PARTITION_PATH_METADATA_FIELD, "colA", "colB", "colC", "colD"));
        Schema dataSchema = SchemaTestUtil.getSchemaFromFields(dataSchemaFields);
        TypedProperties props = new TypedProperties();
        if (configureCustomDeleteKey) {
            props.setProperty("hoodie.payload.delete.field", customDeleteKey);
        }
        if (configureCustomDeleteMarker) {
            props.setProperty("hoodie.payload.delete.marker", customDeleteValue);
        }
        Throwable exception = Assertions.assertThrows(IllegalArgumentException.class, () -> new DeleteContext((Properties)props, dataSchema));
        Assertions.assertEquals((Object)"Either custom delete key or marker is not specified", (Object)exception.getMessage());
    }

    @Test
    void testIsCustomDeleteRecord() {
        String customDeleteKey = "op";
        String customDeleteValue = "d";
        GenericData.Record record = new GenericData.Record(this.schema);
        record.put("id", (Object)"12345");
        record.put("ts", (Object)System.currentTimeMillis());
        record.put(customDeleteKey, (Object)"d");
        Mockito.when((Object)this.recordContext.isDeleteRecord(ArgumentMatchers.any(), (DeleteContext)ArgumentMatchers.any())).thenCallRealMethod();
        this.props.setProperty("hoodie.payload.delete.field", customDeleteKey);
        this.props.setProperty("hoodie.payload.delete.marker", customDeleteValue);
        DeleteContext deleteContext = new DeleteContext((Properties)this.props, this.schema);
        Mockito.when((Object)this.recordContext.getValue(ArgumentMatchers.any(), (Schema)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn(null);
        Assertions.assertFalse((boolean)this.recordContext.isDeleteRecord((Object)record, deleteContext));
        this.props.setProperty("hoodie.payload.delete.field", customDeleteKey);
        this.props.setProperty("hoodie.payload.delete.marker", customDeleteValue);
        Mockito.when((Object)this.recordContext.getValue(ArgumentMatchers.eq((Object)record), (Schema)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)customDeleteKey))).thenReturn((Object)"d");
        Assertions.assertTrue((boolean)this.readerContext.getRecordContext().isDeleteRecord((Object)record, deleteContext));
    }

    @Test
    void testProcessCustomDeleteRecord() throws IOException {
        String customDeleteKey = "op";
        String customDeleteValue = "d";
        this.props.setProperty("hoodie.payload.delete.field", customDeleteKey);
        this.props.setProperty("hoodie.payload.delete.marker", customDeleteValue);
        KeyBasedFileGroupRecordBuffer keyBasedBuffer = new KeyBasedFileGroupRecordBuffer(this.readerContext, this.hoodieTableMetaClient, RecordMergeMode.COMMIT_TIME_ORDERING, Option.empty(), this.props, Collections.emptyList(), this.updateProcessor);
        GenericData.Record record = new GenericData.Record(this.schema);
        record.put("id", (Object)"12345");
        record.put("ts", (Object)System.currentTimeMillis());
        record.put("op", (Object)"d");
        record.put("_hoodie_is_deleted", (Object)false);
        Mockito.when((Object)this.recordContext.getOrderingValue(ArgumentMatchers.any(), (Schema)ArgumentMatchers.any(), ArgumentMatchers.anyList())).thenReturn((Object)1);
        Mockito.when((Object)this.recordContext.convertOrderingValueToEngineType((Comparable)ArgumentMatchers.any())).thenReturn((Object)1);
        BufferedRecord bufferedRecord = BufferedRecords.fromEngineRecord((Object)record, (Schema)this.schema, (RecordContext)this.readerContext.getRecordContext(), Collections.singletonList("ts"), (boolean)true);
        keyBasedBuffer.processNextDataRecord(bufferedRecord, (Serializable)((Object)"12345"));
        Map records = keyBasedBuffer.getLogRecords();
        Assertions.assertEquals((int)1, (int)records.size());
        BufferedRecord deleteRecord = (BufferedRecord)records.get("12345");
        Assertions.assertNull((Object)deleteRecord.getRecordKey(), (String)"The record key metadata field is missing");
        Assertions.assertEquals((Object)1, (Object)deleteRecord.getOrderingValue());
        GenericData.Record anotherRecord = new GenericData.Record(this.schema);
        anotherRecord.put("id", (Object)"54321");
        anotherRecord.put("ts", (Object)System.currentTimeMillis());
        anotherRecord.put("op", (Object)"i");
        anotherRecord.put("_hoodie_is_deleted", (Object)true);
        bufferedRecord = BufferedRecords.fromEngineRecord((Object)anotherRecord, (Schema)this.schema, (RecordContext)this.readerContext.getRecordContext(), Collections.singletonList("ts"), (boolean)true);
        keyBasedBuffer.processNextDataRecord(bufferedRecord, (Serializable)((Object)"54321"));
        records = keyBasedBuffer.getLogRecords();
        Assertions.assertEquals((int)2, (int)records.size());
        deleteRecord = (BufferedRecord)records.get("54321");
        Assertions.assertNull((Object)deleteRecord.getRecordKey(), (String)"The record key metadata field is missing");
        Assertions.assertEquals((Object)1, (Object)deleteRecord.getOrderingValue());
    }
}

