/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read.buffer;

import java.util.Collections;
import org.apache.hudi.avro.HoodieAvroReaderContext;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.read.DeleteContext;
import org.apache.hudi.common.table.read.FileGroupReaderSchemaHandler;
import org.apache.hudi.common.table.read.HoodieReadStats;
import org.apache.hudi.common.table.read.InputSplit;
import org.apache.hudi.common.table.read.ReaderParameters;
import org.apache.hudi.common.table.read.buffer.BaseTestFileGroupRecordBuffer;
import org.apache.hudi.common.table.read.buffer.FileGroupRecordBufferLoader;
import org.apache.hudi.common.table.read.buffer.HoodieFileGroupRecordBuffer;
import org.apache.hudi.common.table.read.buffer.KeyBasedFileGroupRecordBuffer;
import org.apache.hudi.common.table.read.buffer.PositionBasedFileGroupRecordBuffer;
import org.apache.hudi.common.table.read.buffer.SortedKeyBasedFileGroupRecordBuffer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class TestFileGroupRecordBufferLoader
extends BaseTestFileGroupRecordBuffer {
    @ParameterizedTest
    @CsvSource(value={"KeyBasedFileGroupRecordBuffer,true", "KeyBasedFileGroupRecordBuffer,false", "SortedKeyBasedFileGroupRecordBuffer,true", "SortedKeyBasedFileGroupRecordBuffer,false", "PositionBasedFileGroupRecordBuffer,false"})
    public void testDefaultFileGroupBufferRecordLoader(String fileGroupRecordBufferType, boolean testRecordsBased) {
        FileGroupRecordBufferLoader fileGroupRecordBufferLoader = !testRecordsBased ? FileGroupRecordBufferLoader.createDefault() : FileGroupRecordBufferLoader.createStreamingRecordsBufferLoader();
        HoodieReadStats readStats = new HoodieReadStats();
        HoodieTableConfig tableConfig = (HoodieTableConfig)Mockito.mock(HoodieTableConfig.class);
        Mockito.when((Object)tableConfig.getRecordMergeMode()).thenReturn((Object)RecordMergeMode.COMMIT_TIME_ORDERING);
        Mockito.when((Object)tableConfig.getTableVersion()).thenReturn((Object)HoodieTableVersion.NINE);
        Mockito.when((Object)tableConfig.getPartialUpdateMode()).thenReturn((Object)Option.empty());
        Mockito.when((Object)tableConfig.getOrderingFieldsStr()).thenReturn((Object)Option.empty());
        Mockito.when((Object)tableConfig.getRecordKeyFields()).thenReturn((Object)Option.of((Object)new String[]{"record_key"}));
        StorageConfiguration storageConfiguration = (StorageConfiguration)Mockito.mock(StorageConfiguration.class);
        HoodieAvroReaderContext readerContext = new HoodieAvroReaderContext(storageConfiguration, tableConfig, Option.empty(), Option.empty());
        readerContext.initRecordMerger(new TypedProperties());
        FileGroupReaderSchemaHandler fileGroupReaderSchemaHandler = (FileGroupReaderSchemaHandler)Mockito.mock(FileGroupReaderSchemaHandler.class);
        Mockito.when((Object)fileGroupReaderSchemaHandler.getRequiredSchema()).thenReturn((Object)SCHEMA);
        Mockito.when((Object)fileGroupReaderSchemaHandler.getRequestedSchema()).thenReturn((Object)SCHEMA);
        Mockito.when((Object)fileGroupReaderSchemaHandler.getInternalSchema()).thenReturn((Object)InternalSchema.getEmptyInternalSchema());
        DeleteContext deleteContext = (DeleteContext)Mockito.mock(DeleteContext.class);
        Mockito.when((Object)deleteContext.getCustomDeleteMarkerKeyValue()).thenReturn((Object)Option.empty());
        Mockito.when((Object)deleteContext.getHoodieOperationPos()).thenReturn((Object)-1);
        Mockito.when((Object)fileGroupReaderSchemaHandler.getDeleteContext()).thenReturn((Object)deleteContext);
        readerContext.setSchemaHandler(fileGroupReaderSchemaHandler);
        readerContext.setRecordMerger(Option.ofNullable(null));
        HoodieTableMetaClient mockMetaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockMetaClient.getTableConfig()).thenReturn((Object)tableConfig);
        HoodieStorage storage = (HoodieStorage)Mockito.mock(HoodieStorage.class);
        Mockito.when((Object)mockMetaClient.getStorage()).thenReturn((Object)storage);
        InputSplit inputSplit = (InputSplit)Mockito.mock(InputSplit.class);
        if (testRecordsBased) {
            Mockito.when((Object)inputSplit.getRecordIterator()).thenReturn(Collections.emptyIterator());
        }
        ReaderParameters readerParameters = (ReaderParameters)Mockito.mock(ReaderParameters.class);
        if (fileGroupRecordBufferType.contains("Sorted")) {
            Mockito.when((Object)readerParameters.sortOutputs()).thenReturn((Object)true);
        }
        if (fileGroupRecordBufferType.contains("Position")) {
            HoodieBaseFile baseFile = (HoodieBaseFile)Mockito.mock(HoodieBaseFile.class);
            Mockito.when((Object)inputSplit.getBaseFileOption()).thenReturn((Object)Option.of((Object)baseFile));
            Mockito.when((Object)readerParameters.useRecordPosition()).thenReturn((Object)true);
        }
        Option fileGroupUpdateCallback = Option.empty();
        HoodieFileGroupRecordBuffer fileGroupRecordBuffer = (HoodieFileGroupRecordBuffer)fileGroupRecordBufferLoader.getRecordBuffer((HoodieReaderContext)readerContext, storage, inputSplit, Collections.singletonList("ts"), mockMetaClient, new TypedProperties(), readerParameters, readStats, fileGroupUpdateCallback).getLeft();
        switch (fileGroupRecordBufferType) {
            case "KeyBasedFileGroupRecordBuffer": {
                Assertions.assertTrue((boolean)(fileGroupRecordBuffer instanceof KeyBasedFileGroupRecordBuffer));
                break;
            }
            case "SortedKeyBasedFileGroupRecordBuffer": {
                Assertions.assertTrue((boolean)(fileGroupRecordBuffer instanceof SortedKeyBasedFileGroupRecordBuffer));
                break;
            }
            case "PositionBasedFileGroupRecordBuffer": {
                Assertions.assertTrue((boolean)(fileGroupRecordBuffer instanceof PositionBasedFileGroupRecordBuffer));
                break;
            }
            default: {
                throw new HoodieIOException("Undefined type");
            }
        }
    }
}

