/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read.buffer;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.HoodieAvroReaderContext;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.model.DeleteRecord;
import org.apache.hudi.common.model.HoodieAvroRecordMerger;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieDeleteBlock;
import org.apache.hudi.common.table.read.FileGroupReaderSchemaHandler;
import org.apache.hudi.common.table.read.HoodieReadStats;
import org.apache.hudi.common.table.read.buffer.BaseTestFileGroupRecordBuffer;
import org.apache.hudi.common.table.read.buffer.KeyBasedFileGroupRecordBuffer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.storage.StorageConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class TestKeyBasedFileGroupRecordBuffer
extends BaseTestFileGroupRecordBuffer {
    private final IndexedRecord testRecord1 = TestKeyBasedFileGroupRecordBuffer.createTestRecord("1", 1, 1L);
    private final IndexedRecord testRecord1UpdateWithSameTime = TestKeyBasedFileGroupRecordBuffer.createTestRecord("1", 2, 1L);
    private final IndexedRecord testRecord2 = TestKeyBasedFileGroupRecordBuffer.createTestRecord("2", 1, 1L);
    private final IndexedRecord testRecord2Update = TestKeyBasedFileGroupRecordBuffer.createTestRecord("2", 1, 2L);
    private final IndexedRecord testRecord2EarlierUpdate = TestKeyBasedFileGroupRecordBuffer.createTestRecord("2", 1, 0L);
    private final IndexedRecord testRecord2Delete = TestKeyBasedFileGroupRecordBuffer.createTestRecord("2", 2, 3L);
    private final IndexedRecord testRecord2CustomPayloadExpected = TestKeyBasedFileGroupRecordBuffer.createTestRecord("2", 2, 2L);
    private final IndexedRecord testRecord3 = TestKeyBasedFileGroupRecordBuffer.createTestRecord("3", 1, 1L);
    private final IndexedRecord testRecord3Update = TestKeyBasedFileGroupRecordBuffer.createTestRecord("3", 1, 2L);
    private final IndexedRecord testRecord3UpdateCustomPayloadExpected = TestKeyBasedFileGroupRecordBuffer.createTestRecord("3", 2, 2L);
    private final IndexedRecord testRecord3DeleteByFieldValue = TestKeyBasedFileGroupRecordBuffer.createTestRecord("3", 3, 1L);
    private final IndexedRecord testRecord4 = TestKeyBasedFileGroupRecordBuffer.createTestRecord("4", 2, 1L);
    private final IndexedRecord testRecord4Update = TestKeyBasedFileGroupRecordBuffer.createTestRecord("4", 1, 2L);
    private final IndexedRecord testRecord4EarlierUpdate = TestKeyBasedFileGroupRecordBuffer.createTestRecord("4", 1, 0L);
    private final IndexedRecord testRecord5 = TestKeyBasedFileGroupRecordBuffer.createTestRecord("5", 1, 1L);
    private final IndexedRecord testRecord5DeleteByCustomMarker = TestKeyBasedFileGroupRecordBuffer.createTestRecord("5", 3, 2L);
    private final IndexedRecord testRecord6 = TestKeyBasedFileGroupRecordBuffer.createTestRecord("6", 1, 5L);
    private final IndexedRecord testRecord6DeleteByCustomMarker = TestKeyBasedFileGroupRecordBuffer.createTestRecord("6", 3, 2L);
    private final IndexedRecord testRecord7 = TestKeyBasedFileGroupRecordBuffer.createTestRecord("7", 1, 5L);

    TestKeyBasedFileGroupRecordBuffer() {
    }

    @Test
    void readWithEventTimeOrdering() throws IOException {
        HoodieReadStats readStats = new HoodieReadStats();
        HoodieTableConfig tableConfig = (HoodieTableConfig)Mockito.mock(HoodieTableConfig.class);
        Mockito.when((Object)tableConfig.getRecordKeyFields()).thenReturn((Object)Option.of((Object)new String[]{"record_key"}));
        StorageConfiguration storageConfiguration = (StorageConfiguration)Mockito.mock(StorageConfiguration.class);
        HoodieAvroReaderContext readerContext = new HoodieAvroReaderContext(storageConfiguration, tableConfig, Option.empty(), Option.empty());
        KeyBasedFileGroupRecordBuffer<IndexedRecord> fileGroupRecordBuffer = TestKeyBasedFileGroupRecordBuffer.buildKeyBasedFileGroupRecordBuffer((HoodieReaderContext<IndexedRecord>)readerContext, tableConfig, readStats, null, RecordMergeMode.EVENT_TIME_ORDERING, Collections.singletonList("ts"), (Option<Pair<String, String>>)Option.of((Object)Pair.of((Object)"counter", (Object)"3")));
        fileGroupRecordBuffer.setBaseFileIterator(ClosableIterator.wrap(Arrays.asList(this.testRecord1, this.testRecord2, this.testRecord3).iterator()));
        HoodieDataBlock dataBlock = (HoodieDataBlock)Mockito.mock(HoodieDataBlock.class);
        Mockito.when((Object)dataBlock.getSchema()).thenReturn((Object)SCHEMA);
        Mockito.when((Object)dataBlock.getEngineRecordIterator((HoodieReaderContext)readerContext)).thenReturn((Object)ClosableIterator.wrap(Arrays.asList(this.testRecord1UpdateWithSameTime, this.testRecord2Update, this.testRecord2EarlierUpdate, this.testRecord3Update, this.testRecord3DeleteByFieldValue).iterator()));
        fileGroupRecordBuffer.processDataBlock(dataBlock, Option.empty());
        List<IndexedRecord> actualRecords = TestKeyBasedFileGroupRecordBuffer.getActualRecords(fileGroupRecordBuffer);
        Assertions.assertEquals(Arrays.asList(this.testRecord1UpdateWithSameTime, this.testRecord2Update, this.testRecord3Update), actualRecords);
        Assertions.assertEquals((long)0L, (long)readStats.getNumInserts());
        Assertions.assertEquals((long)0L, (long)readStats.getNumDeletes());
        Assertions.assertEquals((long)3L, (long)readStats.getNumUpdates());
    }

    @Test
    void readWithEventTimeOrderingAndDeleteBlock() throws IOException {
        HoodieReadStats readStats = new HoodieReadStats();
        HoodieTableConfig tableConfig = (HoodieTableConfig)Mockito.mock(HoodieTableConfig.class);
        Mockito.when((Object)tableConfig.getRecordKeyFields()).thenReturn((Object)Option.of((Object)new String[]{"record_key"}));
        StorageConfiguration storageConfiguration = (StorageConfiguration)Mockito.mock(StorageConfiguration.class);
        HoodieAvroReaderContext readerContext = new HoodieAvroReaderContext(storageConfiguration, tableConfig, Option.empty(), Option.empty());
        KeyBasedFileGroupRecordBuffer<IndexedRecord> fileGroupRecordBuffer = TestKeyBasedFileGroupRecordBuffer.buildKeyBasedFileGroupRecordBuffer((HoodieReaderContext<IndexedRecord>)readerContext, tableConfig, readStats, null, RecordMergeMode.EVENT_TIME_ORDERING, Collections.singletonList("ts"), (Option<Pair<String, String>>)Option.of((Object)Pair.of((Object)"counter", (Object)"3")));
        fileGroupRecordBuffer.setBaseFileIterator(ClosableIterator.wrap(Arrays.asList(this.testRecord1, this.testRecord2, this.testRecord3).iterator()));
        HoodieDataBlock dataBlock = (HoodieDataBlock)Mockito.mock(HoodieDataBlock.class);
        Mockito.when((Object)dataBlock.getSchema()).thenReturn((Object)SCHEMA);
        Mockito.when((Object)dataBlock.getEngineRecordIterator((HoodieReaderContext)readerContext)).thenReturn((Object)ClosableIterator.wrap(Arrays.asList(this.testRecord1UpdateWithSameTime, this.testRecord2Update, this.testRecord3).iterator()));
        HoodieDataBlock dataBlock2 = (HoodieDataBlock)Mockito.mock(HoodieDataBlock.class);
        Mockito.when((Object)dataBlock2.getSchema()).thenReturn((Object)SCHEMA);
        Mockito.when((Object)dataBlock2.getEngineRecordIterator((HoodieReaderContext)readerContext)).thenReturn((Object)ClosableIterator.wrap(Arrays.asList(this.testRecord2EarlierUpdate, this.testRecord3Update).iterator()));
        HoodieDeleteBlock deleteBlock = (HoodieDeleteBlock)Mockito.mock(HoodieDeleteBlock.class);
        Mockito.when((Object)deleteBlock.getRecordsToDelete()).thenReturn((Object)new DeleteRecord[]{DeleteRecord.create((String)"3", (String)""), DeleteRecord.create((String)"2", (String)"", (Comparable)Long.valueOf(-1L)), DeleteRecord.create((String)"1", (String)"", (Comparable)Long.valueOf(2L))});
        fileGroupRecordBuffer.processDataBlock(dataBlock, Option.empty());
        fileGroupRecordBuffer.processDeleteBlock(deleteBlock);
        fileGroupRecordBuffer.processDataBlock(dataBlock2, Option.empty());
        List<IndexedRecord> actualRecords = TestKeyBasedFileGroupRecordBuffer.getActualRecords(fileGroupRecordBuffer);
        Assertions.assertEquals(Arrays.asList(this.testRecord2Update, this.testRecord3Update), actualRecords);
        Assertions.assertEquals((long)0L, (long)readStats.getNumInserts());
        Assertions.assertEquals((long)1L, (long)readStats.getNumDeletes());
        Assertions.assertEquals((long)2L, (long)readStats.getNumUpdates());
    }

    @Test
    void readWithEventTimeOrderingWithRecords() throws IOException {
        HoodieReadStats readStats = new HoodieReadStats();
        TypedProperties properties = new TypedProperties();
        properties.setProperty(HoodieTableConfig.ORDERING_FIELDS.key(), "ts");
        properties.setProperty("hoodie.payload.delete.field", "counter");
        properties.setProperty("hoodie.payload.delete.marker", "3");
        HoodieTableConfig tableConfig = (HoodieTableConfig)Mockito.mock(HoodieTableConfig.class);
        Mockito.when((Object)tableConfig.getRecordMergeMode()).thenReturn((Object)RecordMergeMode.EVENT_TIME_ORDERING);
        Mockito.when((Object)tableConfig.getPartialUpdateMode()).thenReturn((Object)Option.empty());
        Mockito.when((Object)tableConfig.getTableVersion()).thenReturn((Object)HoodieTableVersion.current());
        Mockito.when((Object)tableConfig.getRecordKeyFields()).thenReturn((Object)Option.of((Object)new String[]{"record_key"}));
        StorageConfiguration storageConfiguration = (StorageConfiguration)Mockito.mock(StorageConfiguration.class);
        HoodieAvroReaderContext readerContext = new HoodieAvroReaderContext(storageConfiguration, tableConfig, Option.empty(), Option.empty());
        readerContext.setHasLogFiles(false);
        readerContext.setHasBootstrapBaseFile(false);
        readerContext.initRecordMerger(properties);
        FileGroupReaderSchemaHandler schemaHandler = new FileGroupReaderSchemaHandler((HoodieReaderContext)readerContext, SCHEMA, SCHEMA, Option.empty(), properties, (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class));
        readerContext.setSchemaHandler(schemaHandler);
        List<HoodieRecord> inputRecords = TestKeyBasedFileGroupRecordBuffer.convertToHoodieRecordsList(Arrays.asList(this.testRecord1UpdateWithSameTime, this.testRecord2Update, this.testRecord3Update, this.testRecord4EarlierUpdate, this.testRecord7));
        inputRecords.addAll(TestKeyBasedFileGroupRecordBuffer.convertToHoodieRecordsListForDeletes(Arrays.asList(this.testRecord5DeleteByCustomMarker, this.testRecord6DeleteByCustomMarker), false));
        KeyBasedFileGroupRecordBuffer<IndexedRecord> fileGroupRecordBuffer = TestKeyBasedFileGroupRecordBuffer.buildKeyBasedFileGroupRecordBuffer((HoodieReaderContext<IndexedRecord>)readerContext, tableConfig, readStats, null, RecordMergeMode.EVENT_TIME_ORDERING, Collections.singletonList("ts"), properties, (Option<Iterator<HoodieRecord>>)Option.of(inputRecords.iterator()));
        fileGroupRecordBuffer.setBaseFileIterator(ClosableIterator.wrap(Arrays.asList(this.testRecord1, this.testRecord2, this.testRecord3, this.testRecord4, this.testRecord5, this.testRecord6).iterator()));
        List<IndexedRecord> actualRecords = TestKeyBasedFileGroupRecordBuffer.getActualRecords(fileGroupRecordBuffer);
        Assertions.assertEquals(Arrays.asList(this.getSerializableIndexedRecord(this.testRecord1UpdateWithSameTime), this.getSerializableIndexedRecord(this.testRecord2Update), this.getSerializableIndexedRecord(this.testRecord3Update), this.testRecord4, this.testRecord6, this.getSerializableIndexedRecord(this.testRecord7)), actualRecords);
        Assertions.assertEquals((long)1L, (long)readStats.getNumInserts());
        Assertions.assertEquals((long)1L, (long)readStats.getNumDeletes());
        Assertions.assertEquals((long)3L, (long)readStats.getNumUpdates());
    }

    @Test
    void readWithCommitTimeOrdering() throws IOException {
        HoodieReadStats readStats = new HoodieReadStats();
        HoodieTableConfig tableConfig = (HoodieTableConfig)Mockito.mock(HoodieTableConfig.class);
        Mockito.when((Object)tableConfig.getRecordKeyFields()).thenReturn((Object)Option.of((Object)new String[]{"record_key"}));
        StorageConfiguration storageConfiguration = (StorageConfiguration)Mockito.mock(StorageConfiguration.class);
        HoodieAvroReaderContext readerContext = new HoodieAvroReaderContext(storageConfiguration, tableConfig, Option.empty(), Option.empty());
        KeyBasedFileGroupRecordBuffer<IndexedRecord> fileGroupRecordBuffer = TestKeyBasedFileGroupRecordBuffer.buildKeyBasedFileGroupRecordBuffer((HoodieReaderContext<IndexedRecord>)readerContext, tableConfig, readStats, null, RecordMergeMode.COMMIT_TIME_ORDERING, Collections.emptyList(), (Option<Pair<String, String>>)Option.of((Object)Pair.of((Object)"counter", (Object)"3")));
        fileGroupRecordBuffer.setBaseFileIterator(ClosableIterator.wrap(Arrays.asList(this.testRecord1, this.testRecord2, this.testRecord3).iterator()));
        HoodieDataBlock dataBlock1 = (HoodieDataBlock)Mockito.mock(HoodieDataBlock.class);
        Mockito.when((Object)dataBlock1.getSchema()).thenReturn((Object)SCHEMA);
        Mockito.when((Object)dataBlock1.getEngineRecordIterator((HoodieReaderContext)readerContext)).thenReturn((Object)ClosableIterator.wrap(Arrays.asList(this.testRecord1UpdateWithSameTime, this.testRecord2Update, this.testRecord2EarlierUpdate).iterator()));
        HoodieDataBlock dataBlock2 = (HoodieDataBlock)Mockito.mock(HoodieDataBlock.class);
        Mockito.when((Object)dataBlock2.getSchema()).thenReturn((Object)SCHEMA);
        Mockito.when((Object)dataBlock2.getEngineRecordIterator((HoodieReaderContext)readerContext)).thenReturn((Object)ClosableIterator.wrap(Arrays.asList(this.testRecord2EarlierUpdate, this.testRecord3Update, this.testRecord3DeleteByFieldValue).iterator()));
        fileGroupRecordBuffer.processDataBlock(dataBlock1, Option.empty());
        fileGroupRecordBuffer.processDataBlock(dataBlock2, Option.empty());
        List<IndexedRecord> actualRecords = TestKeyBasedFileGroupRecordBuffer.getActualRecords(fileGroupRecordBuffer);
        Assertions.assertEquals(Arrays.asList(this.testRecord1UpdateWithSameTime, this.testRecord2EarlierUpdate), actualRecords);
        Assertions.assertEquals((long)0L, (long)readStats.getNumInserts());
        Assertions.assertEquals((long)1L, (long)readStats.getNumDeletes());
        Assertions.assertEquals((long)2L, (long)readStats.getNumUpdates());
    }

    @Test
    void readWithCommitTimeOrderingWithRecords() throws IOException {
        HoodieReadStats readStats = new HoodieReadStats();
        TypedProperties properties = new TypedProperties();
        properties.setProperty("hoodie.payload.delete.field", "counter");
        properties.setProperty("hoodie.payload.delete.marker", "3");
        HoodieTableConfig tableConfig = (HoodieTableConfig)Mockito.mock(HoodieTableConfig.class);
        Mockito.when((Object)tableConfig.getRecordMergeMode()).thenReturn((Object)RecordMergeMode.COMMIT_TIME_ORDERING);
        Mockito.when((Object)tableConfig.getPartialUpdateMode()).thenReturn((Object)Option.empty());
        Mockito.when((Object)tableConfig.getTableVersion()).thenReturn((Object)HoodieTableVersion.current());
        Mockito.when((Object)tableConfig.getRecordKeyFields()).thenReturn((Object)Option.of((Object)new String[]{"record_key"}));
        StorageConfiguration storageConfiguration = (StorageConfiguration)Mockito.mock(StorageConfiguration.class);
        HoodieAvroReaderContext readerContext = new HoodieAvroReaderContext(storageConfiguration, tableConfig, Option.empty(), Option.empty());
        readerContext.setHasLogFiles(false);
        readerContext.setHasBootstrapBaseFile(false);
        readerContext.initRecordMerger(properties);
        FileGroupReaderSchemaHandler schemaHandler = new FileGroupReaderSchemaHandler((HoodieReaderContext)readerContext, SCHEMA, SCHEMA, Option.empty(), properties, (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class));
        readerContext.setSchemaHandler(schemaHandler);
        List<HoodieRecord> inputRecords = TestKeyBasedFileGroupRecordBuffer.convertToHoodieRecordsList(Arrays.asList(this.testRecord1UpdateWithSameTime, this.testRecord2Update, this.testRecord3Update, this.testRecord4EarlierUpdate, this.testRecord7));
        inputRecords.addAll(TestKeyBasedFileGroupRecordBuffer.convertToHoodieRecordsListForDeletes(Arrays.asList(this.testRecord5DeleteByCustomMarker, this.testRecord6DeleteByCustomMarker), true));
        KeyBasedFileGroupRecordBuffer<IndexedRecord> fileGroupRecordBuffer = TestKeyBasedFileGroupRecordBuffer.buildKeyBasedFileGroupRecordBuffer((HoodieReaderContext<IndexedRecord>)readerContext, tableConfig, readStats, null, RecordMergeMode.COMMIT_TIME_ORDERING, Collections.singletonList("ts"), properties, (Option<Iterator<HoodieRecord>>)Option.of(inputRecords.iterator()));
        fileGroupRecordBuffer.setBaseFileIterator(ClosableIterator.wrap(Arrays.asList(this.testRecord1, this.testRecord2, this.testRecord3, this.testRecord4, this.testRecord5, this.testRecord6).iterator()));
        List<IndexedRecord> actualRecords = TestKeyBasedFileGroupRecordBuffer.getActualRecords(fileGroupRecordBuffer);
        Assertions.assertEquals(this.convertGenRecordsToSerializableIndexedRecords(Stream.of(this.testRecord1UpdateWithSameTime, this.testRecord2Update, this.testRecord3Update, this.testRecord4EarlierUpdate, this.testRecord7)), actualRecords);
        Assertions.assertEquals((long)1L, (long)readStats.getNumInserts());
        Assertions.assertEquals((long)2L, (long)readStats.getNumDeletes());
        Assertions.assertEquals((long)4L, (long)readStats.getNumUpdates());
    }

    @Test
    void readWithCustomPayload() throws IOException {
        HoodieReadStats readStats = new HoodieReadStats();
        HoodieTableConfig tableConfig = (HoodieTableConfig)Mockito.mock(HoodieTableConfig.class);
        Mockito.when((Object)tableConfig.getPayloadClass()).thenReturn((Object)BaseTestFileGroupRecordBuffer.CustomPayload.class.getName());
        Mockito.when((Object)tableConfig.getRecordKeyFields()).thenReturn((Object)Option.of((Object)new String[]{"record_key"}));
        Mockito.when((Object)tableConfig.getRecordMergeMode()).thenReturn((Object)RecordMergeMode.CUSTOM);
        Mockito.when((Object)tableConfig.getPartialUpdateMode()).thenReturn((Object)Option.empty());
        StorageConfiguration storageConfiguration = (StorageConfiguration)Mockito.mock(StorageConfiguration.class);
        HoodieAvroReaderContext readerContext = new HoodieAvroReaderContext(storageConfiguration, tableConfig, Option.empty(), Option.empty());
        KeyBasedFileGroupRecordBuffer<IndexedRecord> fileGroupRecordBuffer = TestKeyBasedFileGroupRecordBuffer.buildKeyBasedFileGroupRecordBuffer((HoodieReaderContext<IndexedRecord>)readerContext, tableConfig, readStats, (HoodieRecordMerger)new HoodieAvroRecordMerger(), RecordMergeMode.CUSTOM, Collections.emptyList(), (Option<Pair<String, String>>)Option.empty());
        fileGroupRecordBuffer.setBaseFileIterator(ClosableIterator.wrap(Arrays.asList(this.testRecord1, this.testRecord2, this.testRecord3, this.testRecord4).iterator()));
        HoodieDataBlock dataBlock1 = (HoodieDataBlock)Mockito.mock(HoodieDataBlock.class);
        Mockito.when((Object)dataBlock1.getSchema()).thenReturn((Object)SCHEMA);
        Mockito.when((Object)dataBlock1.getEngineRecordIterator((HoodieReaderContext)readerContext)).thenReturn((Object)ClosableIterator.wrap(Arrays.asList(this.testRecord2Update, this.testRecord1UpdateWithSameTime).iterator()));
        HoodieDataBlock dataBlock2 = (HoodieDataBlock)Mockito.mock(HoodieDataBlock.class);
        Mockito.when((Object)dataBlock2.getSchema()).thenReturn((Object)SCHEMA);
        Mockito.when((Object)dataBlock2.getEngineRecordIterator((HoodieReaderContext)readerContext)).thenReturn((Object)ClosableIterator.wrap(Arrays.asList(this.testRecord1UpdateWithSameTime, this.testRecord2Delete, this.testRecord4Update).iterator()));
        HoodieDeleteBlock deleteBlock = (HoodieDeleteBlock)Mockito.mock(HoodieDeleteBlock.class);
        Mockito.when((Object)deleteBlock.getRecordsToDelete()).thenReturn((Object)new DeleteRecord[]{DeleteRecord.create((String)"3", (String)"")});
        fileGroupRecordBuffer.processDataBlock(dataBlock1, Option.empty());
        fileGroupRecordBuffer.processDataBlock(dataBlock2, Option.empty());
        fileGroupRecordBuffer.processDeleteBlock(deleteBlock);
        List<IndexedRecord> actualRecords = TestKeyBasedFileGroupRecordBuffer.getActualRecords(fileGroupRecordBuffer);
        Assertions.assertEquals(Collections.singletonList(this.testRecord1), actualRecords);
        Assertions.assertEquals((long)0L, (long)readStats.getNumInserts());
        Assertions.assertEquals((long)3L, (long)readStats.getNumDeletes());
        Assertions.assertEquals((long)0L, (long)readStats.getNumUpdates());
    }

    @Test
    void readWithCustomPayloadWithRecords() throws IOException {
        HoodieReadStats readStats = new HoodieReadStats();
        TypedProperties properties = new TypedProperties();
        properties.setProperty("hoodie.payload.delete.field", "counter");
        properties.setProperty("hoodie.payload.delete.marker", "3");
        properties.setProperty(HoodieTableConfig.RECORD_MERGE_MODE.key(), "CUSTOM");
        properties.setProperty(HoodieTableConfig.PAYLOAD_CLASS_NAME.key(), BaseTestFileGroupRecordBuffer.CustomPayload.class.getName());
        properties.setProperty(HoodieTableConfig.RECORD_MERGE_STRATEGY_ID.key(), "00000000-0000-0000-0000-000000000000");
        HoodieTableConfig tableConfig = (HoodieTableConfig)Mockito.mock(HoodieTableConfig.class);
        Mockito.when((Object)tableConfig.getPayloadClass()).thenReturn((Object)BaseTestFileGroupRecordBuffer.CustomPayload.class.getName());
        Mockito.when((Object)tableConfig.getRecordKeyFields()).thenReturn((Object)Option.of((Object)new String[]{"record_key"}));
        Mockito.when((Object)tableConfig.getRecordMergeMode()).thenReturn((Object)RecordMergeMode.CUSTOM);
        Mockito.when((Object)tableConfig.getPartialUpdateMode()).thenReturn((Object)Option.empty());
        Mockito.when((Object)tableConfig.getRecordMergeStrategyId()).thenReturn((Object)"00000000-0000-0000-0000-000000000000");
        Mockito.when((Object)tableConfig.getTableVersion()).thenReturn((Object)HoodieTableVersion.current());
        StorageConfiguration storageConfiguration = (StorageConfiguration)Mockito.mock(StorageConfiguration.class);
        HoodieAvroReaderContext readerContext = new HoodieAvroReaderContext(storageConfiguration, tableConfig, Option.empty(), Option.empty());
        readerContext.setHasLogFiles(false);
        readerContext.setHasBootstrapBaseFile(false);
        readerContext.initRecordMerger(properties);
        FileGroupReaderSchemaHandler schemaHandler = new FileGroupReaderSchemaHandler((HoodieReaderContext)readerContext, SCHEMA, SCHEMA, Option.empty(), properties, (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class));
        readerContext.setSchemaHandler(schemaHandler);
        List<HoodieRecord> inputRecords = TestKeyBasedFileGroupRecordBuffer.convertToHoodieRecordsList(Arrays.asList(this.testRecord1UpdateWithSameTime, this.testRecord2Update, this.testRecord3Update, this.testRecord4EarlierUpdate));
        inputRecords.addAll(TestKeyBasedFileGroupRecordBuffer.convertToHoodieRecordsListForDeletes(Arrays.asList(this.testRecord5DeleteByCustomMarker, this.testRecord6DeleteByCustomMarker), true));
        KeyBasedFileGroupRecordBuffer<IndexedRecord> fileGroupRecordBuffer = TestKeyBasedFileGroupRecordBuffer.buildKeyBasedFileGroupRecordBuffer((HoodieReaderContext<IndexedRecord>)readerContext, tableConfig, readStats, (HoodieRecordMerger)new HoodieAvroRecordMerger(), RecordMergeMode.CUSTOM, Collections.singletonList("ts"), properties, (Option<Iterator<HoodieRecord>>)Option.of(inputRecords.iterator()));
        fileGroupRecordBuffer.setBaseFileIterator(ClosableIterator.wrap(Arrays.asList(this.testRecord1, this.testRecord2, this.testRecord3, this.testRecord4, this.testRecord5, this.testRecord6).iterator()));
        List<IndexedRecord> actualRecords = TestKeyBasedFileGroupRecordBuffer.getActualRecords(fileGroupRecordBuffer);
        Assertions.assertEquals(Arrays.asList(this.testRecord1, this.testRecord2CustomPayloadExpected, this.testRecord3UpdateCustomPayloadExpected), actualRecords);
        Assertions.assertEquals((long)0L, (long)readStats.getNumInserts());
        Assertions.assertEquals((long)3L, (long)readStats.getNumDeletes());
        Assertions.assertEquals((long)2L, (long)readStats.getNumUpdates());
    }

    @Test
    void readWithCustomMerger() throws IOException {
        HoodieReadStats readStats = new HoodieReadStats();
        HoodieTableConfig tableConfig = (HoodieTableConfig)Mockito.mock(HoodieTableConfig.class);
        Mockito.when((Object)tableConfig.getPayloadClass()).thenReturn((Object)BaseTestFileGroupRecordBuffer.CustomPayload.class.getName());
        Mockito.when((Object)tableConfig.getRecordKeyFields()).thenReturn((Object)Option.of((Object)new String[]{"record_key"}));
        StorageConfiguration storageConfiguration = (StorageConfiguration)Mockito.mock(StorageConfiguration.class);
        HoodieAvroReaderContext readerContext = new HoodieAvroReaderContext(storageConfiguration, tableConfig, Option.empty(), Option.empty());
        KeyBasedFileGroupRecordBuffer<IndexedRecord> fileGroupRecordBuffer = TestKeyBasedFileGroupRecordBuffer.buildKeyBasedFileGroupRecordBuffer((HoodieReaderContext<IndexedRecord>)readerContext, tableConfig, readStats, new BaseTestFileGroupRecordBuffer.CustomMerger(), RecordMergeMode.CUSTOM, Collections.emptyList(), (Option<Pair<String, String>>)Option.empty());
        fileGroupRecordBuffer.setBaseFileIterator(ClosableIterator.wrap(Arrays.asList(this.testRecord1, this.testRecord2, this.testRecord3, this.testRecord4).iterator()));
        HoodieDataBlock dataBlock1 = (HoodieDataBlock)Mockito.mock(HoodieDataBlock.class);
        Mockito.when((Object)dataBlock1.getSchema()).thenReturn((Object)SCHEMA);
        Mockito.when((Object)dataBlock1.getEngineRecordIterator((HoodieReaderContext)readerContext)).thenReturn((Object)ClosableIterator.wrap(Arrays.asList(this.testRecord2Update, this.testRecord1UpdateWithSameTime, this.testRecord1UpdateWithSameTime).iterator()));
        HoodieDataBlock dataBlock2 = (HoodieDataBlock)Mockito.mock(HoodieDataBlock.class);
        Mockito.when((Object)dataBlock2.getSchema()).thenReturn((Object)SCHEMA);
        Mockito.when((Object)dataBlock2.getEngineRecordIterator((HoodieReaderContext)readerContext)).thenReturn((Object)ClosableIterator.wrap(Arrays.asList(this.testRecord2Delete, this.testRecord4Update).iterator()));
        HoodieDeleteBlock deleteBlock = (HoodieDeleteBlock)Mockito.mock(HoodieDeleteBlock.class);
        Mockito.when((Object)deleteBlock.getRecordsToDelete()).thenReturn((Object)new DeleteRecord[]{DeleteRecord.create((String)"3", (String)"")});
        fileGroupRecordBuffer.processDataBlock(dataBlock1, Option.empty());
        fileGroupRecordBuffer.processDataBlock(dataBlock2, Option.empty());
        fileGroupRecordBuffer.processDeleteBlock(deleteBlock);
        List<IndexedRecord> actualRecords = TestKeyBasedFileGroupRecordBuffer.getActualRecords(fileGroupRecordBuffer);
        Assertions.assertEquals(Collections.singletonList(this.testRecord1), actualRecords);
        Assertions.assertEquals((long)0L, (long)readStats.getNumInserts());
        Assertions.assertEquals((long)3L, (long)readStats.getNumDeletes());
        Assertions.assertEquals((long)0L, (long)readStats.getNumUpdates());
    }

    @Test
    void readWithCustomMergerWithRecords() throws IOException {
        HoodieReadStats readStats = new HoodieReadStats();
        TypedProperties properties = new TypedProperties();
        properties.setProperty("hoodie.payload.delete.field", "counter");
        properties.setProperty("hoodie.payload.delete.marker", "3");
        properties.setProperty(HoodieTableConfig.PAYLOAD_CLASS_NAME.key(), BaseTestFileGroupRecordBuffer.CustomPayload.class.getName());
        HoodieTableConfig tableConfig = (HoodieTableConfig)Mockito.mock(HoodieTableConfig.class);
        Mockito.when((Object)tableConfig.getPayloadClass()).thenReturn((Object)BaseTestFileGroupRecordBuffer.CustomPayload.class.getName());
        Mockito.when((Object)tableConfig.getRecordKeyFields()).thenReturn((Object)Option.of((Object)new String[]{"record_key"}));
        Mockito.when((Object)tableConfig.getRecordMergeMode()).thenReturn((Object)RecordMergeMode.CUSTOM);
        Mockito.when((Object)tableConfig.getPartialUpdateMode()).thenReturn((Object)Option.empty());
        Mockito.when((Object)tableConfig.getRecordMergeStrategyId()).thenReturn((Object)"00000000-0000-0000-0000-000000000000");
        Mockito.when((Object)tableConfig.getTableVersion()).thenReturn((Object)HoodieTableVersion.current());
        StorageConfiguration storageConfiguration = (StorageConfiguration)Mockito.mock(StorageConfiguration.class);
        HoodieAvroReaderContext readerContext = new HoodieAvroReaderContext(storageConfiguration, tableConfig, Option.empty(), Option.empty());
        readerContext.setHasLogFiles(false);
        readerContext.setHasBootstrapBaseFile(false);
        readerContext.initRecordMerger(properties);
        FileGroupReaderSchemaHandler schemaHandler = new FileGroupReaderSchemaHandler((HoodieReaderContext)readerContext, SCHEMA, SCHEMA, Option.empty(), properties, (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class));
        readerContext.setSchemaHandler(schemaHandler);
        List<HoodieRecord> inputRecords = TestKeyBasedFileGroupRecordBuffer.convertToHoodieRecordsList(Arrays.asList(this.testRecord1UpdateWithSameTime, this.testRecord2Update, this.testRecord3Update, this.testRecord4EarlierUpdate));
        inputRecords.addAll(TestKeyBasedFileGroupRecordBuffer.convertToHoodieRecordsListForDeletes(Arrays.asList(this.testRecord5DeleteByCustomMarker, this.testRecord6DeleteByCustomMarker), true));
        KeyBasedFileGroupRecordBuffer<IndexedRecord> fileGroupRecordBuffer = TestKeyBasedFileGroupRecordBuffer.buildKeyBasedFileGroupRecordBuffer((HoodieReaderContext<IndexedRecord>)readerContext, tableConfig, readStats, new BaseTestFileGroupRecordBuffer.CustomMerger(), RecordMergeMode.CUSTOM, Collections.singletonList("ts"), properties, (Option<Iterator<HoodieRecord>>)Option.of(inputRecords.iterator()));
        fileGroupRecordBuffer.setBaseFileIterator(ClosableIterator.wrap(Arrays.asList(this.testRecord1, this.testRecord2, this.testRecord3, this.testRecord4, this.testRecord5, this.testRecord6).iterator()));
        List<IndexedRecord> actualRecords = TestKeyBasedFileGroupRecordBuffer.getActualRecords(fileGroupRecordBuffer);
        Assertions.assertEquals(Arrays.asList(this.testRecord1, this.testRecord2CustomPayloadExpected, this.testRecord3UpdateCustomPayloadExpected), actualRecords);
        Assertions.assertEquals((long)0L, (long)readStats.getNumInserts());
        Assertions.assertEquals((long)3L, (long)readStats.getNumDeletes());
        Assertions.assertEquals((long)2L, (long)readStats.getNumUpdates());
    }
}

