/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read.buffer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.table.read.HoodieReadStats;
import org.apache.hudi.common.table.read.UpdateProcessor;
import org.apache.hudi.common.table.read.buffer.ReusableKeyBasedRecordBuffer;
import org.apache.hudi.common.table.read.buffer.TestRecord;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.expression.Literal;
import org.apache.hudi.expression.Predicates;
import org.apache.hudi.internal.schema.InternalSchema;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class TestReusableKeyBasedRecordBuffer {
    private final HoodieReaderContext<TestRecord> mockReaderContext = (HoodieReaderContext)Mockito.mock(HoodieReaderContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private final HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);

    TestReusableKeyBasedRecordBuffer() {
    }

    @Test
    void testRemainingLogEntryHandling() throws IOException {
        HashMap<String, BufferedRecord> preMergedLogRecords = new HashMap<String, BufferedRecord>();
        preMergedLogRecords.put("1", new BufferedRecord("1", (Comparable)Integer.valueOf(10), (Object)new TestRecord("1", 1), Integer.valueOf(0), null));
        preMergedLogRecords.put("2", new BufferedRecord("2", (Comparable)Integer.valueOf(10), (Object)new TestRecord("2", 2), Integer.valueOf(0), null));
        preMergedLogRecords.put("3", new BufferedRecord("3", (Comparable)Integer.valueOf(10), (Object)new TestRecord("3", 3), Integer.valueOf(0), null));
        preMergedLogRecords.put("4", new BufferedRecord("4", (Comparable)Integer.valueOf(10), (Object)new TestRecord("4", 4), Integer.valueOf(0), null));
        HoodieReadStats readStats = new HoodieReadStats();
        Mockito.when((Object)this.mockReaderContext.getPayloadClasses((TypedProperties)ArgumentMatchers.any())).thenReturn((Object)Option.empty());
        UpdateProcessor updateProcessor = UpdateProcessor.create((HoodieReadStats)readStats, this.mockReaderContext, (boolean)false, (Option)Option.empty(), (TypedProperties)new TypedProperties());
        Predicates.In keyFilter = Predicates.in(null, Arrays.asList(Literal.from((Object)"1"), Literal.from((Object)"2"), Literal.from((Object)"3"), Literal.from((Object)"5")));
        Mockito.when((Object)this.mockReaderContext.getKeyFilterOpt()).thenReturn((Object)Option.of((Object)keyFilter));
        Mockito.when((Object)this.mockReaderContext.getSchemaHandler().getRequiredSchema()).thenReturn((Object)HoodieTestDataGenerator.AVRO_SCHEMA);
        Mockito.when((Object)this.mockReaderContext.getSchemaHandler().getInternalSchema()).thenReturn((Object)InternalSchema.getEmptyInternalSchema());
        Mockito.when((Object)this.mockReaderContext.getRecordContext().getDeleteRow((String)ArgumentMatchers.any())).thenAnswer(invocation -> {
            String recordKey = (String)invocation.getArgument(0);
            return new TestRecord(recordKey, 0);
        });
        Mockito.when((Object)this.mockReaderContext.getRecordContext().getRecordKey(ArgumentMatchers.any(), (Schema)ArgumentMatchers.any())).thenAnswer(invocation -> ((TestRecord)invocation.getArgument(0)).getRecordKey());
        Mockito.when((Object)this.mockReaderContext.getRecordContext().getOrderingValue(ArgumentMatchers.any(), (Schema)ArgumentMatchers.any(), ArgumentMatchers.anyList())).thenAnswer(invocation -> {
            TestRecord record = (TestRecord)invocation.getArgument(0);
            if (record.getRecordKey().equals("1")) {
                return 20;
            }
            return 1;
        });
        Mockito.when((Object)this.mockReaderContext.getRecordContext().toBinaryRow((Schema)ArgumentMatchers.any(), ArgumentMatchers.any())).thenAnswer(invocation -> invocation.getArgument(1));
        Mockito.when((Object)this.mockReaderContext.getRecordContext().seal(ArgumentMatchers.any())).thenAnswer(invocation -> invocation.getArgument(0));
        ReusableKeyBasedRecordBuffer buffer = new ReusableKeyBasedRecordBuffer(this.mockReaderContext, this.metaClient, RecordMergeMode.EVENT_TIME_ORDERING, Option.empty(), new TypedProperties(), Collections.singletonList("value"), updateProcessor, preMergedLogRecords);
        List<TestRecord> baseFileRecords = Arrays.asList(new TestRecord("1", 10), new TestRecord("3", 30));
        buffer.setBaseFileIterator(ClosableIterator.wrap(baseFileRecords.iterator()));
        ArrayList<Object> actualRecords = new ArrayList<Object>();
        while (buffer.hasNext()) {
            actualRecords.add(buffer.next().getRecord());
        }
        Assertions.assertEquals(Arrays.asList(new TestRecord("1", 10), new TestRecord("3", 3), new TestRecord("2", 2)), actualRecords);
    }
}

