/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read.buffer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.HoodieAvroReaderContext;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.model.DeleteRecord;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieDeleteBlock;
import org.apache.hudi.common.table.read.FileGroupReaderSchemaHandler;
import org.apache.hudi.common.table.read.HoodieReadStats;
import org.apache.hudi.common.table.read.InputSplit;
import org.apache.hudi.common.table.read.ReaderParameters;
import org.apache.hudi.common.table.read.UpdateProcessor;
import org.apache.hudi.common.table.read.buffer.BaseTestFileGroupRecordBuffer;
import org.apache.hudi.common.table.read.buffer.FileGroupRecordBuffer;
import org.apache.hudi.common.table.read.buffer.FileGroupRecordBufferLoader;
import org.apache.hudi.common.table.read.buffer.SortedKeyBasedFileGroupRecordBuffer;
import org.apache.hudi.common.table.read.buffer.TestRecord;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.storage.StorageConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class TestSortedKeyBasedFileGroupRecordBuffer
extends BaseTestFileGroupRecordBuffer {
    private final TestRecord testRecord1 = new TestRecord("1", 0);
    private final TestRecord testRecord2 = new TestRecord("2", 0);
    private final TestRecord testRecord2Update = new TestRecord("2", 1);
    private final TestRecord testRecord3 = new TestRecord("3", 0);
    private final TestRecord testRecord4 = new TestRecord("4", 0);
    private final TestRecord testRecord5 = new TestRecord("5", 0);
    private final TestRecord testRecord6 = new TestRecord("6", 0);
    private final TestRecord testRecord6Update = new TestRecord("6", 1);
    private final IndexedRecord testIndexedRecord1 = TestSortedKeyBasedFileGroupRecordBuffer.createTestRecord("1", 1, 1L);
    private final IndexedRecord testIndexedRecord2 = TestSortedKeyBasedFileGroupRecordBuffer.createTestRecord("2", 1, 1L);
    private final IndexedRecord testIndexedRecord2Update = TestSortedKeyBasedFileGroupRecordBuffer.createTestRecord("2", 1, 2L);
    private final IndexedRecord testIndexedRecord3 = TestSortedKeyBasedFileGroupRecordBuffer.createTestRecord("3", 1, 1L);
    private final IndexedRecord testIndexedRecord4 = TestSortedKeyBasedFileGroupRecordBuffer.createTestRecord("4", 2, 2L);
    private final IndexedRecord testIndexedRecord4LowerOrdering = TestSortedKeyBasedFileGroupRecordBuffer.createTestRecord("4", 2, 1L);
    private final IndexedRecord testIndexedRecord5 = TestSortedKeyBasedFileGroupRecordBuffer.createTestRecord("5", 1, 1L);
    private final IndexedRecord testRecord5DeleteByCustomMarker = TestSortedKeyBasedFileGroupRecordBuffer.createTestRecord("5", 3, 2L);
    private final IndexedRecord testIndexedRecord6 = TestSortedKeyBasedFileGroupRecordBuffer.createTestRecord("6", 1, 5L);
    private final IndexedRecord testIndexedRecord6Update = TestSortedKeyBasedFileGroupRecordBuffer.createTestRecord("6", 2, 10L);

    TestSortedKeyBasedFileGroupRecordBuffer() {
    }

    @Test
    void readBaseFileAndLogFile() throws IOException {
        HoodieReadStats readStats = new HoodieReadStats();
        HoodieReaderContext mockReaderContext = (HoodieReaderContext)Mockito.mock(HoodieReaderContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        SortedKeyBasedFileGroupRecordBuffer<TestRecord> fileGroupRecordBuffer = this.buildSortedKeyBasedFileGroupRecordBuffer((HoodieReaderContext<TestRecord>)mockReaderContext, readStats);
        fileGroupRecordBuffer.setBaseFileIterator(ClosableIterator.wrap(Arrays.asList(this.testRecord2, this.testRecord3, this.testRecord5).iterator()));
        HoodieDataBlock dataBlock = (HoodieDataBlock)Mockito.mock(HoodieDataBlock.class);
        Mockito.when((Object)dataBlock.getSchema()).thenReturn((Object)HoodieTestDataGenerator.AVRO_SCHEMA);
        Mockito.when((Object)dataBlock.getEngineRecordIterator(mockReaderContext)).thenReturn((Object)ClosableIterator.wrap(Arrays.asList(this.testRecord6, this.testRecord4, this.testRecord1, this.testRecord6Update, this.testRecord2Update).iterator()));
        HoodieDeleteBlock deleteBlock = (HoodieDeleteBlock)Mockito.mock(HoodieDeleteBlock.class);
        Mockito.when((Object)deleteBlock.getRecordsToDelete()).thenReturn((Object)new DeleteRecord[]{DeleteRecord.create((String)"3", (String)"")});
        fileGroupRecordBuffer.processDataBlock(dataBlock, Option.empty());
        fileGroupRecordBuffer.processDeleteBlock(deleteBlock);
        List<TestRecord> actualRecords = TestSortedKeyBasedFileGroupRecordBuffer.getActualRecordsForSortedKeyBased(fileGroupRecordBuffer);
        Assertions.assertEquals(Arrays.asList(this.testRecord1, this.testRecord2Update, this.testRecord4, this.testRecord5, this.testRecord6Update), actualRecords);
        Assertions.assertEquals((long)3L, (long)readStats.getNumInserts());
        Assertions.assertEquals((long)1L, (long)readStats.getNumUpdates());
        Assertions.assertEquals((long)1L, (long)readStats.getNumDeletes());
    }

    @Test
    void readWithStreamingRecordBufferLoaderAndEventTimeOrdering() throws IOException {
        HoodieReadStats readStats = new HoodieReadStats();
        TypedProperties properties = new TypedProperties();
        properties.setProperty(HoodieTableConfig.ORDERING_FIELDS.key(), "ts");
        properties.setProperty("hoodie.payload.delete.field", "counter");
        properties.setProperty("hoodie.payload.delete.marker", "3");
        HoodieTableConfig tableConfig = (HoodieTableConfig)Mockito.mock(HoodieTableConfig.class);
        Mockito.when((Object)tableConfig.getRecordKeyFields()).thenReturn((Object)Option.of((Object)new String[]{"record_key"}));
        Mockito.when((Object)tableConfig.getTableVersion()).thenReturn((Object)HoodieTableVersion.current());
        Mockito.when((Object)tableConfig.getRecordMergeMode()).thenReturn((Object)RecordMergeMode.EVENT_TIME_ORDERING);
        StorageConfiguration storageConfiguration = (StorageConfiguration)Mockito.mock(StorageConfiguration.class);
        HoodieAvroReaderContext readerContext = new HoodieAvroReaderContext(storageConfiguration, tableConfig, Option.empty(), Option.empty());
        readerContext.setHasLogFiles(false);
        readerContext.setHasBootstrapBaseFile(false);
        FileGroupReaderSchemaHandler schemaHandler = new FileGroupReaderSchemaHandler((HoodieReaderContext)readerContext, SCHEMA, SCHEMA, Option.empty(), properties, (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class));
        readerContext.setSchemaHandler(schemaHandler);
        readerContext.initRecordMerger(properties);
        List<HoodieRecord> inputRecords = TestSortedKeyBasedFileGroupRecordBuffer.convertToHoodieRecordsList(Arrays.asList(this.testIndexedRecord6Update, this.testIndexedRecord4LowerOrdering, this.testIndexedRecord1, this.testIndexedRecord2Update));
        inputRecords.addAll(TestSortedKeyBasedFileGroupRecordBuffer.convertToHoodieRecordsListForDeletes(Arrays.asList(this.testRecord5DeleteByCustomMarker), false));
        HoodieTableMetaClient mockMetaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockMetaClient.getTableConfig()).thenReturn((Object)tableConfig);
        Mockito.when((Object)tableConfig.getPayloadClass()).thenReturn((Object)DefaultHoodieRecordPayload.class.getName());
        Mockito.when((Object)tableConfig.getPartialUpdateMode()).thenReturn((Object)Option.empty());
        FileGroupRecordBufferLoader recordBufferLoader = FileGroupRecordBufferLoader.createStreamingRecordsBufferLoader();
        InputSplit inputSplit = (InputSplit)Mockito.mock(InputSplit.class);
        Mockito.when((Object)inputSplit.hasNoRecordsToMerge()).thenReturn((Object)false);
        Mockito.when((Object)inputSplit.getRecordIterator()).thenReturn(inputRecords.iterator());
        ReaderParameters readerParameters = (ReaderParameters)Mockito.mock(ReaderParameters.class);
        Mockito.when((Object)readerParameters.sortOutputs()).thenReturn((Object)true);
        SortedKeyBasedFileGroupRecordBuffer fileGroupRecordBuffer = (SortedKeyBasedFileGroupRecordBuffer)recordBufferLoader.getRecordBuffer((HoodieReaderContext)readerContext, mockMetaClient.getStorage(), inputSplit, Collections.singletonList("ts"), mockMetaClient, properties, readerParameters, readStats, Option.empty()).getKey();
        Mockito.when((Object)tableConfig.getPayloadClass()).thenReturn((Object)DefaultHoodieRecordPayload.class.getName());
        fileGroupRecordBuffer.setBaseFileIterator(ClosableIterator.wrap(Arrays.asList(this.testIndexedRecord2, this.testIndexedRecord3, this.testIndexedRecord4, this.testIndexedRecord5, this.testIndexedRecord6).iterator()));
        List<IndexedRecord> actualRecords = TestSortedKeyBasedFileGroupRecordBuffer.getActualRecords((FileGroupRecordBuffer<IndexedRecord>)fileGroupRecordBuffer);
        Assertions.assertEquals(this.convertGenRecordsToSerializableIndexedRecords(Stream.of(this.testIndexedRecord1, this.testIndexedRecord2Update, this.testIndexedRecord3, this.testIndexedRecord4, this.testIndexedRecord6Update)), actualRecords);
        Assertions.assertEquals((long)1L, (long)readStats.getNumInserts());
        Assertions.assertEquals((long)1L, (long)readStats.getNumDeletes());
        Assertions.assertEquals((long)2L, (long)readStats.getNumUpdates());
    }

    @Test
    void readLogFiles() throws IOException {
        HoodieReadStats readStats = new HoodieReadStats();
        HoodieReaderContext mockReaderContext = (HoodieReaderContext)Mockito.mock(HoodieReaderContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        SortedKeyBasedFileGroupRecordBuffer<TestRecord> fileGroupRecordBuffer = this.buildSortedKeyBasedFileGroupRecordBuffer((HoodieReaderContext<TestRecord>)mockReaderContext, readStats);
        fileGroupRecordBuffer.setBaseFileIterator(ClosableIterator.wrap(Collections.emptyIterator()));
        HoodieDataBlock dataBlock1 = (HoodieDataBlock)Mockito.mock(HoodieDataBlock.class);
        Mockito.when((Object)dataBlock1.getSchema()).thenReturn((Object)HoodieTestDataGenerator.AVRO_SCHEMA);
        Mockito.when((Object)dataBlock1.getEngineRecordIterator(mockReaderContext)).thenReturn((Object)ClosableIterator.wrap(Arrays.asList(this.testRecord6, this.testRecord4, this.testRecord6Update, this.testRecord2).iterator()));
        HoodieDataBlock dataBlock2 = (HoodieDataBlock)Mockito.mock(HoodieDataBlock.class);
        Mockito.when((Object)dataBlock2.getSchema()).thenReturn((Object)HoodieTestDataGenerator.AVRO_SCHEMA);
        Mockito.when((Object)dataBlock2.getEngineRecordIterator(mockReaderContext)).thenReturn((Object)ClosableIterator.wrap(Arrays.asList(this.testRecord2Update, this.testRecord5, this.testRecord3, this.testRecord1).iterator()));
        HoodieDeleteBlock deleteBlock = (HoodieDeleteBlock)Mockito.mock(HoodieDeleteBlock.class);
        Mockito.when((Object)deleteBlock.getRecordsToDelete()).thenReturn((Object)new DeleteRecord[]{DeleteRecord.create((String)"3", (String)"")});
        fileGroupRecordBuffer.processDataBlock(dataBlock1, Option.empty());
        fileGroupRecordBuffer.processDataBlock(dataBlock2, Option.empty());
        fileGroupRecordBuffer.processDeleteBlock(deleteBlock);
        List<TestRecord> actualRecords = TestSortedKeyBasedFileGroupRecordBuffer.getActualRecordsForSortedKeyBased(fileGroupRecordBuffer);
        Assertions.assertEquals(Arrays.asList(this.testRecord1, this.testRecord2Update, this.testRecord4, this.testRecord5, this.testRecord6Update), actualRecords);
        Assertions.assertEquals((long)5L, (long)readStats.getNumInserts());
        Assertions.assertEquals((long)0L, (long)readStats.getNumUpdates());
        Assertions.assertEquals((long)1L, (long)readStats.getNumDeletes());
    }

    private SortedKeyBasedFileGroupRecordBuffer<TestRecord> buildSortedKeyBasedFileGroupRecordBuffer(HoodieReaderContext<TestRecord> mockReaderContext, HoodieReadStats readStats) {
        Mockito.when((Object)mockReaderContext.getSchemaHandler().getRequiredSchema()).thenReturn((Object)HoodieTestDataGenerator.AVRO_SCHEMA);
        Mockito.when((Object)mockReaderContext.getSchemaHandler().getInternalSchema()).thenReturn((Object)InternalSchema.getEmptyInternalSchema());
        Mockito.when((Object)mockReaderContext.getRecordContext().getDeleteRow((String)ArgumentMatchers.any())).thenAnswer(invocation -> {
            String recordKey = (String)invocation.getArgument(0);
            return new TestRecord(recordKey, 0);
        });
        Mockito.when((Object)mockReaderContext.getRecordContext().getRecordKey(ArgumentMatchers.any(), (Schema)ArgumentMatchers.any())).thenAnswer(invocation -> ((TestRecord)invocation.getArgument(0)).getRecordKey());
        Mockito.when((Object)mockReaderContext.getRecordContext().getOrderingValue(ArgumentMatchers.any(), (Schema)ArgumentMatchers.any(), ArgumentMatchers.anyList())).thenReturn((Object)0);
        Mockito.when((Object)mockReaderContext.getRecordContext().toBinaryRow((Schema)ArgumentMatchers.any(), ArgumentMatchers.any())).thenAnswer(invocation -> invocation.getArgument(1));
        Mockito.when((Object)mockReaderContext.getRecordContext().seal(ArgumentMatchers.any())).thenAnswer(invocation -> invocation.getArgument(0));
        HoodieTableMetaClient mockMetaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        RecordMergeMode recordMergeMode = RecordMergeMode.COMMIT_TIME_ORDERING;
        Option partialUpdateModeOpt = Option.empty();
        TypedProperties props = new TypedProperties();
        Mockito.when((Object)mockReaderContext.getPayloadClasses((TypedProperties)ArgumentMatchers.any())).thenReturn((Object)Option.empty());
        UpdateProcessor updateProcessor = UpdateProcessor.create((HoodieReadStats)readStats, mockReaderContext, (boolean)false, (Option)Option.empty(), (TypedProperties)props);
        return new SortedKeyBasedFileGroupRecordBuffer(mockReaderContext, mockMetaClient, recordMergeMode, partialUpdateModeOpt, props, Collections.emptyList(), updateProcessor);
    }

    private static <T> List<T> getActualRecordsForSortedKeyBased(SortedKeyBasedFileGroupRecordBuffer<T> fileGroupRecordBuffer) throws IOException {
        ArrayList<Object> actualRecords = new ArrayList<Object>();
        while (fileGroupRecordBuffer.hasNext()) {
            actualRecords.add(fileGroupRecordBuffer.next().getRecord());
        }
        return actualRecords;
    }
}

