/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.versioning.common.InstantComparators;
import org.apache.hudi.common.table.timeline.versioning.v2.InstantComparatorV2;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestInstantComparators {
    TestInstantComparators() {
    }

    @Test
    void testCompletionTimeOrdering() {
        HoodieInstant instant1 = TestInstantComparators.createCompletedHoodieInstant("001", "002");
        HoodieInstant instant2 = TestInstantComparators.createCompletedHoodieInstant("003", "005");
        HoodieInstant instant3 = TestInstantComparators.createCompletedHoodieInstant("002", "004");
        HoodieInstant instant4 = TestInstantComparators.createInflightHoodieInstant("004");
        HoodieInstant instant5 = TestInstantComparators.createInflightHoodieInstant("009");
        InstantComparators.CompletionTimeBasedComparator comparator = new InstantComparators.CompletionTimeBasedComparator(Collections.singletonMap("compaction", "commit"));
        List<HoodieInstant> instants = Arrays.asList(instant5, instant3, instant1, instant4, instant2);
        instants.sort((Comparator<HoodieInstant>)comparator);
        Assertions.assertEquals(Arrays.asList(instant1, instant3, instant2, instant4, instant5), instants);
    }

    private static HoodieInstant createCompletedHoodieInstant(String requestedTime, String completionTime) {
        return new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", requestedTime, completionTime, InstantComparatorV2.COMPLETION_TIME_BASED_COMPARATOR);
    }

    private static HoodieInstant createInflightHoodieInstant(String requestedTime) {
        return new HoodieInstant(HoodieInstant.State.INFLIGHT, "commit", requestedTime, InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR);
    }
}

