/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import org.apache.hudi.common.table.timeline.LSMTimeline;
import org.apache.hudi.exception.HoodieException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestLSMTimeline {
    @Test
    void testParseMinInstantTime() {
        String fileName = "001_002_0.parquet";
        String minInstantTime = LSMTimeline.getMinInstantTime((String)fileName);
        MatcherAssert.assertThat((Object)minInstantTime, (Matcher)CoreMatchers.is((Object)"001"));
        Assertions.assertThrows(HoodieException.class, () -> LSMTimeline.getMinInstantTime((String)"invalid_file_name.parquet"));
    }

    @Test
    void testParseMaxInstantTime() {
        String fileName = "001_002_0.parquet";
        String maxInstantTime = LSMTimeline.getMaxInstantTime((String)fileName);
        MatcherAssert.assertThat((Object)maxInstantTime, (Matcher)CoreMatchers.is((Object)"002"));
        Assertions.assertThrows(HoodieException.class, () -> LSMTimeline.getMaxInstantTime((String)"invalid_file_name.parquet"));
    }

    @Test
    void testParseFileLayer() {
        String fileName = "001_002_0.parquet";
        int layer = LSMTimeline.getFileLayer((String)fileName);
        MatcherAssert.assertThat((Object)layer, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((String)"for invalid file name, returns 0", (Object)LSMTimeline.getFileLayer((String)"invalid_file_name.parquet"), (Matcher)CoreMatchers.is((Object)0));
    }
}

