/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.avro.model.HoodieRestoreMetadata;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieRollbackPlan;
import org.apache.hudi.avro.model.HoodieSavepointMetadata;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.timeline.CommitMetadataSerDe;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.testutils.FileCreateUtilsBase;
import org.apache.hudi.common.testutils.InProcessTimeGenerator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.storage.HoodieInstantWriter;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;

public class FileCreateUtils
extends FileCreateUtilsBase {
    private static void createMetaFile(HoodieTableMetaClient metaClient, String instantTime, String suffix, HoodieStorage storage) throws IOException {
        FileCreateUtils.createMetaFile(metaClient, instantTime, suffix, storage, metaClient.getTableConfig().getTableVersion().lesserThan(HoodieTableVersion.EIGHT));
    }

    private static void createMetaFile(HoodieTableMetaClient metaClient, String instantTime, String suffix, HoodieStorage storage, boolean preTableVersion8) throws IOException {
        FileCreateUtils.createMetaFileInMetaPath(metaClient.getMetaPath(), instantTime, suffix, storage, preTableVersion8);
    }

    private static void createMetaFile(HoodieTableMetaClient metaClient, String instantTime, String suffix) throws IOException {
        FileCreateUtils.createMetaFile(metaClient, instantTime, (Option<String>)Option.empty(), suffix, Option.empty());
    }

    private static <T> void createMetaFile(HoodieTableMetaClient metaClient, String instantTime, Option<String> completeTime, String suffix, Option<T> metadata) throws IOException {
        FileCreateUtils.createMetaFileInTimelinePath(metaClient, instantTime, completeTime.isEmpty() ? InProcessTimeGenerator::createNewInstantTime : () -> completeTime.get(), suffix, (Option<HoodieInstantWriter>)metadata.flatMap(m -> metaClient.getCommitMetadataSerDe().getInstantWriter(m)));
    }

    private static <T> void createMetaFile(HoodieTableMetaClient metaClient, String instantTime, String suffix, Option<T> metadata) throws IOException {
        FileCreateUtils.createMetaFileInTimelinePath(metaClient, instantTime, InProcessTimeGenerator::createNewInstantTime, suffix, (Option<HoodieInstantWriter>)metadata.flatMap(m -> metaClient.getCommitMetadataSerDe().getInstantWriter(m)));
    }

    public static String markerFileName(String fileName, IOType ioType) {
        return String.format("%s%s.%s", fileName, ".marker", ioType.name());
    }

    public static String dataFileMarkerFileName(String instantTime, String fileId, IOType ioType, String fileExtension, String writeToken) {
        return FileCreateUtils.markerFileName(FSUtils.makeBaseFileName((String)instantTime, (String)writeToken, (String)fileId, (String)fileExtension), ioType);
    }

    public static String logFileMarkerFileName(String instantTime, String fileId, IOType ioType, int logVersion) {
        return FileCreateUtils.logFileMarkerFileName(instantTime, fileId, ioType, ".log", logVersion);
    }

    public static String logFileMarkerFileName(String instantTime, String fileId, IOType ioType, String fileExtension, int logVersion) {
        return FileCreateUtils.markerFileName(FSUtils.makeLogFileName((String)fileId, (String)fileExtension, (String)instantTime, (int)logVersion, (String)"1-0-1"), ioType);
    }

    private static void deleteMetaFile(HoodieTableMetaClient metaClient, String instantTime, String suffix, HoodieStorage storage) throws IOException {
        FileCreateUtils.deleteMetaFileInTimeline(metaClient.getTimelinePath().toUri().getPath(), instantTime, suffix, storage);
    }

    public static void createCommit(HoodieTableMetaClient metaClient, CommitMetadataSerDe commitMetadataSerDe, String instantTime, Option<HoodieCommitMetadata> metadata) throws IOException {
        FileCreateUtils.createCommit(metaClient, commitMetadataSerDe, instantTime, (Option<String>)Option.empty(), metadata);
    }

    public static void createCommit(HoodieTableMetaClient metaClient, CommitMetadataSerDe commitMetadataSerDe, String instantTime, Option<String> completionTime, Option<HoodieCommitMetadata> metadata) throws IOException {
        Supplier<String> completionTimeSupplier = () -> completionTime.isPresent() ? (String)completionTime.get() : InProcessTimeGenerator.createNewInstantTime();
        if (metadata.isPresent()) {
            HoodieCommitMetadata commitMetadata = (HoodieCommitMetadata)metadata.get();
            FileCreateUtils.createMetaFileInTimelinePath(metaClient, instantTime, completionTimeSupplier, ".commit", (Option<HoodieInstantWriter>)metaClient.getCommitMetadataSerDe().getInstantWriter((Object)commitMetadata));
        } else {
            FileCreateUtils.createMetaFileInTimelinePath(metaClient, instantTime, completionTimeSupplier, ".commit", (Option<HoodieInstantWriter>)Option.empty());
        }
    }

    public static void createSavepointCommit(HoodieTableMetaClient metaClient, String instantTime, Option<String> completeTime, HoodieSavepointMetadata savepointMetadata) throws IOException {
        FileCreateUtils.createMetaFile(metaClient, instantTime, completeTime, ".savepoint", Option.of((Object)savepointMetadata));
    }

    public static void createCommit(HoodieTableMetaClient metaClient, String instantTime) throws IOException {
        FileCreateUtils.createMetaFile(metaClient, instantTime, ".commit");
    }

    public static void createRequestedCommit(HoodieTableMetaClient metaClient, String instantTime) throws IOException {
        FileCreateUtils.createMetaFile(metaClient, instantTime, ".commit.requested");
    }

    public static void createInflightCommit(HoodieTableMetaClient metaClient, String instantTime) throws IOException {
        FileCreateUtils.createMetaFile(metaClient, instantTime, ".inflight");
    }

    public static void createDeltaCommit(HoodieTableMetaClient metaClient, CommitMetadataSerDe commitMetadataSerDe, String instantTime, Option<String> completeTime, HoodieCommitMetadata metadata) throws IOException {
        FileCreateUtils.createMetaFile(metaClient, instantTime, completeTime, ".deltacommit", Option.of((Object)metadata));
    }

    public static void createDeltaCommit(HoodieTableMetaClient metaClient, String instantTime) throws IOException {
        FileCreateUtils.createMetaFile(metaClient, instantTime, ".deltacommit");
    }

    public static void createDeltaCommit(HoodieTableMetaClient metaClient, String instantTime, HoodieStorage storage) throws IOException {
        FileCreateUtils.createMetaFile(metaClient, instantTime, ".deltacommit", storage);
    }

    public static void createDeltaCommit(HoodieTableMetaClient metaClient, String instantTime, HoodieStorage storage, boolean preTableVersion8) throws IOException {
        FileCreateUtils.createMetaFile(metaClient, instantTime, ".deltacommit", storage, preTableVersion8);
    }

    public static void createRequestedDeltaCommit(HoodieTableMetaClient metaClient, String instantTime) throws IOException {
        FileCreateUtils.createMetaFile(metaClient, instantTime, ".deltacommit.requested");
    }

    public static void createInflightDeltaCommit(HoodieTableMetaClient metaClient, String instantTime) throws IOException {
        FileCreateUtils.createMetaFile(metaClient, instantTime, ".deltacommit.inflight");
    }

    public static void createInflightDeltaCommit(HoodieTableMetaClient metaClient, String instantTime, HoodieStorage storage) throws IOException {
        FileCreateUtils.createMetaFile(metaClient, instantTime, ".deltacommit.inflight", storage);
    }

    public static void createInflightReplaceCommit(HoodieTableMetaClient metaClient, String instantTime) throws IOException {
        FileCreateUtils.createMetaFile(metaClient, instantTime, ".replacecommit.inflight");
    }

    public static void createReplaceCommit(HoodieTableMetaClient metaClient, CommitMetadataSerDe commitMetadataSerDe, String instantTime, Option<String> completeTime, HoodieReplaceCommitMetadata metadata) throws IOException {
        FileCreateUtils.createMetaFile(metaClient, instantTime, completeTime, ".replacecommit", Option.of((Object)metadata));
    }

    public static void createReplaceCommit(HoodieTableMetaClient metaClient, CommitMetadataSerDe commitMetadataSerDe, String instantTime, HoodieReplaceCommitMetadata metadata) throws IOException {
        FileCreateUtils.createMetaFile(metaClient, instantTime, (Option<String>)Option.empty(), ".replacecommit", Option.of((Object)metadata));
    }

    public static void createReplaceCommit(HoodieTableMetaClient metaClient, CommitMetadataSerDe commitMetadataSerDe, String instantTime, String completionTime, HoodieReplaceCommitMetadata metadata) throws IOException {
        FileCreateUtils.createMetaFileInTimelinePath(metaClient, instantTime, () -> completionTime, ".replacecommit", (Option<HoodieInstantWriter>)metaClient.getCommitMetadataSerDe().getInstantWriter((Object)metadata));
    }

    public static void createRequestedClusterCommit(HoodieTableMetaClient metaClient, String instantTime, HoodieRequestedReplaceMetadata requestedReplaceMetadata) throws IOException {
        FileCreateUtils.createMetaFile(metaClient, instantTime, ".clustering.requested", Option.of((Object)requestedReplaceMetadata));
    }

    public static void createInflightClusterCommit(HoodieTableMetaClient metaClient, CommitMetadataSerDe commitMetadataSerDe, String instantTime, Option<HoodieReplaceCommitMetadata> inflightReplaceMetadata) throws IOException {
        if (inflightReplaceMetadata.isPresent()) {
            FileCreateUtils.createMetaFile(metaClient, instantTime, ".clustering.inflight", inflightReplaceMetadata);
        } else {
            FileCreateUtils.createMetaFile(metaClient, instantTime, ".clustering.inflight");
        }
    }

    public static void createRequestedReplaceCommit(HoodieTableMetaClient metaClient, String instantTime, Option<HoodieRequestedReplaceMetadata> requestedReplaceMetadata) throws IOException {
        if (requestedReplaceMetadata.isPresent()) {
            FileCreateUtils.createMetaFile(metaClient, instantTime, ".replacecommit.requested", requestedReplaceMetadata);
        } else {
            FileCreateUtils.createMetaFile(metaClient, instantTime, ".replacecommit.requested");
        }
    }

    public static void createInflightReplaceCommit(HoodieTableMetaClient metaClient, CommitMetadataSerDe commitMetadataSerDe, String instantTime, Option<HoodieCommitMetadata> inflightReplaceMetadata) throws IOException {
        if (inflightReplaceMetadata.isPresent()) {
            FileCreateUtils.createMetaFile(metaClient, instantTime, ".replacecommit.inflight", inflightReplaceMetadata);
        } else {
            FileCreateUtils.createMetaFile(metaClient, instantTime, ".replacecommit.inflight");
        }
    }

    public static void createRequestedCompactionCommit(HoodieTableMetaClient metaClient, String instantTime, HoodieCompactionPlan requestedCompactionPlan) throws IOException {
        FileCreateUtils.createMetaFile(metaClient, instantTime, HoodieTimeline.REQUESTED_COMPACTION_EXTENSION, Option.of((Object)requestedCompactionPlan));
    }

    public static void createCleanFile(HoodieTableMetaClient metaClient, String instantTime, HoodieCleanMetadata metadata) throws IOException {
        FileCreateUtils.createMetaFile(metaClient, instantTime, ".clean", Option.of((Object)metadata));
    }

    public static void createCleanFile(HoodieTableMetaClient metaClient, String instantTime, Option<String> completeTime, HoodieCleanMetadata metadata, boolean isEmpty) throws IOException {
        FileCreateUtils.createMetaFile(metaClient, instantTime, completeTime, ".clean", isEmpty ? Option.empty() : Option.of((Object)metadata));
    }

    public static void createRequestedCleanFile(HoodieTableMetaClient metaClient, String instantTime, HoodieCleanerPlan cleanerPlan) throws IOException {
        FileCreateUtils.createMetaFile(metaClient, instantTime, ".clean.requested", Option.of((Object)cleanerPlan));
    }

    public static void createRequestedCleanFile(HoodieTableMetaClient metaClient, String instantTime, HoodieCleanerPlan cleanerPlan, boolean isEmpty) throws IOException {
        FileCreateUtils.createMetaFile(metaClient, instantTime, ".clean.requested", isEmpty ? Option.empty() : Option.of((Object)cleanerPlan));
    }

    public static void createInflightCleanFile(HoodieTableMetaClient metaClient, String instantTime, HoodieCleanerPlan cleanerPlan) throws IOException {
        FileCreateUtils.createMetaFile(metaClient, instantTime, ".clean.inflight", Option.of((Object)cleanerPlan));
    }

    public static void createInflightCleanFile(HoodieTableMetaClient metaClient, String instantTime, HoodieCleanerPlan cleanerPlan, boolean isEmpty) throws IOException {
        FileCreateUtils.createMetaFile(metaClient, instantTime, ".clean.inflight", isEmpty ? Option.empty() : Option.of((Object)cleanerPlan));
    }

    public static void createRequestedRollbackFile(HoodieTableMetaClient metaClient, String instantTime, HoodieRollbackPlan plan) throws IOException {
        FileCreateUtils.createMetaFile(metaClient, instantTime, ".rollback.requested", Option.of((Object)plan));
    }

    public static void createRequestedRollbackFile(HoodieTableMetaClient metaClient, String instantTime, byte[] content) throws IOException {
        FileCreateUtils.createMetaFileInTimelinePath(metaClient, instantTime, InProcessTimeGenerator::createNewInstantTime, ".rollback.requested", (Option<HoodieInstantWriter>)Option.of((Object)HoodieInstantWriter.convertByteArrayToWriter((byte[])content)));
    }

    public static void createRequestedRollbackFile(HoodieTableMetaClient metaClient, String instantTime) throws IOException {
        FileCreateUtils.createMetaFile(metaClient, instantTime, ".rollback.requested");
    }

    public static void createInflightRollbackFile(HoodieTableMetaClient metaClient, String instantTime) throws IOException {
        FileCreateUtils.createMetaFile(metaClient, instantTime, ".rollback.inflight");
    }

    public static void createRollbackFile(HoodieTableMetaClient metaClient, String instantTime, HoodieRollbackMetadata hoodieRollbackMetadata, boolean isEmpty) throws IOException {
        FileCreateUtils.createMetaFile(metaClient, instantTime, ".rollback", isEmpty ? Option.empty() : Option.of((Object)hoodieRollbackMetadata));
    }

    public static void createRestoreFile(HoodieTableMetaClient metaClient, String instantTime, HoodieRestoreMetadata hoodieRestoreMetadata) throws IOException {
        FileCreateUtils.createMetaFile(metaClient, instantTime, "restore", Option.of((Object)hoodieRestoreMetadata));
    }

    public static void createRequestedCompaction(HoodieTableMetaClient metaClient, String instantTime) throws IOException {
        FileCreateUtils.createMetaFile(metaClient, instantTime, HoodieTimeline.REQUESTED_COMPACTION_EXTENSION);
    }

    public static void createInflightCompaction(HoodieTableMetaClient metaClient, String instantTime) throws IOException {
        FileCreateUtils.createMetaFile(metaClient, instantTime, HoodieTimeline.INFLIGHT_COMPACTION_EXTENSION);
    }

    public static void createInflightSavepoint(HoodieTableMetaClient metaClient, String instantTime) throws IOException {
        FileCreateUtils.createMetaFile(metaClient, instantTime, ".savepoint.inflight");
    }

    protected static void createMetaFileInTimelinePath(HoodieTableMetaClient metaClient, String instantTime, Supplier<String> completionTimeSupplier, String suffix, Option<HoodieInstantWriter> writer) throws IOException {
        block24: {
            try {
                Path parentPath = Paths.get(metaClient.getTimelinePath().makeQualified(new URI("file:///")).toUri());
                Files.createDirectories(parentPath, new FileAttribute[0]);
                if (suffix.contains(".inflight") || suffix.contains(".requested")) {
                    Path metaFilePath = parentPath.resolve(instantTime + suffix);
                    if (Files.notExists(metaFilePath, new LinkOption[0])) {
                        if (writer.isEmpty()) {
                            Files.createFile(metaFilePath, new FileAttribute[0]);
                        } else {
                            Files.write(metaFilePath, (byte[])writer.map(FileCreateUtils::writeInstantContentToBytes).get(), new OpenOption[0]);
                        }
                    }
                    break block24;
                }
                try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(parentPath, instantTime + "*" + suffix);){
                    if (!dirStream.iterator().hasNext()) {
                        String completedInstantFilePrefix = "";
                        if (metaClient.getTimelineLayoutVersion().getVersion().equals(TimelineLayoutVersion.VERSION_1)) {
                            completedInstantFilePrefix = instantTime;
                        } else if (metaClient.getTimelineLayoutVersion().getVersion().equals(TimelineLayoutVersion.VERSION_2)) {
                            completedInstantFilePrefix = instantTime + "_" + completionTimeSupplier.get();
                        }
                        Path metaFilePath = parentPath.resolve(completedInstantFilePrefix + suffix);
                        if (writer.isEmpty()) {
                            Files.createFile(metaFilePath, new FileAttribute[0]);
                        } else {
                            Files.write(metaFilePath, (byte[])writer.map(FileCreateUtils::writeInstantContentToBytes).get(), new OpenOption[0]);
                        }
                    }
                }
            }
            catch (URISyntaxException ex) {
                throw new HoodieException((Throwable)ex);
            }
        }
    }

    public static String createBaseFile(HoodieTableMetaClient metaClient, String partitionPath, String instantTime, String fileId) throws Exception {
        return FileCreateUtils.createBaseFile(metaClient, partitionPath, instantTime, fileId, 1L);
    }

    public static String createBaseFile(HoodieTableMetaClient metaClient, String partitionPath, String instantTime, String fileId, long length) throws Exception {
        return FileCreateUtils.createBaseFile(metaClient, partitionPath, instantTime, fileId, length, Instant.now().toEpochMilli());
    }

    public static String createBaseFile(HoodieTableMetaClient metaClient, String partitionPath, String instantTime, String fileId, long length, long lastModificationTimeMilli) throws Exception {
        Path parentPath = Paths.get(metaClient.getBasePath().toUri().getPath(), partitionPath);
        Files.createDirectories(parentPath, new FileAttribute[0]);
        Path baseFilePath = parentPath.resolve(FileCreateUtils.baseFileName(instantTime, fileId));
        if (Files.notExists(baseFilePath, new LinkOption[0])) {
            Files.createFile(baseFilePath, new FileAttribute[0]);
        }
        try (RandomAccessFile raf = new RandomAccessFile(baseFilePath.toFile(), "rw");){
            raf.setLength(length);
        }
        Files.setLastModifiedTime(baseFilePath, FileTime.fromMillis(lastModificationTimeMilli));
        return baseFilePath.toString();
    }

    public static Path getBaseFilePath(String basePath, String partitionPath, String instantTime, String fileId) {
        Path parentPath = Paths.get(basePath, partitionPath);
        return parentPath.resolve(FileCreateUtils.baseFileName(instantTime, fileId));
    }

    public static String createLogFile(HoodieTableMetaClient metaClient, String partitionPath, String instantTime, String fileId, int version) throws Exception {
        return FileCreateUtils.createLogFile(metaClient, partitionPath, instantTime, fileId, version, 0);
    }

    public static String createLogFile(HoodieTableMetaClient metaClient, String partitionPath, String instantTime, String fileId, int version, int length) throws Exception {
        Path parentPath = Paths.get(metaClient.getBasePath().toUri().getPath(), partitionPath);
        Files.createDirectories(parentPath, new FileAttribute[0]);
        Path logFilePath = parentPath.resolve(FileCreateUtils.logFileName(instantTime, fileId, version));
        if (Files.notExists(logFilePath, new LinkOption[0])) {
            Files.createFile(logFilePath, new FileAttribute[0]);
        }
        RandomAccessFile raf = new RandomAccessFile(logFilePath.toFile(), "rw");
        raf.setLength(length);
        raf.close();
        return logFilePath.toString();
    }

    public static String createMarkerFile(HoodieTableMetaClient metaClient, String partitionPath, String instantTime, String fileId, IOType ioType) throws IOException {
        if (IOType.APPEND == ioType) {
            String logFileName = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)instantTime, (int)HoodieLogFile.LOGFILE_BASE_VERSION, (String)"1-0-1");
            String markerFileName = FileCreateUtils.markerFileName(logFileName, ioType);
            return FileCreateUtils.createMarkerFile(metaClient, partitionPath, instantTime, markerFileName);
        }
        return FileCreateUtils.createMarkerFile(metaClient, partitionPath, instantTime, instantTime, fileId, ioType, "1-0-1");
    }

    public static String createMarkerFile(HoodieTableMetaClient metaClient, String partitionPath, String commitInstant, String instantTime, String fileId, IOType ioType, String writeToken) throws IOException {
        return FileCreateUtils.createMarkerFile(metaClient, partitionPath, commitInstant, FileCreateUtils.markerFileName(instantTime, fileId, ioType, BASE_FILE_EXTENSION, writeToken));
    }

    public static String createMarkerFile(HoodieTableMetaClient metaClient, String partitionPath, String commitInstant, String markerFileName) throws IOException {
        Path parentPath = Paths.get(metaClient.getTempFolderPath(), commitInstant, partitionPath);
        Files.createDirectories(parentPath, new FileAttribute[0]);
        Path markerFilePath = parentPath.resolve(markerFileName);
        if (Files.notExists(markerFilePath, new LinkOption[0])) {
            Files.createFile(markerFilePath, new FileAttribute[0]);
        }
        return markerFilePath.toAbsolutePath().toString();
    }

    public static String createMarkerFile(String basePath, String partitionPath, String commitInstant, String instantTime, String fileId, IOType ioType, String writeToken) throws IOException {
        Path parentPath = Paths.get(basePath, ".hoodie/.temp", instantTime, partitionPath);
        Files.createDirectories(parentPath, new FileAttribute[0]);
        Path markerFilePath = parentPath.resolve(FileCreateUtils.dataFileMarkerFileName(instantTime, fileId, ioType, BASE_FILE_EXTENSION, writeToken));
        if (Files.notExists(markerFilePath, new LinkOption[0])) {
            Files.createFile(markerFilePath, new FileAttribute[0]);
        }
        return markerFilePath.toAbsolutePath().toString();
    }

    public static String createLogFileMarker(String basePath, String partitionPath, String instantTime, String fileId, IOType ioType) throws IOException {
        return FileCreateUtils.createLogFileMarker(basePath, partitionPath, instantTime, instantTime, fileId, ioType, HoodieLogFile.LOGFILE_BASE_VERSION);
    }

    public static String createLogFileMarker(String basePath, String partitionPath, String baseInstantTime, String instantTime, String fileId, IOType ioType, int logVersion) throws IOException {
        Path parentPath = Paths.get(basePath, ".hoodie/.temp", instantTime, partitionPath);
        Files.createDirectories(parentPath, new FileAttribute[0]);
        Path markerFilePath = parentPath.resolve(FileCreateUtils.logFileMarkerFileName(baseInstantTime, fileId, ioType, logVersion));
        if (Files.notExists(markerFilePath, new LinkOption[0])) {
            Files.createFile(markerFilePath, new FileAttribute[0]);
        }
        return markerFilePath.toAbsolutePath().toString();
    }

    public static String createFileMarkerByFileName(String basePath, String partitionPath, String instantTime, String fileName, IOType ioType) throws IOException {
        Path parentPath = Paths.get(basePath, ".hoodie/.temp", instantTime, partitionPath);
        Files.createDirectories(parentPath, new FileAttribute[0]);
        Path markerFilePath = parentPath.resolve(FileCreateUtils.markerFileName(fileName, ioType));
        if (Files.notExists(markerFilePath, new LinkOption[0])) {
            Files.createFile(markerFilePath, new FileAttribute[0]);
        }
        return markerFilePath.toAbsolutePath().toString();
    }

    public static String createLogFileMarker(HoodieTableMetaClient metaClient, String partitionPath, String instantTime, String logFileName) throws IOException {
        return FileCreateUtils.createMarkerFile(metaClient, partitionPath, instantTime, FileCreateUtils.markerFileName(logFileName, metaClient.getTableConfig().getTableVersion().greaterThanOrEquals(HoodieTableVersion.EIGHT) ? IOType.CREATE : IOType.APPEND));
    }

    private static void removeMetaFile(HoodieTableMetaClient metaClient, String instantTime, String suffix) throws IOException {
        FileCreateUtils.removeMetaFileInTimelinePath(metaClient.getTimelinePath().toUri().getPath(), instantTime, suffix);
    }

    public static void deleteCommit(HoodieTableMetaClient metaClient, String instantTime) throws IOException {
        FileCreateUtils.removeMetaFileInTimelinePath(metaClient.getTimelinePath().toUri().getPath(), instantTime, ".commit");
    }

    public static void deleteRequestedCommit(HoodieTableMetaClient metaClient, String instantTime) throws IOException {
        FileCreateUtils.removeMetaFileInTimelinePath(metaClient.getTimelinePath().toUri().getPath(), instantTime, ".commit.requested");
    }

    public static void deleteInflightCommit(HoodieTableMetaClient metaClient, String instantTime) throws IOException {
        FileCreateUtils.removeMetaFileInTimelinePath(metaClient.getTimelinePath().toUri().getPath(), instantTime, ".inflight");
    }

    public static void deleteDeltaCommit(HoodieTableMetaClient metaClient, String instantTime) throws IOException {
        FileCreateUtils.removeMetaFileInTimelinePath(metaClient.getTimelinePath().toUri().getPath(), instantTime, ".deltacommit");
    }

    public static void deleteReplaceCommit(HoodieTableMetaClient metaClient, String instantTime) throws IOException {
        FileCreateUtils.removeMetaFileInTimelinePath(metaClient.getTimelinePath().toUri().getPath(), instantTime, ".replacecommit");
    }

    public static void deleteRollbackCommit(HoodieTableMetaClient metaClient, String instantTime) throws IOException {
        FileCreateUtils.removeMetaFileInTimelinePath(metaClient.getTimelinePath().toUri().getPath(), instantTime, ".rollback");
    }

    public static Path renameFileToTemp(Path sourcePath, String instantTime) throws IOException {
        Path dummyFilePath = sourcePath.getParent().resolve(instantTime + ".temp");
        Files.move(sourcePath, dummyFilePath, new CopyOption[0]);
        return dummyFilePath;
    }

    public static void renameTempToMetaFile(Path tempFilePath, Path destPath) throws IOException {
        Files.move(tempFilePath, destPath, new CopyOption[0]);
    }

    public static long getTotalMarkerFileCount(HoodieTableMetaClient metaClient, String partitionPath, String instantTime, IOType ioType) throws IOException {
        Path parentPath = Paths.get(metaClient.getTempFolderPath(), instantTime, partitionPath);
        if (Files.notExists(parentPath, new LinkOption[0])) {
            return 0L;
        }
        return Files.list(parentPath).filter(p -> p.getFileName().toString().endsWith(String.format("%s.%s", ".marker", ioType))).count();
    }

    public static List<Path> getPartitionPaths(Path basePath) throws IOException {
        if (Files.notExists(basePath, new LinkOption[0])) {
            return Collections.emptyList();
        }
        return Files.list(basePath).filter(entry -> !entry.getFileName().toString().equals(".hoodie") && !FileCreateUtils.isBaseOrLogFilename(entry.getFileName().toString()) && !entry.getFileName().toString().startsWith(".hoodie_partition_metadata")).collect(Collectors.toList());
    }

    public static boolean isBaseOrLogFilename(String filename) {
        for (HoodieFileFormat format : HoodieFileFormat.values()) {
            if (!filename.contains(format.getFileExtension())) continue;
            return true;
        }
        return false;
    }

    public static Map<String, Long> getBaseFileCountsForPaths(HoodieTableMetaClient metaClient, HoodieStorage storage, String ... paths) {
        HashMap<String, Long> toReturn = new HashMap<String, Long>();
        try {
            for (String path : paths) {
                HoodieTableFileSystemView fileSystemView = new HoodieTableFileSystemView(metaClient, metaClient.getCommitsTimeline().filterCompletedInstants(), storage.globEntries(new StoragePath(path)));
                toReturn.put(path, fileSystemView.getLatestBaseFiles().count());
            }
            return toReturn;
        }
        catch (Exception e) {
            throw new HoodieException("Error reading hoodie table as a dataframe", (Throwable)e);
        }
    }

    public static void deleteDeltaCommit(HoodieTableMetaClient metaClient, String instantTime, HoodieStorage storage) throws IOException {
        FileCreateUtils.deleteMetaFile(metaClient, instantTime, ".deltacommit", storage);
    }

    public static void deleteSavepointCommit(HoodieTableMetaClient metaClient, String instantTime, HoodieStorage storage) throws IOException {
        FileCreateUtils.deleteMetaFile(metaClient, instantTime, ".savepoint.inflight", storage);
        FileCreateUtils.deleteMetaFile(metaClient, instantTime, ".savepoint", storage);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    private static byte[] writeInstantContentToBytes(HoodieInstantWriter writer) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            writer.writeToStream((OutputStream)outputStream);
            outputStream.flush();
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            throw new HoodieIOException("Failed to convert to bytes", ex);
        }
    }
}

