/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.InProcessTimeGenerator;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCreateUtilsBase {
    protected static final Logger LOG = LoggerFactory.getLogger(FileCreateUtilsBase.class);
    protected static final String WRITE_TOKEN = "1-0-1";
    protected static final String BASE_FILE_EXTENSION = ((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).getFileExtension();
    public static final byte[] EMPTY_BYTES = new byte[0];

    public static String baseFileName(String instantTime, String fileId) {
        return FileCreateUtilsBase.baseFileName(instantTime, fileId, BASE_FILE_EXTENSION);
    }

    public static String baseFileName(String instantTime, String fileId, String fileExtension) {
        return FSUtils.makeBaseFileName((String)instantTime, (String)WRITE_TOKEN, (String)fileId, (String)fileExtension);
    }

    public static String logFileName(String instantTime, String fileId, int version) {
        return FileCreateUtilsBase.logFileName(instantTime, fileId, version, HoodieFileFormat.HOODIE_LOG.getFileExtension());
    }

    public static String logFileName(String instantTime, String fileId, int version, String fileExtension) {
        return FSUtils.makeLogFileName((String)fileId, (String)fileExtension, (String)instantTime, (int)version, (String)WRITE_TOKEN);
    }

    public static String markerFileName(String fileName, IOType ioType) {
        return String.format("%s%s.%s", fileName, ".marker", ioType.name());
    }

    public static String markerFileName(String instantTime, String fileId, IOType ioType, String fileExtension) {
        return FileCreateUtilsBase.markerFileName(instantTime, fileId, ioType, fileExtension, WRITE_TOKEN);
    }

    public static String markerFileName(String instantTime, String fileId, IOType ioType, String fileExtension, String writeToken) {
        return String.format("%s_%s_%s%s%s.%s", fileId, writeToken, instantTime, fileExtension, ".marker", ioType);
    }

    public static boolean isBaseOrLogFilename(String filename) {
        for (HoodieFileFormat format : HoodieFileFormat.values()) {
            if (!filename.contains(format.getFileExtension())) continue;
            return true;
        }
        return false;
    }

    public static URI createPartitionMetaFile(String basePath, String partitionPath) throws IOException {
        try {
            Path parentPath = Paths.get(new URI(basePath).getPath(), partitionPath);
            Files.createDirectories(parentPath, new FileAttribute[0]);
            Path metaFilePath = parentPath.resolve(".hoodie_partition_metadata");
            if (Files.notExists(metaFilePath, new LinkOption[0])) {
                Files.createFile(metaFilePath, new FileAttribute[0]);
            }
            return metaFilePath.toUri();
        }
        catch (URISyntaxException e) {
            throw new HoodieException("Error creating partition meta file", (Throwable)e);
        }
    }

    protected static void createMetaFileInMetaPath(StoragePath metaPath, String instantTime, String suffix, HoodieStorage storage, boolean preTableVersion8) throws IOException {
        if (!storage.exists(metaPath)) {
            storage.create(metaPath).close();
        }
        if (suffix.contains(".inflight") || suffix.contains(".requested")) {
            StoragePath metaFilePath = new StoragePath(metaPath, instantTime + suffix);
            if (!storage.exists(metaFilePath)) {
                storage.create(metaFilePath).close();
            }
        } else {
            String instantTimeWithCompletionTime = preTableVersion8 ? instantTime : instantTime + "_" + InProcessTimeGenerator.createNewInstantTime();
            storage.create(new StoragePath(metaPath, instantTimeWithCompletionTime + suffix)).close();
        }
    }

    protected static void removeMetaFileInTimelinePath(String timelinePath, String instantTime, String suffix) throws IOException {
        block17: {
            try {
                Path parentPath = Paths.get(new StoragePath(timelinePath).makeQualified(new URI("file:///")).toUri());
                if (suffix.contains(".inflight") || suffix.contains(".requested")) {
                    Path metaFilePath = parentPath.resolve(instantTime + suffix);
                    if (Files.exists(metaFilePath, new LinkOption[0])) {
                        Files.delete(metaFilePath);
                    }
                    break block17;
                }
                if (!Files.exists(parentPath, new LinkOption[0])) break block17;
                try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(parentPath, instantTime + "*" + suffix);){
                    Iterator<Path> iterator = dirStream.iterator();
                    if (iterator.hasNext()) {
                        Files.delete(iterator.next());
                    }
                }
            }
            catch (Exception ex) {
                throw new HoodieException((Throwable)ex);
            }
        }
    }

    protected static void deleteMetaFileInTimeline(String timelinePath, String instantTime, String suffix, HoodieStorage storage) throws IOException {
        StoragePath parentPath = new StoragePath(timelinePath);
        if (suffix.contains(".inflight") || suffix.contains(".requested")) {
            StoragePath metaFilePath = new StoragePath(parentPath, instantTime + suffix);
            if (storage.exists(metaFilePath)) {
                storage.deleteFile(metaFilePath);
            }
        } else {
            StoragePath metaFilePath = new StoragePath(parentPath, instantTime + "*" + suffix);
            List pathInfoList = storage.globEntries(metaFilePath);
            if (pathInfoList.size() != 0) {
                storage.deleteFile(((StoragePathInfo)pathInfoList.get(0)).getPath());
            }
        }
    }

    public static Map<String, Long> getBaseFileCountsForPaths(String basePath, HoodieStorage storage, String ... paths) {
        HashMap<String, Long> toReturn = new HashMap<String, Long>();
        try {
            HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient(storage.getConf(), basePath);
            for (String path : paths) {
                HoodieTableFileSystemView fileSystemView = new HoodieTableFileSystemView(metaClient, metaClient.getCommitsTimeline().filterCompletedInstants(), storage.globEntries(new StoragePath(path)));
                toReturn.put(path, fileSystemView.getLatestBaseFiles().count());
            }
            return toReturn;
        }
        catch (Exception e) {
            throw new HoodieException("Error reading hoodie table as a dataframe", (Throwable)e);
        }
    }
}

