/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils;

import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.avro.model.HoodieRollbackPlan;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.table.timeline.CommitMetadataSerDe;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.testutils.FileCreateUtilsBase;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.InProcessTimeGenerator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.storage.HoodieInstantWriter;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;

public class FileCreateUtilsLegacy
extends FileCreateUtilsBase {
    public static StoragePath getTimelinePath(StoragePath basePath) throws IOException {
        return new StoragePath(new StoragePath(basePath, ".hoodie"), "timeline");
    }

    private static StoragePath getMetaPath(String basePath) {
        return new StoragePath(basePath, ".hoodie");
    }

    private static void createMetaFile(String basePath, String instantTime, String suffix, HoodieStorage storage) throws IOException {
        FileCreateUtilsLegacy.createMetaFileInMetaPath(FileCreateUtilsLegacy.getMetaPath(basePath), instantTime, suffix, storage, false);
    }

    private static void createMetaFile(String basePath, String instantTime, String suffix) throws IOException {
        FileCreateUtilsLegacy.createMetaFile(basePath, instantTime, suffix, Option.empty());
    }

    private static <T> void createMetaFile(String basePath, String instantTime, String suffix, Option<T> metadata) throws IOException {
        FileCreateUtilsLegacy.createMetaFile(FileCreateUtilsLegacy.getTimelinePath(new StoragePath(basePath)).toUri().getPath(), instantTime, InProcessTimeGenerator::createNewInstantTime, suffix, (Option<HoodieInstantWriter>)metadata.flatMap(arg_0 -> ((CommitMetadataSerDe)HoodieTestUtils.COMMIT_METADATA_SER_DE).getInstantWriter(arg_0)));
    }

    private static void createMetaFile(String basePath, String instantTime, String suffix, HoodieInstantWriter writer) throws IOException {
        FileCreateUtilsLegacy.createMetaFile(FileCreateUtilsLegacy.getTimelinePath(new StoragePath(basePath)).toUri().getPath(), instantTime, InProcessTimeGenerator::createNewInstantTime, suffix, (Option<HoodieInstantWriter>)Option.of((Object)writer));
    }

    public static void createCommit(String basePath, String instantTime) throws IOException {
        FileCreateUtilsLegacy.createMetaFile(basePath, instantTime, ".commit");
    }

    public static void createCommit(CommitMetadataSerDe commitMetadataSerDe, String basePath, String instantTime, Option<HoodieCommitMetadata> metadata) throws IOException {
        FileCreateUtilsLegacy.createCommit(commitMetadataSerDe, basePath, instantTime, (Option<String>)Option.empty(), metadata);
    }

    public static void createCommit(CommitMetadataSerDe commitMetadataSerDe, String basePath, String instantTime, Option<String> completionTime, Option<HoodieCommitMetadata> metadata) throws IOException {
        Supplier<String> completionTimeSupplier = () -> completionTime.isPresent() ? (String)completionTime.get() : InProcessTimeGenerator.createNewInstantTime();
        String timelinePath = FileCreateUtilsLegacy.getTimelinePath(new StoragePath(basePath)).toUri().getPath();
        if (metadata.isPresent()) {
            HoodieCommitMetadata commitMetadata = (HoodieCommitMetadata)metadata.get();
            FileCreateUtilsLegacy.createMetaFile(timelinePath, instantTime, completionTimeSupplier, ".commit", (Option<HoodieInstantWriter>)HoodieTestUtils.COMMIT_METADATA_SER_DE.getInstantWriter((Object)commitMetadata));
        } else {
            FileCreateUtilsLegacy.createMetaFile(timelinePath, instantTime, completionTimeSupplier, ".commit", (Option<HoodieInstantWriter>)Option.empty());
        }
    }

    public static void createCommit(String basePath, String instantTime, HoodieStorage storage) throws IOException {
        FileCreateUtilsLegacy.createMetaFile(basePath, instantTime, ".commit", storage);
    }

    public static void createInflightCommit(String basePath, String instantTime) throws IOException {
        FileCreateUtilsLegacy.createMetaFile(basePath, instantTime, ".inflight");
    }

    public static void createDeltaCommit(CommitMetadataSerDe commitMetadataSerDe, String basePath, String instantTime, HoodieCommitMetadata metadata) throws IOException {
        FileCreateUtilsLegacy.createMetaFile(basePath, instantTime, ".deltacommit", Option.of((Object)metadata));
    }

    public static void createDeltaCommit(String basePath, String instantTime) throws IOException {
        FileCreateUtilsLegacy.createMetaFile(basePath, instantTime, ".deltacommit");
    }

    public static void createDeltaCommit(String basePath, String instantTime, HoodieStorage storage) throws IOException {
        FileCreateUtilsLegacy.createMetaFile(basePath, instantTime, ".deltacommit", storage);
    }

    public static void createDeltaCommit(String basePath, String instantTime, HoodieStorage storage, boolean preTableVersion8) throws IOException {
        FileCreateUtilsLegacy.createMetaFileInMetaPath(FileCreateUtilsLegacy.getMetaPath(basePath), instantTime, ".deltacommit", storage, preTableVersion8);
    }

    public static void createInflightDeltaCommit(String basePath, String instantTime, HoodieStorage storage) throws IOException {
        FileCreateUtilsLegacy.createMetaFile(basePath, instantTime, ".deltacommit.inflight", storage);
    }

    public static void createReplaceCommit(CommitMetadataSerDe commitMetadataSerDe, String basePath, String instantTime, HoodieReplaceCommitMetadata metadata) throws IOException {
        FileCreateUtilsLegacy.createMetaFile(basePath, instantTime, ".replacecommit", Option.of((Object)metadata));
    }

    public static void createRequestedClusterCommit(String basePath, String instantTime, HoodieRequestedReplaceMetadata requestedReplaceMetadata) throws IOException {
        FileCreateUtilsLegacy.createMetaFile(basePath, instantTime, ".clustering.requested", Option.of((Object)requestedReplaceMetadata));
    }

    public static void createRequestedCompactionCommit(String basePath, String instantTime, HoodieCompactionPlan requestedCompactionPlan) throws IOException {
        FileCreateUtilsLegacy.createMetaFile(basePath, instantTime, HoodieTimeline.REQUESTED_COMPACTION_EXTENSION, Option.of((Object)requestedCompactionPlan));
    }

    public static void createRequestedRollbackFile(String basePath, String instantTime, HoodieRollbackPlan plan) throws IOException {
        FileCreateUtilsLegacy.createMetaFile(basePath, instantTime, ".rollback.requested", Option.of((Object)plan));
    }

    public static void createRequestedRollbackFile(String basePath, String instantTime, byte[] content) throws IOException {
        FileCreateUtilsLegacy.createMetaFile(basePath, instantTime, ".rollback.requested", HoodieInstantWriter.convertByteArrayToWriter((byte[])content));
    }

    public static void createInflightCompaction(String basePath, String instantTime) throws IOException {
        FileCreateUtilsLegacy.createMetaFile(basePath, instantTime, HoodieTimeline.INFLIGHT_COMPACTION_EXTENSION);
    }

    public static String createBaseFile(String basePath, String partitionPath, String instantTime, String fileId) throws Exception {
        return FileCreateUtilsLegacy.createBaseFile(basePath, partitionPath, instantTime, fileId, 1L);
    }

    public static String createBaseFile(String basePath, String partitionPath, String instantTime, String fileId, long length) throws Exception {
        return FileCreateUtilsLegacy.createBaseFile(basePath, partitionPath, instantTime, fileId, length, Instant.now().toEpochMilli());
    }

    public static String createBaseFile(String basePath, String partitionPath, String instantTime, String fileId, long length, long lastModificationTimeMilli) throws Exception {
        Path parentPath = Paths.get(basePath, partitionPath);
        Files.createDirectories(parentPath, new FileAttribute[0]);
        Path baseFilePath = parentPath.resolve(FileCreateUtilsLegacy.baseFileName(instantTime, fileId));
        if (Files.notExists(baseFilePath, new LinkOption[0])) {
            Files.createFile(baseFilePath, new FileAttribute[0]);
        }
        try (RandomAccessFile raf = new RandomAccessFile(baseFilePath.toFile(), "rw");){
            raf.setLength(length);
        }
        Files.setLastModifiedTime(baseFilePath, FileTime.fromMillis(lastModificationTimeMilli));
        return baseFilePath.toString();
    }

    public static Path getBaseFilePath(String basePath, String partitionPath, String instantTime, String fileId) {
        Path parentPath = Paths.get(basePath, partitionPath);
        return parentPath.resolve(FileCreateUtilsLegacy.baseFileName(instantTime, fileId));
    }

    public static String createLogFile(String basePath, String partitionPath, String instantTime, String fileId, int version) throws Exception {
        return FileCreateUtilsLegacy.createLogFile(basePath, partitionPath, instantTime, fileId, version, 0);
    }

    public static String createLogFile(String basePath, String partitionPath, String instantTime, String fileId, int version, int length) throws Exception {
        Path parentPath = Paths.get(basePath, partitionPath);
        Files.createDirectories(parentPath, new FileAttribute[0]);
        Path logFilePath = parentPath.resolve(FileCreateUtilsLegacy.logFileName(instantTime, fileId, version));
        if (Files.notExists(logFilePath, new LinkOption[0])) {
            Files.createFile(logFilePath, new FileAttribute[0]);
        }
        RandomAccessFile raf = new RandomAccessFile(logFilePath.toFile(), "rw");
        raf.setLength(length);
        raf.close();
        return logFilePath.toString();
    }

    public static String createMarkerFile(String basePath, String partitionPath, String instantTime, String fileId, IOType ioType) throws IOException {
        if (IOType.APPEND == ioType) {
            String logFileName = FSUtils.makeLogFileName((String)fileId, (String)".log", (String)instantTime, (int)HoodieLogFile.LOGFILE_BASE_VERSION, (String)"1-0-1");
            String markerFileName = FileCreateUtilsLegacy.markerFileName(logFileName, ioType);
            return FileCreateUtilsLegacy.createMarkerFile(basePath, partitionPath, instantTime, markerFileName);
        }
        return FileCreateUtilsLegacy.createMarkerFile(basePath, partitionPath, instantTime, instantTime, fileId, ioType, "1-0-1");
    }

    public static String createMarkerFile(String basePath, String partitionPath, String commitInstant, String instantTime, String fileId, IOType ioType, String writeToken) throws IOException {
        return FileCreateUtilsLegacy.createMarkerFile(basePath, partitionPath, commitInstant, FileCreateUtilsLegacy.markerFileName(instantTime, fileId, ioType, BASE_FILE_EXTENSION, writeToken));
    }

    public static String createMarkerFile(String basePath, String partitionPath, String commitInstant, String markerFileName) throws IOException {
        Path parentPath = Paths.get(basePath, ".hoodie/.temp", commitInstant, partitionPath);
        Files.createDirectories(parentPath, new FileAttribute[0]);
        Path markerFilePath = parentPath.resolve(markerFileName);
        if (Files.notExists(markerFilePath, new LinkOption[0])) {
            Files.createFile(markerFilePath, new FileAttribute[0]);
        }
        return markerFilePath.toAbsolutePath().toString();
    }

    private static void createMetaFile(String timelinePath, String instantTime, Supplier<String> completionTimeSupplier, String suffix, Option<HoodieInstantWriter> writerOption) throws IOException {
        block41: {
            try {
                Path parentPath = Paths.get(new StoragePath(timelinePath).makeQualified(new URI("file:///")).toUri());
                Files.createDirectories(parentPath, new FileAttribute[0]);
                if (suffix.contains(".inflight") || suffix.contains(".requested")) {
                    Path metaFilePath = parentPath.resolve(instantTime + suffix);
                    if (!Files.notExists(metaFilePath, new LinkOption[0])) break block41;
                    if (writerOption.isEmpty()) {
                        Files.createFile(metaFilePath, new FileAttribute[0]);
                        break block41;
                    }
                    try (OutputStream outputStream = Files.newOutputStream(metaFilePath, new OpenOption[0]);){
                        ((HoodieInstantWriter)writerOption.get()).writeToStream(outputStream);
                        break block41;
                    }
                }
                try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(parentPath, instantTime + "*" + suffix);){
                    if (dirStream.iterator().hasNext()) break block41;
                    String instantTimeAndCompletionTime = instantTime + "_" + completionTimeSupplier.get();
                    Path metaFilePath = parentPath.resolve(instantTimeAndCompletionTime + suffix);
                    if (writerOption.isEmpty()) {
                        Files.createFile(metaFilePath, new FileAttribute[0]);
                        break block41;
                    }
                    try (OutputStream outputStream = Files.newOutputStream(metaFilePath, new OpenOption[0]);){
                        ((HoodieInstantWriter)writerOption.get()).writeToStream(outputStream);
                    }
                }
            }
            catch (URISyntaxException ex) {
                throw new HoodieException((Throwable)ex);
            }
        }
    }

    public static void deleteCommit(String basePath, String instantTime) throws IOException {
        FileCreateUtilsLegacy.removeMetaFileInTimelinePath(FileCreateUtilsLegacy.getTimelinePath(new StoragePath(basePath)).toUri().getPath(), instantTime, ".commit");
    }

    public static void deleteDeltaCommit(String basePath, String instantTime) throws IOException {
        FileCreateUtilsLegacy.removeMetaFileInTimelinePath(FileCreateUtilsLegacy.getTimelinePath(new StoragePath(basePath)).toUri().getPath(), instantTime, ".deltacommit");
    }

    public static void deleteReplaceCommit(String basePath, String instantTime) throws IOException {
        FileCreateUtilsLegacy.removeMetaFileInTimelinePath(FileCreateUtilsLegacy.getTimelinePath(new StoragePath(basePath)).toUri().getPath(), instantTime, ".replacecommit");
    }

    public static void deleteRollbackCommit(String basePath, String instantTime) throws IOException {
        FileCreateUtilsLegacy.removeMetaFileInTimelinePath(FileCreateUtilsLegacy.getTimelinePath(new StoragePath(basePath)).toUri().getPath(), instantTime, ".rollback");
    }

    public static Path renameFileToTemp(Path sourcePath, String instantTime) throws IOException {
        Path dummyFilePath = sourcePath.getParent().resolve(instantTime + ".temp");
        Files.move(sourcePath, dummyFilePath, new CopyOption[0]);
        return dummyFilePath;
    }

    public static void renameTempToMetaFile(Path tempFilePath, Path destPath) throws IOException {
        Files.move(tempFilePath, destPath, new CopyOption[0]);
    }

    public static long getTotalMarkerFileCount(String basePath, String partitionPath, String instantTime, IOType ioType) throws IOException {
        Path parentPath = Paths.get(basePath, ".hoodie/.temp", instantTime, partitionPath);
        if (Files.notExists(parentPath, new LinkOption[0])) {
            return 0L;
        }
        return Files.list(parentPath).filter(p -> p.getFileName().toString().endsWith(String.format("%s.%s", ".marker", ioType))).count();
    }

    public static List<Path> getPartitionPaths(Path basePath) throws IOException {
        if (Files.notExists(basePath, new LinkOption[0])) {
            return Collections.emptyList();
        }
        return Files.list(basePath).filter(entry -> !entry.getFileName().toString().equals(".hoodie") && !FileCreateUtilsLegacy.isBaseOrLogFilename(entry.getFileName().toString()) && !entry.getFileName().toString().startsWith(".hoodie_partition_metadata")).collect(Collectors.toList());
    }

    public static boolean isBaseOrLogFilename(String filename) {
        for (HoodieFileFormat format : HoodieFileFormat.values()) {
            if (!filename.contains(format.getFileExtension())) continue;
            return true;
        }
        return false;
    }

    public static void deleteDeltaCommit(String basePath, String instantTime, HoodieStorage storage) throws IOException {
        FileCreateUtilsLegacy.deleteMetaFileInTimeline(FileCreateUtilsLegacy.getTimelinePath(new StoragePath(basePath)).toUri().getPath(), instantTime, ".deltacommit", storage);
    }
}

