/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.AWSDmsAvroPayload;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.model.EmptyHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.MetadataValues;
import org.apache.hudi.common.model.OverwriteNonDefaultsWithLatestAvroPayload;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.model.PartialUpdateAvroPayload;
import org.apache.hudi.common.model.debezium.MySqlDebeziumAvroPayload;
import org.apache.hudi.common.model.debezium.PostgresDebeziumAvroPayload;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;

public class HoodieAdaptablePayloadDataGenerator {
    public static final Schema SCHEMA = SchemaTestUtil.getSchemaFromResource(HoodieAdaptablePayloadDataGenerator.class, "/adaptable-payload.avsc");
    public static final Schema SCHEMA_WITH_METAFIELDS = HoodieAvroUtils.addMetadataFields((Schema)SCHEMA, (boolean)false);
    public static final String SCHEMA_STR = SCHEMA.toString();

    public static Properties getKeyGenProps(Class<?> payloadClass) {
        String orderingField = new RecordGen(payloadClass).getOrderingField();
        Properties props = new Properties();
        props.put("hoodie.datasource.write.recordkey.field", "id");
        props.put("hoodie.datasource.write.partitionpath.field", "pt");
        props.put(HoodieTableConfig.ORDERING_FIELDS.key(), orderingField);
        props.put(HoodieTableConfig.RECORDKEY_FIELDS.key(), "id");
        props.put(HoodieTableConfig.PARTITION_FIELDS.key(), "pt");
        props.put(HoodieTableConfig.ORDERING_FIELDS.key(), orderingField);
        return props;
    }

    public static Properties getPayloadProps(Class<?> payloadClass) {
        String orderingField = new RecordGen(payloadClass).getOrderingField();
        Properties props = new Properties();
        props.put("hoodie.compaction.payload.class", payloadClass.getName());
        props.put("hoodie.payload.event.time.field", orderingField);
        props.put("hoodie.payload.ordering.field", orderingField);
        return props;
    }

    public static List<HoodieRecord> getInserts(int n, String partition, long ts, Class<?> payloadClass) throws IOException {
        return HoodieAdaptablePayloadDataGenerator.getInserts(n, new String[]{partition}, ts, payloadClass);
    }

    public static List<HoodieRecord> getInserts(int n, String[] partitions, long ts, Class<?> payloadClass) throws IOException {
        ArrayList<HoodieRecord> inserts = new ArrayList<HoodieRecord>();
        RecordGen recordGen = new RecordGen(payloadClass);
        for (GenericRecord r : HoodieAdaptablePayloadDataGenerator.getInserts(n, partitions, ts, recordGen)) {
            inserts.add(HoodieAdaptablePayloadDataGenerator.getHoodieRecord(r, recordGen.getPayloadClass()));
        }
        return inserts;
    }

    private static List<GenericRecord> getInserts(int n, String[] partitions, long ts, RecordGen recordGen) {
        return IntStream.range(0, n).mapToObj(id -> {
            String pt = partitions.length == 0 ? "" : partitions[id % partitions.length];
            return HoodieAdaptablePayloadDataGenerator.getInsert(id, pt, ts, recordGen);
        }).collect(Collectors.toList());
    }

    private static GenericRecord getInsert(int id, String pt, long ts, RecordGen recordGen) {
        GenericData.Record r = new GenericData.Record(SCHEMA);
        r.put("id", (Object)id);
        r.put("pt", (Object)pt);
        return recordGen.populateForInsert((GenericRecord)r, ts);
    }

    public static List<HoodieRecord> getUpdates(List<HoodieRecord> baseRecords, long ts, Class<?> payloadClass) throws IOException {
        RecordGen recordGen = new RecordGen(payloadClass);
        ArrayList<HoodieRecord> updates = new ArrayList<HoodieRecord>();
        Properties props = new Properties();
        for (HoodieRecord r : baseRecords) {
            GenericRecord gr = (GenericRecord)((HoodieAvroIndexedRecord)r.toIndexedRecord(SCHEMA, props).get()).getData();
            GenericRecord updated = HoodieAdaptablePayloadDataGenerator.getUpdate(Integer.parseInt(gr.get("id").toString()), gr.get("pt").toString(), ts, recordGen);
            updates.add(HoodieAdaptablePayloadDataGenerator.getHoodieRecord(updated, recordGen.getPayloadClass()));
        }
        return updates;
    }

    public static List<HoodieRecord> getUpdates(List<HoodieRecord> baseRecords, String newPartition, long ts, Class<?> payloadClass) throws IOException {
        RecordGen recordGen = new RecordGen(payloadClass);
        ArrayList<HoodieRecord> updates = new ArrayList<HoodieRecord>();
        Properties props = new Properties();
        for (HoodieRecord r : baseRecords) {
            GenericRecord gr = (GenericRecord)((HoodieAvroIndexedRecord)r.toIndexedRecord(SCHEMA, props).get()).getData();
            GenericRecord updated = HoodieAdaptablePayloadDataGenerator.getUpdate(Integer.parseInt(gr.get("id").toString()), newPartition, ts, recordGen);
            updates.add(HoodieAdaptablePayloadDataGenerator.getHoodieRecord(updated, recordGen.getPayloadClass()));
        }
        return updates;
    }

    private static GenericRecord getUpdate(int id, String pt, long ts, RecordGen recordGen) {
        GenericData.Record r = new GenericData.Record(SCHEMA);
        r.put("id", (Object)id);
        r.put("pt", (Object)pt);
        return recordGen.populateForUpdate((GenericRecord)r, ts);
    }

    public static List<HoodieRecord> getDeletes(List<HoodieRecord> baseRecords, long ts, Class<?> payloadClass) throws IOException {
        RecordGen recordGen = new RecordGen(payloadClass);
        ArrayList<HoodieRecord> deletes = new ArrayList<HoodieRecord>();
        Properties props = new Properties();
        for (HoodieRecord r : baseRecords) {
            GenericRecord gr = (GenericRecord)((HoodieAvroIndexedRecord)r.toIndexedRecord(SCHEMA, props).get()).getData();
            GenericRecord deleted = HoodieAdaptablePayloadDataGenerator.getDelete(Integer.parseInt(gr.get("id").toString()), gr.get("pt").toString(), ts, recordGen);
            deletes.add(HoodieAdaptablePayloadDataGenerator.getHoodieRecord(deleted, recordGen.getPayloadClass()));
        }
        return deletes;
    }

    public static List<HoodieRecord> getDeletesWithNewPartition(List<HoodieRecord> baseRecords, String newPartition, long ts, Class<?> payloadClass) throws IOException {
        RecordGen recordGen = new RecordGen(payloadClass);
        ArrayList<HoodieRecord> deletes = new ArrayList<HoodieRecord>();
        Properties props = new Properties();
        for (HoodieRecord r : baseRecords) {
            GenericRecord gr = (GenericRecord)((HoodieAvroIndexedRecord)r.toIndexedRecord(SCHEMA, props).get()).getData();
            GenericRecord deleted = HoodieAdaptablePayloadDataGenerator.getDelete(Integer.parseInt(gr.get("id").toString()), newPartition, ts, recordGen);
            deletes.add(HoodieAdaptablePayloadDataGenerator.getHoodieRecord(deleted, recordGen.getPayloadClass()));
        }
        return deletes;
    }

    public static List<HoodieRecord> getDeletesWithEmptyPayload(List<HoodieRecord> baseRecords) {
        ArrayList<HoodieRecord> deletes = new ArrayList<HoodieRecord>();
        for (HoodieRecord r : baseRecords) {
            deletes.add(HoodieAdaptablePayloadDataGenerator.getHoodieRecordForEmptyPayload(r.getKey()));
        }
        return deletes;
    }

    public static List<HoodieRecord> getDeletesWithEmptyPayloadAndNewPartition(List<HoodieRecord> baseRecords, String newPartition) {
        ArrayList<HoodieRecord> deletes = new ArrayList<HoodieRecord>();
        for (HoodieRecord r : baseRecords) {
            deletes.add(HoodieAdaptablePayloadDataGenerator.getHoodieRecordForEmptyPayload(new HoodieKey(r.getRecordKey(), newPartition)));
        }
        return deletes;
    }

    private static GenericRecord getDelete(int id, String pt, long ts, RecordGen recordGen) {
        GenericData.Record r = new GenericData.Record(SCHEMA);
        r.put("id", (Object)id);
        r.put("pt", (Object)pt);
        return recordGen.populateForDelete((GenericRecord)r, ts);
    }

    private static HoodieRecord getHoodieRecordForEmptyPayload(HoodieKey key) {
        return new HoodieAvroRecord(key, (HoodieRecordPayload)new EmptyHoodieRecordPayload());
    }

    private static HoodieRecord getHoodieRecord(GenericRecord r, Class<?> payloadClass) throws IOException {
        if (payloadClass == EmptyHoodieRecordPayload.class) {
            return HoodieAdaptablePayloadDataGenerator.getHoodieRecordForEmptyPayload(new HoodieKey(r.get("id").toString(), r.get("pt").toString()));
        }
        return new HoodieAvroIndexedRecord((IndexedRecord)r).prependMetaFields(SCHEMA, SCHEMA_WITH_METAFIELDS, new MetadataValues().setRecordKey(r.get("id").toString()).setPartitionPath(r.get("pt").toString()), new Properties()).wrapIntoHoodieRecordPayloadWithParams(SCHEMA_WITH_METAFIELDS, HoodieAdaptablePayloadDataGenerator.getPayloadProps(payloadClass), Option.empty(), Boolean.valueOf(false), Option.empty(), Boolean.valueOf(false), Option.of((Object)SCHEMA));
    }

    public static class RecordGen {
        public static final Set<Class<?>> SUPPORTED_PAYLOAD_CLASSES = new HashSet<Class>(Arrays.asList(OverwriteWithLatestAvroPayload.class, OverwriteNonDefaultsWithLatestAvroPayload.class, PartialUpdateAvroPayload.class, DefaultHoodieRecordPayload.class, AWSDmsAvroPayload.class, MySqlDebeziumAvroPayload.class, PostgresDebeziumAvroPayload.class));
        private final Class<?> payloadClass;
        private final String orderingField;

        public RecordGen(Class<?> payloadClass) {
            ValidationUtils.checkArgument((boolean)SUPPORTED_PAYLOAD_CLASSES.contains(payloadClass));
            this.payloadClass = payloadClass;
            this.orderingField = payloadClass == MySqlDebeziumAvroPayload.class ? "_event_seq" : (payloadClass == PostgresDebeziumAvroPayload.class ? "_event_lsn" : "ts");
        }

        public Class<?> getPayloadClass() {
            return this.payloadClass;
        }

        public String getOrderingField() {
            return this.orderingField;
        }

        GenericRecord populateForInsert(GenericRecord r, long ts) {
            r.put(this.orderingField, (Object)ts);
            if (this.payloadClass == AWSDmsAvroPayload.class) {
                r.put("Op", (Object)"I");
            }
            return r;
        }

        GenericRecord populateForUpdate(GenericRecord r, long ts) {
            r.put(this.orderingField, (Object)ts);
            if (this.payloadClass == AWSDmsAvroPayload.class) {
                r.put("Op", (Object)"U");
            }
            return r;
        }

        GenericRecord populateForDelete(GenericRecord r, long ts) {
            r.put(this.orderingField, (Object)ts);
            if (this.payloadClass == MySqlDebeziumAvroPayload.class) {
                r.put("_change_operation_type", (Object)"d");
            } else if (this.payloadClass == PostgresDebeziumAvroPayload.class) {
                r.put("_change_operation_type", (Object)"d");
            } else if (this.payloadClass == AWSDmsAvroPayload.class) {
                r.put("Op", (Object)"D");
            } else {
                r.put("_hoodie_is_deleted", (Object)true);
            }
            return r;
        }
    }
}

