/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieEmptyRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieInstantTimeGenerator;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.InProcessTimeGenerator;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.storage.HoodieInstantWriter;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieTestDataGenerator
implements AutoCloseable {
    private boolean makeDatesAmbiguous = false;
    public static final int BYTES_PER_RECORD = 1228;
    public static final int BLOOM_FILTER_BYTES = 323495;
    private static Logger logger = LoggerFactory.getLogger(HoodieTestDataGenerator.class);
    public static final String NO_PARTITION_PATH = "";
    public static final String DEFAULT_FIRST_PARTITION_PATH = "2016/03/15";
    public static final String DEFAULT_SECOND_PARTITION_PATH = "2015/03/16";
    public static final String DEFAULT_THIRD_PARTITION_PATH = "2015/03/17";
    public static final String[] OPERATIONS = new String[]{"i", "u", "d"};
    public static final String[] DEFAULT_PARTITION_PATHS = new String[]{"2016/03/15", "2015/03/16", "2015/03/17"};
    public static final int DEFAULT_PARTITION_DEPTH = 3;
    public static final String TRIP_TYPE_ENUM_TYPE = "{\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}";
    public static final Schema TRIP_TYPE_ENUM_SCHEMA = new Schema.Parser().parse("{\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}");
    public static final String TRIP_SCHEMA_PREFIX = "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},";
    public static final String HOODIE_IS_DELETED_SCHEMA = "{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false}";
    public static final String TRIP_SCHEMA_SUFFIX = "{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}";
    public static final String FARE_NESTED_SCHEMA = "{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},";
    public static final String FARE_FLATTENED_SCHEMA = "{\"name\": \"fare\", \"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"},";
    public static final String TIP_NESTED_SCHEMA = "{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},";
    public static final String MAP_TYPE_SCHEMA = "{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},";
    public static final String EXTRA_TYPE_SCHEMA = "{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},";
    public static final String EXTENDED_LOGICAL_TYPES_SCHEMA_V6 = "{\"name\":\"ts_millis\",\"type\":{\"type\":\"long\",\"logicalType\":\"timestamp-millis\"}},{\"name\":\"ts_micros\",\"type\":{\"type\":\"long\",\"logicalType\":\"timestamp-micros\"}},{\"name\":\"local_ts_millis\",\"type\":{\"type\":\"long\",\"logicalType\":\"local-timestamp-millis\"}},{\"name\":\"local_ts_micros\",\"type\":{\"type\":\"long\",\"logicalType\":\"local-timestamp-micros\"}},{\"name\":\"event_date\",\"type\":{\"type\":\"int\",\"logicalType\":\"date\"}},{\"name\":\"dec_fixed_small\",\"type\":{\"type\":\"fixed\",\"name\":\"decFixedSmall\",\"size\":3,\"logicalType\":\"decimal\",\"precision\":5,\"scale\":2}},{\"name\":\"dec_fixed_large\",\"type\":{\"type\":\"fixed\",\"name\":\"decFixedLarge\",\"size\":8,\"logicalType\":\"decimal\",\"precision\":18,\"scale\":9}},";
    public static final String EXTENDED_LOGICAL_TYPES_SCHEMA = "{\"name\":\"ts_millis\",\"type\":{\"type\":\"long\",\"logicalType\":\"timestamp-millis\"}},{\"name\":\"ts_micros\",\"type\":{\"type\":\"long\",\"logicalType\":\"timestamp-micros\"}},{\"name\":\"local_ts_millis\",\"type\":{\"type\":\"long\",\"logicalType\":\"local-timestamp-millis\"}},{\"name\":\"local_ts_micros\",\"type\":{\"type\":\"long\",\"logicalType\":\"local-timestamp-micros\"}},{\"name\":\"event_date\",\"type\":{\"type\":\"int\",\"logicalType\":\"date\"}},{\"name\":\"dec_plain_large\",\"type\":{\"type\":\"bytes\",\"logicalType\":\"decimal\",\"precision\":20,\"scale\":10}},{\"name\":\"dec_fixed_small\",\"type\":{\"type\":\"fixed\",\"name\":\"decFixedSmall\",\"size\":3,\"logicalType\":\"decimal\",\"precision\":5,\"scale\":2}},{\"name\":\"dec_fixed_large\",\"type\":{\"type\":\"fixed\",\"name\":\"decFixedLarge\",\"size\":8,\"logicalType\":\"decimal\",\"precision\":18,\"scale\":9}},";
    public static final String EXTENDED_LOGICAL_TYPES_SCHEMA_NO_LTS = "{\"name\":\"ts_millis\",\"type\":{\"type\":\"long\",\"logicalType\":\"timestamp-millis\"}},{\"name\":\"ts_micros\",\"type\":{\"type\":\"long\",\"logicalType\":\"timestamp-micros\"}},{\"name\":\"event_date\",\"type\":{\"type\":\"int\",\"logicalType\":\"date\"}},{\"name\":\"dec_plain_large\",\"type\":{\"type\":\"bytes\",\"logicalType\":\"decimal\",\"precision\":20,\"scale\":10}},{\"name\":\"dec_fixed_small\",\"type\":{\"type\":\"fixed\",\"name\":\"decFixedSmall\",\"size\":3,\"logicalType\":\"decimal\",\"precision\":5,\"scale\":2}},{\"name\":\"dec_fixed_large\",\"type\":{\"type\":\"fixed\",\"name\":\"decFixedLarge\",\"size\":8,\"logicalType\":\"decimal\",\"precision\":18,\"scale\":9}},";
    public static final String EXTENDED_LOGICAL_TYPES_SCHEMA_NO_LTS_V6 = "{\"name\":\"ts_millis\",\"type\":{\"type\":\"long\",\"logicalType\":\"timestamp-millis\"}},{\"name\":\"ts_micros\",\"type\":{\"type\":\"long\",\"logicalType\":\"timestamp-micros\"}},{\"name\":\"event_date\",\"type\":{\"type\":\"int\",\"logicalType\":\"date\"}},{\"name\":\"dec_fixed_small\",\"type\":{\"type\":\"fixed\",\"name\":\"decFixedSmall\",\"size\":3,\"logicalType\":\"decimal\",\"precision\":5,\"scale\":2}},{\"name\":\"dec_fixed_large\",\"type\":{\"type\":\"fixed\",\"name\":\"decFixedLarge\",\"size\":8,\"logicalType\":\"decimal\",\"precision\":18,\"scale\":9}},";
    public static final String EXTRA_COL_SCHEMA1 = "{\"name\": \"extra_column1\", \"type\": [\"null\", \"string\"], \"default\": null },";
    public static final String EXTRA_COL_SCHEMA2 = "{\"name\": \"extra_column2\", \"type\": [\"null\", \"string\"], \"default\": null},";
    public static final String EXTRA_COL_SCHEMA_FOR_AWS_DMS_PAYLOAD = "{\"name\": \"Op\", \"type\": [\"null\", \"string\"], \"default\": null},";
    public static final String EXTRA_COL_SCHEMA_FOR_POSTGRES_PAYLOAD = "{\"name\": \"_event_lsn\", \"type\": [\"null\", \"long\"], \"default\": null},";
    public static final String TRIP_EXAMPLE_SCHEMA_WITH_PAYLOAD_SPECIFIC_COLS = "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"Op\", \"type\": [\"null\", \"string\"], \"default\": null},{\"name\": \"_event_lsn\", \"type\": [\"null\", \"long\"], \"default\": null},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}";
    public static final String TRIP_EXAMPLE_SCHEMA = "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}";
    public static final String TRIP_EXAMPLE_SCHEMA_EVOLVED_1 = "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"extra_column1\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}";
    public static final String TRIP_EXAMPLE_SCHEMA_EVOLVED_2 = "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"extra_column2\", \"type\": [\"null\", \"string\"], \"default\": null},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}";
    public static final String TRIP_FLATTENED_SCHEMA = "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"fare\", \"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}";
    public static final String TRIP_LOGICAL_TYPES_SCHEMA_V6 = "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\":\"ts_millis\",\"type\":{\"type\":\"long\",\"logicalType\":\"timestamp-millis\"}},{\"name\":\"ts_micros\",\"type\":{\"type\":\"long\",\"logicalType\":\"timestamp-micros\"}},{\"name\":\"local_ts_millis\",\"type\":{\"type\":\"long\",\"logicalType\":\"local-timestamp-millis\"}},{\"name\":\"local_ts_micros\",\"type\":{\"type\":\"long\",\"logicalType\":\"local-timestamp-micros\"}},{\"name\":\"event_date\",\"type\":{\"type\":\"int\",\"logicalType\":\"date\"}},{\"name\":\"dec_fixed_small\",\"type\":{\"type\":\"fixed\",\"name\":\"decFixedSmall\",\"size\":3,\"logicalType\":\"decimal\",\"precision\":5,\"scale\":2}},{\"name\":\"dec_fixed_large\",\"type\":{\"type\":\"fixed\",\"name\":\"decFixedLarge\",\"size\":8,\"logicalType\":\"decimal\",\"precision\":18,\"scale\":9}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}";
    public static final String TRIP_LOGICAL_TYPES_SCHEMA = "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\":\"ts_millis\",\"type\":{\"type\":\"long\",\"logicalType\":\"timestamp-millis\"}},{\"name\":\"ts_micros\",\"type\":{\"type\":\"long\",\"logicalType\":\"timestamp-micros\"}},{\"name\":\"local_ts_millis\",\"type\":{\"type\":\"long\",\"logicalType\":\"local-timestamp-millis\"}},{\"name\":\"local_ts_micros\",\"type\":{\"type\":\"long\",\"logicalType\":\"local-timestamp-micros\"}},{\"name\":\"event_date\",\"type\":{\"type\":\"int\",\"logicalType\":\"date\"}},{\"name\":\"dec_plain_large\",\"type\":{\"type\":\"bytes\",\"logicalType\":\"decimal\",\"precision\":20,\"scale\":10}},{\"name\":\"dec_fixed_small\",\"type\":{\"type\":\"fixed\",\"name\":\"decFixedSmall\",\"size\":3,\"logicalType\":\"decimal\",\"precision\":5,\"scale\":2}},{\"name\":\"dec_fixed_large\",\"type\":{\"type\":\"fixed\",\"name\":\"decFixedLarge\",\"size\":8,\"logicalType\":\"decimal\",\"precision\":18,\"scale\":9}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}";
    public static final String TRIP_LOGICAL_TYPES_SCHEMA_NO_LTS = "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\":\"ts_millis\",\"type\":{\"type\":\"long\",\"logicalType\":\"timestamp-millis\"}},{\"name\":\"ts_micros\",\"type\":{\"type\":\"long\",\"logicalType\":\"timestamp-micros\"}},{\"name\":\"event_date\",\"type\":{\"type\":\"int\",\"logicalType\":\"date\"}},{\"name\":\"dec_plain_large\",\"type\":{\"type\":\"bytes\",\"logicalType\":\"decimal\",\"precision\":20,\"scale\":10}},{\"name\":\"dec_fixed_small\",\"type\":{\"type\":\"fixed\",\"name\":\"decFixedSmall\",\"size\":3,\"logicalType\":\"decimal\",\"precision\":5,\"scale\":2}},{\"name\":\"dec_fixed_large\",\"type\":{\"type\":\"fixed\",\"name\":\"decFixedLarge\",\"size\":8,\"logicalType\":\"decimal\",\"precision\":18,\"scale\":9}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}";
    public static final String TRIP_LOGICAL_TYPES_SCHEMA_NO_LTS_V6 = "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\":\"ts_millis\",\"type\":{\"type\":\"long\",\"logicalType\":\"timestamp-millis\"}},{\"name\":\"ts_micros\",\"type\":{\"type\":\"long\",\"logicalType\":\"timestamp-micros\"}},{\"name\":\"event_date\",\"type\":{\"type\":\"int\",\"logicalType\":\"date\"}},{\"name\":\"dec_fixed_small\",\"type\":{\"type\":\"fixed\",\"name\":\"decFixedSmall\",\"size\":3,\"logicalType\":\"decimal\",\"precision\":5,\"scale\":2}},{\"name\":\"dec_fixed_large\",\"type\":{\"type\":\"fixed\",\"name\":\"decFixedLarge\",\"size\":8,\"logicalType\":\"decimal\",\"precision\":18,\"scale\":9}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}";
    public static final String TRIP_NESTED_EXAMPLE_SCHEMA = "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}";
    public static final String TRIP_ENCODED_DECIMAL_SCHEMA = "{\"type\":\"record\",\"name\":\"tripUberRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"decfield\",\"type\":{\"type\":\"bytes\",\"name\":\"abc\",\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\":\"lowprecision\",\"type\":{\"type\":\"bytes\",\"name\":\"def\",\"logicalType\":\"decimal\",\"precision\":4,\"scale\":2}},{\"name\":\"highprecision\",\"type\":{\"type\":\"bytes\",\"name\":\"ghi\",\"logicalType\":\"decimal\",\"precision\":32,\"scale\":12}},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false}]}";
    public static final String TRIP_SCHEMA = "{\"type\":\"record\",\"name\":\"tripUberRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false}]}";
    public static final String SHORT_TRIP_SCHEMA = "{\"type\":\"record\",\"name\":\"shortTripRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false}]}";
    public static final String NULL_SCHEMA = Schema.create((Schema.Type)Schema.Type.NULL).toString();
    public static final String TRIP_HIVE_COLUMN_TYPES = "bigint,string,string,string,string,string,double,double,double,double,int,bigint,float,binary,int,bigint,decimal(10,6),map<string,string>,struct<amount:double,currency:string>,array<struct<amount:double,currency:string>>,boolean";
    public static final Schema AVRO_SCHEMA = new Schema.Parser().parse("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}");
    public static final Schema AVRO_SCHEMA_WITH_SPECIFIC_COLUMNS = new Schema.Parser().parse("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"Op\", \"type\": [\"null\", \"string\"], \"default\": null},{\"name\": \"_event_lsn\", \"type\": [\"null\", \"long\"], \"default\": null},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}");
    public static final Schema NESTED_AVRO_SCHEMA = new Schema.Parser().parse("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}");
    public static final Schema AVRO_SCHEMA_WITH_METADATA_FIELDS = HoodieAvroUtils.addMetadataFields((Schema)AVRO_SCHEMA);
    public static final Schema AVRO_SHORT_TRIP_SCHEMA = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"shortTripRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false}]}");
    public static final Schema AVRO_TRIP_ENCODED_DECIMAL_SCHEMA = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"tripUberRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"decfield\",\"type\":{\"type\":\"bytes\",\"name\":\"abc\",\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\":\"lowprecision\",\"type\":{\"type\":\"bytes\",\"name\":\"def\",\"logicalType\":\"decimal\",\"precision\":4,\"scale\":2}},{\"name\":\"highprecision\",\"type\":{\"type\":\"bytes\",\"name\":\"ghi\",\"logicalType\":\"decimal\",\"precision\":32,\"scale\":12}},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false}]}");
    public static final Schema AVRO_TRIP_LOGICAL_TYPES_SCHEMA = new Schema.Parser().parse("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\":\"ts_millis\",\"type\":{\"type\":\"long\",\"logicalType\":\"timestamp-millis\"}},{\"name\":\"ts_micros\",\"type\":{\"type\":\"long\",\"logicalType\":\"timestamp-micros\"}},{\"name\":\"local_ts_millis\",\"type\":{\"type\":\"long\",\"logicalType\":\"local-timestamp-millis\"}},{\"name\":\"local_ts_micros\",\"type\":{\"type\":\"long\",\"logicalType\":\"local-timestamp-micros\"}},{\"name\":\"event_date\",\"type\":{\"type\":\"int\",\"logicalType\":\"date\"}},{\"name\":\"dec_plain_large\",\"type\":{\"type\":\"bytes\",\"logicalType\":\"decimal\",\"precision\":20,\"scale\":10}},{\"name\":\"dec_fixed_small\",\"type\":{\"type\":\"fixed\",\"name\":\"decFixedSmall\",\"size\":3,\"logicalType\":\"decimal\",\"precision\":5,\"scale\":2}},{\"name\":\"dec_fixed_large\",\"type\":{\"type\":\"fixed\",\"name\":\"decFixedLarge\",\"size\":8,\"logicalType\":\"decimal\",\"precision\":18,\"scale\":9}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}");
    public static final Schema AVRO_TRIP_LOGICAL_TYPES_SCHEMA_V6 = new Schema.Parser().parse("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\":\"ts_millis\",\"type\":{\"type\":\"long\",\"logicalType\":\"timestamp-millis\"}},{\"name\":\"ts_micros\",\"type\":{\"type\":\"long\",\"logicalType\":\"timestamp-micros\"}},{\"name\":\"local_ts_millis\",\"type\":{\"type\":\"long\",\"logicalType\":\"local-timestamp-millis\"}},{\"name\":\"local_ts_micros\",\"type\":{\"type\":\"long\",\"logicalType\":\"local-timestamp-micros\"}},{\"name\":\"event_date\",\"type\":{\"type\":\"int\",\"logicalType\":\"date\"}},{\"name\":\"dec_fixed_small\",\"type\":{\"type\":\"fixed\",\"name\":\"decFixedSmall\",\"size\":3,\"logicalType\":\"decimal\",\"precision\":5,\"scale\":2}},{\"name\":\"dec_fixed_large\",\"type\":{\"type\":\"fixed\",\"name\":\"decFixedLarge\",\"size\":8,\"logicalType\":\"decimal\",\"precision\":18,\"scale\":9}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}");
    public static final Schema AVRO_TRIP_LOGICAL_TYPES_SCHEMA_NO_LTS = new Schema.Parser().parse("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\":\"ts_millis\",\"type\":{\"type\":\"long\",\"logicalType\":\"timestamp-millis\"}},{\"name\":\"ts_micros\",\"type\":{\"type\":\"long\",\"logicalType\":\"timestamp-micros\"}},{\"name\":\"event_date\",\"type\":{\"type\":\"int\",\"logicalType\":\"date\"}},{\"name\":\"dec_plain_large\",\"type\":{\"type\":\"bytes\",\"logicalType\":\"decimal\",\"precision\":20,\"scale\":10}},{\"name\":\"dec_fixed_small\",\"type\":{\"type\":\"fixed\",\"name\":\"decFixedSmall\",\"size\":3,\"logicalType\":\"decimal\",\"precision\":5,\"scale\":2}},{\"name\":\"dec_fixed_large\",\"type\":{\"type\":\"fixed\",\"name\":\"decFixedLarge\",\"size\":8,\"logicalType\":\"decimal\",\"precision\":18,\"scale\":9}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}");
    public static final Schema AVRO_TRIP_LOGICAL_TYPES_SCHEMA_NO_LTS_V6 = new Schema.Parser().parse("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\":\"ts_millis\",\"type\":{\"type\":\"long\",\"logicalType\":\"timestamp-millis\"}},{\"name\":\"ts_micros\",\"type\":{\"type\":\"long\",\"logicalType\":\"timestamp-micros\"}},{\"name\":\"event_date\",\"type\":{\"type\":\"int\",\"logicalType\":\"date\"}},{\"name\":\"dec_fixed_small\",\"type\":{\"type\":\"fixed\",\"name\":\"decFixedSmall\",\"size\":3,\"logicalType\":\"decimal\",\"precision\":5,\"scale\":2}},{\"name\":\"dec_fixed_large\",\"type\":{\"type\":\"fixed\",\"name\":\"decFixedLarge\",\"size\":8,\"logicalType\":\"decimal\",\"precision\":18,\"scale\":9}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}");
    public static final Schema AVRO_TRIP_SCHEMA = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"tripUberRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false}]}");
    public static final Schema FLATTENED_AVRO_SCHEMA = new Schema.Parser().parse("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"fare\", \"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}");
    private final Random rand;
    private final Map<String, Map<Integer, KeyPartition>> existingKeysBySchema;
    private final String[] partitionPaths;
    private Map<String, Integer> numKeysBySchema;
    private Option<Schema> extendedSchema = Option.empty();

    public HoodieTestDataGenerator(long seed) {
        this(seed, DEFAULT_PARTITION_PATHS, new HashMap<Integer, KeyPartition>());
    }

    public HoodieTestDataGenerator(String schema, long seed) {
        this(schema, seed, DEFAULT_PARTITION_PATHS, new HashMap<Integer, KeyPartition>());
    }

    public HoodieTestDataGenerator(long seed, String[] partitionPaths, Map<Integer, KeyPartition> keyPartitionMap) {
        this(TRIP_EXAMPLE_SCHEMA, seed, partitionPaths, keyPartitionMap);
    }

    public HoodieTestDataGenerator(String schema, long seed, String[] partitionPaths, Map<Integer, KeyPartition> keyPartitionMap) {
        this.rand = new Random(seed);
        this.partitionPaths = Arrays.copyOf(partitionPaths, partitionPaths.length);
        this.existingKeysBySchema = new HashMap<String, Map<Integer, KeyPartition>>();
        this.existingKeysBySchema.put(schema, keyPartitionMap);
        this.numKeysBySchema = new HashMap<String, Integer>();
        this.numKeysBySchema.put(schema, keyPartitionMap.size());
        logger.info(String.format("Test DataGenerator's seed (%s)", seed));
    }

    @Deprecated
    public HoodieTestDataGenerator(String[] partitionPaths) {
        this(partitionPaths, new HashMap<Integer, KeyPartition>());
    }

    @Deprecated
    public HoodieTestDataGenerator() {
        this(DEFAULT_PARTITION_PATHS);
    }

    public static HoodieTestDataGenerator createTestGeneratorFirstPartition() {
        return new HoodieTestDataGenerator(new String[]{DEFAULT_FIRST_PARTITION_PATH});
    }

    public static HoodieTestDataGenerator createTestGeneratorSecondPartition() {
        return new HoodieTestDataGenerator(new String[]{DEFAULT_SECOND_PARTITION_PATH});
    }

    public static HoodieTestDataGenerator createTestGeneratorThirdPartition() {
        return new HoodieTestDataGenerator(new String[]{DEFAULT_THIRD_PARTITION_PATH});
    }

    public HoodieTestDataGenerator(boolean makeDatesAmbiguous) {
        this();
        this.makeDatesAmbiguous = makeDatesAmbiguous;
    }

    @Deprecated
    public HoodieTestDataGenerator(String[] partitionPaths, Map<Integer, KeyPartition> keyPartitionMap) {
        this(System.nanoTime(), partitionPaths, keyPartitionMap);
    }

    public static Long getNextCommitTime(long curCommitTime) {
        if ((curCommitTime + 1L) % 1000000000000L >= 60L) {
            return Long.parseLong(InProcessTimeGenerator.createNewInstantTime());
        }
        return curCommitTime + 1L;
    }

    public static String getCommitTimeAtUTC(long epochSecond) {
        return HoodieInstantTimeGenerator.getInstantFromTemporalAccessor((TemporalAccessor)Instant.ofEpochSecond(epochSecond).atZone(ZoneOffset.UTC));
    }

    public static void writePartitionMetadataDeprecated(HoodieStorage storage, String[] partitionPaths, String basePath) {
        new HoodieTestDataGenerator().writePartitionMetadata(storage, partitionPaths, basePath);
    }

    public void writePartitionMetadata(HoodieStorage storage, String[] partitionPaths, String basePath) {
        for (String partitionPath : partitionPaths) {
            new HoodiePartitionMetadata(storage, "000", new StoragePath(basePath), new StoragePath(basePath, partitionPath), Option.empty()).trySave();
        }
    }

    public int getEstimatedFileSizeInBytes(int numOfRecords) {
        return numOfRecords * 1228 + 323495;
    }

    public IndexedRecord generateRandomValueAsPerSchema(String schemaStr, HoodieKey key, String commitTime, boolean isFlattened, long timestamp) throws IOException {
        return this.generateRandomValueAsPerSchema(schemaStr, key, commitTime, isFlattened, false, timestamp);
    }

    public IndexedRecord generateRandomValueAsPerSchema(String schemaStr, HoodieKey key, String commitTime, boolean isFlattened, boolean isDelete, long timestamp) throws IOException {
        if (!isDelete) {
            if (TRIP_FLATTENED_SCHEMA.equals(schemaStr)) {
                return this.generateRandomValue(key, commitTime, true, timestamp);
            }
            if (TRIP_EXAMPLE_SCHEMA.equals(schemaStr)) {
                return this.generateRandomValue(key, commitTime, isFlattened, timestamp);
            }
            if (TRIP_ENCODED_DECIMAL_SCHEMA.equals(schemaStr)) {
                return this.generatePayloadForTripEncodedDecimalSchema(key, commitTime, timestamp);
            }
            if (TRIP_SCHEMA.equals(schemaStr)) {
                return this.generatePayloadForTripSchema(key, commitTime, timestamp);
            }
            if (SHORT_TRIP_SCHEMA.equals(schemaStr)) {
                return this.generatePayloadForShortTripSchema(key, commitTime, timestamp);
            }
            if (TRIP_NESTED_EXAMPLE_SCHEMA.equals(schemaStr)) {
                return this.generateNestedExampleRandomValue(key, commitTime, timestamp);
            }
            if (TRIP_EXAMPLE_SCHEMA_WITH_PAYLOAD_SPECIFIC_COLS.equals(schemaStr)) {
                return this.generateRandomValueWithColumnRequired(key, commitTime);
            }
            if (TRIP_LOGICAL_TYPES_SCHEMA.equals(schemaStr)) {
                return this.generatePayloadForLogicalTypesSchema(key, commitTime, false, timestamp);
            }
            if (TRIP_LOGICAL_TYPES_SCHEMA_V6.equals(schemaStr)) {
                return this.generatePayloadForLogicalTypesSchemaV6(key, commitTime, false, timestamp);
            }
            if (TRIP_LOGICAL_TYPES_SCHEMA_NO_LTS.equals(schemaStr)) {
                return this.generatePayloadForLogicalTypesSchemaNoLTS(key, commitTime, false, timestamp);
            }
            if (TRIP_LOGICAL_TYPES_SCHEMA_NO_LTS_V6.equals(schemaStr)) {
                return this.generatePayloadForLogicalTypesSchemaNoLTSV6(key, commitTime, false, timestamp);
            }
        } else {
            if (TRIP_EXAMPLE_SCHEMA.equals(schemaStr)) {
                return this.generateRandomDeleteValue(key, commitTime, timestamp);
            }
            if (TRIP_LOGICAL_TYPES_SCHEMA.equals(schemaStr)) {
                return this.generatePayloadForLogicalTypesSchema(key, commitTime, true, timestamp);
            }
            if (TRIP_LOGICAL_TYPES_SCHEMA_V6.equals(schemaStr)) {
                return this.generatePayloadForLogicalTypesSchemaV6(key, commitTime, true, timestamp);
            }
            if (TRIP_LOGICAL_TYPES_SCHEMA_NO_LTS.equals(schemaStr)) {
                return this.generatePayloadForLogicalTypesSchemaNoLTS(key, commitTime, true, timestamp);
            }
            if (TRIP_LOGICAL_TYPES_SCHEMA_NO_LTS_V6.equals(schemaStr)) {
                return this.generatePayloadForLogicalTypesSchemaNoLTSV6(key, commitTime, true, timestamp);
            }
        }
        return null;
    }

    public IndexedRecord generateRandomValue(HoodieKey key, String instantTime) {
        return this.generateRandomValue(key, instantTime, false);
    }

    private IndexedRecord generateRandomValue(HoodieKey key, String instantTime, boolean isFlattened) {
        return this.generateRandomValue(key, instantTime, isFlattened, System.currentTimeMillis());
    }

    private IndexedRecord generateNestedExampleRandomValue(HoodieKey key, String instantTime) {
        return this.generateNestedExampleRandomValue(key, instantTime, System.currentTimeMillis());
    }

    private IndexedRecord generateRandomValue(HoodieKey key, String instantTime, boolean isFlattened, long timestamp) {
        return this.generateGenericRecord(key.getRecordKey(), key.getPartitionPath(), "rider-" + instantTime, "driver-" + instantTime, timestamp, false, isFlattened);
    }

    private IndexedRecord generateNestedExampleRandomValue(HoodieKey key, String instantTime, long ts) {
        return this.generateNestedExampleGenericRecord(key.getRecordKey(), key.getPartitionPath(), "rider-" + instantTime, "driver-" + instantTime, ts, false);
    }

    public IndexedRecord generatePayloadForTripEncodedDecimalSchema(HoodieKey key, String commitTime, long timestamp) {
        return this.generateRecordForTripEncodedDecimalSchema(key.getRecordKey(), "rider-" + commitTime, "driver-" + commitTime, timestamp);
    }

    public IndexedRecord generatePayloadForLogicalTypesSchemaNoLTS(HoodieKey key, String commitTime, boolean isDelete, long timestamp) {
        return this.generateRecordForTripLogicalTypesSchema(key, "rider-" + commitTime, "driver-" + commitTime, timestamp, isDelete, false, false);
    }

    public IndexedRecord generatePayloadForLogicalTypesSchemaNoLTSV6(HoodieKey key, String commitTime, boolean isDelete, long timestamp) {
        return this.generateRecordForTripLogicalTypesSchema(key, "rider-" + commitTime, "driver-" + commitTime, timestamp, isDelete, true, false);
    }

    public IndexedRecord generatePayloadForLogicalTypesSchema(HoodieKey key, String commitTime, boolean isDelete, long timestamp) {
        return this.generateRecordForTripLogicalTypesSchema(key, "rider-" + commitTime, "driver-" + commitTime, timestamp, isDelete, false, true);
    }

    public IndexedRecord generatePayloadForLogicalTypesSchemaV6(HoodieKey key, String commitTime, boolean isDelete, long timestamp) {
        return this.generateRecordForTripLogicalTypesSchema(key, "rider-" + commitTime, "driver-" + commitTime, timestamp, isDelete, true, true);
    }

    public IndexedRecord generatePayloadForTripSchema(HoodieKey key, String commitTime, long timestamp) {
        return this.generateRecordForTripSchema(key.getRecordKey(), "rider-" + commitTime, "driver-" + commitTime, timestamp);
    }

    public IndexedRecord generatePayloadForShortTripSchema(HoodieKey key, String commitTime, long timestamp) {
        return this.generateRecordForShortTripSchema(key.getRecordKey(), "rider-" + commitTime, "driver-" + commitTime, timestamp);
    }

    private IndexedRecord generateRandomDeleteValue(HoodieKey key, String instantTime, long timestamp) throws IOException {
        return this.generateGenericRecord(key.getRecordKey(), key.getPartitionPath(), "rider-" + instantTime, "driver-" + instantTime, timestamp, true, false);
    }

    private IndexedRecord generateAvroPayload(HoodieKey key, String instantTime, long timestamp) {
        return this.generateGenericRecord(key.getRecordKey(), key.getPartitionPath(), "rider-" + instantTime, "driver-" + instantTime, timestamp);
    }

    public GenericRecord generateGenericRecord(String rowKey, String partitionPath, String riderName, String driverName, long timestamp) {
        return this.generateGenericRecord(rowKey, partitionPath, riderName, driverName, timestamp, false, false);
    }

    private void generateTripPrefixValues(GenericRecord rec, String rowKey, String partitionPath, String riderName, String driverName, long timestamp) {
        rec.put("_row_key", (Object)rowKey);
        rec.put("timestamp", (Object)timestamp);
        rec.put("partition_path", (Object)partitionPath);
        rec.put("trip_type", (Object)new GenericData.EnumSymbol(TRIP_TYPE_ENUM_SCHEMA, this.rand.nextInt(2) == 0 ? "UBERX" : "BLACK"));
        rec.put("rider", (Object)riderName);
        rec.put("driver", (Object)driverName);
        rec.put("begin_lat", (Object)this.rand.nextDouble());
        rec.put("begin_lon", (Object)this.rand.nextDouble());
        rec.put("end_lat", (Object)this.rand.nextDouble());
        rec.put("end_lon", (Object)this.rand.nextDouble());
    }

    private void generateFareFlattenedValues(GenericRecord rec) {
        rec.put("fare", (Object)(this.rand.nextDouble() * 100.0));
        rec.put("currency", (Object)"USD");
    }

    private void generateExtraSchemaValues(GenericRecord rec) {
        rec.put("distance_in_meters", (Object)this.rand.nextInt());
        rec.put("seconds_since_epoch", (Object)this.rand.nextLong());
        rec.put("weight", (Object)Float.valueOf(this.rand.nextFloat()));
        byte[] bytes = StringUtils.getUTF8Bytes((String)"Canada");
        rec.put("nation", (Object)ByteBuffer.wrap(bytes));
        long randomMillis = HoodieTestDataGenerator.genRandomTimeMillis(this.rand);
        Instant instant = Instant.ofEpochMilli(randomMillis);
        rec.put("current_date", (Object)(this.makeDatesAmbiguous ? -1000000 : (int)LocalDateTime.ofInstant(instant, ZoneOffset.UTC).toLocalDate().toEpochDay()));
        rec.put("current_ts", (Object)randomMillis);
        BigDecimal bigDecimal = new BigDecimal(String.format(Locale.ENGLISH, "%5f", Float.valueOf(this.rand.nextFloat())));
        Schema decimalSchema = AVRO_SCHEMA.getField("height").schema();
        Conversions.DecimalConversion decimalConversions = new Conversions.DecimalConversion();
        GenericFixed genericFixed = decimalConversions.toFixed(bigDecimal, decimalSchema, (LogicalType)LogicalTypes.decimal((int)10, (int)6));
        rec.put("height", (Object)genericFixed);
    }

    private void generateMapTypeValues(GenericRecord rec) {
        rec.put("city_to_state", Collections.singletonMap("LA", "CA"));
    }

    private void generateFareNestedValues(GenericRecord rec) {
        GenericData.Record fareRecord = new GenericData.Record(((Schema)this.extendedSchema.orElse((Object)AVRO_SCHEMA)).getField("fare").schema());
        fareRecord.put("amount", (Object)(this.rand.nextDouble() * 100.0));
        fareRecord.put("currency", (Object)"USD");
        if (this.extendedSchema.isPresent()) {
            this.generateCustomValues((GenericRecord)fareRecord, "customFare");
        }
        rec.put("fare", (Object)fareRecord);
    }

    private void generateOpColumnValue(GenericRecord rec) {
        int index = this.rand.nextInt(2);
        rec.put("Op", (Object)OPERATIONS[index]);
    }

    private void generateEventLSNValue(GenericRecord rec) {
        rec.put("_event_lsn", (Object)this.rand.nextLong());
    }

    private void generateTipNestedValues(GenericRecord rec) {
        if (this.extendedSchema.isPresent() && ((Schema)this.extendedSchema.get()).getField("tip_history") == null) {
            return;
        }
        GenericData.Array tipHistoryArray = new GenericData.Array(1, AVRO_SCHEMA.getField("tip_history").schema());
        Schema tipSchema = new Schema.Parser().parse(AVRO_SCHEMA.getField("tip_history").schema().toString()).getElementType();
        GenericData.Record tipRecord = new GenericData.Record(tipSchema);
        tipRecord.put("amount", (Object)(this.rand.nextDouble() * 100.0));
        tipRecord.put("currency", (Object)"USD");
        tipHistoryArray.add((Object)tipRecord);
        rec.put("tip_history", (Object)tipHistoryArray);
    }

    private void generateTripSuffixValues(GenericRecord rec, boolean isDeleteRecord) {
        if (isDeleteRecord) {
            rec.put("_hoodie_is_deleted", (Object)true);
        } else {
            rec.put("_hoodie_is_deleted", (Object)false);
        }
    }

    public GenericRecord generateGenericRecord(String rowKey, String partitionPath, String riderName, String driverName, long timestamp, boolean isDeleteRecord, boolean isFlattened) {
        GenericData.Record rec = new GenericData.Record((Schema)this.extendedSchema.orElseGet(() -> isFlattened ? FLATTENED_AVRO_SCHEMA : AVRO_SCHEMA));
        this.generateTripPrefixValues((GenericRecord)rec, rowKey, partitionPath, riderName, driverName, timestamp);
        if (isFlattened) {
            this.generateFareFlattenedValues((GenericRecord)rec);
        } else {
            this.generateExtraSchemaValues((GenericRecord)rec);
            this.generateMapTypeValues((GenericRecord)rec);
            this.generateFareNestedValues((GenericRecord)rec);
            this.generateTipNestedValues((GenericRecord)rec);
        }
        this.generateCustomValues((GenericRecord)rec, "customField");
        this.generateTripSuffixValues((GenericRecord)rec, isDeleteRecord);
        return rec;
    }

    public IndexedRecord generateRandomValueWithColumnRequired(HoodieKey key, String instantTime) throws IOException {
        GenericData.Record rec = new GenericData.Record(AVRO_SCHEMA_WITH_SPECIFIC_COLUMNS);
        this.generateTripPrefixValues((GenericRecord)rec, key.getRecordKey(), key.getPartitionPath(), "rider_" + instantTime, "driver_" + instantTime, 0L);
        this.generateExtraSchemaValues((GenericRecord)rec);
        this.generateMapTypeValues((GenericRecord)rec);
        this.generateFareNestedValues((GenericRecord)rec);
        this.generateTipNestedValues((GenericRecord)rec);
        this.generateOpColumnValue((GenericRecord)rec);
        this.generateEventLSNValue((GenericRecord)rec);
        this.generateTripSuffixValues((GenericRecord)rec, false);
        return rec;
    }

    public GenericRecord generateNestedExampleGenericRecord(String rowKey, String partitionPath, String riderName, String driverName, long timestamp, boolean isDeleteRecord) {
        GenericData.Record rec = new GenericData.Record(NESTED_AVRO_SCHEMA);
        this.generateTripPrefixValues((GenericRecord)rec, rowKey, partitionPath, riderName, driverName, timestamp);
        this.generateFareNestedValues((GenericRecord)rec);
        this.generateTripSuffixValues((GenericRecord)rec, isDeleteRecord);
        return rec;
    }

    public GenericRecord generateRecordForTripEncodedDecimalSchema(String rowKey, String riderName, String driverName, long timestamp) {
        GenericData.Record rec = new GenericData.Record(AVRO_TRIP_ENCODED_DECIMAL_SCHEMA);
        rec.put("_row_key", (Object)rowKey);
        rec.put("timestamp", (Object)timestamp);
        rec.put("rider", (Object)riderName);
        rec.put("decfield", (Object)HoodieTestDataGenerator.getNonzeroEncodedBigDecimal(this.rand, 6, 10));
        rec.put("lowprecision", (Object)HoodieTestDataGenerator.getNonzeroEncodedBigDecimal(this.rand, 2, 4));
        rec.put("highprecision", (Object)HoodieTestDataGenerator.getNonzeroEncodedBigDecimal(this.rand, 12, 32));
        rec.put("driver", (Object)driverName);
        rec.put("fare", (Object)(this.rand.nextDouble() * 100.0));
        rec.put("_hoodie_is_deleted", (Object)false);
        return rec;
    }

    public GenericRecord generateRecordForTripLogicalTypesSchema(HoodieKey key, String riderName, String driverName, long timestamp, boolean isDeleteRecord, boolean v6, boolean hasLTS) {
        GenericData.Record rec = !hasLTS ? (v6 ? new GenericData.Record(AVRO_TRIP_LOGICAL_TYPES_SCHEMA_NO_LTS_V6) : new GenericData.Record(AVRO_TRIP_LOGICAL_TYPES_SCHEMA_NO_LTS)) : (v6 ? new GenericData.Record(AVRO_TRIP_LOGICAL_TYPES_SCHEMA_V6) : new GenericData.Record(AVRO_TRIP_LOGICAL_TYPES_SCHEMA));
        this.generateTripPrefixValues((GenericRecord)rec, key.getRecordKey(), key.getPartitionPath(), riderName, driverName, timestamp);
        int hash = key.getRecordKey().hashCode();
        boolean above = (hash & 1) == 0;
        Instant tsMillisThreshold = Instant.parse("2020-01-01T00:00:00Z");
        Instant tsMicrosThreshold = Instant.parse("2020-06-01T12:00:00Z");
        Instant localTsMillisThreshold = ZonedDateTime.of(2015, 5, 20, 12, 34, 56, 0, ZoneOffset.UTC).toInstant();
        Instant localTsMicrosThreshold = ZonedDateTime.of(2017, 7, 7, 7, 7, 7, 0, ZoneOffset.UTC).toInstant();
        LocalDate dateThreshold = LocalDate.of(2000, 1, 1);
        long tsMillisBase = tsMillisThreshold.toEpochMilli();
        rec.put("ts_millis", (Object)(above ? tsMillisBase + 1L : tsMillisBase - 1L));
        long tsMicrosBase = TimeUnit.SECONDS.toMicros(tsMicrosThreshold.getEpochSecond()) + (long)tsMicrosThreshold.getNano() / 1000L;
        rec.put("ts_micros", (Object)(above ? tsMicrosBase + 1L : tsMicrosBase - 1L));
        if (hasLTS) {
            long localTsMillisBase = localTsMillisThreshold.toEpochMilli();
            rec.put("local_ts_millis", (Object)(above ? localTsMillisBase + 1L : localTsMillisBase - 1L));
            long localTsMicrosBase = TimeUnit.SECONDS.toMicros(localTsMicrosThreshold.getEpochSecond()) + (long)localTsMicrosThreshold.getNano() / 1000L;
            rec.put("local_ts_micros", (Object)(above ? localTsMicrosBase + 1L : localTsMicrosBase - 1L));
        }
        int eventDateBase = (int)dateThreshold.toEpochDay();
        rec.put("event_date", (Object)(above ? eventDateBase + 1 : eventDateBase - 1));
        BigDecimal decPlainLargeThreshold = new BigDecimal("1234567890.0987654321");
        BigDecimal decFixedSmallThreshold = new BigDecimal("543.21");
        BigDecimal decFixedLargeThreshold = new BigDecimal("987654321.123456789");
        BigDecimal incSmallScale2 = new BigDecimal("0.01");
        BigDecimal incLargeScale9 = new BigDecimal("0.000000001");
        BigDecimal incLargeScale10 = new BigDecimal("0.0000000001");
        if (!v6) {
            rec.put("dec_plain_large", (Object)ByteBuffer.wrap((above ? decPlainLargeThreshold.add(incLargeScale10) : decPlainLargeThreshold.subtract(incLargeScale10)).unscaledValue().toByteArray()));
        }
        Conversions.DecimalConversion decimalConversions = new Conversions.DecimalConversion();
        Schema decFixedSmallSchema = AVRO_TRIP_LOGICAL_TYPES_SCHEMA.getField("dec_fixed_small").schema();
        rec.put("dec_fixed_small", (Object)decimalConversions.toFixed(above ? decFixedSmallThreshold.add(incSmallScale2) : decFixedSmallThreshold.subtract(incSmallScale2), decFixedSmallSchema, (LogicalType)LogicalTypes.decimal((int)5, (int)2)));
        Schema decFixedLargeSchema = AVRO_TRIP_LOGICAL_TYPES_SCHEMA.getField("dec_fixed_large").schema();
        rec.put("dec_fixed_large", (Object)decimalConversions.toFixed(above ? decFixedLargeThreshold.add(incLargeScale9) : decFixedLargeThreshold.subtract(incLargeScale9), decFixedLargeSchema, (LogicalType)LogicalTypes.decimal((int)18, (int)9)));
        this.generateTripSuffixValues((GenericRecord)rec, isDeleteRecord);
        return rec;
    }

    private static String getNonzeroEncodedBigDecimal(Random rand, int scale, int precision) {
        double nextDouble = rand.nextDouble();
        while (nextDouble <= 0.1) {
            nextDouble = rand.nextDouble();
        }
        double valuescale = Math.pow(10.0, precision - scale);
        BigDecimal dec = BigDecimal.valueOf(nextDouble * valuescale).setScale(scale, RoundingMode.HALF_UP).round(new MathContext(precision, RoundingMode.HALF_UP));
        return Base64.getEncoder().encodeToString(dec.unscaledValue().toByteArray());
    }

    public GenericRecord generateRecordForTripSchema(String rowKey, String riderName, String driverName, long timestamp) {
        GenericData.Record rec = new GenericData.Record(AVRO_TRIP_SCHEMA);
        rec.put("_row_key", (Object)rowKey);
        rec.put("timestamp", (Object)timestamp);
        rec.put("rider", (Object)riderName);
        rec.put("driver", (Object)driverName);
        rec.put("fare", (Object)(this.rand.nextDouble() * 100.0));
        rec.put("_hoodie_is_deleted", (Object)false);
        return rec;
    }

    public GenericRecord generateRecordForShortTripSchema(String rowKey, String riderName, String driverName, long timestamp) {
        GenericData.Record rec = new GenericData.Record(AVRO_SHORT_TRIP_SCHEMA);
        rec.put("_row_key", (Object)rowKey);
        rec.put("timestamp", (Object)timestamp);
        rec.put("rider", (Object)riderName);
        rec.put("driver", (Object)driverName);
        rec.put("fare", (Object)(this.rand.nextDouble() * 100.0));
        rec.put("_hoodie_is_deleted", (Object)false);
        return rec;
    }

    public static void createRequestedCommitFile(String basePath, String instantTime, StorageConfiguration<?> configuration) throws IOException {
        Path pendingRequestedFile = new Path(basePath + "/" + ".hoodie" + "/" + "timeline" + "/" + HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.makeRequestedCommitFileName(instantTime));
        HoodieTestDataGenerator.createEmptyFile(basePath, pendingRequestedFile, configuration);
    }

    public static void createPendingCommitFile(String basePath, String instantTime, StorageConfiguration<?> configuration) throws IOException {
        Path pendingCommitFile = new Path(basePath + "/" + ".hoodie" + "/" + "timeline" + "/" + HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.makeInflightCommitFileName(instantTime));
        HoodieTestDataGenerator.createEmptyFile(basePath, pendingCommitFile, configuration);
    }

    public static void createCommitFile(String basePath, String instantTime, StorageConfiguration<?> configuration) {
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        HoodieTestDataGenerator.createCommitFile(basePath, instantTime, configuration, commitMetadata);
    }

    private static void createCommitFile(String basePath, String instantTime, StorageConfiguration<?> configuration, HoodieCommitMetadata commitMetadata) {
        Arrays.asList(HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.makeCommitFileName(instantTime + "_" + InProcessTimeGenerator.createNewInstantTime()), HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.makeInflightCommitFileName(instantTime), HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.makeRequestedCommitFileName(instantTime)).forEach(f -> HoodieTestDataGenerator.createMetadataFile(f, basePath, configuration, commitMetadata));
    }

    public static void createOnlyCompletedCommitFile(String basePath, String instantTime, StorageConfiguration<?> configuration) {
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        HoodieTestDataGenerator.createOnlyCompletedCommitFile(basePath, instantTime, configuration, commitMetadata);
    }

    public static void createOnlyCompletedCommitFile(String basePath, String instantTime, StorageConfiguration<?> configuration, HoodieCommitMetadata commitMetadata) {
        HoodieTestDataGenerator.createMetadataFile(HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.makeCommitFileName(instantTime), basePath, configuration, commitMetadata);
    }

    public static void createDeltaCommitFile(String basePath, String instantTime, StorageConfiguration<?> configuration) {
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        HoodieTestDataGenerator.createDeltaCommitFile(basePath, instantTime, configuration, commitMetadata);
    }

    private static void createDeltaCommitFile(String basePath, String instantTime, StorageConfiguration<?> configuration, HoodieCommitMetadata commitMetadata) {
        Arrays.asList(HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.makeDeltaFileName(instantTime + "_" + InProcessTimeGenerator.createNewInstantTime()), HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.makeInflightDeltaFileName(instantTime), HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.makeRequestedDeltaFileName(instantTime)).forEach(f -> HoodieTestDataGenerator.createMetadataFile(f, basePath, configuration, commitMetadata));
    }

    private static void createMetadataFile(String f, String basePath, StorageConfiguration<?> configuration, HoodieCommitMetadata commitMetadata) {
        HoodieTestDataGenerator.createMetadataFile(f, basePath, configuration, (HoodieInstantWriter)HoodieTestUtils.COMMIT_METADATA_SER_DE.getInstantWriter((Object)commitMetadata).get());
    }

    private static void createMetadataFile(String f, String basePath, StorageConfiguration<?> configuration, HoodieInstantWriter writer) {
        Path commitFile = new Path(basePath + "/" + ".hoodie" + "/" + "timeline" + "/" + f);
        OutputStream os = null;
        try {
            HoodieStorage storage = HoodieStorageUtils.getStorage((String)basePath, configuration);
            os = storage.create(new StoragePath(commitFile.toUri()), true);
            writer.writeToStream(os);
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
        finally {
            if (null != os) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    throw new HoodieIOException(e.getMessage(), e);
                }
            }
        }
    }

    public static void createReplaceCommitRequestedFile(String basePath, String instantTime, StorageConfiguration<?> configuration) throws IOException {
        Path commitFile = new Path(basePath + "/" + ".hoodie" + "/" + "timeline" + "/" + HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.makeRequestedReplaceFileName(instantTime));
        HoodieTestDataGenerator.createEmptyFile(basePath, commitFile, configuration);
    }

    public static void createReplaceCommitInflightFile(String basePath, String instantTime, StorageConfiguration<?> configuration) throws IOException {
        Path commitFile = new Path(basePath + "/" + ".hoodie" + "/" + "timeline" + "/" + HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.makeInflightReplaceFileName(instantTime));
        HoodieTestDataGenerator.createEmptyFile(basePath, commitFile, configuration);
    }

    private static void createPendingClusterFile(String basePath, String instantTime, StorageConfiguration<?> configuration, HoodieCommitMetadata commitMetadata) {
        Arrays.asList(HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.makeInflightClusteringFileName(instantTime), HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.makeRequestedClusteringFileName(instantTime)).forEach(f -> HoodieTestDataGenerator.createMetadataFile(f, basePath, configuration, commitMetadata));
    }

    public static void createPendingClusterFile(String basePath, String instantTime, StorageConfiguration<?> configuration) {
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        HoodieTestDataGenerator.createPendingClusterFile(basePath, instantTime, configuration, commitMetadata);
    }

    public static void createEmptyCleanRequestedFile(String basePath, String instantTime, StorageConfiguration<?> configuration) throws IOException {
        Path commitFile = new Path(basePath + "/" + ".hoodie" + "/" + "timeline" + "/" + HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.makeRequestedCleanerFileName(instantTime));
        HoodieTestDataGenerator.createEmptyFile(basePath, commitFile, configuration);
    }

    private static void createEmptyFile(String basePath, Path filePath, StorageConfiguration<?> configuration) throws IOException {
        HoodieStorage storage = HoodieStorageUtils.getStorage((String)basePath, configuration);
        OutputStream os = storage.create(new StoragePath(filePath.toUri()), true);
        os.close();
    }

    public static void createCompactionRequestedFile(String basePath, String instantTime, StorageConfiguration<?> configuration) throws IOException {
        Path commitFile = new Path(basePath + "/" + ".hoodie" + "/" + "timeline" + "/" + HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.makeRequestedCompactionFileName(instantTime));
        HoodieTestDataGenerator.createEmptyFile(basePath, commitFile, configuration);
    }

    public static void createCompactionAuxiliaryMetadata(String basePath, HoodieInstant instant, StorageConfiguration<?> configuration) throws IOException {
        Path commitFile = new Path(basePath + "/" + ".hoodie/.aux" + "/" + HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.getFileName(instant));
        HoodieStorage storage = HoodieStorageUtils.getStorage((String)basePath, configuration);
        try (OutputStream os = storage.create(new StoragePath(commitFile.toUri()), true);){
            HoodieCompactionPlan workload = HoodieCompactionPlan.newBuilder().setVersion(Integer.valueOf(1)).build();
            ((HoodieInstantWriter)HoodieTestUtils.COMMIT_METADATA_SER_DE.getInstantWriter((Object)workload).get()).writeToStream(os);
        }
    }

    public static void createSavepointFile(String basePath, String instantTime, StorageConfiguration<?> configuration) throws IOException {
        Path commitFile = new Path(basePath + "/" + ".hoodie" + "/" + "timeline" + "/" + HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.makeSavePointFileName(instantTime + "_" + InProcessTimeGenerator.createNewInstantTime()));
        HoodieStorage storage = HoodieStorageUtils.getStorage((String)basePath, configuration);
        try (OutputStream os = storage.create(new StoragePath(commitFile.toUri()), true);){
            HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
            ((HoodieInstantWriter)HoodieTestUtils.COMMIT_METADATA_SER_DE.getInstantWriter((Object)commitMetadata).get()).writeToStream(os);
        }
    }

    public List<HoodieRecord> generateInsertsAsPerSchema(String commitTime, Integer n, String schemaStr) {
        return this.generateInsertsStream(commitTime, n, false, schemaStr, System.currentTimeMillis()).collect(Collectors.toList());
    }

    public List<HoodieRecord> generateInsertsAsPerSchema(String commitTime, Integer n, String schemaStr, long timestamp) {
        return this.generateInsertsStream(commitTime, n, false, schemaStr, timestamp).collect(Collectors.toList());
    }

    public List<HoodieRecord> generateInserts(String instantTime, Integer n) {
        return this.generateInserts(instantTime, n, false);
    }

    public List<HoodieRecord> generateInserts(String instantTime, Integer n, long timestamp) {
        return this.generateInsertsStream(instantTime, n, false, TRIP_EXAMPLE_SCHEMA, timestamp).collect(Collectors.toList());
    }

    public List<HoodieRecord> generateInsertsNestedExample(String instantTime, Integer n) {
        return this.generateInsertsStream(instantTime, n, false, TRIP_NESTED_EXAMPLE_SCHEMA, System.currentTimeMillis()).collect(Collectors.toList());
    }

    public List<HoodieRecord> generateInserts(String instantTime, Integer n, boolean isFlattened) {
        return this.generateInsertsStream(instantTime, n, isFlattened, isFlattened ? TRIP_FLATTENED_SCHEMA : TRIP_EXAMPLE_SCHEMA, System.currentTimeMillis()).collect(Collectors.toList());
    }

    public Stream<HoodieRecord> generateInsertsStream(String commitTime, Integer n, boolean isFlattened, String schemaStr, long timestamp) {
        return this.generateInsertsStream(commitTime, n, isFlattened, schemaStr, false, timestamp);
    }

    public List<HoodieRecord> generateInsertsContainsAllPartitions(String instantTime, Integer n) {
        if (n < this.partitionPaths.length) {
            throw new HoodieIOException("n must greater then partitionPaths length");
        }
        long timestamp = System.currentTimeMillis();
        return this.generateInsertsStream(instantTime, n, false, TRIP_EXAMPLE_SCHEMA, true, timestamp).collect(Collectors.toList());
    }

    public List<HoodieRecord> generateInsertsForPartitionPerSchema(String instantTime, Integer n, String partition, String schemaStr) {
        long timestamp = System.currentTimeMillis();
        return this.generateInsertsStream(instantTime, n, false, schemaStr, false, () -> partition, () -> HoodieTestDataGenerator.genPseudoRandomUUID(this.rand).toString(), timestamp).collect(Collectors.toList());
    }

    public List<HoodieRecord> generateInsertsForPartition(String instantTime, Integer n, String partition) {
        long timestamp = System.currentTimeMillis();
        return this.generateInsertsStream(instantTime, n, false, TRIP_EXAMPLE_SCHEMA, false, () -> partition, () -> HoodieTestDataGenerator.genPseudoRandomUUID(this.rand).toString(), timestamp).collect(Collectors.toList());
    }

    public Stream<HoodieRecord> generateInsertsStream(String commitTime, Integer n, boolean isFlattened, String schemaStr, boolean containsAllPartitions, long timestamp) {
        AtomicInteger partitionIndex = new AtomicInteger(0);
        return this.generateInsertsStream(commitTime, n, isFlattened, schemaStr, containsAllPartitions, () -> {
            String partitionToUse = this.partitionPaths[partitionIndex.get()];
            partitionIndex.set((partitionIndex.get() + 1) % this.partitionPaths.length);
            return partitionToUse;
        }, () -> HoodieTestDataGenerator.genPseudoRandomUUID(this.rand).toString(), timestamp);
    }

    public Stream<HoodieRecord> generateInsertsStream(String instantTime, Integer n, boolean isFlattened, String schemaStr, boolean containsAllPartitions, Supplier<String> partitionPathSupplier, Supplier<String> recordKeySupplier, long timestamp) {
        int currSize = this.getNumExistingKeys(schemaStr);
        return IntStream.range(0, n).boxed().map(i -> {
            String partitionPath = (String)partitionPathSupplier.get();
            if (containsAllPartitions && i < this.partitionPaths.length) {
                partitionPath = this.partitionPaths[i];
            }
            HoodieKey key = new HoodieKey((String)recordKeySupplier.get(), partitionPath);
            KeyPartition kp = new KeyPartition();
            kp.key = key;
            kp.partitionPath = partitionPath;
            this.populateKeysBySchema(schemaStr, currSize + i, kp);
            this.incrementNumExistingKeysBySchema(schemaStr);
            try {
                return new HoodieAvroIndexedRecord(key, this.generateRandomValueAsPerSchema(schemaStr, key, instantTime, isFlattened, timestamp), null, Option.of(Collections.singletonMap("InputRecordCount_1506582000", "2")), null, null);
            }
            catch (IOException e) {
                throw new HoodieIOException(e.getMessage(), e);
            }
        });
    }

    private void populateKeysBySchema(String schemaStr, int i, KeyPartition kp) {
        if (this.existingKeysBySchema.containsKey(schemaStr)) {
            this.existingKeysBySchema.get(schemaStr).put(i, kp);
        } else {
            this.existingKeysBySchema.put(schemaStr, new HashMap());
            this.existingKeysBySchema.get(schemaStr).put(i, kp);
        }
    }

    private void incrementNumExistingKeysBySchema(String schemaStr) {
        if (this.numKeysBySchema.containsKey(schemaStr)) {
            this.numKeysBySchema.put(schemaStr, this.numKeysBySchema.get(schemaStr) + 1);
        } else {
            this.numKeysBySchema.put(schemaStr, 1);
        }
    }

    public List<HoodieRecord> generateSameKeyInserts(String instantTime, List<HoodieRecord> origin) {
        ArrayList<HoodieRecord> copy = new ArrayList<HoodieRecord>();
        for (HoodieRecord r : origin) {
            HoodieKey key = r.getKey();
            HoodieAvroIndexedRecord record = new HoodieAvroIndexedRecord(key, this.generateRandomValue(key, instantTime));
            copy.add((HoodieRecord)record);
        }
        return copy;
    }

    public List<HoodieRecord> generateUpdatesWithHoodieAvroPayload(String instantTime, List<HoodieRecord> baseRecords) {
        ArrayList<HoodieRecord> updates = new ArrayList<HoodieRecord>();
        long timestamp = System.currentTimeMillis();
        for (HoodieRecord baseRecord : baseRecords) {
            HoodieAvroIndexedRecord record = new HoodieAvroIndexedRecord(baseRecord.getKey(), this.generateAvroPayload(baseRecord.getKey(), instantTime, timestamp));
            updates.add((HoodieRecord)record);
        }
        return updates;
    }

    public List<HoodieRecord> generateDeletes(String instantTime, Integer n) throws IOException {
        List<HoodieRecord> inserts = this.generateInserts(instantTime, n);
        return this.generateDeletesFromExistingRecords(inserts);
    }

    public List<HoodieRecord> generateDeletesFromExistingRecords(List<HoodieRecord> existingRecords) throws IOException {
        ArrayList<HoodieRecord> deletes = new ArrayList<HoodieRecord>();
        for (HoodieRecord existingRecord : existingRecords) {
            HoodieRecord record = this.generateDeleteRecord(existingRecord);
            deletes.add(record);
        }
        return deletes;
    }

    public HoodieRecord generateDeleteRecord(HoodieRecord existingRecord) {
        HoodieKey key = existingRecord.getKey();
        return this.generateDeleteRecord(key);
    }

    public HoodieRecord generateDeleteRecord(HoodieKey key) {
        return new HoodieEmptyRecord(key, HoodieRecord.HoodieRecordType.AVRO);
    }

    public HoodieRecord generateUpdateRecord(HoodieKey key, String instantTime) throws IOException {
        return new HoodieAvroIndexedRecord(key, this.generateRandomValue(key, instantTime));
    }

    public HoodieRecord generateUpdateRecordWithTimestamp(HoodieKey key, String instantTime, long timestamp) {
        return new HoodieAvroIndexedRecord(key, this.generateRandomValue(key, instantTime, false, timestamp));
    }

    public List<HoodieRecord> generateUpdates(String instantTime, List<HoodieRecord> baseRecords) throws IOException {
        ArrayList<HoodieRecord> updates = new ArrayList<HoodieRecord>();
        for (HoodieRecord baseRecord : baseRecords) {
            HoodieRecord record = this.generateUpdateRecord(baseRecord.getKey(), instantTime);
            updates.add(record);
        }
        return updates;
    }

    public List<HoodieRecord> generateUpdatesWithTimestamp(String instantTime, List<HoodieRecord> baseRecords, long timestamp) {
        ArrayList<HoodieRecord> updates = new ArrayList<HoodieRecord>();
        for (HoodieRecord baseRecord : baseRecords) {
            updates.add(this.generateUpdateRecordWithTimestamp(baseRecord.getKey(), instantTime, timestamp));
        }
        return updates;
    }

    public List<HoodieRecord> generateUpdatesForDifferentPartition(String instantTime, List<HoodieRecord> baseRecords, long timestamp, String newPartition) {
        ArrayList<HoodieRecord> updates = new ArrayList<HoodieRecord>();
        for (HoodieRecord baseRecord : baseRecords) {
            String partition = baseRecord.getPartitionPath();
            ValidationUtils.checkState((!partition.equals(newPartition) ? 1 : 0) != 0, (String)"newPartition should be different from any given record's current partition.");
            HoodieKey key = new HoodieKey(baseRecord.getRecordKey(), newPartition);
            HoodieRecord record = this.generateUpdateRecordWithTimestamp(key, instantTime, timestamp);
            updates.add(record);
        }
        return updates;
    }

    public List<HoodieRecord> generateUpdates(String instantTime, Integer n) throws IOException {
        return this.generateUpdates(instantTime, n, TRIP_EXAMPLE_SCHEMA);
    }

    public List<HoodieRecord> generateUpdates(String instantTime, Integer n, String schemaStr) throws IOException {
        ArrayList<HoodieRecord> updates = new ArrayList<HoodieRecord>();
        for (int i = 0; i < n; ++i) {
            Map<Integer, KeyPartition> existingKeys = this.existingKeysBySchema.get(schemaStr);
            Integer numExistingKeys = this.numKeysBySchema.get(schemaStr);
            KeyPartition kp = existingKeys.get(this.rand.nextInt(numExistingKeys - 1));
            HoodieRecord record = this.generateUpdateRecord(kp.key, instantTime);
            updates.add(record);
        }
        return updates;
    }

    public List<HoodieRecord> generateUpdatesForAllRecords(String instantTime) {
        ArrayList<HoodieRecord> updates = new ArrayList<HoodieRecord>();
        Map<Integer, KeyPartition> existingKeys = this.existingKeysBySchema.get(TRIP_EXAMPLE_SCHEMA);
        existingKeys.values().forEach(kp -> {
            try {
                HoodieRecord record = this.generateUpdateRecord(kp.key, instantTime);
                updates.add(record);
            }
            catch (IOException ioe) {
                throw new HoodieIOException(ioe.getMessage(), ioe);
            }
        });
        return updates;
    }

    public List<HoodieRecord> generateUpdatesAsPerSchema(String commitTime, Integer n, String schemaStr) {
        return this.generateUniqueUpdatesStream(commitTime, n, schemaStr).collect(Collectors.toList());
    }

    public List<HoodieRecord> generateUniqueUpdates(String instantTime, Integer n) {
        return this.generateUniqueUpdatesStream(instantTime, n, TRIP_EXAMPLE_SCHEMA).collect(Collectors.toList());
    }

    public List<HoodieRecord> generateUniqueUpdates(String instantTime, Integer n, long timestamp) {
        return this.generateUniqueUpdatesStream(instantTime, n, TRIP_EXAMPLE_SCHEMA, timestamp).collect(Collectors.toList());
    }

    public List<HoodieRecord> generateUniqueUpdates(String instantTime, Integer n, String schemaStr) {
        return this.generateUniqueUpdatesStream(instantTime, n, schemaStr).collect(Collectors.toList());
    }

    public List<HoodieRecord> generateUniqueUpdates(String instantTime, Integer n, String schemaStr, long timestamp) {
        return this.generateUniqueUpdatesStream(instantTime, n, schemaStr, timestamp).collect(Collectors.toList());
    }

    public List<HoodieRecord> generateUniqueUpdatesNestedExample(String instantTime, Integer n) {
        return this.generateUniqueUpdatesStream(instantTime, n, TRIP_NESTED_EXAMPLE_SCHEMA).collect(Collectors.toList());
    }

    public List<HoodieRecord> generateUniqueUpdatesAsPerSchema(String instantTime, Integer n, String schemaStr) {
        return this.generateUniqueUpdatesStream(instantTime, n, schemaStr).collect(Collectors.toList());
    }

    public List<HoodieKey> generateUniqueDeletes(Integer n) {
        return this.generateUniqueDeleteStream(n).collect(Collectors.toList());
    }

    public Stream<HoodieRecord> generateUniqueUpdatesStream(String instantTime, Integer n, String schemaStr) {
        long timestamp = System.currentTimeMillis();
        return this.generateUniqueUpdatesStream(instantTime, n, schemaStr, timestamp);
    }

    public Stream<HoodieRecord> generateUniqueUpdatesStream(String instantTime, Integer n, String schemaStr, long timestamp) {
        HashSet used = new HashSet();
        int numExistingKeys = this.numKeysBySchema.getOrDefault(schemaStr, 0);
        Map<Integer, KeyPartition> existingKeys = this.existingKeysBySchema.get(schemaStr);
        if (n > numExistingKeys) {
            throw new IllegalArgumentException("Requested unique updates is greater than number of available keys");
        }
        return IntStream.range(0, n).boxed().map(i -> {
            int index = numExistingKeys == 1 ? 0 : this.rand.nextInt(numExistingKeys - 1);
            KeyPartition kp = (KeyPartition)existingKeys.get(index);
            while (used.contains(kp)) {
                index = (index + 1) % numExistingKeys;
                kp = (KeyPartition)existingKeys.get(index);
            }
            logger.debug("key getting updated: {}", (Object)kp.key.getRecordKey());
            used.add(kp);
            try {
                return new HoodieAvroIndexedRecord(kp.key, this.generateRandomValueAsPerSchema(schemaStr, kp.key, instantTime, false, timestamp));
            }
            catch (IOException e) {
                throw new HoodieIOException(e.getMessage(), e);
            }
        });
    }

    public Stream<HoodieKey> generateUniqueDeleteStream(Integer n) {
        HashSet<KeyPartition> used = new HashSet<KeyPartition>();
        Map<Integer, KeyPartition> existingKeys = this.existingKeysBySchema.get(TRIP_EXAMPLE_SCHEMA);
        Integer numExistingKeys = this.numKeysBySchema.get(TRIP_EXAMPLE_SCHEMA);
        if (n > numExistingKeys) {
            throw new IllegalArgumentException("Requested unique deletes is greater than number of available keys");
        }
        ArrayList<HoodieKey> result = new ArrayList<HoodieKey>();
        for (int i = 0; i < n; ++i) {
            int index = this.rand.nextInt(numExistingKeys);
            while (!existingKeys.containsKey(index)) {
                index = (index + 1) % numExistingKeys;
            }
            KeyPartition kp = existingKeys.remove(index);
            existingKeys.put(index, existingKeys.get(numExistingKeys - 1));
            existingKeys.remove(numExistingKeys - 1);
            Integer n2 = numExistingKeys;
            Integer n3 = numExistingKeys = Integer.valueOf(numExistingKeys - 1);
            used.add(kp);
            result.add(kp.key);
        }
        this.numKeysBySchema.put(TRIP_EXAMPLE_SCHEMA, numExistingKeys);
        return result.stream();
    }

    private Stream<HoodieRecord> generateUniqueDeleteRecordStream(String instantTime, Integer n, boolean updatePartition, long timestamp) {
        return this.generateUniqueDeleteRecordStream(instantTime, n, updatePartition, TRIP_EXAMPLE_SCHEMA, timestamp);
    }

    public Stream<HoodieRecord> generateUniqueDeleteRecordStream(String instantTime, Integer n, boolean updatePartition, String schemaStr, long timestamp) {
        HashSet<KeyPartition> used = new HashSet<KeyPartition>();
        Map<Integer, KeyPartition> existingKeys = this.existingKeysBySchema.get(schemaStr);
        Integer numExistingKeys = this.numKeysBySchema.get(schemaStr);
        if (n > numExistingKeys) {
            throw new IllegalArgumentException("Requested unique deletes is greater than number of available keys");
        }
        ArrayList<HoodieAvroIndexedRecord> result = new ArrayList<HoodieAvroIndexedRecord>();
        for (int i = 0; i < n; ++i) {
            int index = this.rand.nextInt(numExistingKeys);
            while (!existingKeys.containsKey(index)) {
                index = (index + 1) % numExistingKeys;
            }
            KeyPartition kp = existingKeys.remove(index);
            existingKeys.put(index, existingKeys.get(numExistingKeys - 1));
            existingKeys.remove(numExistingKeys - 1);
            Integer n2 = numExistingKeys;
            Integer n3 = numExistingKeys = Integer.valueOf(numExistingKeys - 1);
            used.add(kp);
            HoodieKey key = kp.key;
            if (updatePartition) {
                String updatedPartitionPath = Arrays.stream(this.partitionPaths).filter(p -> !p.equals(kp.partitionPath)).findAny().orElseThrow(() -> new HoodieIOException("No other partition path found to update"));
                key = new HoodieKey(key.getRecordKey(), updatedPartitionPath);
            }
            try {
                result.add(new HoodieAvroIndexedRecord(key, this.generateRandomValueAsPerSchema(schemaStr, kp.key, instantTime, false, true, timestamp)));
                continue;
            }
            catch (IOException e) {
                throw new HoodieIOException(e.getMessage(), e);
            }
        }
        this.numKeysBySchema.put(schemaStr, numExistingKeys);
        return result.stream();
    }

    public List<HoodieRecord> generateUniqueDeleteRecords(String instantTime, Integer n) {
        return this.generateUniqueDeleteRecordStream(instantTime, n, false, System.currentTimeMillis()).collect(Collectors.toList());
    }

    public List<HoodieRecord> generateUniqueDeleteRecordsWithUpdatedPartition(String instantTime, Integer n) {
        return this.generateUniqueDeleteRecordStream(instantTime, n, true, System.currentTimeMillis()).collect(Collectors.toList());
    }

    public List<HoodieRecord> generateUniqueDeleteRecords(String instantTime, Integer n, long timestamp) {
        return this.generateUniqueDeleteRecordStream(instantTime, n, false, timestamp).collect(Collectors.toList());
    }

    public List<HoodieRecord> generateUniqueDeleteRecordsWithUpdatedPartition(String instantTime, Integer n, long timestamp) {
        return this.generateUniqueDeleteRecordStream(instantTime, n, true, timestamp).collect(Collectors.toList());
    }

    public boolean deleteExistingKeyIfPresent(HoodieKey key) {
        Map<Integer, KeyPartition> existingKeys = this.existingKeysBySchema.get(TRIP_EXAMPLE_SCHEMA);
        Integer numExistingKeys = this.numKeysBySchema.get(TRIP_EXAMPLE_SCHEMA);
        for (Map.Entry<Integer, KeyPartition> entry : existingKeys.entrySet()) {
            if (!entry.getValue().key.equals((Object)key)) continue;
            int index = entry.getKey();
            existingKeys.put(index, existingKeys.get(numExistingKeys - 1));
            existingKeys.remove(numExistingKeys - 1);
            Integer n = numExistingKeys;
            Integer n2 = numExistingKeys = Integer.valueOf(numExistingKeys - 1);
            this.numKeysBySchema.put(TRIP_EXAMPLE_SCHEMA, numExistingKeys);
            return true;
        }
        return false;
    }

    public GenericRecord generateGenericRecord() {
        return this.generateGenericRecord(HoodieTestDataGenerator.genPseudoRandomUUID(this.rand).toString(), "0", HoodieTestDataGenerator.genPseudoRandomUUID(this.rand).toString(), HoodieTestDataGenerator.genPseudoRandomUUID(this.rand).toString(), this.rand.nextLong());
    }

    public List<GenericRecord> generateGenericRecords(int numRecords) {
        ArrayList<GenericRecord> list = new ArrayList<GenericRecord>();
        IntStream.range(0, numRecords).forEach(i -> list.add(this.generateGenericRecord()));
        return list;
    }

    public String[] getPartitionPaths() {
        return this.partitionPaths;
    }

    public int getNumExistingKeys(String schemaStr) {
        return this.numKeysBySchema.getOrDefault(schemaStr, 0);
    }

    public List<String> getExistingKeys() {
        return this.getExistingKeys(TRIP_EXAMPLE_SCHEMA);
    }

    public List<String> getExistingKeys(String schemaStr) {
        return this.existingKeysBySchema.get(schemaStr).values().stream().map(kp -> kp.key.getRecordKey()).collect(Collectors.toList());
    }

    @Override
    public void close() {
        this.existingKeysBySchema.clear();
    }

    private static long genRandomTimeMillis(Random r) {
        long anchorTs = 1234567890000L;
        return anchorTs + (long)r.nextInt(259200000);
    }

    public static UUID genPseudoRandomUUID(Random r) {
        byte[] bytes = new byte[16];
        r.nextBytes(bytes);
        bytes[6] = (byte)(bytes[6] & 0xF);
        bytes[6] = (byte)(bytes[6] | 0x40);
        bytes[8] = (byte)(bytes[8] & 0x3F);
        bytes[8] = (byte)(bytes[8] | 0x80);
        try {
            Constructor ctor = UUID.class.getDeclaredConstructor(byte[].class);
            ctor.setAccessible(true);
            return (UUID)ctor.newInstance(new Object[]{bytes});
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            logger.info("Failed to generate pseudo-random UUID!");
            throw new HoodieException((Throwable)e);
        }
    }

    public void extendSchema(SchemaEvolutionConfigs configs, boolean isBefore) {
        ArrayList<Schema.Type> baseFields = new ArrayList<Schema.Type>();
        for (SchemaEvolutionTypePromotionCase evolution : SchemaEvolutionTypePromotionCase.values()) {
            if (!evolution.isEnabled.test(configs)) continue;
            baseFields.add(isBefore ? evolution.before : evolution.after);
        }
        if (!isBefore && configs.addNewFieldSupport) {
            baseFields.add(Schema.Type.BOOLEAN);
        }
        this.extendedSchema = Option.of((Object)HoodieTestDataGenerator.generateExtendedSchema(configs, new ArrayList<Schema.Type>(baseFields)));
    }

    public void extendSchemaBeforeEvolution(SchemaEvolutionConfigs configs) {
        this.extendSchema(configs, true);
    }

    public void extendSchemaAfterEvolution(SchemaEvolutionConfigs configs) {
        this.extendSchema(configs, false);
    }

    public Schema getExtendedSchema() {
        return (Schema)this.extendedSchema.orElseThrow(IllegalArgumentException::new);
    }

    private static Schema generateExtendedSchema(SchemaEvolutionConfigs configs, List<Schema.Type> baseFields) {
        return HoodieTestDataGenerator.generateExtendedSchema(configs.schema, configs, baseFields, "customField", true);
    }

    private static Schema generateExtendedSchema(Schema baseSchema, SchemaEvolutionConfigs configs, List<Schema.Type> baseFields, String fieldPrefix, boolean toplevel) {
        List fields = baseSchema.getFields();
        ArrayList<Schema.Field> finalFields = new ArrayList<Schema.Field>(fields.size() + baseFields.size());
        boolean addedFields = false;
        for (Schema.Field field : fields) {
            if (configs.nestedSupport && field.name().equals("fare") && field.schema().getType() == Schema.Type.RECORD) {
                finalFields.add(HoodieAvroUtils.createNewSchemaField((String)field.name(), (Schema)HoodieTestDataGenerator.generateExtendedSchema(field.schema(), configs, baseFields, "customFare", false), (String)field.doc(), (Object)field.defaultVal()));
                continue;
            }
            if (!configs.anyArraySupport && field.name().equals("tip_history")) continue;
            if (field.name().equals("_hoodie_is_deleted")) {
                addedFields = true;
                HoodieTestDataGenerator.addFields(configs, finalFields, baseFields, fieldPrefix, baseSchema.getNamespace(), toplevel);
            }
            finalFields.add(HoodieAvroUtils.createNewSchemaField((Schema.Field)field));
        }
        if (!addedFields) {
            HoodieTestDataGenerator.addFields(configs, finalFields, baseFields, fieldPrefix, baseSchema.getNamespace(), toplevel);
        }
        Schema finalSchema = Schema.createRecord((String)baseSchema.getName(), (String)baseSchema.getDoc(), (String)baseSchema.getNamespace(), (boolean)baseSchema.isError());
        finalSchema.setFields(finalFields);
        return finalSchema;
    }

    private static void addFields(SchemaEvolutionConfigs configs, List<Schema.Field> finalFields, List<Schema.Type> baseFields, String fieldPrefix, String namespace, boolean toplevel) {
        if (toplevel) {
            if (configs.mapSupport) {
                ArrayList<Schema.Field> mapFields = new ArrayList<Schema.Field>(baseFields.size());
                HoodieTestDataGenerator.addFieldsHelper(mapFields, baseFields, fieldPrefix + "Map");
                finalFields.add(new Schema.Field(fieldPrefix + "Map", Schema.createMap((Schema)Schema.createRecord((String)"customMapRecord", (String)NO_PARTITION_PATH, (String)namespace, (boolean)false, mapFields)), NO_PARTITION_PATH, null));
            }
            if (configs.arraySupport) {
                ArrayList<Schema.Field> arrayFields = new ArrayList<Schema.Field>(baseFields.size());
                HoodieTestDataGenerator.addFieldsHelper(arrayFields, baseFields, fieldPrefix + "Array");
                finalFields.add(new Schema.Field(fieldPrefix + "Array", Schema.createArray((Schema)Schema.createRecord((String)"customArrayRecord", (String)NO_PARTITION_PATH, (String)namespace, (boolean)false, arrayFields)), NO_PARTITION_PATH, null));
            }
        }
        HoodieTestDataGenerator.addFieldsHelper(finalFields, baseFields, fieldPrefix);
    }

    private static void addFieldsHelper(List<Schema.Field> finalFields, List<Schema.Type> baseFields, String fieldPrefix) {
        for (int i = 0; i < baseFields.size(); ++i) {
            if (baseFields.get(i) == Schema.Type.BOOLEAN) {
                finalFields.add(new Schema.Field(fieldPrefix + i, AvroSchemaUtils.createNullableSchema((Schema.Type)Schema.Type.BOOLEAN), NO_PARTITION_PATH, null));
                continue;
            }
            finalFields.add(new Schema.Field(fieldPrefix + i, Schema.create((Schema.Type)baseFields.get(i)), NO_PARTITION_PATH, null));
        }
    }

    private void generateCustomValues(GenericRecord rec, String customPrefix) {
        block12: for (Schema.Field field : rec.getSchema().getFields()) {
            if (!field.name().startsWith(customPrefix)) continue;
            switch (field.schema().getType()) {
                case INT: {
                    rec.put(field.name(), (Object)this.rand.nextInt());
                    continue block12;
                }
                case LONG: {
                    rec.put(field.name(), (Object)this.rand.nextLong());
                    continue block12;
                }
                case FLOAT: {
                    rec.put(field.name(), (Object)Float.valueOf(this.rand.nextFloat()));
                    continue block12;
                }
                case DOUBLE: {
                    rec.put(field.name(), (Object)this.rand.nextDouble());
                    continue block12;
                }
                case STRING: {
                    rec.put(field.name(), (Object)HoodieTestDataGenerator.genPseudoRandomUUID(this.rand).toString());
                    continue block12;
                }
                case BYTES: {
                    rec.put(field.name(), (Object)ByteBuffer.wrap(StringUtils.getUTF8Bytes((String)HoodieTestDataGenerator.genPseudoRandomUUID(this.rand).toString())));
                    continue block12;
                }
                case UNION: {
                    if (!AvroSchemaUtils.getNonNullTypeFromUnion((Schema)field.schema()).getType().equals((Object)Schema.Type.BOOLEAN)) {
                        throw new IllegalStateException("Union should only be boolean");
                    }
                    rec.put(field.name(), (Object)this.rand.nextBoolean());
                    continue block12;
                }
                case BOOLEAN: {
                    rec.put(field.name(), (Object)this.rand.nextBoolean());
                    continue block12;
                }
                case MAP: {
                    rec.put(field.name(), this.genMap(field.schema(), field.name()));
                    continue block12;
                }
                case ARRAY: {
                    rec.put(field.name(), this.genArray(field.schema(), field.name()));
                    continue block12;
                }
            }
            throw new UnsupportedOperationException("Unsupported type: " + field.schema().getType());
        }
    }

    private GenericArray<GenericRecord> genArray(Schema arraySchema, String customPrefix) {
        GenericData.Array customArray = new GenericData.Array(1, arraySchema);
        Schema arrayElementSchema = arraySchema.getElementType();
        GenericData.Record customRecord = new GenericData.Record(arrayElementSchema);
        this.generateCustomValues((GenericRecord)customRecord, customPrefix);
        customArray.add((Object)customRecord);
        return customArray;
    }

    private Map<String, GenericRecord> genMap(Schema mapSchema, String customPrefix) {
        Schema mapElementSchema = mapSchema.getValueType();
        GenericData.Record customRecord = new GenericData.Record(mapElementSchema);
        this.generateCustomValues((GenericRecord)customRecord, customPrefix);
        return Collections.singletonMap("customMapKey", customRecord);
    }

    public static List<String> recordsToStrings(List<HoodieRecord> records) {
        return records.stream().map(HoodieTestDataGenerator::recordToString).filter(Option::isPresent).map(Option::get).collect(Collectors.toList());
    }

    public static Option<String> recordToString(HoodieRecord record) {
        try {
            String str = ((GenericRecord)record.getData()).toString();
            str = str.substring(0, str.length() - 1);
            return Option.of((Object)(str + ", \"partition\": \"" + record.getPartitionPath() + "\"}"));
        }
        catch (Exception e) {
            return Option.empty();
        }
    }

    public static List<String> deleteRecordsToStrings(List<HoodieKey> records) {
        return records.stream().map(record -> "{\"_row_key\": \"" + record.getRecordKey() + "\",\"partition\": \"" + record.getPartitionPath() + "\"}").collect(Collectors.toList());
    }

    private static enum SchemaEvolutionTypePromotionCase {
        INT_TO_INT(Schema.Type.INT, Schema.Type.INT, config -> true),
        INT_TO_LONG(Schema.Type.INT, Schema.Type.LONG, config -> config.intToLongSupport),
        INT_TO_FLOAT(Schema.Type.INT, Schema.Type.FLOAT, config -> config.intToFloatSupport),
        INT_TO_DOUBLE(Schema.Type.INT, Schema.Type.DOUBLE, config -> config.intToDoubleSupport),
        INT_TO_STRING(Schema.Type.INT, Schema.Type.STRING, config -> config.intToStringSupport),
        LONG_TO_LONG(Schema.Type.LONG, Schema.Type.LONG, config -> true),
        LONG_TO_FLOAT(Schema.Type.LONG, Schema.Type.FLOAT, config -> config.longToFloatSupport),
        LONG_TO_DOUBLE(Schema.Type.LONG, Schema.Type.DOUBLE, config -> config.longToDoubleSupport),
        LONG_TO_STRING(Schema.Type.LONG, Schema.Type.STRING, config -> config.longToStringSupport),
        FLOAT_TO_FLOAT(Schema.Type.FLOAT, Schema.Type.FLOAT, config -> true),
        FLOAT_TO_DOUBLE(Schema.Type.FLOAT, Schema.Type.DOUBLE, config -> config.floatToDoubleSupport),
        FLOAT_TO_STRING(Schema.Type.FLOAT, Schema.Type.STRING, config -> config.floatToStringSupport),
        DOUBLE_TO_DOUBLE(Schema.Type.DOUBLE, Schema.Type.DOUBLE, config -> true),
        DOUBLE_TO_STRING(Schema.Type.DOUBLE, Schema.Type.STRING, config -> config.doubleToStringSupport),
        STRING_TO_STRING(Schema.Type.STRING, Schema.Type.STRING, config -> true),
        STRING_TO_BYTES(Schema.Type.STRING, Schema.Type.BYTES, config -> config.stringToBytesSupport),
        BYTES_TO_BYTES(Schema.Type.BYTES, Schema.Type.BYTES, config -> true),
        BYTES_TO_STRING(Schema.Type.BYTES, Schema.Type.STRING, config -> config.bytesToStringSupport);

        public final Schema.Type before;
        public final Schema.Type after;
        public final Predicate<SchemaEvolutionConfigs> isEnabled;

        private SchemaEvolutionTypePromotionCase(Schema.Type before, Schema.Type after, Predicate<SchemaEvolutionConfigs> isEnabled) {
            this.before = before;
            this.after = after;
            this.isEnabled = isEnabled;
        }
    }

    public static class SchemaEvolutionConfigs {
        public Schema schema = AVRO_SCHEMA;
        public boolean nestedSupport = true;
        public boolean mapSupport = true;
        public boolean arraySupport = true;
        public boolean addNewFieldSupport = true;
        public boolean anyArraySupport = true;
        public boolean intToLongSupport = true;
        public boolean intToFloatSupport = true;
        public boolean intToDoubleSupport = true;
        public boolean intToStringSupport = true;
        public boolean longToFloatSupport = true;
        public boolean longToDoubleSupport = true;
        public boolean longToStringSupport = true;
        public boolean floatToDoubleSupport = true;
        public boolean floatToStringSupport = true;
        public boolean doubleToStringSupport = true;
        public boolean stringToBytesSupport = true;
        public boolean bytesToStringSupport = true;
    }

    public static class RecordIdentifier {
        private final String recordKey;
        private final String orderingVal;
        private final String partitionPath;
        private final String riderValue;

        @JsonCreator
        public RecordIdentifier(@JsonProperty(value="recordKey") String recordKey, @JsonProperty(value="partitionPath") String partitionPath, @JsonProperty(value="orderingVal") String orderingVal, @JsonProperty(value="riderValue") String riderValue) {
            this.recordKey = recordKey;
            this.orderingVal = orderingVal;
            this.partitionPath = partitionPath;
            this.riderValue = riderValue;
        }

        public static RecordIdentifier clone(RecordIdentifier toClone, String orderingVal) {
            return new RecordIdentifier(toClone.recordKey, toClone.partitionPath, orderingVal, toClone.riderValue);
        }

        public static RecordIdentifier fromTripTestPayload(HoodieAvroIndexedRecord record, String[] orderingFields) {
            String recordKey = record.getRecordKey();
            String partitionPath = record.getPartitionPath();
            Comparable orderingValue = record.getOrderingValue(record.getData().getSchema(), CollectionUtils.emptyProps(), orderingFields);
            String orderingValStr = orderingValue.toString();
            String riderValue = ((GenericRecord)record.getData()).hasField("rider") ? ((GenericRecord)record.getData()).get("rider").toString() : HoodieTestDataGenerator.NO_PARTITION_PATH;
            return new RecordIdentifier(recordKey, partitionPath, orderingValStr, riderValue);
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RecordIdentifier that = (RecordIdentifier)o;
            return Objects.equals(this.recordKey, that.recordKey) && Objects.equals(this.orderingVal, that.orderingVal) && Objects.equals(this.partitionPath, that.partitionPath) && Objects.equals(this.riderValue, that.riderValue);
        }

        public int hashCode() {
            return Objects.hash(this.recordKey, this.orderingVal, this.partitionPath, this.riderValue);
        }

        public String getRecordKey() {
            return this.recordKey;
        }

        public String getOrderingVal() {
            return this.orderingVal;
        }

        public String getPartitionPath() {
            return this.partitionPath;
        }

        public String getRiderValue() {
            return this.riderValue;
        }

        public String toString() {
            return "RowKey: " + this.recordKey + ", PartitionPath: " + this.partitionPath + ", OrderingVal: " + this.orderingVal + ", RiderValue: " + this.riderValue;
        }
    }

    public static class KeyPartition
    implements Serializable {
        public HoodieKey key;
        public String partitionPath;
    }
}

