/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.MercifulJsonConverter;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;

public class RawTripTestPayload
implements HoodieRecordPayload<RawTripTestPayload> {
    private static final MercifulJsonConverter JSON_CONVERTER = new MercifulJsonConverter();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private String partitionPath;
    private String rowKey;
    private byte[] jsonDataCompressed;
    private int dataSize;
    private boolean isDeleted;
    private Comparable orderingVal;

    public RawTripTestPayload(String jsonData) throws IOException {
        this.jsonDataCompressed = this.compressData(jsonData);
        this.dataSize = jsonData.length();
        Map jsonRecordMap = (Map)OBJECT_MAPPER.readValue(jsonData, Map.class);
        this.rowKey = jsonRecordMap.get("_row_key").toString();
        this.partitionPath = HoodieTestUtils.extractPartitionFromTimeField(jsonRecordMap.get("time").toString());
        this.isDeleted = false;
        this.orderingVal = Integer.valueOf(((Object)jsonRecordMap.getOrDefault("number", 0)).toString());
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public RawTripTestPayload preCombine(RawTripTestPayload oldValue) {
        if (!this.orderingVal.equals(0) && oldValue.orderingVal.compareTo(this.orderingVal) > 0) {
            return oldValue;
        }
        return this;
    }

    public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord oldRec, Schema schema) throws IOException {
        return this.getInsertValue(schema);
    }

    public Option<IndexedRecord> getInsertValue(Schema schema) throws IOException {
        if (this.isDeleted) {
            return Option.empty();
        }
        return Option.of((Object)JSON_CONVERTER.convert(this.getJsonData(), schema));
    }

    public Comparable<?> getOrderingValue() {
        return this.orderingVal;
    }

    public IndexedRecord getRecordToInsert(Schema schema) throws IOException {
        return JSON_CONVERTER.convert(this.getJsonData(), schema);
    }

    public Option<Map<String, String>> getMetadata() {
        HashMap<String, String> metadataMap = new HashMap<String, String>();
        metadataMap.put("InputRecordCount_1506582000", "2");
        return Option.of(metadataMap);
    }

    public String getRowKey() {
        return this.rowKey;
    }

    public String getJsonData() throws IOException {
        return this.unCompressData(this.jsonDataCompressed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] compressData(String jsonData) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)baos, new Deflater(9), true);
        try {
            dos.write(StringUtils.getUTF8Bytes((String)jsonData));
        }
        finally {
            dos.flush();
            dos.close();
        }
        return baos.toByteArray();
    }

    private String unCompressData(byte[] data) throws IOException {
        try (InflaterInputStream iis = new InflaterInputStream(new ByteArrayInputStream(data));){
            String string = FileIOUtils.readAsUTFString((InputStream)iis, (int)this.dataSize);
            return string;
        }
    }
}

