/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils.reader;

import java.util.List;

public class DataGenerationPlan {
    private final List<String> recordKeys;
    private final String partitionPath;
    private final long timestamp;
    private final OperationType operationType;
    private final String instantTime;
    private final boolean writePositions;

    public DataGenerationPlan(List<String> recordKeys, String partitionPath, long timestamp, OperationType operationType, String instantTime, boolean writePositions) {
        this.recordKeys = recordKeys;
        this.partitionPath = partitionPath;
        this.timestamp = timestamp;
        this.operationType = operationType;
        this.instantTime = instantTime;
        this.writePositions = writePositions;
    }

    public List<String> getRecordKeys() {
        return this.recordKeys;
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public String getInstantTime() {
        return this.instantTime;
    }

    public boolean getWritePositions() {
        return this.writePositions;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private List<String> recordKeys;
        private String partitionPath;
        private long timestamp;
        private OperationType operationType;
        private String instantTime;
        private boolean writePositions;

        public Builder withRecordKeys(List<String> recordKeys) {
            this.recordKeys = recordKeys;
            return this;
        }

        public Builder withPartitionPath(String partitionPath) {
            this.partitionPath = partitionPath;
            return this;
        }

        public Builder withTimeStamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder withOperationType(OperationType operationType) {
            this.operationType = operationType;
            return this;
        }

        public Builder withInstantTime(String instantTime) {
            this.instantTime = instantTime;
            return this;
        }

        public Builder withWritePositions(boolean writePositions) {
            this.writePositions = writePositions;
            return this;
        }

        public DataGenerationPlan build() {
            return new DataGenerationPlan(this.recordKeys, this.partitionPath, this.timestamp, this.operationType, this.instantTime, this.writePositions);
        }
    }

    public static enum OperationType {
        INSERT,
        UPDATE,
        DELETE;

    }
}

