/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils.reader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.bloom.BloomFilterTypeCode;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.LocalTaskContextSupplier;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.DeleteRecord;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieAvroDataBlock;
import org.apache.hudi.common.table.log.block.HoodieCDCDataBlock;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieDeleteBlock;
import org.apache.hudi.common.table.log.block.HoodieHFileDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.log.block.HoodieParquetDataBlock;
import org.apache.hudi.common.testutils.FileCreateUtilsLegacy;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.reader.DataGenerationPlan;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.io.storage.HoodieAvroFileWriter;
import org.apache.hudi.io.storage.HoodieFileWriterFactory;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;

public class HoodieFileSliceTestUtils {
    public static final String FORWARD_SLASH = "/";
    public static final String PARQUET = ".parquet";
    public static final String DRIVER = "driver";
    public static final String PARTITION_PATH = "partition_path";
    public static final String RIDER = "rider";
    public static final String ROW_KEY = "_row_key";
    public static final int RECORD_KEY_INDEX = HoodieTestDataGenerator.AVRO_SCHEMA.getField("_row_key").pos();
    public static final String TIMESTAMP = "timestamp";
    public static final HoodieTestDataGenerator DATA_GEN = new HoodieTestDataGenerator(57069L);
    public static final TypedProperties PROPERTIES = new TypedProperties();
    private static String[] orderingFields = new String[]{"timestamp"};

    private static Path generateBaseFilePath(String basePath, String fileId, String instantTime) {
        return new Path(basePath + FORWARD_SLASH + FileCreateUtilsLegacy.baseFileName(instantTime, fileId, PARQUET));
    }

    private static Path generateLogFilePath(String basePath, String fileId, String instantTime, int version) {
        return new Path(basePath + FORWARD_SLASH + FileCreateUtilsLegacy.logFileName(instantTime, fileId, version));
    }

    private static List<String> generateKeys(KeyRange range) {
        List<String> keys = new ArrayList<String>();
        if (range.start == range.end) {
            keys.add(String.valueOf(range.start));
        } else {
            keys = IntStream.rangeClosed(range.start, range.end).boxed().map(String::valueOf).collect(Collectors.toList());
        }
        return keys;
    }

    private static List<IndexedRecord> generateRecords(DataGenerationPlan plan) {
        ArrayList<IndexedRecord> records = new ArrayList<IndexedRecord>();
        List<String> keys = plan.getRecordKeys();
        for (String key : keys) {
            records.add((IndexedRecord)DATA_GEN.generateGenericRecord(key, plan.getPartitionPath(), "rider." + UUID.randomUUID(), "driver." + UUID.randomUUID(), plan.getTimestamp(), plan.getOperationType() == DataGenerationPlan.OperationType.DELETE, false));
        }
        return records;
    }

    private static HoodieDataBlock getDataBlock(HoodieLogBlock.HoodieLogBlockType dataBlockType, List<IndexedRecord> records, Map<HoodieLogBlock.HeaderMetadataType, String> header, StoragePath logFilePath, Map<String, Long> keyToPositionMap) {
        return HoodieFileSliceTestUtils.createDataBlock(dataBlockType, records.stream().map(r -> new HoodieAvroIndexedRecord(r, new HoodieRecordLocation("", "", ((Long)keyToPositionMap.get(r.get(RECORD_KEY_INDEX))).longValue()))).collect(Collectors.toList()), header, logFilePath);
    }

    private static HoodieDataBlock createDataBlock(HoodieLogBlock.HoodieLogBlockType dataBlockType, List<HoodieRecord> records, Map<HoodieLogBlock.HeaderMetadataType, String> header, StoragePath pathForReader) {
        switch (dataBlockType) {
            case CDC_DATA_BLOCK: {
                header.remove(HoodieLogBlock.HeaderMetadataType.BASE_FILE_INSTANT_TIME_OF_RECORD_POSITIONS);
                return new HoodieCDCDataBlock(records, header, HoodieRecord.RECORD_KEY_METADATA_FIELD);
            }
            case AVRO_DATA_BLOCK: {
                return new HoodieAvroDataBlock(records, header, HoodieRecord.RECORD_KEY_METADATA_FIELD);
            }
            case HFILE_DATA_BLOCK: {
                header.remove(HoodieLogBlock.HeaderMetadataType.BASE_FILE_INSTANT_TIME_OF_RECORD_POSITIONS);
                return new HoodieHFileDataBlock(records, header, (String)HoodieStorageConfig.HFILE_COMPRESSION_ALGORITHM_NAME.defaultValue(), pathForReader);
            }
            case PARQUET_DATA_BLOCK: {
                return new HoodieParquetDataBlock(records, header, HoodieRecord.RECORD_KEY_METADATA_FIELD, (String)HoodieStorageConfig.PARQUET_COMPRESSION_CODEC_NAME.defaultValue(), 0.1, true);
            }
        }
        throw new RuntimeException("Unknown data block type " + dataBlockType);
    }

    public static HoodieDeleteBlock getDeleteBlock(List<IndexedRecord> records, Map<HoodieLogBlock.HeaderMetadataType, String> header, Schema schema, Properties props, Map<String, Long> keyToPositionMap) {
        List hoodieRecords = records.stream().map(r -> {
            String rowKey = (String)r.get(r.getSchema().getField(ROW_KEY).pos());
            String partitionPath = (String)r.get(r.getSchema().getField(PARTITION_PATH).pos());
            return new HoodieAvroIndexedRecord(new HoodieKey(rowKey, partitionPath), r, null, new HoodieRecordLocation("", "", ((Long)keyToPositionMap.get(r.get(RECORD_KEY_INDEX))).longValue()));
        }).collect(Collectors.toList());
        return new HoodieDeleteBlock(hoodieRecords.stream().map(r -> Pair.of((Object)DeleteRecord.create((HoodieKey)r.getKey(), (Comparable)r.getOrderingValue(schema, props, orderingFields)), (Object)r.getCurrentLocation().getPosition())).collect(Collectors.toList()), header);
    }

    public static HoodieBaseFile createBaseFile(String baseFilePath, List<IndexedRecord> records, Schema schema, String baseInstantTime) throws IOException {
        HoodieStorage storage = HoodieTestUtils.getStorage(baseFilePath);
        HoodieConfig cfg = new HoodieConfig();
        cfg.setValue(HoodieTableConfig.POPULATE_META_FIELDS.key(), "true");
        cfg.setValue(HoodieStorageConfig.PARQUET_WITH_BLOOM_FILTER_ENABLED.key(), "true");
        cfg.setValue(HoodieStorageConfig.BLOOM_FILTER_NUM_ENTRIES_VALUE.key(), String.valueOf(1000));
        cfg.setValue(HoodieStorageConfig.BLOOM_FILTER_FPP_VALUE.key(), String.valueOf(1.0E-5));
        cfg.setValue(HoodieStorageConfig.BLOOM_FILTER_DYNAMIC_MAX_ENTRIES.key(), String.valueOf(10000));
        cfg.setValue(HoodieStorageConfig.BLOOM_FILTER_TYPE.key(), BloomFilterTypeCode.DYNAMIC_V0.name());
        cfg.setValue(HoodieStorageConfig.PARQUET_COMPRESSION_CODEC_NAME.key(), CompressionCodecName.GZIP.name());
        cfg.setValue(HoodieStorageConfig.PARQUET_BLOCK_SIZE.key(), String.valueOf(0x8000000));
        cfg.setValue(HoodieStorageConfig.PARQUET_PAGE_SIZE.key(), String.valueOf(0x100000));
        cfg.setValue(HoodieStorageConfig.PARQUET_MAX_FILE_SIZE.key(), String.valueOf(0x40000000));
        cfg.setValue(HoodieStorageConfig.PARQUET_COMPRESSION_RATIO_FRACTION.key(), String.valueOf(0.1));
        cfg.setValue(HoodieStorageConfig.PARQUET_DICTIONARY_ENABLED.key(), "true");
        try (HoodieAvroFileWriter writer = (HoodieAvroFileWriter)HoodieFileWriterFactory.getFileWriter((String)baseInstantTime, (StoragePath)new StoragePath(baseFilePath), (HoodieStorage)storage, (HoodieConfig)cfg, (Schema)schema, (TaskContextSupplier)new LocalTaskContextSupplier(), (HoodieRecord.HoodieRecordType)HoodieRecord.HoodieRecordType.AVRO);){
            for (IndexedRecord record : records) {
                writer.writeAvro((String)record.get(schema.getField(ROW_KEY).pos()), record);
            }
        }
        return new HoodieBaseFile(baseFilePath);
    }

    public static HoodieLogFile createLogFile(HoodieStorage storage, String logFilePath, List<IndexedRecord> records, Schema schema, String fileId, String baseFileInstantTime, String logInstantTime, int version, HoodieLogBlock.HoodieLogBlockType blockType, boolean writePositions, Map<String, Long> keyToPositionMap) throws InterruptedException, IOException {
        try (HoodieLogFormat.Writer writer = HoodieLogFormat.newWriterBuilder().onParentPath(new StoragePath(logFilePath).getParent()).withFileExtension(".log").withFileId(fileId).withInstantTime(logInstantTime).withLogVersion(version).withStorage(storage).build();){
            HashMap<HoodieLogBlock.HeaderMetadataType, String> header = new HashMap<HoodieLogBlock.HeaderMetadataType, String>();
            header.put(HoodieLogBlock.HeaderMetadataType.INSTANT_TIME, logInstantTime);
            header.put(HoodieLogBlock.HeaderMetadataType.SCHEMA, schema.toString());
            if (writePositions) {
                header.put(HoodieLogBlock.HeaderMetadataType.BASE_FILE_INSTANT_TIME_OF_RECORD_POSITIONS, baseFileInstantTime);
            }
            if (blockType != HoodieLogBlock.HoodieLogBlockType.DELETE_BLOCK) {
                HoodieDataBlock dataBlock = HoodieFileSliceTestUtils.getDataBlock(blockType, records, header, new StoragePath(logFilePath), keyToPositionMap);
                writer.appendBlock((HoodieLogBlock)dataBlock);
            } else {
                HoodieDeleteBlock deleteBlock = HoodieFileSliceTestUtils.getDeleteBlock(records, header, schema, (Properties)PROPERTIES, keyToPositionMap);
                writer.appendBlock((HoodieLogBlock)deleteBlock);
            }
        }
        return new HoodieLogFile(logFilePath);
    }

    public static FileSlice generateFileSlice(HoodieStorage storage, String basePath, String fileId, String partitionPath, Schema schema, List<DataGenerationPlan> plans) throws IOException, InterruptedException {
        assert (!plans.isEmpty());
        HoodieBaseFile baseFile = null;
        ArrayList<HoodieLogFile> logFiles = new ArrayList<HoodieLogFile>();
        HashMap<String, Long> keyToPositionMap = new HashMap<String, Long>();
        DataGenerationPlan baseFilePlan = plans.get(0);
        if (!baseFilePlan.getRecordKeys().isEmpty()) {
            Path baseFilePath = HoodieFileSliceTestUtils.generateBaseFilePath(basePath, fileId, baseFilePlan.getInstantTime());
            List<IndexedRecord> records = HoodieFileSliceTestUtils.generateRecords(baseFilePlan);
            baseFile = HoodieFileSliceTestUtils.createBaseFile(baseFilePath.toString(), records, schema, baseFilePlan.getInstantTime());
            for (int i = 0; i < baseFilePlan.getRecordKeys().size(); ++i) {
                keyToPositionMap.put(baseFilePlan.getRecordKeys().get(i), Long.valueOf(i));
            }
        }
        for (int i = 1; i < plans.size(); ++i) {
            DataGenerationPlan logFilePlan = plans.get(i);
            if (logFilePlan.getRecordKeys().isEmpty()) continue;
            Path logFile = HoodieFileSliceTestUtils.generateLogFilePath(basePath, fileId, logFilePlan.getInstantTime(), i);
            List<IndexedRecord> records = HoodieFileSliceTestUtils.generateRecords(logFilePlan);
            HoodieLogBlock.HoodieLogBlockType blockType = logFilePlan.getOperationType() == DataGenerationPlan.OperationType.DELETE ? HoodieLogBlock.HoodieLogBlockType.DELETE_BLOCK : HoodieLogBlock.HoodieLogBlockType.PARQUET_DATA_BLOCK;
            logFiles.add(HoodieFileSliceTestUtils.createLogFile(storage, logFile.toString(), records, schema, fileId, baseFilePlan.getInstantTime(), logFilePlan.getInstantTime(), i, blockType, logFilePlan.getWritePositions(), keyToPositionMap));
        }
        HoodieFileGroupId fileGroupId = new HoodieFileGroupId(partitionPath, fileId);
        String baseInstantTime = baseFile == null ? null : baseFile.getCommitTime();
        return new FileSlice(fileGroupId, baseInstantTime, baseFile, logFiles);
    }

    public static Option<FileSlice> getBaseFileOnlyFileSlice(HoodieStorage storage, KeyRange range, long timestamp, String basePath, String partitionPath, String fileId, String baseInstantTime) throws IOException, InterruptedException {
        List<String> keys = HoodieFileSliceTestUtils.generateKeys(range);
        ArrayList<DataGenerationPlan> plans = new ArrayList<DataGenerationPlan>();
        DataGenerationPlan baseFilePlan = DataGenerationPlan.newBuilder().withRecordKeys(keys).withOperationType(DataGenerationPlan.OperationType.INSERT).withPartitionPath(partitionPath).withTimeStamp(timestamp).withInstantTime(baseInstantTime).withWritePositions(false).build();
        plans.add(baseFilePlan);
        return Option.of((Object)HoodieFileSliceTestUtils.generateFileSlice(storage, basePath, fileId, partitionPath, HoodieTestDataGenerator.AVRO_SCHEMA, plans));
    }

    public static Option<FileSlice> getFileSlice(HoodieStorage storage, List<KeyRange> ranges, List<Long> timestamps, List<DataGenerationPlan.OperationType> operationTypes, List<String> instantTimes, List<Boolean> shouldWritePositions, String basePath, String partitionPath, String fileId) throws IOException, InterruptedException {
        ArrayList<DataGenerationPlan> plans = new ArrayList<DataGenerationPlan>();
        for (int i = 0; i < ranges.size(); ++i) {
            List<String> keys = HoodieFileSliceTestUtils.generateKeys(ranges.get(i));
            plans.add(DataGenerationPlan.newBuilder().withOperationType(operationTypes.get(i)).withPartitionPath(partitionPath).withRecordKeys(keys).withTimeStamp(timestamps.get(i)).withInstantTime(instantTimes.get(i)).withWritePositions(shouldWritePositions.get(i)).build());
        }
        return Option.of((Object)HoodieFileSliceTestUtils.generateFileSlice(storage, basePath, fileId, partitionPath, HoodieTestDataGenerator.AVRO_SCHEMA, plans));
    }

    public static class KeyRange {
        public int start;
        public int end;

        public KeyRange(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

