/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.hudi.common.util.Base64CodecUtil;
import org.apache.hudi.common.util.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBase64CodecUtil {
    @Test
    public void testCodec() {
        int times = 100;
        UUID uuid = UUID.randomUUID();
        for (int i = 0; i < times; ++i) {
            byte[] originalData = StringUtils.getUTF8Bytes((String)uuid.toString());
            String encodeData = Base64CodecUtil.encode((byte[])originalData);
            byte[] decodeData = Base64CodecUtil.decode((String)encodeData);
            ByteBuffer encodedByteBuffer = ByteBuffer.wrap(StringUtils.getUTF8Bytes((String)encodeData));
            ByteBuffer decodeByteBuffer = Base64CodecUtil.decode((ByteBuffer)encodedByteBuffer);
            Assertions.assertArrayEquals((byte[])originalData, (byte[])decodeData);
            Assertions.assertArrayEquals((byte[])originalData, (byte[])decodeByteBuffer.array());
        }
    }
}

