/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hudi.common.util.CollectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestCollectionUtils {
    TestCollectionUtils() {
    }

    @Test
    void getBatchesFromList() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> CollectionUtils.batches(Collections.emptyList(), (int)-1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> CollectionUtils.batches(Collections.emptyList(), (int)0));
        Assertions.assertEquals(Collections.emptyList(), (Object)CollectionUtils.batches(Collections.emptyList(), (int)1));
        List intsBatches1 = CollectionUtils.batches(Arrays.asList(1, 2, 3, 4, 5, 6), (int)3);
        Assertions.assertEquals((int)2, (int)intsBatches1.size());
        Assertions.assertEquals(Arrays.asList(1, 2, 3), intsBatches1.get(0));
        Assertions.assertEquals(Arrays.asList(4, 5, 6), intsBatches1.get(1));
        List intsBatches2 = CollectionUtils.batches(Arrays.asList(1, 2, 3, 4, 5, 6), (int)5);
        Assertions.assertEquals((int)2, (int)intsBatches2.size());
        Assertions.assertEquals(Arrays.asList(1, 2, 3, 4, 5), intsBatches2.get(0));
        Assertions.assertEquals(Collections.singletonList(6), intsBatches2.get(1));
    }
}

