/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestConfigUtils {
    public static final ConfigProperty<String> TEST_BOOLEAN_CONFIG_PROPERTY = ConfigProperty.key((String)"hoodie.test.boolean.config").defaultValue((Object)"true").withAlternatives(new String[]{"hudi.test.boolean.config"}).markAdvanced().withDocumentation("Testing boolean config.");

    private static Stream<Arguments> separatorArgs() {
        ArrayList<Option> separatorList = new ArrayList<Option>();
        separatorList.add(Option.empty());
        separatorList.add(Option.of((Object)"\n"));
        separatorList.add(Option.of((Object)","));
        return separatorList.stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @MethodSource(value={"separatorArgs"})
    void testToMapSucceeds(Option<String> separator) {
        String sepString = separator.isPresent() ? (String)separator.get() : "\n";
        HashMap<String, String> expectedMap = new HashMap<String, String>();
        expectedMap.put("k.1.1.2", "v1");
        expectedMap.put("k.2.1.2", "v2");
        expectedMap.put("k.3.1.2", "v3");
        String srcKv = String.format("k.1.1.2=v1%sk.2.1.2=v2%sk.3.1.2=v3", sepString, sepString);
        Map<String, String> outMap = this.toMap(srcKv, separator);
        Assertions.assertEquals(expectedMap, outMap);
        srcKv = String.format("k.1.1.2=v1%sk.2.1.2=v2%sk.3.1.2=v3%s", sepString, sepString, sepString);
        outMap = this.toMap(srcKv, separator);
        Assertions.assertEquals(expectedMap, outMap);
        srcKv = String.format("k.1.1.2=v1%sk.2.1.2=v2%s%sk.3.1.2=v3", sepString, sepString, sepString);
        outMap = this.toMap(srcKv, separator);
        Assertions.assertEquals(expectedMap, outMap);
        srcKv = String.format("k.1.1.2=v1%s  %sk.2.1.2=v2%s%sk.3.1.2=v3", sepString, sepString, sepString, sepString);
        outMap = this.toMap(srcKv, separator);
        Assertions.assertEquals(expectedMap, outMap);
        srcKv = String.format(" k.1.1.2 =   v1%s k.2.1.2 = v2 %sk.3.1.2 = v3", sepString, sepString);
        outMap = this.toMap(srcKv, separator);
        Assertions.assertEquals(expectedMap, outMap);
    }

    @Test
    void testGetRawValueWithAltKeys() {
        TypedProperties properties = new TypedProperties();
        ExternalSpillableMap.DiskMapType diskMapType = (ExternalSpillableMap.DiskMapType)ConfigUtils.getRawValueWithAltKeys((Properties)properties, (ConfigProperty)HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE, (boolean)true);
        Assertions.assertEquals((Object)ExternalSpillableMap.DiskMapType.BITCASK, (Object)diskMapType);
        properties.put((Object)HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE.key(), (Object)ExternalSpillableMap.DiskMapType.ROCKS_DB);
        diskMapType = (ExternalSpillableMap.DiskMapType)ConfigUtils.getRawValueWithAltKeys((Properties)properties, (ConfigProperty)HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE, (boolean)true);
        Assertions.assertEquals((Object)ExternalSpillableMap.DiskMapType.ROCKS_DB, (Object)diskMapType);
        properties.remove((Object)HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE.key());
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            ExternalSpillableMap.DiskMapType cfr_ignored_0 = (ExternalSpillableMap.DiskMapType)ConfigUtils.getRawValueWithAltKeys((Properties)properties, (ConfigProperty)HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE, (boolean)false);
        });
    }

    @ParameterizedTest
    @MethodSource(value={"separatorArgs"})
    void testToMapThrowError(Option<String> separator) {
        String sepString = separator.isPresent() ? (String)separator.get() : "\n";
        String srcKv = String.format("k.1.1.2=v1=v1.1%sk.2.1.2=v2%sk.3.1.2=v3", sepString, sepString);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.toMap(srcKv, separator));
    }

    @Test
    void testShouldTrackEventTimeWaterMarkByConfig() {
        TypedProperties props = new TypedProperties();
        Assertions.assertFalse((boolean)ConfigUtils.isTrackingEventTimeWatermark((TypedProperties)props));
        props.put((Object)"hoodie.write.track.event.time.watermark", (Object)"true");
        Assertions.assertTrue((boolean)ConfigUtils.isTrackingEventTimeWatermark((TypedProperties)props));
        props.put((Object)"hoodie.write.track.event.time.watermark", (Object)"false");
        Assertions.assertFalse((boolean)ConfigUtils.isTrackingEventTimeWatermark((TypedProperties)props));
        props.put((Object)"hoodie.write.track.event.time.watermark", (Object)true);
        Assertions.assertTrue((boolean)ConfigUtils.isTrackingEventTimeWatermark((TypedProperties)props));
        props.put((Object)"hoodie.write.track.event.time.watermark", (Object)false);
        Assertions.assertFalse((boolean)ConfigUtils.isTrackingEventTimeWatermark((TypedProperties)props));
    }

    @Test
    void testShouldKeepConsistentLogicalTimestamp() {
        TypedProperties props = new TypedProperties();
        Assertions.assertFalse((boolean)ConfigUtils.shouldKeepConsistentLogicalTimestamp((TypedProperties)props));
        props.put((Object)KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.key(), (Object)"true");
        Assertions.assertTrue((boolean)ConfigUtils.shouldKeepConsistentLogicalTimestamp((TypedProperties)props));
        props.put((Object)KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.key(), (Object)"false");
        Assertions.assertFalse((boolean)ConfigUtils.shouldKeepConsistentLogicalTimestamp((TypedProperties)props));
        props.put((Object)KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.key(), (Object)true);
        Assertions.assertTrue((boolean)ConfigUtils.shouldKeepConsistentLogicalTimestamp((TypedProperties)props));
        props.put((Object)KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.key(), (Object)false);
        Assertions.assertFalse((boolean)ConfigUtils.shouldKeepConsistentLogicalTimestamp((TypedProperties)props));
    }

    @Test
    void testGetEventTimeFieldName() {
        TypedProperties props = new TypedProperties();
        Assertions.assertFalse((ConfigUtils.getEventTimeFieldName((TypedProperties)props) != null ? 1 : 0) != 0);
        String eventTimeField = "event_timestamp";
        props.put((Object)"hoodie.payload.event.time.field", (Object)eventTimeField);
        Assertions.assertNotNull((Object)ConfigUtils.getEventTimeFieldName((TypedProperties)props));
        Assertions.assertEquals((Object)eventTimeField, (Object)ConfigUtils.getEventTimeFieldName((TypedProperties)props));
        String anotherField = "created_at";
        props.put((Object)"hoodie.payload.event.time.field", (Object)anotherField);
        Assertions.assertNotNull((Object)ConfigUtils.getEventTimeFieldName((TypedProperties)props));
        Assertions.assertEquals((Object)anotherField, (Object)ConfigUtils.getEventTimeFieldName((TypedProperties)props));
        props.put((Object)"hoodie.payload.event.time.field", (Object)"");
        Assertions.assertNotNull((Object)ConfigUtils.getEventTimeFieldName((TypedProperties)props));
        Assertions.assertEquals((Object)"", (Object)ConfigUtils.getEventTimeFieldName((TypedProperties)props));
    }

    private Map<String, String> toMap(String config, Option<String> separator) {
        if (separator.isEmpty()) {
            return ConfigUtils.toMap((String)config);
        }
        return ConfigUtils.toMap((String)config, (String)((String)separator.get()));
    }

    @Test
    void testParseValidProperties() {
        TypedProperties props = new TypedProperties();
        props.setProperty("hoodie.record.merge.property.Ki", "Vi");
        Map result = ConfigUtils.extractWithPrefix((TypedProperties)props, (String)"hoodie.record.merge.property.");
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertEquals((Object)"Vi", result.get("Ki"));
    }

    @Test
    void testMissingKeyReturnsEmptyMap() {
        TypedProperties props = new TypedProperties();
        Map result = ConfigUtils.extractWithPrefix((TypedProperties)props, (String)"hoodie.record.merge.property.");
        Assertions.assertTrue((boolean)result.isEmpty());
    }

    @Test
    void testMultipleValidProperties() {
        TypedProperties props = new TypedProperties();
        props.setProperty("hoodie.record.merge.property.key1", "value1");
        props.setProperty("hoodie.record.merge.property.key2", "value2");
        props.setProperty("hoodie.record.merge.property.key3", "value3");
        Map result = ConfigUtils.extractWithPrefix((TypedProperties)props, (String)"hoodie.record.merge.property.");
        Assertions.assertEquals((int)3, (int)result.size());
        Assertions.assertEquals((Object)"value1", result.get("key1"));
        Assertions.assertEquals((Object)"value2", result.get("key2"));
        Assertions.assertEquals((Object)"value3", result.get("key3"));
    }

    @Test
    void testPropertiesWithDifferentPrefixes() {
        TypedProperties props = new TypedProperties();
        props.setProperty("hoodie.record.merge.property.mergeKey", "mergeValue");
        props.setProperty("other.prefix.key", "otherValue");
        props.setProperty("hoodie.merge.custom.property", "directPrefixValue");
        Map result = ConfigUtils.extractWithPrefix((TypedProperties)props, (String)"hoodie.record.merge.property.");
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertEquals((Object)"mergeValue", result.get("mergeKey"));
    }

    @Test
    void testPropertiesWithEmptyValues() {
        TypedProperties props = new TypedProperties();
        props.setProperty("hoodie.record.merge.property.emptyKey", "");
        Map result = ConfigUtils.extractWithPrefix((TypedProperties)props, (String)"hoodie.record.merge.property.");
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertEquals((Object)"", result.get("emptyKey"));
    }

    @Test
    void testPropertiesWithSpecialCharacters() {
        TypedProperties props = new TypedProperties();
        props.setProperty("hoodie.record.merge.property.key.with.dots", "value.with.dots");
        props.setProperty("hoodie.record.merge.property.key_with_underscores", "value_with_underscores");
        props.setProperty("hoodie.record.merge.property.key-with-dashes", "value-with-dashes");
        Map result = ConfigUtils.extractWithPrefix((TypedProperties)props, (String)"hoodie.record.merge.property.");
        Assertions.assertEquals((int)3, (int)result.size());
        Assertions.assertEquals((Object)"value.with.dots", result.get("key.with.dots"));
        Assertions.assertEquals((Object)"value_with_underscores", result.get("key_with_underscores"));
        Assertions.assertEquals((Object)"value-with-dashes", result.get("key-with-dashes"));
    }

    @Test
    void testPropertiesWithNumericValues() {
        TypedProperties props = new TypedProperties();
        props.setProperty("hoodie.record.merge.property.intKey", "123");
        props.setProperty("hoodie.record.merge.property.doubleKey", "123.45");
        props.setProperty("hoodie.record.merge.property.booleanKey", "true");
        Map result = ConfigUtils.extractWithPrefix((TypedProperties)props, (String)"hoodie.record.merge.property.");
        Assertions.assertEquals((int)3, (int)result.size());
        Assertions.assertEquals((Object)"123", result.get("intKey"));
        Assertions.assertEquals((Object)"123.45", result.get("doubleKey"));
        Assertions.assertEquals((Object)"true", result.get("booleanKey"));
    }

    @Test
    void testPropertiesWithWhitespace() {
        TypedProperties props = new TypedProperties();
        props.setProperty("hoodie.record.merge.property.  spacedKey  ", "  spacedValue  ");
        Map result = ConfigUtils.extractWithPrefix((TypedProperties)props, (String)"hoodie.record.merge.property.");
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertEquals((Object)"spacedValue", result.get("spacedKey"));
    }

    @Test
    void testPropertiesWithWhitespaceInKeysAndValues() {
        TypedProperties props = new TypedProperties();
        props.setProperty("hoodie.record.merge.property.  keyWithSpaces  ", "  valueWithSpaces  ");
        props.setProperty("hoodie.record.merge.property.keyWithoutSpaces", "valueWithoutSpaces");
        Map result = ConfigUtils.extractWithPrefix((TypedProperties)props, (String)"hoodie.record.merge.property.");
        Assertions.assertEquals((int)2, (int)result.size());
        Assertions.assertEquals((Object)"valueWithSpaces", result.get("keyWithSpaces"));
        Assertions.assertEquals((Object)"valueWithoutSpaces", result.get("keyWithoutSpaces"));
    }

    @Test
    void testPropertiesWithExactPrefixMatch() {
        TypedProperties props = new TypedProperties();
        props.setProperty("hoodie.record.merge.property.", "exactPrefixValue");
        Map result = ConfigUtils.extractWithPrefix((TypedProperties)props, (String)"hoodie.record.merge.property.");
        Assertions.assertEquals((int)0, (int)result.size());
    }

    @Test
    void testPropertiesWithPrefixFollowedByDot() {
        TypedProperties props = new TypedProperties();
        props.setProperty("hoodie.record.merge.property.", "valueAfterDot");
        Map result = ConfigUtils.extractWithPrefix((TypedProperties)props, (String)"hoodie.record.merge.property.");
        Assertions.assertEquals((int)0, (int)result.size());
    }

    @Test
    void testPropertiesWithWhitespaceOnlyKeys() {
        TypedProperties props = new TypedProperties();
        props.setProperty("hoodie.record.merge.property.   ", "valueForWhitespaceKey");
        props.setProperty("hoodie.record.merge.property.  \t  \n  ", "valueForTabNewlineKey");
        Map result = ConfigUtils.extractWithPrefix((TypedProperties)props, (String)"hoodie.record.merge.property.");
        Assertions.assertEquals((int)0, (int)result.size());
    }

    @Test
    void testPropertiesWithNullKeys() {
        TypedProperties props = new TypedProperties();
        props.setProperty("hoodie.record.merge.property.", "valueForNullKey");
        Map result = ConfigUtils.extractWithPrefix((TypedProperties)props, (String)"hoodie.record.merge.property.");
        Assertions.assertEquals((int)0, (int)result.size());
    }

    @Test
    void testPropertiesWithMixedValidAndInvalidKeys() {
        TypedProperties props = new TypedProperties();
        props.setProperty("hoodie.record.merge.property.validKey", "validValue");
        props.setProperty("hoodie.record.merge.property.   ", "invalidValue1");
        props.setProperty("hoodie.record.merge.property.", "invalidValue2");
        props.setProperty("hoodie.record.merge.property.anotherValidKey", "anotherValidValue");
        Map result = ConfigUtils.extractWithPrefix((TypedProperties)props, (String)"hoodie.record.merge.property.");
        Assertions.assertEquals((int)2, (int)result.size());
        Assertions.assertEquals((Object)"validValue", result.get("validKey"));
        Assertions.assertEquals((Object)"anotherValidValue", result.get("anotherValidKey"));
    }

    @Test
    void testPropertiesWithCaseSensitivity() {
        TypedProperties props = new TypedProperties();
        props.setProperty("hoodie.record.merge.property.Key1", "Value1");
        props.setProperty("hoodie.record.merge.property.key1", "value1");
        Map result = ConfigUtils.extractWithPrefix((TypedProperties)props, (String)"hoodie.record.merge.property.");
        Assertions.assertEquals((int)2, (int)result.size());
        Assertions.assertEquals((Object)"Value1", result.get("Key1"));
        Assertions.assertEquals((Object)"value1", result.get("key1"));
    }

    @Test
    void testPropertiesWithLeadingAndTrailingWhitespace() {
        TypedProperties props = new TypedProperties();
        props.setProperty("hoodie.record.merge.property.  leadingSpaceKey", "trailingSpaceValue  ");
        props.setProperty("hoodie.record.merge.property.trailingSpaceKey  ", "  leadingSpaceValue");
        Map result = ConfigUtils.extractWithPrefix((TypedProperties)props, (String)"hoodie.record.merge.property.");
        Assertions.assertEquals((int)2, (int)result.size());
        Assertions.assertEquals((Object)"trailingSpaceValue", result.get("leadingSpaceKey"));
        Assertions.assertEquals((Object)"leadingSpaceValue", result.get("trailingSpaceKey"));
    }

    @Test
    void testNullProperties() {
        Map result = ConfigUtils.extractWithPrefix(null, (String)"hoodie.record.merge.property.");
        Assertions.assertTrue((boolean)result.isEmpty());
    }

    @Test
    void testParseRecordMergePropertiesWithPrefixedProperties() {
        TypedProperties tableProps = new TypedProperties();
        tableProps.put((Object)"hoodie.record.merge.property.strategy", (Object)"overwrite");
        tableProps.put((Object)"hoodie.record.merge.property.field", (Object)"col1");
        HoodieTableConfig tableConfig = new HoodieTableConfig();
        tableConfig.getProps().putAll((Map)tableProps);
        TypedProperties props = ConfigUtils.getMergeProps((TypedProperties)new TypedProperties(), (HoodieTableConfig)tableConfig);
        props.put((Object)"unrelated.key", (Object)"value");
        Assertions.assertEquals((Object)"overwrite", (Object)props.get((Object)"strategy"));
        Assertions.assertEquals((Object)"col1", (Object)props.get((Object)"field"));
        Assertions.assertEquals((Object)"value", (Object)props.get((Object)"unrelated.key"));
    }

    @Test
    void testParseRecordMergePropertiesWithNoPrefixedProperties() {
        HoodieTableConfig tableConfig = new HoodieTableConfig();
        TypedProperties props = new TypedProperties();
        props.put((Object)"normal.key", (Object)"val");
        props = ConfigUtils.getMergeProps((TypedProperties)props, (HoodieTableConfig)tableConfig);
        Assertions.assertEquals((int)1, (int)props.size());
        Assertions.assertEquals((Object)"val", (Object)props.get((Object)"normal.key"));
    }

    @Test
    void testParseRecordMergePropertiesWithOverwrite() {
        TypedProperties tableProps = new TypedProperties();
        tableProps.put((Object)"hoodie.record.merge.property.strategy", (Object)"overwrite");
        HoodieTableConfig tableConfig = new HoodieTableConfig();
        tableConfig.getProps().putAll((Map)tableProps);
        TypedProperties props = new TypedProperties();
        props.put((Object)"strategy", (Object)"keep");
        props = ConfigUtils.getMergeProps((TypedProperties)props, (HoodieTableConfig)tableConfig);
        Assertions.assertEquals((int)1, (int)props.size());
        Assertions.assertEquals((Object)"overwrite", (Object)props.get((Object)"strategy"));
    }

    @Test
    void testIsPropertiesInvalid() {
        TypedProperties props = new TypedProperties();
        Assertions.assertTrue((boolean)ConfigUtils.isPropertiesInvalid((TypedProperties)props));
        props.setProperty(HoodieTableConfig.NAME.key(), "test_db.test_table");
        props.setProperty(HoodieTableConfig.TYPE.key(), "COPY_ON_WRITE");
        props.setProperty(HoodieTableConfig.VERSION.key(), "6");
        props.setProperty(HoodieTableConfig.TABLE_CHECKSUM.key(), String.valueOf(HoodieTableConfig.generateChecksum((Properties)props)));
        Assertions.assertFalse((boolean)ConfigUtils.isPropertiesInvalid((TypedProperties)props));
        props.setProperty(HoodieTableConfig.TABLE_CHECKSUM.key(), "0");
        Assertions.assertTrue((boolean)ConfigUtils.isPropertiesInvalid((TypedProperties)props));
        props.remove((Object)HoodieTableConfig.TABLE_CHECKSUM.key());
        Assertions.assertFalse((boolean)ConfigUtils.isPropertiesInvalid((TypedProperties)props));
        props.remove((Object)HoodieTableConfig.NAME.key());
        Assertions.assertTrue((boolean)ConfigUtils.isPropertiesInvalid((TypedProperties)props));
    }
}

