/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.LockSupport;
import org.apache.hudi.common.util.CustomizedThreadFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCustomizedThreadFactory {
    @Test
    public void testThreadPrefix() throws ExecutionException, InterruptedException {
        int nThreads = 100;
        String threadNamePrefix = "consumer";
        ExecutorService executorService = Executors.newFixedThreadPool(nThreads, (ThreadFactory)new CustomizedThreadFactory(threadNamePrefix));
        for (int i = 0; i < nThreads; ++i) {
            Future<Boolean> resultFuture = executorService.submit(() -> {
                LockSupport.parkNanos(10000000L);
                String name = Thread.currentThread().getName();
                return name.startsWith(threadNamePrefix);
            });
            Boolean result = resultFuture.get();
            Assertions.assertTrue((boolean)result);
        }
        executorService.shutdown();
    }

    @Test
    public void testDefaultThreadPrefix() throws ExecutionException, InterruptedException {
        int nThreads = 100;
        String defaultThreadNamePrefix = "pool-1";
        ExecutorService executorService = Executors.newFixedThreadPool(nThreads, (ThreadFactory)new CustomizedThreadFactory());
        for (int i = 0; i < nThreads; ++i) {
            Future<Boolean> resultFuture = executorService.submit(() -> {
                LockSupport.parkNanos(10000000L);
                String name = Thread.currentThread().getName();
                return name.startsWith(defaultThreadNamePrefix);
            });
            Boolean result = resultFuture.get();
            Assertions.assertTrue((boolean)result);
        }
        executorService.shutdown();
    }

    @Test
    public void testDaemonThread() throws ExecutionException, InterruptedException {
        int nThreads = 100;
        String threadNamePrefix = "consumer";
        ExecutorService executorService = Executors.newFixedThreadPool(nThreads, (ThreadFactory)new CustomizedThreadFactory(threadNamePrefix, true));
        for (int i = 0; i < nThreads; ++i) {
            Future<Boolean> resultFuture = executorService.submit(() -> {
                LockSupport.parkNanos(10000000L);
                String name = Thread.currentThread().getName();
                boolean daemon = Thread.currentThread().isDaemon();
                return name.startsWith(threadNamePrefix) && daemon;
            });
            Boolean result = resultFuture.get();
            Assertions.assertTrue((boolean)result);
        }
        executorService.shutdown();
    }
}

