/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.util.Collections;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieAvroRecordMerger;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.HoodieRecordUtils;
import org.apache.hudi.exception.HoodieException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class TestHoodieRecordUtils {
    TestHoodieRecordUtils() {
    }

    @Test
    void loadHoodieMerge() {
        String mergeClassName = HoodieAvroRecordMerger.class.getName();
        HoodieRecordMerger recordMerger1 = HoodieRecordUtils.loadRecordMerger((String)mergeClassName);
        HoodieRecordMerger recordMerger2 = HoodieRecordUtils.loadRecordMerger((String)mergeClassName);
        Assertions.assertEquals((Object)recordMerger1.getClass().getName(), (Object)mergeClassName);
        Assertions.assertEquals((Object)recordMerger2.getClass().getName(), (Object)mergeClassName);
    }

    @Test
    void loadHoodieMergeWithWrongMerger() {
        String mergeClassName = "wrong.package.MergerName";
        Assertions.assertThrows(HoodieException.class, () -> HoodieRecordUtils.loadRecordMerger((String)mergeClassName));
    }

    @Test
    void loadPayload() {
        String payloadClassName = DefaultHoodieRecordPayload.class.getName();
        HoodieRecordPayload payload = HoodieRecordUtils.loadPayload((String)payloadClassName, null, (Comparable)Integer.valueOf(0));
        Assertions.assertEquals((Object)payload.getClass().getName(), (Object)payloadClassName);
    }

    @Test
    void testGetOrderingFields() {
        HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        TypedProperties props = new TypedProperties();
        Assertions.assertTrue((boolean)HoodieRecordUtils.getOrderingFieldNames((RecordMergeMode)RecordMergeMode.COMMIT_TIME_ORDERING, (HoodieTableMetaClient)metaClient).isEmpty());
        HoodieTableConfig tableConfig = new HoodieTableConfig();
        tableConfig.setValue(HoodieTableConfig.ORDERING_FIELDS, "tbl");
        Mockito.when((Object)metaClient.getTableConfig()).thenReturn((Object)tableConfig);
        Assertions.assertEquals(Collections.singletonList("tbl"), (Object)HoodieRecordUtils.getOrderingFieldNames((RecordMergeMode)RecordMergeMode.EVENT_TIME_ORDERING, (HoodieTableMetaClient)metaClient));
        props.setProperty("hoodie.table.ordering.fields", "props");
        Assertions.assertEquals(Collections.singletonList("tbl"), (Object)HoodieRecordUtils.getOrderingFieldNames((RecordMergeMode)RecordMergeMode.EVENT_TIME_ORDERING, (HoodieTableMetaClient)metaClient));
    }
}

