/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.avro.Schema;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.util.LocalAvroSchemaCache;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestLocalAvroSchemaCache {
    @Test
    public void testBasicCacheUsage() {
        LocalAvroSchemaCache localAvroSchemaCache = LocalAvroSchemaCache.getInstance();
        Integer avroSchemaCacheNum = localAvroSchemaCache.cacheSchema(HoodieTestDataGenerator.AVRO_SCHEMA);
        Integer avroTripSchemaCacheNum = localAvroSchemaCache.cacheSchema(HoodieTestDataGenerator.AVRO_TRIP_SCHEMA);
        Integer flatAvroSchemaCacheNum = localAvroSchemaCache.cacheSchema(HoodieTestDataGenerator.FLATTENED_AVRO_SCHEMA);
        Integer nestAvroSchemaCacheNum = localAvroSchemaCache.cacheSchema(HoodieTestDataGenerator.NESTED_AVRO_SCHEMA);
        HashSet<Integer> uniqueSet = new HashSet<Integer>(Arrays.asList(avroSchemaCacheNum, avroTripSchemaCacheNum, flatAvroSchemaCacheNum, nestAvroSchemaCacheNum));
        Assertions.assertEquals((int)4, (int)uniqueSet.size());
        Assertions.assertTrue((boolean)localAvroSchemaCache.getSchema(avroSchemaCacheNum).isPresent());
        Assertions.assertEquals((Object)HoodieTestDataGenerator.AVRO_SCHEMA, (Object)localAvroSchemaCache.getSchema(avroSchemaCacheNum).get());
        Assertions.assertTrue((boolean)localAvroSchemaCache.getSchema(avroTripSchemaCacheNum).isPresent());
        Assertions.assertEquals((Object)HoodieTestDataGenerator.AVRO_TRIP_SCHEMA, (Object)localAvroSchemaCache.getSchema(avroTripSchemaCacheNum).get());
        Assertions.assertTrue((boolean)localAvroSchemaCache.getSchema(flatAvroSchemaCacheNum).isPresent());
        Assertions.assertEquals((Object)HoodieTestDataGenerator.FLATTENED_AVRO_SCHEMA, (Object)localAvroSchemaCache.getSchema(flatAvroSchemaCacheNum).get());
        Assertions.assertTrue((boolean)localAvroSchemaCache.getSchema(nestAvroSchemaCacheNum).isPresent());
        Assertions.assertEquals((Object)HoodieTestDataGenerator.NESTED_AVRO_SCHEMA, (Object)localAvroSchemaCache.getSchema(nestAvroSchemaCacheNum).get());
    }

    @Test
    public void testCopiesOfSameSchema() {
        LocalAvroSchemaCache localAvroSchemaCache = LocalAvroSchemaCache.getInstance();
        Schema testSchema1 = new Schema.Parser().parse("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}");
        Schema testSchema2 = new Schema.Parser().parse("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}");
        Integer cachenum = localAvroSchemaCache.cacheSchema(testSchema1);
        Integer secondSchemaCacheNum = localAvroSchemaCache.cacheSchema(testSchema2);
        Assertions.assertEquals((Integer)cachenum, (Integer)secondSchemaCacheNum);
        Assertions.assertTrue((boolean)localAvroSchemaCache.getSchema(cachenum).isPresent());
        Assertions.assertEquals((Object)testSchema1, (Object)localAvroSchemaCache.getSchema(cachenum).get());
    }
}

