/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Objects;
import org.apache.avro.util.Utf8;
import org.apache.hudi.common.model.DeleteRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.table.log.block.HoodieDeleteBlock;
import org.apache.hudi.common.util.SerializationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSerializationUtils {
    @Test
    public void testSerDeser() throws IOException {
        this.verifyObject(null);
        this.verifyObject(new NonSerializableClass(null));
        this.verifyObject(new NonSerializableClass("testValue"));
        this.verifyObject(new NonSerializableClass("testValue1", "testValue2"));
        this.verifyObject(new Utf8("test-key"));
        this.verifyObject(new LinkedList<Integer>(Arrays.asList(2, 3, 5)));
    }

    @Test
    public void testAvroUtf8SerDe() throws IOException {
        byte[] firstBytes = SerializationUtils.serialize((Object)new Utf8("test"));
        Assertions.assertEquals((int)7, (int)firstBytes.length);
    }

    @Test
    public void testClassFullyQualifiedNameSerialization() throws IOException {
        DeleteRecord deleteRecord = DeleteRecord.create((HoodieKey)new HoodieKey("key", "partition"));
        ArrayList<Pair> deleteRecordList = new ArrayList<Pair>();
        deleteRecordList.add(Pair.of((Object)deleteRecord, (Object)-1L));
        HoodieDeleteBlock deleteBlock = new HoodieDeleteBlock(deleteRecordList, Collections.emptyMap());
        byte[] firstBytes = SerializationUtils.serialize((Object)deleteBlock);
        byte[] secondBytes = SerializationUtils.serialize((Object)deleteBlock);
        Assertions.assertNotSame((Object)firstBytes, (Object)secondBytes);
        Assertions.assertEquals((Object)ByteBuffer.wrap(firstBytes), (Object)ByteBuffer.wrap(secondBytes));
    }

    private <T> void verifyObject(T expectedValue) throws IOException {
        byte[] serializedObject = SerializationUtils.serialize(expectedValue);
        Assertions.assertNotNull((Object)serializedObject);
        Assertions.assertTrue((serializedObject.length > 0 ? 1 : 0) != 0);
        Object deserializedValue = SerializationUtils.deserialize((byte[])serializedObject);
        if (expectedValue == null) {
            Assertions.assertNull((Object)deserializedValue);
        } else {
            Assertions.assertEquals(expectedValue, (Object)deserializedValue);
        }
    }

    private static class NonSerializableClass {
        private String id;
        private String name;

        NonSerializableClass(String id) {
            this(id, "");
        }

        NonSerializableClass(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof NonSerializableClass)) {
                return false;
            }
            NonSerializableClass other = (NonSerializableClass)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name);
        }
    }
}

