/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.RewriteAvroPayload;
import org.apache.hudi.common.util.SortUtils;
import org.apache.hudi.common.util.collection.FlatLists;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestSortUtils {
    private static final String SCHEMA = "{\"type\": \"record\",\"name\": \"testrec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"double\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"non_pii_col\", \"type\": \"string\"},{\"name\": \"pii_col\", \"type\": \"string\", \"column_category\": \"user_profile\"}]}";

    @Test
    void testPrependPartitionPath() {
        Object[] columnValues = new Object[]{"col1", "col2", "col3"};
        Object[] sortColumns = SortUtils.prependPartitionPath((String)"partition_path", (Object[])columnValues);
        Assertions.assertArrayEquals((Object[])new Object[]{"partition_path", "col1", "col2", "col3"}, (Object[])sortColumns);
    }

    @Test
    void testPrependPartitionPathAndSuffixRecordKey() {
        Object[] columnValues = new Object[]{"col1", "col2", "col3"};
        Object[] sortColumns = SortUtils.prependPartitionPathAndSuffixRecordKey((String)"partition_path", (String)"record_key", (Object[])columnValues);
        Assertions.assertArrayEquals((Object[])new Object[]{"partition_path", "col1", "col2", "col3", "record_key"}, (Object[])sortColumns);
    }

    @ParameterizedTest
    @MethodSource(value={"getArguments"})
    void testGetComparableSortColumnsAvroRecord(HoodieRecord.HoodieRecordType recordType, boolean suffixRecordKey) {
        Schema schema = new Schema.Parser().parse(SCHEMA);
        GenericData.Record genericRecord = new GenericData.Record(schema);
        genericRecord.put("non_pii_col", (Object)"val1");
        genericRecord.put("pii_col", (Object)"val2");
        genericRecord.put("timestamp", (Object)3.5);
        RewriteAvroPayload payload = new RewriteAvroPayload((GenericRecord)genericRecord);
        TestSparkRecord<RewriteAvroPayload> record = recordType == HoodieRecord.HoodieRecordType.AVRO ? new TestSparkRecord<RewriteAvroPayload>(new HoodieKey("record1", "partition1"), (HoodieRecordPayload)payload) : new TestSparkRecord<RewriteAvroPayload>(new HoodieKey("record1", "partition1"), payload);
        String[] userSortColumns = new String[]{"non_pii_col", "timestamp"};
        FlatLists.ComparableList comparableList = SortUtils.getComparableSortColumns(record, (String[])userSortColumns, (Schema)Schema.parse((String)SCHEMA), (boolean)suffixRecordKey, (boolean)true);
        Object[] expectedSortColumnValues = suffixRecordKey ? new Object[]{"partition1", "val1", 3.5, "record1"} : new Object[]{"partition1", "val1", 3.5};
        Assertions.assertEquals((Object)FlatLists.ofComparableArray((Object[])expectedSortColumnValues), (Object)comparableList);
    }

    private static Stream<Arguments> getArguments() {
        return Stream.of(Arguments.of((Object[])new Object[]{HoodieRecord.HoodieRecordType.SPARK, true}), Arguments.of((Object[])new Object[]{HoodieRecord.HoodieRecordType.SPARK, false}), Arguments.of((Object[])new Object[]{HoodieRecord.HoodieRecordType.AVRO, true}), Arguments.of((Object[])new Object[]{HoodieRecord.HoodieRecordType.AVRO, false}));
    }

    public static class TestSparkRecord<T extends HoodieRecordPayload>
    extends HoodieAvroRecord {
        public TestSparkRecord(HoodieKey key, T data) {
            super(key, data);
        }

        public HoodieRecord.HoodieRecordType getRecordType() {
            return HoodieRecord.HoodieRecordType.SPARK;
        }
    }
}

