/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.collection;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.hudi.common.util.collection.ClosableSortedDedupingIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestClosableSortedDedupingIterator {
    @Test
    public void testEmptyIterator() {
        Iterator emptyIterator = Collections.emptyIterator();
        ClosableSortedDedupingIterator dedupingIterator = new ClosableSortedDedupingIterator(emptyIterator);
        Assertions.assertFalse((boolean)dedupingIterator.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> {
            String cfr_ignored_0 = (String)dedupingIterator.next();
        });
        Assertions.assertDoesNotThrow(() -> dedupingIterator.close());
    }

    @Test
    public void testSingleElementIterator() {
        List<String> singleElement = Arrays.asList("test");
        ClosableSortedDedupingIterator dedupingIterator = new ClosableSortedDedupingIterator(singleElement.iterator());
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        Assertions.assertEquals((Object)"test", (Object)dedupingIterator.next());
        Assertions.assertFalse((boolean)dedupingIterator.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> {
            String cfr_ignored_0 = (String)dedupingIterator.next();
        });
        Assertions.assertDoesNotThrow(() -> dedupingIterator.close());
    }

    @Test
    public void testMultipleUniqueElements() {
        List<String> uniqueElements = Arrays.asList("a", "b", "c");
        ClosableSortedDedupingIterator dedupingIterator = new ClosableSortedDedupingIterator(uniqueElements.iterator());
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        Assertions.assertEquals((Object)"a", (Object)dedupingIterator.next());
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        Assertions.assertEquals((Object)"b", (Object)dedupingIterator.next());
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        Assertions.assertEquals((Object)"c", (Object)dedupingIterator.next());
        Assertions.assertFalse((boolean)dedupingIterator.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> {
            String cfr_ignored_0 = (String)dedupingIterator.next();
        });
        Assertions.assertDoesNotThrow(() -> dedupingIterator.close());
    }

    @Test
    public void testConsecutiveDuplicates() {
        List<String> elementsWithDuplicates = Arrays.asList("a", "a", "b", "b", "c");
        ClosableSortedDedupingIterator dedupingIterator = new ClosableSortedDedupingIterator(elementsWithDuplicates.iterator());
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        Assertions.assertEquals((Object)"a", (Object)dedupingIterator.next());
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        Assertions.assertEquals((Object)"b", (Object)dedupingIterator.next());
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        Assertions.assertEquals((Object)"c", (Object)dedupingIterator.next());
        Assertions.assertFalse((boolean)dedupingIterator.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> {
            String cfr_ignored_0 = (String)dedupingIterator.next();
        });
        Assertions.assertDoesNotThrow(() -> dedupingIterator.close());
    }

    @Test
    public void testNonConsecutiveDuplicates() {
        List<String> elementsWithNonConsecutiveDuplicates = Arrays.asList("a", "b", "a", "c", "b");
        ClosableSortedDedupingIterator dedupingIterator = new ClosableSortedDedupingIterator(elementsWithNonConsecutiveDuplicates.iterator());
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        Assertions.assertEquals((Object)"a", (Object)dedupingIterator.next());
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        Assertions.assertEquals((Object)"b", (Object)dedupingIterator.next());
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        Assertions.assertEquals((Object)"a", (Object)dedupingIterator.next());
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        Assertions.assertEquals((Object)"c", (Object)dedupingIterator.next());
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        Assertions.assertEquals((Object)"b", (Object)dedupingIterator.next());
        Assertions.assertFalse((boolean)dedupingIterator.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> {
            String cfr_ignored_0 = (String)dedupingIterator.next();
        });
        Assertions.assertDoesNotThrow(() -> dedupingIterator.close());
    }

    @Test
    public void testAllSameElements() {
        List<String> allSameElements = Arrays.asList("a", "a", "a", "a");
        ClosableSortedDedupingIterator dedupingIterator = new ClosableSortedDedupingIterator(allSameElements.iterator());
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        Assertions.assertEquals((Object)"a", (Object)dedupingIterator.next());
        Assertions.assertFalse((boolean)dedupingIterator.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> {
            String cfr_ignored_0 = (String)dedupingIterator.next();
        });
        Assertions.assertDoesNotThrow(() -> dedupingIterator.close());
    }

    @Test
    public void testNullElements() {
        List<String> elementsWithNulls = Arrays.asList("a", null, "b", null, "c");
        ClosableSortedDedupingIterator dedupingIterator = new ClosableSortedDedupingIterator(elementsWithNulls.iterator());
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        Assertions.assertEquals((Object)"a", (Object)dedupingIterator.next());
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        Assertions.assertNull((Object)dedupingIterator.next());
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        Assertions.assertEquals((Object)"b", (Object)dedupingIterator.next());
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        Assertions.assertNull((Object)dedupingIterator.next());
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        Assertions.assertEquals((Object)"c", (Object)dedupingIterator.next());
        Assertions.assertFalse((boolean)dedupingIterator.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> {
            String cfr_ignored_0 = (String)dedupingIterator.next();
        });
        Assertions.assertDoesNotThrow(() -> dedupingIterator.close());
    }

    @Test
    public void testConsecutiveNullElements() {
        List<String> elementsWithConsecutiveNulls = Arrays.asList("a", null, null, "b", null, null);
        ClosableSortedDedupingIterator dedupingIterator = new ClosableSortedDedupingIterator(elementsWithConsecutiveNulls.iterator());
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        Assertions.assertEquals((Object)"a", (Object)dedupingIterator.next());
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        Assertions.assertNull((Object)dedupingIterator.next());
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        Assertions.assertEquals((Object)"b", (Object)dedupingIterator.next());
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        Assertions.assertNull((Object)dedupingIterator.next());
        Assertions.assertFalse((boolean)dedupingIterator.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> {
            String cfr_ignored_0 = (String)dedupingIterator.next();
        });
        Assertions.assertDoesNotThrow(() -> dedupingIterator.close());
    }

    @Test
    public void testConsecutiveNullElementsDebug() {
        List<String> elementsWithConsecutiveNulls = Arrays.asList("a", null, null, "b", null, null);
        ClosableSortedDedupingIterator dedupingIterator = new ClosableSortedDedupingIterator(elementsWithConsecutiveNulls.iterator());
        System.out.println("Input: " + elementsWithConsecutiveNulls);
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        String first = (String)dedupingIterator.next();
        System.out.println("1. " + first);
        Assertions.assertEquals((Object)"a", (Object)first);
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        String second = (String)dedupingIterator.next();
        System.out.println("2. " + second);
        Assertions.assertNull((Object)second);
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        String third = (String)dedupingIterator.next();
        System.out.println("3. " + third);
        Assertions.assertEquals((Object)"b", (Object)third);
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        String fourth = (String)dedupingIterator.next();
        System.out.println("4. " + fourth);
        Assertions.assertNull((Object)fourth);
        Assertions.assertFalse((boolean)dedupingIterator.hasNext());
        Assertions.assertDoesNotThrow(() -> dedupingIterator.close());
    }

    @Test
    public void testMultipleHasNextCalls() {
        List<String> elements = Arrays.asList("a", "a", "b");
        ClosableSortedDedupingIterator dedupingIterator = new ClosableSortedDedupingIterator(elements.iterator());
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        Assertions.assertEquals((Object)"a", (Object)dedupingIterator.next());
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        Assertions.assertEquals((Object)"b", (Object)dedupingIterator.next());
        Assertions.assertFalse((boolean)dedupingIterator.hasNext());
        Assertions.assertFalse((boolean)dedupingIterator.hasNext());
        Assertions.assertDoesNotThrow(() -> dedupingIterator.close());
    }

    @Test
    public void testClosableInnerIterator() {
        AutoCloseableIterator autoCloseableIterator = new AutoCloseableIterator(Arrays.asList("a", "a", "b"));
        ClosableSortedDedupingIterator dedupingIterator = new ClosableSortedDedupingIterator((Iterator)autoCloseableIterator);
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        Assertions.assertEquals((Object)"a", (Object)dedupingIterator.next());
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        Assertions.assertEquals((Object)"b", (Object)dedupingIterator.next());
        Assertions.assertFalse((boolean)dedupingIterator.hasNext());
        Assertions.assertDoesNotThrow(() -> dedupingIterator.close());
        Assertions.assertTrue((boolean)autoCloseableIterator.isClosed());
    }

    @Test
    public void testIntegerElements() {
        List<Integer> integerElements = Arrays.asList(1, 1, 2, 3, 3, 4);
        ClosableSortedDedupingIterator dedupingIterator = new ClosableSortedDedupingIterator(integerElements.iterator());
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        Assertions.assertEquals((Integer)1, (Integer)((Integer)dedupingIterator.next()));
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        Assertions.assertEquals((Integer)2, (Integer)((Integer)dedupingIterator.next()));
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        Assertions.assertEquals((Integer)3, (Integer)((Integer)dedupingIterator.next()));
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        Assertions.assertEquals((Integer)4, (Integer)((Integer)dedupingIterator.next()));
        Assertions.assertFalse((boolean)dedupingIterator.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> {
            Integer cfr_ignored_0 = (Integer)dedupingIterator.next();
        });
        Assertions.assertDoesNotThrow(() -> dedupingIterator.close());
    }

    @Test
    public void testCustomObjectElements() {
        List<TestObject> customObjects = Arrays.asList(new TestObject("a", 1), new TestObject("a", 1), new TestObject("b", 2), new TestObject("b", 2));
        ClosableSortedDedupingIterator dedupingIterator = new ClosableSortedDedupingIterator(customObjects.iterator());
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        TestObject first = (TestObject)dedupingIterator.next();
        Assertions.assertEquals((Object)"a", (Object)first.name);
        Assertions.assertEquals((int)1, (int)first.value);
        Assertions.assertTrue((boolean)dedupingIterator.hasNext());
        TestObject second = (TestObject)dedupingIterator.next();
        Assertions.assertEquals((Object)"b", (Object)second.name);
        Assertions.assertEquals((int)2, (int)second.value);
        Assertions.assertFalse((boolean)dedupingIterator.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> {
            TestObject cfr_ignored_0 = (TestObject)dedupingIterator.next();
        });
        Assertions.assertDoesNotThrow(() -> dedupingIterator.close());
    }

    private static class TestObject {
        private final String name;
        private final int value;

        public TestObject(String name, int value) {
            this.name = name;
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            TestObject that = (TestObject)obj;
            return this.value == that.value && this.name.equals(that.name);
        }

        public int hashCode() {
            return this.name.hashCode() * 31 + this.value;
        }
    }

    private static class AutoCloseableIterator
    implements Iterator<String>,
    AutoCloseable {
        private final List<String> data;
        private int index = 0;
        private boolean closed = false;

        public AutoCloseableIterator(List<String> data) {
            this.data = data;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.data.size();
        }

        @Override
        public String next() {
            if (this.index >= this.data.size()) {
                throw new NoSuchElementException();
            }
            return this.data.get(this.index++);
        }

        @Override
        public void close() throws Exception {
            this.closed = true;
        }

        public boolean isClosed() {
            return this.closed;
        }
    }
}

