/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.apache.hudi.common.util.collection.ClosableSortingIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestSortingIterator {
    @ParameterizedTest
    @MethodSource(value={"sortingTestCases"})
    <T extends Comparable<T>> void testSortingWithComparableElements(List<T> unsorted, List<T> expected) throws Exception {
        List<T> result = this.collectSortedElements(unsorted.iterator());
        Assertions.assertEquals(expected, result);
    }

    private static Stream<Arguments> sortingTestCases() {
        return Stream.of(Arguments.of((Object[])new Object[]{Arrays.asList(3, 1, 4, 1, 5, 9, 2, 6), Arrays.asList(1, 1, 2, 3, 4, 5, 6, 9)}), Arguments.of((Object[])new Object[]{Arrays.asList("banana", "apple", "cherry", "date"), Arrays.asList("apple", "banana", "cherry", "date")}), Arguments.of((Object[])new Object[]{Collections.singletonList(42), Collections.singletonList(42)}), Arguments.of((Object[])new Object[]{Collections.emptyList(), Collections.emptyList()}));
    }

    @Test
    void testEmptyIterator() throws Exception {
        try (ClosableSortingIterator sortingIterator = new ClosableSortingIterator(Collections.emptyIterator());){
            Assertions.assertFalse((boolean)sortingIterator.hasNext());
        }
    }

    @Test
    void testSingleElement() throws Exception {
        try (ClosableSortingIterator sortingIterator = new ClosableSortingIterator(Arrays.asList(42).iterator());){
            Assertions.assertTrue((boolean)sortingIterator.hasNext());
            Assertions.assertEquals((int)42, (Integer)((Integer)sortingIterator.next()));
            Assertions.assertFalse((boolean)sortingIterator.hasNext());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"errorTestCases"})
    void testErrorCases(List<Object> input, String expectedMessagePart) throws Exception {
        try (ClosableSortingIterator sortingIterator = new ClosableSortingIterator(input.iterator());){
            IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ((ClosableSortingIterator)sortingIterator).hasNext());
            Assertions.assertTrue((boolean)exception.getMessage().contains(expectedMessagePart));
        }
    }

    private static Stream<Arguments> errorTestCases() {
        return Stream.of(Arguments.of((Object[])new Object[]{Arrays.asList(new Object(), new Object(), new Object()), "Elements must implement Comparable interface"}), Arguments.of((Object[])new Object[]{Arrays.asList(3, "string", 1, "another", 2), "Elements cannot be compared with each other"}));
    }

    @ParameterizedTest
    @MethodSource(value={"closeableSourceTestCases"})
    void testCloseableIteratorSources(boolean isAutoCloseable) throws Exception {
        List<Integer> data = Arrays.asList(3, 1, 4, 1, 5, 9, 2, 6);
        List<Integer> expected = Arrays.asList(1, 1, 2, 3, 4, 5, 6, 9);
        if (isAutoCloseable) {
            TestAutoCloseableIterator<Integer> sourceIterator = new TestAutoCloseableIterator<Integer>(data.iterator());
            List<Integer> result = this.collectSortedElements(sourceIterator);
            Assertions.assertEquals(expected, result);
            Assertions.assertTrue((boolean)sourceIterator.isClosed());
        } else {
            List<Integer> result = this.collectSortedElements(data.iterator());
            Assertions.assertEquals(expected, result);
        }
    }

    private static Stream<Arguments> closeableSourceTestCases() {
        return Stream.of(Arguments.of((Object[])new Object[]{true}), Arguments.of((Object[])new Object[]{false}));
    }

    @Test
    void testCloseCalledMultipleTimes() throws Exception {
        TestAutoCloseableIterator<Integer> sourceIterator = new TestAutoCloseableIterator<Integer>(Arrays.asList(3, 1, 4).iterator());
        ClosableSortingIterator sortingIterator = new ClosableSortingIterator(sourceIterator);
        sortingIterator.close();
        sortingIterator.close();
        sortingIterator.close();
        Assertions.assertEquals((int)1, (int)sourceIterator.getCloseCount());
    }

    private <T> List<T> collectSortedElements(Iterator<T> sourceIterator) throws Exception {
        try (ClosableSortingIterator sortingIterator = new ClosableSortingIterator(sourceIterator);){
            ArrayList<Object> result = new ArrayList<Object>();
            while (sortingIterator.hasNext()) {
                result.add(sortingIterator.next());
            }
            ArrayList<Object> arrayList = result;
            return arrayList;
        }
    }

    private static class TestAutoCloseableIterator<T>
    implements Iterator<T>,
    AutoCloseable {
        private final Iterator<T> delegate;
        private boolean closed = false;
        private int closeCount = 0;

        public TestAutoCloseableIterator(Iterator<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public T next() {
            return this.delegate.next();
        }

        @Override
        public void close() throws Exception {
            if (!this.closed) {
                this.closed = true;
                ++this.closeCount;
            }
        }

        public boolean isClosed() {
            return this.closed;
        }

        public int getCloseCount() {
            return this.closeCount;
        }
    }
}

