/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config.metrics;

import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestHoodieMetricsConfig {
    TestHoodieMetricsConfig() {
    }

    @Test
    void testReturnsBasePathWhenSetViaBuilder() {
        HoodieMetricsConfig config = HoodieMetricsConfig.newBuilder().withPath("primary/base/path").build();
        Assertions.assertEquals((Object)"primary/base/path", (Object)config.getBasePath());
    }

    @Test
    void testReturnsMetaSyncPathWhenBasePathIsNotSet() {
        HoodieMetricsConfig config = HoodieMetricsConfig.newBuilder().build();
        config.setValue("hoodie.datasource.meta.sync.base.path", "base/path/set/during/sync");
        Assertions.assertEquals((Object)"base/path/set/during/sync", (Object)config.getBasePath());
    }

    @Test
    void testReturnsNullWhenNeitherBasePathNorMetaSyncIsSet() {
        HoodieMetricsConfig config = HoodieMetricsConfig.newBuilder().build();
        Assertions.assertNull((Object)config.getBasePath());
    }
}

