/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.expression;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hudi.expression.ArrayData;
import org.apache.hudi.expression.Expression;
import org.apache.hudi.expression.ExpressionVisitor;
import org.apache.hudi.expression.Literal;
import org.apache.hudi.expression.NameReference;
import org.apache.hudi.expression.PartialBindVisitor;
import org.apache.hudi.expression.Predicates;
import org.apache.hudi.expression.StructLike;
import org.apache.hudi.internal.schema.Type;
import org.apache.hudi.internal.schema.Types;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestPartialBindVisitor {
    private static Types.RecordType schema;

    @BeforeAll
    public static void init() {
        ArrayList<Types.Field> fields = new ArrayList<Types.Field>(5);
        fields.add(Types.Field.get((int)0, (boolean)true, (String)"a", (Type)Types.StringType.get()));
        fields.add(Types.Field.get((int)1, (boolean)true, (String)"b", (Type)Types.DateType.get()));
        fields.add(Types.Field.get((int)2, (boolean)true, (String)"c", (Type)Types.IntType.get()));
        fields.add(Types.Field.get((int)3, (boolean)true, (String)"d", (Type)Types.LongType.get()));
        fields.add(Types.Field.get((int)4, (boolean)false, (String)"f", (Type)Types.BooleanType.get()));
        schema = Types.RecordType.get(fields, (String)"schema");
    }

    @Test
    public void testPartialBindIfAllExisting() {
        PartialBindVisitor partialBindVisitor = new PartialBindVisitor(schema, false);
        Predicates.BinaryComparison eq = Predicates.eq((Expression)new NameReference("a"), (Expression)Literal.from((Object)"Jane"));
        Predicates.BinaryComparison gt = Predicates.gt((Expression)new NameReference("c"), (Expression)Literal.from((Object)10));
        Predicates.In in = Predicates.in((Expression)new NameReference("d"), Arrays.asList(Literal.from((Object)10L), Literal.from((Object)13L)));
        Predicates.And expr = Predicates.and((Expression)eq, (Expression)Predicates.or((Expression)gt, (Expression)in));
        Expression binded = (Expression)expr.accept((ExpressionVisitor)partialBindVisitor);
        Assertions.assertTrue((boolean)((Boolean)binded.eval((StructLike)new ArrayData(Arrays.asList("Jane", "2023-04-02", 15, 5L, false)))));
        Assertions.assertTrue((boolean)((Boolean)binded.eval((StructLike)new ArrayData(Arrays.asList("Jane", "2023-04-02", 5, 10L, false)))));
        Assertions.assertFalse((boolean)((Boolean)binded.eval((StructLike)new ArrayData(Arrays.asList("Lone", "2023-04-02", 15, 5L, false)))));
        Assertions.assertFalse((boolean)((Boolean)binded.eval((StructLike)new ArrayData(Arrays.asList("Lone", "2023-04-02", 10, 5L, false)))));
    }

    @Test
    public void testPartialBindIfFieldMissing() {
        PartialBindVisitor partialBindVisitor = new PartialBindVisitor(schema, false);
        Predicates.BinaryComparison eq = Predicates.eq((Expression)new NameReference("a"), (Expression)Literal.from((Object)"Jane"));
        Predicates.BinaryComparison lt = Predicates.lt((Expression)new NameReference("m"), (Expression)Literal.from((Object)10));
        Predicates.BinaryComparison gteq = Predicates.gteq((Expression)new NameReference("d"), (Expression)Literal.from((Object)10L));
        Predicates.And expr = Predicates.and((Expression)eq, (Expression)Predicates.or((Expression)lt, (Expression)gteq));
        Expression binded = (Expression)expr.accept((ExpressionVisitor)partialBindVisitor);
        Assertions.assertTrue((boolean)((Boolean)binded.eval((StructLike)new ArrayData(Arrays.asList("Jane", "2023-04-02", 15, 5L, false)))));
        Assertions.assertFalse((boolean)((Boolean)binded.eval((StructLike)new ArrayData(Arrays.asList("Lone", "2023-04-02", 15, 5L, false)))));
        Assertions.assertFalse((boolean)((Boolean)binded.eval((StructLike)new ArrayData(Arrays.asList("Lone", "2023-04-02", 10, 5L, false)))));
    }
}

