/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal.schema.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.InternalSchemaBuilder;
import org.apache.hudi.internal.schema.Type;
import org.apache.hudi.internal.schema.Types;
import org.apache.hudi.internal.schema.utils.InternalSchemaUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestInternalSchemaUtils {
    @Test
    public void testPruneSchema() {
        Types.RecordType record = this.getSimpleRecordType();
        InternalSchema originSchema = new InternalSchema(Types.RecordType.get((List)record.fields()));
        ArrayList<Integer> prunedCols = new ArrayList<Integer>();
        prunedCols.add(4);
        prunedCols.add(3);
        prunedCols.add(0);
        prunedCols.add(2);
        InternalSchema prunedSchema = InternalSchemaUtils.pruneInternalSchemaByID((InternalSchema)originSchema, prunedCols, null);
        InternalSchema checkedSchema = new InternalSchema(Types.RecordType.get(Arrays.asList(Types.Field.get((int)0, (String)"bool", (Type)Types.BooleanType.get()), Types.Field.get((int)2, (String)"long", (Type)Types.LongType.get()), Types.Field.get((int)3, (String)"float", (Type)Types.FloatType.get()), Types.Field.get((int)4, (String)"double", (Type)Types.DoubleType.get()))));
        Assertions.assertEquals((Object)prunedSchema, (Object)checkedSchema);
        Types.RecordType nestRecord = this.getNestRecordType();
        InternalSchema originNestSchema = new InternalSchema(Types.RecordType.get((List)nestRecord.fields()));
        ArrayList<Integer> prunedNestCols = new ArrayList<Integer>();
        prunedNestCols.add(0);
        prunedNestCols.add(1);
        prunedNestCols.add(5);
        prunedNestCols.add(11);
        InternalSchema prunedNestSchema = InternalSchemaUtils.pruneInternalSchemaByID((InternalSchema)originNestSchema, prunedNestCols, null);
    }

    @Test
    public void testInternalSchemaVisitor() {
        Types.RecordType nestRecord = this.getNestRecordType();
        Map result = InternalSchemaBuilder.getBuilder().buildNameToId((Type)nestRecord);
        Assertions.assertEquals((int)result.size(), (int)12);
        Assertions.assertEquals((Integer)((Integer)result.get("locations.value.long")), (int)11);
        Assertions.assertEquals((Integer)((Integer)result.get("locations.value.lat")), (int)10);
        Assertions.assertEquals((Integer)((Integer)result.get("locations.value")), (int)9);
        Assertions.assertEquals((Integer)((Integer)result.get("locations.key")), (int)8);
        Assertions.assertEquals((Integer)((Integer)result.get("doubles.element")), (int)7);
        Types.RecordType simpleRecord = this.getSimpleRecordType();
        Map result1 = InternalSchemaBuilder.getBuilder().buildNameToId((Type)simpleRecord);
        Assertions.assertEquals((int)result1.size(), (int)5);
        Assertions.assertEquals((Integer)((Integer)result1.get("double")), (int)4);
    }

    @Test
    public void testIntTypeEqualsAfterDeserialization() throws Exception {
        Types.IntType intType = Types.IntType.get();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new ObjectOutputStream(baos).writeObject(intType);
        Types.IntType deserializedIntType = (Types.IntType)new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray())).readObject();
        Assertions.assertEquals((Object)intType, (Object)deserializedIntType);
    }

    @Test
    void testFieldOrderingVisitor() {
        Types.RecordType nestRecord = this.getNestRecordType();
        Map result = new InternalSchema(nestRecord).getNameToPosition();
        HashMap<String, Integer> expected = new HashMap<String, Integer>();
        expected.put("id", 0);
        expected.put("data", 1);
        expected.put("preferences", 2);
        expected.put("preferences.feature1", 3);
        expected.put("preferences.feature2", 4);
        expected.put("doubles", 5);
        expected.put("doubles.element", 6);
        expected.put("locations", 7);
        expected.put("locations.key", 8);
        expected.put("locations.value", 9);
        expected.put("locations.value.lat", 10);
        expected.put("locations.value.long", 11);
        Assertions.assertEquals(expected, (Object)result);
    }

    public Types.RecordType getNestRecordType() {
        return Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)0, (boolean)false, (String)"id", (Type)Types.IntType.get()), Types.Field.get((int)1, (boolean)true, (String)"data", (Type)Types.StringType.get()), Types.Field.get((int)2, (boolean)true, (String)"preferences", (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)5, (boolean)false, (String)"feature1", (Type)Types.BooleanType.get()), Types.Field.get((int)6, (boolean)true, (String)"feature2", (Type)Types.BooleanType.get())})), Types.Field.get((int)3, (boolean)false, (String)"doubles", (Type)Types.ArrayType.get((int)7, (boolean)false, (Type)Types.DoubleType.get())), Types.Field.get((int)4, (boolean)false, (String)"locations", (Type)Types.MapType.get((int)8, (int)9, (Type)Types.StringType.get(), (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)10, (boolean)false, (String)"lat", (Type)Types.FloatType.get()), Types.Field.get((int)11, (boolean)false, (String)"long", (Type)Types.FloatType.get())}), (boolean)false))});
    }

    public Types.RecordType getSimpleRecordType() {
        return Types.RecordType.get(Arrays.asList(Types.Field.get((int)0, (String)"bool", (Type)Types.BooleanType.get()), Types.Field.get((int)1, (String)"int", (Type)Types.IntType.get()), Types.Field.get((int)2, (String)"long", (Type)Types.LongType.get()), Types.Field.get((int)3, (String)"float", (Type)Types.FloatType.get()), Types.Field.get((int)4, (String)"double", (Type)Types.DoubleType.get())));
    }
}

