/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.io.SeekableDataInputStream;
import org.apache.hudi.io.hfile.HFileReader;
import org.apache.hudi.io.hfile.HFileReaderImpl;
import org.apache.hudi.io.storage.HFileReaderFactory;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
class TestHFileReaderFactory {
    @Mock
    private HoodieStorage mockStorage;
    @Mock
    private StoragePath mockPath;
    @Mock
    private StoragePathInfo mockPathInfo;
    @Mock
    private SeekableDataInputStream mockInputStream;
    private TypedProperties properties;
    private final byte[] testContent = "test content".getBytes();

    TestHFileReaderFactory() {
    }

    @BeforeEach
    void setUp() {
        this.properties = new TypedProperties();
    }

    @Test
    void testCreateHFileReader_FileSizeBelowThreshold_ShouldUseContentCache() throws IOException {
        long fileSizeBelow = 5L;
        int thresholdMB = 10;
        this.properties.setProperty(HoodieMetadataConfig.METADATA_FILE_CACHE_MAX_SIZE_MB.key(), String.valueOf(10));
        Mockito.when((Object)this.mockStorage.getPathInfo(this.mockPath)).thenReturn((Object)this.mockPathInfo);
        Mockito.when((Object)this.mockPathInfo.getLength()).thenReturn((Object)5L);
        Mockito.when((Object)this.mockStorage.openSeekable(this.mockPath, false)).thenReturn((Object)this.mockInputStream);
        ((SeekableDataInputStream)Mockito.doAnswer(invocation -> {
            byte[] buffer = (byte[])invocation.getArgument(0);
            System.arraycopy(this.testContent, 0, buffer, 0, Math.min(this.testContent.length, buffer.length));
            return null;
        }).when((Object)this.mockInputStream)).readFully((byte[])ArgumentMatchers.any(byte[].class));
        HFileReaderFactory factory = HFileReaderFactory.builder().withStorage(this.mockStorage).withProps(this.properties).withPath(this.mockPath).build();
        HFileReader result = factory.createHFileReader();
        Assertions.assertNotNull((Object)result);
        Assertions.assertInstanceOf(HFileReaderImpl.class, (Object)result);
        ((HoodieStorage)Mockito.verify((Object)this.mockStorage, (VerificationMode)Mockito.times((int)2))).getPathInfo(this.mockPath);
        ((HoodieStorage)Mockito.verify((Object)this.mockStorage, (VerificationMode)Mockito.times((int)1))).openSeekable(this.mockPath, false);
        ((SeekableDataInputStream)Mockito.verify((Object)this.mockInputStream, (VerificationMode)Mockito.times((int)1))).readFully((byte[])ArgumentMatchers.any(byte[].class));
    }

    @Test
    void testCreateHFileReader_FileSizeAboveThreshold_ShouldNotUseContentCache() throws IOException {
        long fileSizeAbove = 0xF00000L;
        int thresholdMB = 10;
        this.properties.setProperty(HoodieMetadataConfig.METADATA_FILE_CACHE_MAX_SIZE_MB.key(), String.valueOf(10));
        Mockito.when((Object)this.mockStorage.getPathInfo(this.mockPath)).thenReturn((Object)this.mockPathInfo);
        Mockito.when((Object)this.mockPathInfo.getLength()).thenReturn((Object)0xF00000L);
        Mockito.when((Object)this.mockStorage.openSeekable(this.mockPath, false)).thenReturn((Object)this.mockInputStream);
        HFileReaderFactory factory = HFileReaderFactory.builder().withStorage(this.mockStorage).withProps(this.properties).withPath(this.mockPath).build();
        HFileReader result = factory.createHFileReader();
        Assertions.assertNotNull((Object)result);
        Assertions.assertInstanceOf(HFileReaderImpl.class, (Object)result);
        ((HoodieStorage)Mockito.verify((Object)this.mockStorage, (VerificationMode)Mockito.times((int)1))).getPathInfo(this.mockPath);
        ((HoodieStorage)Mockito.verify((Object)this.mockStorage, (VerificationMode)Mockito.times((int)1))).openSeekable(this.mockPath, false);
        ((SeekableDataInputStream)Mockito.verify((Object)this.mockInputStream, (VerificationMode)Mockito.never())).readFully((byte[])ArgumentMatchers.any(byte[].class));
    }

    @Test
    void testCreateHFileReader_ContentProvidedInConstructor_ShouldUseProvidedContent() throws IOException {
        int thresholdMB = 10;
        this.properties.setProperty(HoodieMetadataConfig.METADATA_FILE_CACHE_MAX_SIZE_MB.key(), String.valueOf(10));
        HFileReaderFactory factory = HFileReaderFactory.builder().withStorage(this.mockStorage).withProps(this.properties).withContent(this.testContent).build();
        HFileReader result = factory.createHFileReader();
        Assertions.assertNotNull((Object)result);
        Assertions.assertInstanceOf(HFileReaderImpl.class, (Object)result);
        ((HoodieStorage)Mockito.verify((Object)this.mockStorage, (VerificationMode)Mockito.never())).getPathInfo((StoragePath)ArgumentMatchers.any());
        ((HoodieStorage)Mockito.verify((Object)this.mockStorage, (VerificationMode)Mockito.never())).openSeekable((StoragePath)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
    }

    @Test
    void testCreateHFileReader_ContentProvidedAndPathProvided_ShouldFail() throws IOException {
        int thresholdMB = 10;
        this.properties.setProperty(HoodieMetadataConfig.METADATA_FILE_CACHE_MAX_SIZE_MB.key(), String.valueOf(10));
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> HFileReaderFactory.builder().withStorage(this.mockStorage).withProps(this.properties).withPath(this.mockPath).withContent(this.testContent).build());
        Assertions.assertEquals((Object)"HFile source already set, cannot set bytes content", (Object)exception.getMessage());
        exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> HFileReaderFactory.builder().withStorage(this.mockStorage).withProps(this.properties).withContent(this.testContent).withPath(this.mockPath).build());
        Assertions.assertEquals((Object)"HFile source already set, cannot set path", (Object)exception.getMessage());
    }

    @Test
    void testCreateHFileReader_NoPathOrContent_ShouldThrowException() {
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> HFileReaderFactory.builder().withStorage(this.mockStorage).withProps(this.properties).build());
        Assertions.assertEquals((Object)"HFile source cannot be null", (Object)exception.getMessage());
    }

    @Test
    void testBuilder_WithNullStorage_ShouldThrowException() {
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> HFileReaderFactory.builder().withStorage(null).withPath(this.mockPath).build());
        Assertions.assertEquals((Object)"Storage cannot be null", (Object)exception.getMessage());
    }

    @Test
    void testBuilder_WithoutPropertiesProvided_ShouldUseDefaultProperties() throws IOException {
        Mockito.when((Object)this.mockStorage.getPathInfo(this.mockPath)).thenReturn((Object)this.mockPathInfo);
        Mockito.when((Object)this.mockPathInfo.getLength()).thenReturn((Object)1024L);
        Mockito.when((Object)this.mockStorage.openSeekable(this.mockPath, false)).thenReturn((Object)this.mockInputStream);
        HFileReaderFactory factory = HFileReaderFactory.builder().withStorage(this.mockStorage).withPath(this.mockPath).build();
        HFileReader result = factory.createHFileReader();
        Assertions.assertNotNull((Object)result);
    }
}

