/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.util.HashMap;
import java.util.Map;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.bloom.BloomFilterTypeCode;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.util.HoodieFileMetadataMerger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TestHoodieFileMetadataMerger {
    @Test
    public void testMinKey() {
        HoodieFileMetadataMerger metaMerge = new HoodieFileMetadataMerger();
        Map mergeMap = metaMerge.mergeMetaData(this.newMap(new String[0]));
        Assertions.assertTrue((mergeMap.keySet().size() == 0 ? 1 : 0) != 0);
        metaMerge = new HoodieFileMetadataMerger();
        mergeMap = metaMerge.mergeMetaData(this.newMap("hoodie_min_record_key", "1"));
        Assertions.assertTrue((mergeMap.keySet().size() == 1 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)"1", mergeMap.get("hoodie_min_record_key"));
        mergeMap = metaMerge.mergeMetaData(this.newMap(new String[0]));
        Assertions.assertTrue((mergeMap.keySet().size() == 1 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)"1", mergeMap.get("hoodie_min_record_key"));
        mergeMap = metaMerge.mergeMetaData(this.newMap("hoodie_min_record_key", "5"));
        Assertions.assertTrue((mergeMap.keySet().size() == 1 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)"1", mergeMap.get("hoodie_min_record_key"));
        mergeMap = metaMerge.mergeMetaData(this.newMap("hoodie_min_record_key", "0"));
        Assertions.assertTrue((mergeMap.keySet().size() == 1 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)"0", mergeMap.get("hoodie_min_record_key"));
    }

    @Test
    public void testMaxKey() {
        HoodieFileMetadataMerger metaMerge = new HoodieFileMetadataMerger();
        Map mergeMap = metaMerge.mergeMetaData(this.newMap(new String[0]));
        Assertions.assertTrue((mergeMap.keySet().size() == 0 ? 1 : 0) != 0);
        metaMerge = new HoodieFileMetadataMerger();
        mergeMap = metaMerge.mergeMetaData(this.newMap("hoodie_max_record_key", "1"));
        Assertions.assertTrue((mergeMap.keySet().size() == 1 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)"1", mergeMap.get("hoodie_max_record_key"));
        mergeMap = metaMerge.mergeMetaData(this.newMap(new String[0]));
        Assertions.assertTrue((mergeMap.keySet().size() == 1 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)"1", mergeMap.get("hoodie_max_record_key"));
        mergeMap = metaMerge.mergeMetaData(this.newMap("hoodie_max_record_key", "0"));
        Assertions.assertTrue((mergeMap.keySet().size() == 1 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)"1", mergeMap.get("hoodie_max_record_key"));
        mergeMap = metaMerge.mergeMetaData(this.newMap("hoodie_max_record_key", "5"));
        Assertions.assertEquals((Object)"5", mergeMap.get("hoodie_max_record_key"));
        Assertions.assertFalse((boolean)mergeMap.containsKey("hoodie_min_record_key"));
    }

    @Test
    public void tesMaxAndMin() {
        HoodieFileMetadataMerger metaMerge = new HoodieFileMetadataMerger();
        Map mergeMap = metaMerge.mergeMetaData(this.newMap("hoodie_min_record_key", "1", "hoodie_max_record_key", "6"));
        Assertions.assertTrue((mergeMap.keySet().size() == 2 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)"1", mergeMap.get("hoodie_min_record_key"));
        Assertions.assertEquals((Object)"6", mergeMap.get("hoodie_max_record_key"));
        mergeMap = metaMerge.mergeMetaData(this.newMap("hoodie_min_record_key", "0", "hoodie_max_record_key", "5"));
        Assertions.assertTrue((mergeMap.keySet().size() == 2 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)"0", mergeMap.get("hoodie_min_record_key"));
        Assertions.assertEquals((Object)"6", mergeMap.get("hoodie_max_record_key"));
        mergeMap = metaMerge.mergeMetaData(this.newMap("hoodie_min_record_key", "4", "hoodie_max_record_key", "5"));
        Assertions.assertTrue((mergeMap.keySet().size() == 2 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)"0", mergeMap.get("hoodie_min_record_key"));
        Assertions.assertEquals((Object)"6", mergeMap.get("hoodie_max_record_key"));
    }

    @ParameterizedTest
    @ValueSource(strings={"SIMPLE", "DYNAMIC_V0"})
    public void testBloomFilter(String bloomFilterType) {
        HoodieFileMetadataMerger metaMerge = new HoodieFileMetadataMerger();
        int[] sizes = new int[]{100, 1000, 10000};
        BloomFilter bloomFilter = null;
        for (int size : sizes) {
            BloomFilter filter = this.getBloomFilter(bloomFilterType, 1000, 1.0E-6, 100000);
            for (int i = 0; i < size; ++i) {
                String key = String.format("key%d", size + i);
                filter.add(key);
            }
            if (bloomFilter == null) {
                bloomFilter = filter;
            } else {
                bloomFilter.or(filter);
            }
            metaMerge.mergeMetaData(this.newMap("hoodie_bloom_filter_type_code", bloomFilterType, "org.apache.hudi.bloomfilter", filter.serializeToString()));
        }
        Map mergedMetaData = metaMerge.getMergedMetaData();
        Assertions.assertEquals((Object)bloomFilterType, mergedMetaData.get("hoodie_bloom_filter_type_code"));
        Assertions.assertEquals((Object)bloomFilter.serializeToString(), mergedMetaData.get("org.apache.hudi.bloomfilter"));
    }

    @Test
    public void testDifferentTypeOfBloomFilter() {
        HoodieFileMetadataMerger metaMerge = new HoodieFileMetadataMerger();
        BloomFilter simpleFilter = this.getBloomFilter(BloomFilterTypeCode.SIMPLE.name(), 1000, 1.0E-6, 100000);
        for (int i = 0; i < 100; ++i) {
            String key = String.format("key%d", 100 + i);
            simpleFilter.add(key);
        }
        metaMerge.mergeMetaData(this.newMap("hoodie_bloom_filter_type_code", BloomFilterTypeCode.SIMPLE.name(), "org.apache.hudi.bloomfilter", simpleFilter.serializeToString()));
        BloomFilter dynamicFilter = this.getBloomFilter(BloomFilterTypeCode.DYNAMIC_V0.name(), 1000, 1.0E-6, 100000);
        for (int i = 0; i < 100; ++i) {
            String key = String.format("key%d", 100 + i);
            dynamicFilter.add(key);
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> metaMerge.mergeMetaData(this.newMap("hoodie_bloom_filter_type_code", BloomFilterTypeCode.DYNAMIC_V0.name(), "org.apache.hudi.bloomfilter", dynamicFilter.serializeToString())));
    }

    private BloomFilter getBloomFilter(String typeCode, int numEntries, double errorRate, int maxEntries) {
        if (typeCode.equalsIgnoreCase(BloomFilterTypeCode.SIMPLE.name())) {
            return BloomFilterFactory.createBloomFilter((int)numEntries, (double)errorRate, (int)-1, (String)typeCode);
        }
        return BloomFilterFactory.createBloomFilter((int)numEntries, (double)errorRate, (int)maxEntries, (String)typeCode);
    }

    private Map<String, String> newMap(String ... kvs) {
        ValidationUtils.checkArgument((kvs.length == 0 || kvs.length % 2 == 0 ? 1 : 0) != 0, (String)"num of input args should be 0 or multiples of 2");
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < kvs.length; i += 2) {
            map.put(kvs[i], kvs[i + 1]);
        }
        return map;
    }
}

