/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.expression.Expression;
import org.apache.hudi.expression.Predicate;
import org.apache.hudi.expression.Predicates;
import org.apache.hudi.io.storage.HFileReaderFactory;
import org.apache.hudi.io.storage.HoodieNativeAvroHFileReader;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class TestHoodieNativeAvroHFileReader {
    private static final TypedProperties DEFAULT_PROPS = new TypedProperties();
    private static HoodieNativeAvroHFileReader reader;

    TestHoodieNativeAvroHFileReader() {
        HoodieStorage storage = (HoodieStorage)Mockito.mock(HoodieStorage.class);
        StoragePath path = new StoragePath("anyPath");
        HFileReaderFactory readerFactory = HFileReaderFactory.builder().withStorage(storage).withProps(DEFAULT_PROPS).withPath(path).build();
        reader = HoodieNativeAvroHFileReader.builder().readerFactory(readerFactory).path(path).build();
    }

    @Test
    void testExtractKeysWithValidInPredicate() {
        Expression expr1 = (Expression)Mockito.mock(Expression.class);
        Expression expr2 = (Expression)Mockito.mock(Expression.class);
        Mockito.when((Object)expr1.eval(null)).thenReturn((Object)"key1");
        Mockito.when((Object)expr2.eval(null)).thenReturn((Object)"key2");
        Predicates.In inPredicate = (Predicates.In)Mockito.mock(Predicates.In.class);
        Mockito.when((Object)inPredicate.getOperator()).thenReturn((Object)Expression.Operator.IN);
        Mockito.when((Object)inPredicate.getRightChildren()).thenReturn(Arrays.asList(expr1, expr2));
        List keys = reader.extractKeys(Option.of((Object)inPredicate));
        Assertions.assertEquals(Arrays.asList("key1", "key2"), (Object)keys);
    }

    @Test
    void testExtractKeysWithEmptyOption() {
        List keys = reader.extractKeys(Option.empty());
        Assertions.assertTrue((boolean)keys.isEmpty());
    }

    @Test
    void testExtractKeysWithNonInPredicate() {
        Predicate otherPredicate = (Predicate)Mockito.mock(Predicate.class);
        Mockito.when((Object)otherPredicate.getOperator()).thenReturn((Object)Expression.Operator.EQ);
        List keys = reader.extractKeys(Option.of((Object)otherPredicate));
        Assertions.assertTrue((boolean)keys.isEmpty());
    }

    @Test
    void testExtractKeysWithInPredicateButNoChildren() {
        Predicates.In inPredicate = (Predicates.In)Mockito.mock(Predicates.In.class);
        Mockito.when((Object)inPredicate.getOperator()).thenReturn((Object)Expression.Operator.IN);
        Mockito.when((Object)inPredicate.getRightChildren()).thenReturn(Collections.emptyList());
        List keys = reader.extractKeys(Option.of((Object)inPredicate));
        Assertions.assertTrue((boolean)keys.isEmpty());
    }

    @Test
    void testExtractKeyPrefixesWithValidStartsWithPredicate() {
        Expression expr1 = (Expression)Mockito.mock(Expression.class);
        Expression expr2 = (Expression)Mockito.mock(Expression.class);
        Mockito.when((Object)expr1.eval(null)).thenReturn((Object)"prefix1");
        Mockito.when((Object)expr2.eval(null)).thenReturn((Object)"prefix2");
        Predicates.StringStartsWithAny startsWithPredicate = (Predicates.StringStartsWithAny)Mockito.mock(Predicates.StringStartsWithAny.class);
        Mockito.when((Object)startsWithPredicate.getOperator()).thenReturn((Object)Expression.Operator.STARTS_WITH);
        Mockito.when((Object)startsWithPredicate.getRightChildren()).thenReturn(Arrays.asList(expr1, expr2));
        List prefixes = reader.extractKeyPrefixes(Option.of((Object)startsWithPredicate));
        Assertions.assertEquals(Arrays.asList("prefix1", "prefix2"), (Object)prefixes);
    }

    @Test
    void testExtractKeyPrefixesWithEmptyOption() {
        List prefixes = reader.extractKeyPrefixes(Option.empty());
        Assertions.assertTrue((boolean)prefixes.isEmpty());
    }

    @Test
    void testExtractKeyPrefixesWithNonStartsWithPredicate() {
        Predicate otherPredicate = (Predicate)Mockito.mock(Predicate.class);
        Mockito.when((Object)otherPredicate.getOperator()).thenReturn((Object)Expression.Operator.EQ);
        List prefixes = reader.extractKeyPrefixes(Option.of((Object)otherPredicate));
        Assertions.assertTrue((boolean)prefixes.isEmpty());
    }

    @Test
    void testExtractKeyPrefixesWithStartsWithPredicateButNoChildren() {
        Predicates.StringStartsWithAny startsWithPredicate = (Predicates.StringStartsWithAny)Mockito.mock(Predicates.StringStartsWithAny.class);
        Mockito.when((Object)startsWithPredicate.getOperator()).thenReturn((Object)Expression.Operator.STARTS_WITH);
        Mockito.when((Object)startsWithPredicate.getRightChildren()).thenReturn(Collections.emptyList());
        List prefixes = reader.extractKeyPrefixes(Option.of((Object)startsWithPredicate));
        Assertions.assertTrue((boolean)prefixes.isEmpty());
    }
}

