/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.apache.hudi.exception.HoodieKeyException;
import org.apache.hudi.keygen.KeyGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class TestKeyGenerator {
    TestKeyGenerator() {
    }

    private static Stream<Arguments> testKeyConstruction() {
        return Stream.of(Arguments.of((Object[])new Object[]{new String[]{"key1"}, Collections.singletonList("value1"), "key1:value1"}), Arguments.of((Object[])new Object[]{new String[]{"key1", "key2"}, Arrays.asList("value1", "value2"), "key1:value1,key2:value2"}), Arguments.of((Object[])new Object[]{new String[]{"key1", "key2"}, Arrays.asList("value1", ""), "key1:value1,key2:__empty__"}), Arguments.of((Object[])new Object[]{new String[]{"key1", "key2"}, Arrays.asList(null, "value2"), "key1:__null__,key2:value2"}));
    }

    @ParameterizedTest
    @MethodSource
    void testKeyConstruction(String[] keys, List<String> values, String expected) {
        Assertions.assertEquals((Object)expected, (Object)KeyGenerator.constructRecordKey((String[])keys, (key, index) -> (String)values.get((int)index)));
    }

    @Test
    void testKeyConstructionWithOnlyNulls() {
        Assertions.assertThrows(HoodieKeyException.class, () -> KeyGenerator.constructRecordKey((String[])new String[]{"key1"}, (key, index) -> null));
        Assertions.assertThrows(HoodieKeyException.class, () -> KeyGenerator.constructRecordKey((String[])new String[]{"key1", "key2"}, (key, index) -> null));
    }
}

