/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen.constant;

import java.util.stream.Stream;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.keygen.constant.KeyGeneratorType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestKeyGeneratorType {
    @Test
    void testIsComplexKeyGeneratorWithKeyGeneratorType() {
        HoodieConfig config = new HoodieConfig();
        config.setValue(HoodieTableConfig.KEY_GENERATOR_TYPE, KeyGeneratorType.COMPLEX.name());
        Assertions.assertTrue((boolean)KeyGeneratorType.isComplexKeyGenerator((HoodieConfig)config));
        config.setValue(HoodieTableConfig.KEY_GENERATOR_TYPE, KeyGeneratorType.COMPLEX_AVRO.name());
        Assertions.assertTrue((boolean)KeyGeneratorType.isComplexKeyGenerator((HoodieConfig)config));
        config.setValue(HoodieTableConfig.KEY_GENERATOR_TYPE, KeyGeneratorType.SIMPLE.name());
        Assertions.assertFalse((boolean)KeyGeneratorType.isComplexKeyGenerator((HoodieConfig)config));
        config.setValue(HoodieTableConfig.KEY_GENERATOR_TYPE, KeyGeneratorType.SIMPLE_AVRO.name());
        Assertions.assertFalse((boolean)KeyGeneratorType.isComplexKeyGenerator((HoodieConfig)config));
        config.setValue(HoodieTableConfig.KEY_GENERATOR_TYPE, KeyGeneratorType.TIMESTAMP.name());
        Assertions.assertFalse((boolean)KeyGeneratorType.isComplexKeyGenerator((HoodieConfig)config));
        config.setValue(HoodieTableConfig.KEY_GENERATOR_TYPE, KeyGeneratorType.CUSTOM.name());
        Assertions.assertFalse((boolean)KeyGeneratorType.isComplexKeyGenerator((HoodieConfig)config));
    }

    @Test
    void testIsComplexKeyGeneratorWithKeyGeneratorClassName() {
        HoodieConfig config = new HoodieConfig();
        config.setValue(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME, KeyGeneratorType.COMPLEX.getClassName());
        Assertions.assertTrue((boolean)KeyGeneratorType.isComplexKeyGenerator((HoodieConfig)config));
        config.setValue(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME, KeyGeneratorType.COMPLEX_AVRO.getClassName());
        Assertions.assertTrue((boolean)KeyGeneratorType.isComplexKeyGenerator((HoodieConfig)config));
        config.setValue(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME, KeyGeneratorType.SIMPLE.getClassName());
        Assertions.assertFalse((boolean)KeyGeneratorType.isComplexKeyGenerator((HoodieConfig)config));
        config.setValue(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME, KeyGeneratorType.SIMPLE_AVRO.getClassName());
        Assertions.assertFalse((boolean)KeyGeneratorType.isComplexKeyGenerator((HoodieConfig)config));
        config.setValue(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME, KeyGeneratorType.TIMESTAMP.getClassName());
        Assertions.assertFalse((boolean)KeyGeneratorType.isComplexKeyGenerator((HoodieConfig)config));
        config.setValue(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME, KeyGeneratorType.CUSTOM.getClassName());
        Assertions.assertFalse((boolean)KeyGeneratorType.isComplexKeyGenerator((HoodieConfig)config));
    }

    @Test
    void testIsComplexKeyGeneratorWithUserDefinedClassName() {
        HoodieConfig config = new HoodieConfig();
        config.setValue(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME, "com.example.UserDefinedKeyGenerator");
        Assertions.assertFalse((boolean)KeyGeneratorType.isComplexKeyGenerator((HoodieConfig)config));
    }

    @Test
    void testIsComplexKeyGeneratorWithNoConfig() {
        HoodieConfig config = new HoodieConfig();
        Assertions.assertFalse((boolean)KeyGeneratorType.isComplexKeyGenerator((HoodieConfig)config));
    }

    private static Stream<Arguments> testFromClassNameParams() {
        return Stream.of(Arguments.of((Object[])new Object[]{"org.apache.hudi.keygen.SimpleKeyGenerator", KeyGeneratorType.SIMPLE}), Arguments.of((Object[])new Object[]{"org.apache.hudi.keygen.SimpleAvroKeyGenerator", KeyGeneratorType.SIMPLE_AVRO}), Arguments.of((Object[])new Object[]{"org.apache.hudi.keygen.ComplexKeyGenerator", KeyGeneratorType.COMPLEX}), Arguments.of((Object[])new Object[]{"org.apache.hudi.keygen.ComplexAvroKeyGenerator", KeyGeneratorType.COMPLEX_AVRO}), Arguments.of((Object[])new Object[]{"org.apache.hudi.keygen.TimestampBasedKeyGenerator", KeyGeneratorType.TIMESTAMP}), Arguments.of((Object[])new Object[]{"org.apache.hudi.keygen.TimestampBasedAvroKeyGenerator", KeyGeneratorType.TIMESTAMP_AVRO}), Arguments.of((Object[])new Object[]{"org.apache.hudi.keygen.CustomKeyGenerator", KeyGeneratorType.CUSTOM}), Arguments.of((Object[])new Object[]{"org.apache.hudi.keygen.CustomAvroKeyGenerator", KeyGeneratorType.CUSTOM_AVRO}), Arguments.of((Object[])new Object[]{"org.apache.hudi.keygen.NonpartitionedKeyGenerator", KeyGeneratorType.NON_PARTITION}), Arguments.of((Object[])new Object[]{"org.apache.hudi.keygen.NonpartitionedAvroKeyGenerator", KeyGeneratorType.NON_PARTITION_AVRO}), Arguments.of((Object[])new Object[]{"org.apache.hudi.keygen.GlobalDeleteKeyGenerator", KeyGeneratorType.GLOBAL_DELETE}), Arguments.of((Object[])new Object[]{"org.apache.hudi.keygen.GlobalAvroDeleteKeyGenerator", KeyGeneratorType.GLOBAL_DELETE_AVRO}), Arguments.of((Object[])new Object[]{"org.apache.hudi.keygen.AutoRecordGenWrapperKeyGenerator", KeyGeneratorType.AUTO_RECORD}), Arguments.of((Object[])new Object[]{"org.apache.hudi.keygen.AutoRecordGenWrapperAvroKeyGenerator", KeyGeneratorType.AUTO_RECORD_AVRO}), Arguments.of((Object[])new Object[]{"org.apache.hudi.metadata.HoodieTableMetadataKeyGenerator", KeyGeneratorType.HOODIE_TABLE_METADATA}), Arguments.of((Object[])new Object[]{"org.apache.spark.sql.hudi.command.SqlKeyGenerator", KeyGeneratorType.SPARK_SQL}), Arguments.of((Object[])new Object[]{"org.apache.spark.sql.hudi.command.UuidKeyGenerator", KeyGeneratorType.SPARK_SQL_UUID}), Arguments.of((Object[])new Object[]{"org.apache.spark.sql.hudi.command.MergeIntoKeyGenerator", KeyGeneratorType.SPARK_SQL_MERGE_INTO}), Arguments.of((Object[])new Object[]{"org.apache.hudi.keygen.CustomUserProvidedKeyGenerator", KeyGeneratorType.USER_PROVIDED}), Arguments.of((Object[])new Object[]{"com.example.CustomKeyGenerator", KeyGeneratorType.USER_PROVIDED}));
    }

    @ParameterizedTest
    @MethodSource(value={"testFromClassNameParams"})
    void testFromClassName(String className, KeyGeneratorType expectedType) {
        KeyGeneratorType result = KeyGeneratorType.fromClassName((String)className);
        Assertions.assertEquals((Object)expectedType, (Object)result);
    }

    @Test
    void testFromClassNameWithNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> KeyGeneratorType.fromClassName(null));
    }

    @Test
    void testFromClassNameWithEmpty() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> KeyGeneratorType.fromClassName((String)""));
    }
}

