/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.hudi.expression.Expression;
import org.apache.hudi.expression.Predicate;
import org.apache.hudi.metadata.HoodieBackedTableMetadata;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHoodieBackedTableMetadataBuildPredicate {
    @Test
    public void testBuildPredicateForSecondaryIndexPartition() {
        String partitionName = MetadataPartitionType.SECONDARY_INDEX.getPartitionPath();
        List<String> sortedKeys = Arrays.asList("key1", "key2", "key3");
        Exception exception = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> HoodieBackedTableMetadata.buildPredicate((String)partitionName, (Collection)sortedKeys, (boolean)true));
        Assertions.assertTrue((boolean)exception.getMessage().contains("Secondary index should never use full-key lookup"));
        Predicate predicatePrefixKey = HoodieBackedTableMetadata.buildPredicate((String)partitionName, sortedKeys, (boolean)false);
        Assertions.assertTrue((boolean)predicatePrefixKey.getOperator().equals((Object)Expression.Operator.STARTS_WITH));
    }

    @Test
    public void testBuildPredicateForAllMetadataPartitionTypes() {
        List<String> testKeys = Arrays.asList("key1", "key2");
        for (MetadataPartitionType partitionType : MetadataPartitionType.values()) {
            if (partitionType == MetadataPartitionType.SECONDARY_INDEX) continue;
            String partitionPath = partitionType.getPartitionPath();
            Predicate predicateFullKey = HoodieBackedTableMetadata.buildPredicate((String)partitionPath, testKeys, (boolean)true);
            Assertions.assertNotNull((Object)predicateFullKey, (String)("Predicate should not be null for partition: " + partitionPath));
            Predicate predicatePrefixKey = HoodieBackedTableMetadata.buildPredicate((String)partitionPath, testKeys, (boolean)false);
            Assertions.assertNotNull((Object)predicatePrefixKey, (String)("Predicate should not be null for partition: " + partitionPath));
            Assertions.assertTrue((boolean)predicateFullKey.getOperator().equals((Object)Expression.Operator.IN), (String)"Non-secondary index should use IN for isFullKey=true");
            Assertions.assertTrue((boolean)predicatePrefixKey.getOperator().equals((Object)Expression.Operator.STARTS_WITH), (String)"Non-secondary index should use STARTS_WITH for isFullKey=false");
        }
    }
}

