/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.lang.reflect.Field;
import java.util.Arrays;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodieListData;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.function.SerializableFunctionUnchecked;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metadata.BaseTableMetadata;
import org.apache.hudi.metadata.HoodieBackedTableMetadata;
import org.apache.hudi.metadata.HoodieDataCleanupManager;
import org.apache.hudi.metadata.HoodieIndexVersion;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class TestHoodieBackedTableMetadataDataCleanup {
    private HoodieBackedTableMetadata mockMetadata;
    private HoodieTableMetaClient mockDataMetaClient;
    private HoodieTableConfig mockTableConfig;
    private HoodieDataCleanupManager spyCleanupManager;
    private HoodiePairData mockPairData;
    private HoodiePairData mockResult;
    private HoodieData mockHoodieData;

    @BeforeEach
    public void setUp() throws NoSuchFieldException, IllegalAccessException {
        this.mockMetadata = (HoodieBackedTableMetadata)Mockito.mock(HoodieBackedTableMetadata.class);
        this.mockDataMetaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        this.mockTableConfig = (HoodieTableConfig)Mockito.mock(HoodieTableConfig.class);
        this.spyCleanupManager = (HoodieDataCleanupManager)Mockito.spy((Object)new HoodieDataCleanupManager());
        this.mockPairData = (HoodiePairData)Mockito.mock(HoodiePairData.class);
        this.mockResult = (HoodiePairData)Mockito.mock(HoodiePairData.class);
        this.mockHoodieData = (HoodieData)Mockito.mock(HoodieData.class);
        Mockito.when((Object)this.mockDataMetaClient.getTableConfig()).thenReturn((Object)this.mockTableConfig);
        Mockito.when((Object)this.mockTableConfig.isMetadataPartitionAvailable((MetadataPartitionType)ArgumentMatchers.any())).thenReturn((Object)true);
        this.injectMocks(this.mockMetadata, this.mockDataMetaClient, this.spyCleanupManager);
    }

    private void injectMocks(HoodieBackedTableMetadata metadata, HoodieTableMetaClient dataMetaClient, HoodieDataCleanupManager cleanupManager) throws NoSuchFieldException, IllegalAccessException {
        Field dataMetaClientField = BaseTableMetadata.class.getDeclaredField("dataMetaClient");
        dataMetaClientField.setAccessible(true);
        dataMetaClientField.set(metadata, dataMetaClient);
        Field cleanupManagerField = HoodieBackedTableMetadata.class.getDeclaredField("dataCleanupManager");
        cleanupManagerField.setAccessible(true);
        cleanupManagerField.set(metadata, cleanupManager);
    }

    @Test
    public void testReadRecordIndexInvokesCleanupManager() {
        HoodieListData recordKeys = HoodieListData.eager(Arrays.asList("key1", "key2"));
        Mockito.when((Object)this.mockMetadata.readIndexRecordsWithKeys((HoodieData)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)this.mockPairData);
        Mockito.when((Object)this.mockMetadata.readIndexRecordsWithKeys((HoodieData)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Option)ArgumentMatchers.any())).thenReturn((Object)this.mockPairData);
        Mockito.when((Object)this.mockPairData.mapToPair((SerializablePairFunction)ArgumentMatchers.any())).thenReturn((Object)this.mockResult);
        Mockito.when((Object)this.mockMetadata.readRecordIndexLocationsWithKeys((HoodieData)recordKeys)).thenCallRealMethod();
        Mockito.when((Object)this.mockMetadata.readRecordIndexLocationsWithKeys((HoodieData)recordKeys, Option.empty())).thenCallRealMethod();
        HoodiePairData result = this.mockMetadata.readRecordIndexLocationsWithKeys((HoodieData)recordKeys);
        ((HoodieDataCleanupManager)Mockito.verify((Object)this.spyCleanupManager)).ensureDataCleanupOnException((SerializableFunctionUnchecked)ArgumentMatchers.any());
        Assertions.assertEquals((Object)this.mockResult, (Object)result);
    }

    @Test
    public void testReadRecordIndexLocationsInvokesCleanupManager() {
        HoodieListData recordKeys = HoodieListData.eager(Arrays.asList("key1", "key2"));
        HoodieData mockIndexRecords = (HoodieData)Mockito.mock(HoodieData.class);
        Mockito.when((Object)this.mockMetadata.readIndexRecords((HoodieData)ArgumentMatchers.any(), ArgumentMatchers.anyString(), (Option)ArgumentMatchers.any())).thenReturn((Object)mockIndexRecords);
        Mockito.when((Object)mockIndexRecords.map((SerializableFunction)ArgumentMatchers.any())).thenReturn((Object)this.mockHoodieData);
        Mockito.when((Object)this.mockMetadata.readRecordIndexLocations((HoodieData)recordKeys)).thenCallRealMethod();
        HoodieData result = this.mockMetadata.readRecordIndexLocations((HoodieData)recordKeys);
        ((HoodieDataCleanupManager)Mockito.verify((Object)this.spyCleanupManager)).ensureDataCleanupOnException((SerializableFunctionUnchecked)ArgumentMatchers.any());
        Assertions.assertNotNull((Object)result);
    }

    @Test
    public void testReadSecondaryIndexInvokesCleanupManager() {
        HoodieListData secondaryKeys = HoodieListData.eager(Arrays.asList("skey1", "skey2"));
        String partitionName = "test_partition";
        try (MockedStatic mockedUtil = Mockito.mockStatic(HoodieTableMetadataUtil.class);){
            mockedUtil.when(() -> HoodieTableMetadataUtil.existingIndexVersionOrDefault((String)ArgumentMatchers.anyString(), (HoodieTableMetaClient)((HoodieTableMetaClient)ArgumentMatchers.any()))).thenReturn((Object)HoodieIndexVersion.V2);
            Mockito.when((Object)this.mockMetadata.readSecondaryIndexDataTableRecordKeysV2((HoodieData)ArgumentMatchers.any(), ArgumentMatchers.anyString())).thenReturn((Object)this.mockHoodieData);
            Mockito.when((Object)this.mockPairData.mapToPair((SerializablePairFunction)ArgumentMatchers.any())).thenReturn((Object)this.mockResult);
            Mockito.when((Object)this.mockMetadata.readSecondaryIndexLocationsWithKeys((HoodieData)secondaryKeys, partitionName)).thenCallRealMethod();
            try {
                this.mockMetadata.readSecondaryIndexLocationsWithKeys((HoodieData)secondaryKeys, partitionName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((HoodieDataCleanupManager)Mockito.verify((Object)this.spyCleanupManager)).ensureDataCleanupOnException((SerializableFunctionUnchecked)ArgumentMatchers.any());
        }
    }

    @Test
    public void testReadSecondaryIndexLocationsInvokesCleanupManager() {
        HoodieListData secondaryKeys = HoodieListData.eager(Arrays.asList("skey1", "skey2"));
        String partitionName = "test_partition";
        try (MockedStatic mockedUtil = Mockito.mockStatic(HoodieTableMetadataUtil.class);){
            mockedUtil.when(() -> HoodieTableMetadataUtil.existingIndexVersionOrDefault((String)ArgumentMatchers.anyString(), (HoodieTableMetaClient)((HoodieTableMetaClient)ArgumentMatchers.any()))).thenReturn((Object)HoodieIndexVersion.V2);
            Mockito.when((Object)this.mockPairData.values()).thenReturn((Object)this.mockHoodieData);
            Mockito.when((Object)this.mockMetadata.readSecondaryIndexDataTableRecordKeysV2((HoodieData)ArgumentMatchers.any(), ArgumentMatchers.anyString())).thenReturn((Object)this.mockHoodieData);
            Mockito.when((Object)this.mockMetadata.readRecordIndexLocations((HoodieData)ArgumentMatchers.any())).thenReturn((Object)this.mockHoodieData);
            Mockito.when((Object)this.mockMetadata.readSecondaryIndexLocations((HoodieData)secondaryKeys, partitionName)).thenCallRealMethod();
            try {
                this.mockMetadata.readSecondaryIndexLocations((HoodieData)secondaryKeys, partitionName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((HoodieDataCleanupManager)Mockito.verify((Object)this.spyCleanupManager)).ensureDataCleanupOnException((SerializableFunctionUnchecked)ArgumentMatchers.any());
        }
    }

    @Test
    public void testCleanupManagerPropagatesExceptions() throws NoSuchFieldException, IllegalAccessException {
        HoodieDataCleanupManager mockCleanupManager = (HoodieDataCleanupManager)Mockito.mock(HoodieDataCleanupManager.class);
        this.injectMocks(this.mockMetadata, this.mockDataMetaClient, mockCleanupManager);
        HoodieException testException = new HoodieException("Test exception from cleanup manager");
        ((HoodieDataCleanupManager)Mockito.doThrow((Throwable[])new Throwable[]{testException}).when((Object)mockCleanupManager)).ensureDataCleanupOnException((SerializableFunctionUnchecked)ArgumentMatchers.any());
        Mockito.when((Object)this.mockMetadata.readRecordIndexLocationsWithKeys((HoodieData)ArgumentMatchers.any())).thenCallRealMethod();
        Mockito.when((Object)this.mockMetadata.readRecordIndexLocationsWithKeys((HoodieData)ArgumentMatchers.any(), (Option)ArgumentMatchers.any())).thenCallRealMethod();
        HoodieListData recordKeys = HoodieListData.eager(Arrays.asList("key1"));
        try {
            this.mockMetadata.readRecordIndexLocationsWithKeys((HoodieData)recordKeys);
            Assertions.fail((String)"Expected exception was not thrown");
        }
        catch (HoodieException e) {
            Assertions.assertEquals((Object)"Test exception from cleanup manager", (Object)e.getMessage());
        }
        ((HoodieDataCleanupManager)Mockito.verify((Object)mockCleanupManager)).ensureDataCleanupOnException((SerializableFunctionUnchecked)ArgumentMatchers.any());
    }
}

