/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.function.SerializableFunctionUnchecked;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metadata.HoodieDataCleanupManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestHoodieDataCleanupManager {
    private HoodieDataCleanupManager cleanupManager;
    private ConcurrentHashMap<Long, List<Object>> threadPersistedData;

    @BeforeEach
    public void setUp() {
        this.cleanupManager = new HoodieDataCleanupManager();
        this.threadPersistedData = this.cleanupManager.getThreadPersistedData();
        this.threadPersistedData.clear();
    }

    @AfterEach
    void tearDown() {
        this.threadPersistedData.clear();
    }

    @Test
    public void testTrackPersistedDataAndCleanupOnException_HoodiePairData() {
        long threadId = Thread.currentThread().getId();
        AtomicInteger unpersistCount = new AtomicInteger(0);
        HoodiePairData mockPairData = (HoodiePairData)Mockito.mock(HoodiePairData.class);
        ((HoodiePairData)Mockito.doAnswer(invocation -> {
            unpersistCount.incrementAndGet();
            return null;
        }).when((Object)mockPairData)).unpersistWithDependencies();
        this.cleanupManager.trackPersistedData(mockPairData);
        Assertions.assertNotNull(this.threadPersistedData.get(threadId));
        Assertions.assertEquals((int)1, (int)this.threadPersistedData.get(threadId).size());
        Assertions.assertTrue((boolean)this.threadPersistedData.get(threadId).contains(mockPairData));
        HoodieException exception = (HoodieException)Assertions.assertThrows(HoodieException.class, () -> this.cleanupManager.ensureDataCleanupOnException((SerializableFunctionUnchecked & Serializable)v -> {
            throw new HoodieException("Test exception");
        }));
        Assertions.assertEquals((Object)"Test exception", (Object)exception.getMessage());
        Assertions.assertEquals((int)1, (int)unpersistCount.get());
        ((HoodiePairData)Mockito.verify((Object)mockPairData, (VerificationMode)Mockito.times((int)1))).unpersistWithDependencies();
        Assertions.assertFalse((boolean)this.threadPersistedData.containsKey(threadId));
    }

    @Test
    void testTrackPersistedDataAndCleanupOnException_HoodieData() {
        long threadId = Thread.currentThread().getId();
        AtomicInteger unpersistCount = new AtomicInteger(0);
        HoodieData mockData = (HoodieData)Mockito.mock(HoodieData.class);
        ((HoodieData)Mockito.doAnswer(invocation -> {
            unpersistCount.incrementAndGet();
            return null;
        }).when((Object)mockData)).unpersistWithDependencies();
        this.cleanupManager.trackPersistedData(mockData);
        RuntimeException exception = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> this.cleanupManager.ensureDataCleanupOnException((SerializableFunctionUnchecked & Serializable)v -> {
            throw new RuntimeException("Test runtime exception");
        }));
        Assertions.assertEquals((Object)"Test runtime exception", (Object)exception.getMessage());
        Assertions.assertEquals((int)1, (int)unpersistCount.get());
        ((HoodieData)Mockito.verify((Object)mockData, (VerificationMode)Mockito.times((int)1))).unpersistWithDependencies();
        Assertions.assertFalse((boolean)this.threadPersistedData.containsKey(threadId));
    }

    @Test
    void testEnsureDataCleanupOnException_SuccessfulExecution() {
        long threadId = Thread.currentThread().getId();
        HoodiePairData mockPairData = (HoodiePairData)Mockito.mock(HoodiePairData.class);
        this.cleanupManager.trackPersistedData(mockPairData);
        String result = (String)this.cleanupManager.ensureDataCleanupOnException((SerializableFunctionUnchecked & Serializable)v -> "Success");
        Assertions.assertEquals((Object)"Success", (Object)result);
        ((HoodiePairData)Mockito.verify((Object)mockPairData, (VerificationMode)Mockito.never())).unpersistWithDependencies();
        Assertions.assertFalse((boolean)this.threadPersistedData.containsKey(threadId));
    }

    @Test
    void testCleanupMultiplePersistedDataObjects() {
        long threadId = Thread.currentThread().getId();
        AtomicInteger unpersistCount = new AtomicInteger(0);
        HoodiePairData mockPairData1 = (HoodiePairData)Mockito.mock(HoodiePairData.class);
        HoodiePairData mockPairData2 = (HoodiePairData)Mockito.mock(HoodiePairData.class);
        HoodieData mockData = (HoodieData)Mockito.mock(HoodieData.class);
        ((HoodiePairData)Mockito.doAnswer(invocation -> {
            unpersistCount.incrementAndGet();
            return null;
        }).when((Object)mockPairData1)).unpersistWithDependencies();
        ((HoodiePairData)Mockito.doAnswer(invocation -> {
            unpersistCount.incrementAndGet();
            return null;
        }).when((Object)mockPairData2)).unpersistWithDependencies();
        ((HoodieData)Mockito.doAnswer(invocation -> {
            unpersistCount.incrementAndGet();
            return null;
        }).when((Object)mockData)).unpersistWithDependencies();
        this.cleanupManager.trackPersistedData(mockPairData1);
        this.cleanupManager.trackPersistedData(mockPairData2);
        this.cleanupManager.trackPersistedData(mockData);
        Assertions.assertThrows(HoodieException.class, () -> this.cleanupManager.ensureDataCleanupOnException((SerializableFunctionUnchecked & Serializable)v -> {
            throw new HoodieException("Test exception");
        }));
        Assertions.assertEquals((int)3, (int)unpersistCount.get());
        ((HoodiePairData)Mockito.verify((Object)mockPairData1, (VerificationMode)Mockito.times((int)1))).unpersistWithDependencies();
        ((HoodiePairData)Mockito.verify((Object)mockPairData2, (VerificationMode)Mockito.times((int)1))).unpersistWithDependencies();
        ((HoodieData)Mockito.verify((Object)mockData, (VerificationMode)Mockito.times((int)1))).unpersistWithDependencies();
        Assertions.assertFalse((boolean)this.threadPersistedData.containsKey(threadId));
    }

    @Test
    void testCleanupContinuesWhenUnpersistFails() {
        long threadId = Thread.currentThread().getId();
        AtomicInteger unpersistCount = new AtomicInteger(0);
        HoodiePairData failingPairData = (HoodiePairData)Mockito.mock(HoodiePairData.class);
        HoodiePairData successfulPairData = (HoodiePairData)Mockito.mock(HoodiePairData.class);
        ((HoodiePairData)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Unpersist failed")}).when((Object)failingPairData)).unpersistWithDependencies();
        ((HoodiePairData)Mockito.doAnswer(invocation -> {
            unpersistCount.incrementAndGet();
            return null;
        }).when((Object)successfulPairData)).unpersistWithDependencies();
        this.cleanupManager.trackPersistedData(failingPairData);
        this.cleanupManager.trackPersistedData(successfulPairData);
        Assertions.assertThrows(HoodieException.class, () -> this.cleanupManager.ensureDataCleanupOnException((SerializableFunctionUnchecked & Serializable)v -> {
            throw new HoodieException("Test exception");
        }));
        ((HoodiePairData)Mockito.verify((Object)failingPairData, (VerificationMode)Mockito.times((int)1))).unpersistWithDependencies();
        ((HoodiePairData)Mockito.verify((Object)successfulPairData, (VerificationMode)Mockito.times((int)1))).unpersistWithDependencies();
        Assertions.assertEquals((int)1, (int)unpersistCount.get());
        Assertions.assertFalse((boolean)this.threadPersistedData.containsKey(threadId));
    }

    @Test
    public void testThreadIsolation() throws Exception {
        int i;
        int numThreads = 3;
        ExecutorService executor = Executors.newFixedThreadPool(numThreads);
        CountDownLatch startLatch = new CountDownLatch(1);
        CountDownLatch completionLatch = new CountDownLatch(numThreads);
        AtomicInteger[] unpersistCounts = new AtomicInteger[numThreads];
        for (i = 0; i < numThreads; ++i) {
            unpersistCounts[i] = new AtomicInteger(0);
        }
        i = 0;
        while (i < numThreads) {
            int threadIndex = i++;
            executor.submit(() -> {
                try {
                    startLatch.await();
                    HoodiePairData mockPairData = (HoodiePairData)Mockito.mock(HoodiePairData.class);
                    ((HoodiePairData)Mockito.doAnswer(invocation -> {
                        unpersistCounts[threadIndex].incrementAndGet();
                        return null;
                    }).when((Object)mockPairData)).unpersistWithDependencies();
                    this.cleanupManager.trackPersistedData(mockPairData);
                    Assertions.assertThrows(HoodieException.class, () -> this.cleanupManager.ensureDataCleanupOnException((SerializableFunctionUnchecked & Serializable)v -> {
                        throw new HoodieException("Thread " + threadIndex + " exception");
                    }));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    completionLatch.countDown();
                }
            });
        }
        startLatch.countDown();
        completionLatch.await();
        executor.shutdown();
        for (i = 0; i < numThreads; ++i) {
            Assertions.assertEquals((int)1, (int)unpersistCounts[i].get(), (String)("Thread " + i + " should have cleaned up exactly once"));
        }
        Assertions.assertTrue((boolean)this.threadPersistedData.isEmpty());
    }

    @Test
    void testUnsupportedObjectTypeInCleanup() {
        long threadId = Thread.currentThread().getId();
        Object unsupportedObject = new Object();
        this.threadPersistedData.computeIfAbsent(threadId, k -> new ArrayList()).add(unsupportedObject);
        HoodiePairData mockPairData = (HoodiePairData)Mockito.mock(HoodiePairData.class);
        AtomicInteger unpersistCount = new AtomicInteger(0);
        ((HoodiePairData)Mockito.doAnswer(invocation -> {
            unpersistCount.incrementAndGet();
            return null;
        }).when((Object)mockPairData)).unpersistWithDependencies();
        this.cleanupManager.trackPersistedData(mockPairData);
        Assertions.assertThrows(HoodieException.class, () -> this.cleanupManager.ensureDataCleanupOnException((SerializableFunctionUnchecked & Serializable)v -> {
            throw new HoodieException("Test exception");
        }));
        Assertions.assertEquals((int)1, (int)unpersistCount.get());
        ((HoodiePairData)Mockito.verify((Object)mockPairData, (VerificationMode)Mockito.times((int)1))).unpersistWithDependencies();
        Assertions.assertFalse((boolean)this.threadPersistedData.containsKey(threadId));
    }

    @Test
    void testNoPersistentDataScenario() {
        long threadId = Thread.currentThread().getId();
        Assertions.assertThrows(HoodieException.class, () -> this.cleanupManager.ensureDataCleanupOnException((SerializableFunctionUnchecked & Serializable)v -> {
            throw new HoodieException("Test exception");
        }));
        Assertions.assertFalse((boolean)this.threadPersistedData.containsKey(threadId));
    }

    @Test
    void testNullDataInCleanup() {
        long threadId = Thread.currentThread().getId();
        this.threadPersistedData.computeIfAbsent(threadId, k -> new ArrayList()).add(null);
        HoodiePairData mockPairData = (HoodiePairData)Mockito.mock(HoodiePairData.class);
        AtomicInteger unpersistCount = new AtomicInteger(0);
        ((HoodiePairData)Mockito.doAnswer(invocation -> {
            unpersistCount.incrementAndGet();
            return null;
        }).when((Object)mockPairData)).unpersistWithDependencies();
        this.cleanupManager.trackPersistedData(mockPairData);
        Assertions.assertThrows(HoodieException.class, () -> this.cleanupManager.ensureDataCleanupOnException((SerializableFunctionUnchecked & Serializable)v -> {
            throw new HoodieException("Test exception");
        }));
        Assertions.assertEquals((int)1, (int)unpersistCount.get());
        ((HoodiePairData)Mockito.verify((Object)mockPairData, (VerificationMode)Mockito.times((int)1))).unpersistWithDependencies();
        Assertions.assertFalse((boolean)this.threadPersistedData.containsKey(threadId));
    }
}

