/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.util.Collections;
import java.util.stream.Stream;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.metadata.HoodieIndexVersion;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestHoodieIndexVersion {
    @ParameterizedTest(name="{0}")
    @MethodSource(value={"getCurrentVersionTestCases"})
    public void testGetCurrentVersionWithString(String testName, HoodieTableVersion tableVersion, String partitionPath, HoodieIndexVersion expectedVersion) {
        HoodieIndexVersion result = HoodieIndexVersion.getCurrentVersion((HoodieTableVersion)tableVersion, (String)partitionPath);
        Assertions.assertEquals((Object)expectedVersion, (Object)result);
    }

    private static Stream<Arguments> getCurrentVersionTestCases() {
        return Stream.of(Arguments.of((Object[])new Object[]{"RECORD_INDEX", HoodieTableVersion.EIGHT, "record_index", HoodieIndexVersion.V1}), Arguments.of((Object[])new Object[]{"RECORD_INDEX", HoodieTableVersion.NINE, "record_index", HoodieIndexVersion.V1}), Arguments.of((Object[])new Object[]{"COLUMN_STATS", HoodieTableVersion.EIGHT, "column_stats", HoodieIndexVersion.V1}), Arguments.of((Object[])new Object[]{"COLUMN_STATS", HoodieTableVersion.NINE, "column_stats", HoodieIndexVersion.V2}), Arguments.of((Object[])new Object[]{"BLOOM_FILTERS", HoodieTableVersion.EIGHT, "bloom_filters", HoodieIndexVersion.V1}), Arguments.of((Object[])new Object[]{"BLOOM_FILTERS", HoodieTableVersion.NINE, "bloom_filters", HoodieIndexVersion.V1}), Arguments.of((Object[])new Object[]{"BLOOM_FILTERS", HoodieTableVersion.EIGHT, "expr_index_idx1", HoodieIndexVersion.V1}), Arguments.of((Object[])new Object[]{"BLOOM_FILTERS", HoodieTableVersion.NINE, "expr_index_idx1", HoodieIndexVersion.V2}), Arguments.of((Object[])new Object[]{"BLOOM_FILTERS", HoodieTableVersion.EIGHT, "secondary_index_idx1", HoodieIndexVersion.V1}), Arguments.of((Object[])new Object[]{"BLOOM_FILTERS", HoodieTableVersion.NINE, "secondary_index_idx1", HoodieIndexVersion.V2}), Arguments.of((Object[])new Object[]{"FILES", HoodieTableVersion.EIGHT, "files", HoodieIndexVersion.V1}), Arguments.of((Object[])new Object[]{"FILES", HoodieTableVersion.NINE, "files", HoodieIndexVersion.V1}), Arguments.of((Object[])new Object[]{"EXPRESSION INDEX", HoodieTableVersion.EIGHT, "files", HoodieIndexVersion.V1}), Arguments.of((Object[])new Object[]{"EXPRESSION INDEX", HoodieTableVersion.NINE, "files", HoodieIndexVersion.V1}), Arguments.of((Object[])new Object[]{"PARTITION_STATS", HoodieTableVersion.EIGHT, "partition_stats", HoodieIndexVersion.V1}), Arguments.of((Object[])new Object[]{"PARTITION_STATS", HoodieTableVersion.NINE, "partition_stats", HoodieIndexVersion.V2}));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"getCurrentVersionWithEnumTestCases"})
    public void testGetCurrentVersionWithEnum(String testName, HoodieTableVersion tableVersion, MetadataPartitionType partitionType, HoodieIndexVersion expectedVersion) {
        HoodieIndexVersion result = HoodieIndexVersion.getCurrentVersion((HoodieTableVersion)tableVersion, (MetadataPartitionType)partitionType);
        Assertions.assertEquals((Object)expectedVersion, (Object)result);
    }

    private static Stream<Arguments> getCurrentVersionWithEnumTestCases() {
        return Stream.of(Arguments.of((Object[])new Object[]{"RECORD_INDEX", HoodieTableVersion.EIGHT, MetadataPartitionType.RECORD_INDEX, HoodieIndexVersion.V1}), Arguments.of((Object[])new Object[]{"COLUMN_STATS", HoodieTableVersion.EIGHT, MetadataPartitionType.COLUMN_STATS, HoodieIndexVersion.V1}), Arguments.of((Object[])new Object[]{"BLOOM_FILTERS", HoodieTableVersion.EIGHT, MetadataPartitionType.BLOOM_FILTERS, HoodieIndexVersion.V1}), Arguments.of((Object[])new Object[]{"EXPRESSION_INDEX", HoodieTableVersion.EIGHT, MetadataPartitionType.EXPRESSION_INDEX, HoodieIndexVersion.V1}), Arguments.of((Object[])new Object[]{"FILES", HoodieTableVersion.EIGHT, MetadataPartitionType.FILES, HoodieIndexVersion.V1}), Arguments.of((Object[])new Object[]{"PARTITION_STATS", HoodieTableVersion.EIGHT, MetadataPartitionType.PARTITION_STATS, HoodieIndexVersion.V1}), Arguments.of((Object[])new Object[]{"ALL_PARTITIONS", HoodieTableVersion.EIGHT, MetadataPartitionType.ALL_PARTITIONS, HoodieIndexVersion.V1}));
    }

    @Test
    public void testGetCurrentVersionSecondaryIndexTableVersion8() {
        HoodieIndexVersion result = HoodieIndexVersion.getCurrentVersion((HoodieTableVersion)HoodieTableVersion.EIGHT, (MetadataPartitionType)MetadataPartitionType.SECONDARY_INDEX);
        Assertions.assertEquals((Object)HoodieIndexVersion.V1, (Object)result);
    }

    @Test
    public void testGetCurrentVersionSecondaryIndexTableVersion9() {
        HoodieIndexVersion result = HoodieIndexVersion.getCurrentVersion((HoodieTableVersion)HoodieTableVersion.NINE, (MetadataPartitionType)MetadataPartitionType.SECONDARY_INDEX);
        Assertions.assertEquals((Object)HoodieIndexVersion.V2, (Object)result);
    }

    @Test
    public void testGetCurrentVersionUnknownPartitionType() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> HoodieIndexVersion.getCurrentVersion((HoodieTableVersion)HoodieTableVersion.EIGHT, (String)"unknown_partition_type"));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"isValidIndexDefinitionTestCases"})
    public void testIsValidIndexDefinition(String testName, HoodieTableVersion tableVersion, HoodieIndexDefinition indexDef, boolean expectedResult) {
        boolean result = HoodieIndexVersion.isValidIndexDefinition((HoodieTableVersion)tableVersion, (HoodieIndexDefinition)indexDef);
        Assertions.assertEquals((Object)expectedResult, (Object)result);
    }

    private static Stream<Arguments> isValidIndexDefinitionTestCases() {
        return Stream.of(Arguments.of((Object[])new Object[]{"Table version 8 with SI v1", HoodieTableVersion.EIGHT, TestHoodieIndexVersion.createIndexDefinition("secondary_index_idx_test", HoodieIndexVersion.V1), true}), Arguments.of((Object[])new Object[]{"Table version 8 with SI v2", HoodieTableVersion.EIGHT, TestHoodieIndexVersion.createIndexDefinition("secondary_index_idx_test", HoodieIndexVersion.V2), false}), Arguments.of((Object[])new Object[]{"Table version 9 with SI v1", HoodieTableVersion.NINE, TestHoodieIndexVersion.createIndexDefinition("secondary_index_idx_test", HoodieIndexVersion.V1), true}), Arguments.of((Object[])new Object[]{"Table version 9 with SI v2", HoodieTableVersion.NINE, TestHoodieIndexVersion.createIndexDefinition("secondary_index_idx_test", HoodieIndexVersion.V2), true}), Arguments.of((Object[])new Object[]{"Table version 9 with non-SI v1", HoodieTableVersion.NINE, TestHoodieIndexVersion.createIndexDefinition("column_stats", HoodieIndexVersion.V1), true}), Arguments.of((Object[])new Object[]{"Table version 9 with null version", HoodieTableVersion.NINE, TestHoodieIndexVersion.createIndexDefinition("column_stats", null), false}), Arguments.of((Object[])new Object[]{"Table version 9 with v1", HoodieTableVersion.NINE, TestHoodieIndexVersion.createIndexDefinition("secondary_index_idx_test", null), false}));
    }

    private static HoodieIndexDefinition createIndexDefinition(String indexName, HoodieIndexVersion version) {
        HoodieIndexDefinition.Builder builder = HoodieIndexDefinition.newBuilder().withIndexName(indexName).withIndexType(MetadataPartitionType.fromPartitionPath((String)indexName).name()).withSourceFields(Collections.singletonList("test_field"));
        if (version != null) {
            builder.withVersion(version);
        }
        return builder.build();
    }

    @Test
    public void testComparisonMethods() {
        Assertions.assertTrue((boolean)HoodieIndexVersion.V2.greaterThan(HoodieIndexVersion.V1));
        Assertions.assertFalse((boolean)HoodieIndexVersion.V1.greaterThan(HoodieIndexVersion.V2));
        Assertions.assertFalse((boolean)HoodieIndexVersion.V1.greaterThan(HoodieIndexVersion.V1));
        Assertions.assertTrue((boolean)HoodieIndexVersion.V2.greaterThanOrEquals(HoodieIndexVersion.V1));
        Assertions.assertTrue((boolean)HoodieIndexVersion.V1.greaterThanOrEquals(HoodieIndexVersion.V1));
        Assertions.assertFalse((boolean)HoodieIndexVersion.V1.greaterThanOrEquals(HoodieIndexVersion.V2));
        Assertions.assertTrue((boolean)HoodieIndexVersion.V1.lowerThan(HoodieIndexVersion.V2));
        Assertions.assertFalse((boolean)HoodieIndexVersion.V2.lowerThan(HoodieIndexVersion.V1));
        Assertions.assertFalse((boolean)HoodieIndexVersion.V1.lowerThan(HoodieIndexVersion.V1));
        Assertions.assertTrue((boolean)HoodieIndexVersion.V1.lowerThanOrEquals(HoodieIndexVersion.V2));
        Assertions.assertTrue((boolean)HoodieIndexVersion.V1.lowerThanOrEquals(HoodieIndexVersion.V1));
        Assertions.assertFalse((boolean)HoodieIndexVersion.V2.lowerThanOrEquals(HoodieIndexVersion.V1));
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"V1", (Object)HoodieIndexVersion.V1.toString());
        Assertions.assertEquals((Object)"V2", (Object)HoodieIndexVersion.V2.toString());
    }

    @Test
    public void testBuilderWithNullValuesThrowsException() {
        Assertions.assertThrows(NullPointerException.class, () -> HoodieIndexDefinition.newBuilder().withIndexName(null).withIndexType("COLUMN_STATS").withSourceFields(Collections.singletonList("test_field")).withVersion(HoodieIndexVersion.V1).build());
        Assertions.assertThrows(IllegalArgumentException.class, () -> HoodieIndexDefinition.newBuilder().withIndexType("COLUMN_STATS").withSourceFields(Collections.singletonList("test_field")).withVersion(HoodieIndexVersion.V1).build());
        Assertions.assertThrows(IllegalArgumentException.class, () -> HoodieIndexDefinition.newBuilder().withIndexName("test_index").withIndexType(null).withSourceFields(Collections.singletonList("test_field")).withVersion(HoodieIndexVersion.V1).build());
        Assertions.assertThrows(IllegalArgumentException.class, () -> HoodieIndexDefinition.newBuilder().withIndexName("test_index").withSourceFields(Collections.singletonList("test_field")).withVersion(HoodieIndexVersion.V1).build());
        Assertions.assertThrows(IllegalArgumentException.class, () -> HoodieIndexDefinition.newBuilder().withIndexName("test_index").withIndexType("COLUMN_STATS").withSourceFields(Collections.singletonList("test_field")).withVersion(null).build());
        Assertions.assertThrows(IllegalArgumentException.class, () -> HoodieIndexDefinition.newBuilder().withIndexName("test_index").withIndexType("COLUMN_STATS").withSourceFields(Collections.singletonList("test_field")).build());
    }
}

