/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.hudi.common.function.SerializableBiFunction;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.model.HoodieIndexMetadata;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.metadata.HoodieIndexVersion;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.SecondaryIndexKeyUtils;
import org.apache.hudi.metadata.SecondaryIndexPrefixRawKey;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class TestHoodieTableMetadataUtil {
    TestHoodieTableMetadataUtil() {
    }

    @Test
    void testGetRecordKeyToFileGroupIndexFunction() {
        int numFileGroups = 10;
        String recordKey = "recordKey$";
        String secondaryKey = "secondaryKey$";
        SecondaryIndexPrefixRawKey rawKey1 = new SecondaryIndexPrefixRawKey(secondaryKey);
        String compositeKey = SecondaryIndexKeyUtils.constructSecondaryIndexKey((String)secondaryKey, (String)recordKey);
        SerializableBiFunction hashOnSecKeyOnly = HoodieTableMetadataUtil.getSecondaryKeyToFileGroupMappingFunction((boolean)true);
        SerializableBiFunction hashOnFullKey = HoodieTableMetadataUtil.getSecondaryKeyToFileGroupMappingFunction((boolean)false);
        int result1 = (Integer)hashOnSecKeyOnly.apply((Object)compositeKey, (Object)numFileGroups);
        int result2 = (Integer)hashOnFullKey.apply((Object)rawKey1.encode(), (Object)numFileGroups);
        Assertions.assertEquals((int)result1, (int)result2);
    }

    @Test
    void testGetIndexVersionNoMetadata() {
        HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        Mockito.when((Object)metaClient.getIndexMetadata()).thenReturn((Object)Option.empty());
        Option result = HoodieTableMetadataUtil.getIndexVersionOption((String)"column_stats", (HoodieTableMetaClient)metaClient);
        Assertions.assertFalse((boolean)result.isPresent());
    }

    @Test
    void testGetIndexVersionNoPartitions() {
        HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        HoodieIndexMetadata indexMetadata = (HoodieIndexMetadata)Mockito.mock(HoodieIndexMetadata.class);
        Mockito.when((Object)metaClient.getIndexMetadata()).thenReturn((Object)Option.of((Object)indexMetadata));
        Mockito.when((Object)indexMetadata.getIndexDefinitions()).thenReturn(Collections.emptyMap());
        Option result = HoodieTableMetadataUtil.getIndexVersionOption((String)"column_stats", (HoodieTableMetaClient)metaClient);
        Assertions.assertFalse((boolean)result.isPresent());
    }

    @Test
    void testGetColStatsVersionPartitionStatsExists() {
        HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        HoodieIndexMetadata indexMetadata = (HoodieIndexMetadata)Mockito.mock(HoodieIndexMetadata.class);
        HoodieIndexVersion version = HoodieIndexVersion.V1;
        HoodieIndexDefinition def = (HoodieIndexDefinition)Mockito.mock(HoodieIndexDefinition.class);
        Mockito.when((Object)def.getVersion()).thenReturn((Object)version);
        Map<String, HoodieIndexDefinition> indexDefs = Collections.singletonMap("partition_stats", def);
        Mockito.when((Object)metaClient.getIndexMetadata()).thenReturn((Object)Option.of((Object)indexMetadata));
        Mockito.when((Object)indexMetadata.getIndexDefinitions()).thenReturn(indexDefs);
        Option result = HoodieTableMetadataUtil.getIndexVersionOption((String)"column_stats", (HoodieTableMetaClient)metaClient);
        Assertions.assertTrue((boolean)result.isPresent());
        Assertions.assertEquals((Object)version, (Object)result.get());
    }

    @Test
    void testGetPartitionStatsVersionColStatsExists() {
        HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        HoodieIndexMetadata indexMetadata = (HoodieIndexMetadata)Mockito.mock(HoodieIndexMetadata.class);
        HoodieIndexVersion version = HoodieIndexVersion.V1;
        HoodieIndexDefinition def = (HoodieIndexDefinition)Mockito.mock(HoodieIndexDefinition.class);
        Mockito.when((Object)def.getVersion()).thenReturn((Object)version);
        Map<String, HoodieIndexDefinition> indexDefs = Collections.singletonMap("column_stats", def);
        Mockito.when((Object)metaClient.getIndexMetadata()).thenReturn((Object)Option.of((Object)indexMetadata));
        Mockito.when((Object)indexMetadata.getIndexDefinitions()).thenReturn(indexDefs);
        Option result = HoodieTableMetadataUtil.getIndexVersionOption((String)"partition_stats", (HoodieTableMetaClient)metaClient);
        Assertions.assertTrue((boolean)result.isPresent());
        Assertions.assertEquals((Object)version, (Object)result.get());
    }

    @Test
    void testGetColAndPartitionStatsIndexBothExist() {
        HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        HoodieIndexMetadata indexMetadata = (HoodieIndexMetadata)Mockito.mock(HoodieIndexMetadata.class);
        HoodieIndexVersion version = HoodieIndexVersion.V1;
        HoodieIndexDefinition defColStats = (HoodieIndexDefinition)Mockito.mock(HoodieIndexDefinition.class);
        Mockito.when((Object)defColStats.getVersion()).thenReturn((Object)version);
        HoodieIndexVersion otherVersion = HoodieIndexVersion.V2;
        HoodieIndexDefinition defPartStats = (HoodieIndexDefinition)Mockito.mock(HoodieIndexDefinition.class);
        Mockito.when((Object)defPartStats.getVersion()).thenReturn((Object)otherVersion);
        HashMap<String, HoodieIndexDefinition> indexDefs = new HashMap<String, HoodieIndexDefinition>(2);
        indexDefs.put("column_stats", defColStats);
        indexDefs.put("partition_stats", defPartStats);
        Mockito.when((Object)metaClient.getIndexMetadata()).thenReturn((Object)Option.of((Object)indexMetadata));
        Mockito.when((Object)indexMetadata.getIndexDefinitions()).thenReturn(indexDefs);
        Option result = HoodieTableMetadataUtil.getIndexVersionOption((String)"column_stats", (HoodieTableMetaClient)metaClient);
        Assertions.assertTrue((boolean)result.isPresent());
        Assertions.assertEquals((Object)version, (Object)result.get());
        result = HoodieTableMetadataUtil.getIndexVersionOption((String)"partition_stats", (HoodieTableMetaClient)metaClient);
        Assertions.assertTrue((boolean)result.isPresent());
        Assertions.assertEquals((Object)otherVersion, (Object)result.get());
    }

    @Test
    void testGetArbitraryIndexVersion() {
        String indexName = "asdf";
        HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        HoodieIndexMetadata indexMetadata = (HoodieIndexMetadata)Mockito.mock(HoodieIndexMetadata.class);
        HoodieIndexVersion version = HoodieIndexVersion.V1;
        HoodieIndexDefinition def = (HoodieIndexDefinition)Mockito.mock(HoodieIndexDefinition.class);
        Mockito.when((Object)def.getVersion()).thenReturn((Object)version);
        Map<String, HoodieIndexDefinition> indexDefs = Collections.singletonMap(indexName, def);
        Mockito.when((Object)metaClient.getIndexMetadata()).thenReturn((Object)Option.of((Object)indexMetadata));
        Mockito.when((Object)indexMetadata.getIndexDefinitions()).thenReturn(indexDefs);
        Option result = HoodieTableMetadataUtil.getIndexVersionOption((String)indexName, (HoodieTableMetaClient)metaClient);
        Assertions.assertTrue((boolean)result.isPresent());
        Assertions.assertEquals((Object)version, (Object)result.get());
    }

    @Test
    void testFiltersOutTimestampMillisColumns() {
        Schema tableSchema = (Schema)SchemaBuilder.record((String)"record").fields().requiredString("name").name("created_at").type(LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().requiredInt("age").endRecord();
        List<String> inputCols = Arrays.asList("name", "created_at", "age");
        HoodieIndexDefinition indexDefinition = HoodieIndexDefinition.newBuilder().withVersion(HoodieIndexVersion.V1).withSourceFields(inputCols).withIndexName("column_stats").withIndexType("column_stats").build();
        HoodieTableConfig tableConfig = (HoodieTableConfig)Mockito.mock(HoodieTableConfig.class);
        Mockito.when((Object)tableConfig.getTableInitialVersion()).thenReturn((Object)HoodieTableVersion.NINE);
        List result = HoodieTableMetadataUtil.getValidIndexedColumns((HoodieIndexDefinition)indexDefinition, (Schema)tableSchema, (HoodieTableConfig)tableConfig);
        Assertions.assertEquals(Arrays.asList("name", "age"), (Object)result);
        Assertions.assertFalse((boolean)result.contains("created_at"), (String)"Timestamp-millis field should be excluded");
        indexDefinition = HoodieIndexDefinition.newBuilder().withVersion(HoodieIndexVersion.V2).withSourceFields(inputCols).withIndexName("column_stats").withIndexType("column_stats").build();
        result = HoodieTableMetadataUtil.getValidIndexedColumns((HoodieIndexDefinition)indexDefinition, (Schema)tableSchema, (HoodieTableConfig)tableConfig);
        Assertions.assertEquals(Arrays.asList("name", "created_at", "age"), (Object)result);
        HoodieTableConfig newTableConfig = (HoodieTableConfig)Mockito.mock(HoodieTableConfig.class);
        Mockito.when((Object)newTableConfig.getTableInitialVersion()).thenReturn((Object)HoodieTableVersion.SIX);
        result = HoodieTableMetadataUtil.getValidIndexedColumns((HoodieIndexDefinition)indexDefinition, (Schema)tableSchema, (HoodieTableConfig)newTableConfig);
        Assertions.assertEquals(Arrays.asList("name", "age"), (Object)result);
        inputCols = Arrays.asList("name", "age");
        indexDefinition = HoodieIndexDefinition.newBuilder().withVersion(HoodieIndexVersion.V1).withIndexName("column_stats").withIndexType("column_stats").withSourceFields(inputCols).build();
        result = HoodieTableMetadataUtil.getValidIndexedColumns((HoodieIndexDefinition)indexDefinition, (Schema)tableSchema, (HoodieTableConfig)tableConfig);
        Assertions.assertEquals(inputCols, (Object)result, (String)"Non-timestamp columns should remain unchanged");
        indexDefinition = HoodieIndexDefinition.newBuilder().withVersion(HoodieIndexVersion.V1).withSourceFields(Collections.emptyList()).withIndexName("column_stats").withIndexType("column_stats").build();
        result = HoodieTableMetadataUtil.getValidIndexedColumns((HoodieIndexDefinition)indexDefinition, (Schema)tableSchema, (HoodieTableConfig)tableConfig);
        Assertions.assertTrue((boolean)result.isEmpty(), (String)"Expected empty output for empty input");
    }

    @Test
    void testFilterNestedLogicalTimestampColumn() {
        Schema nestedSchema = (Schema)SchemaBuilder.record((String)"RootRecord").fields().name("user").type((Schema)SchemaBuilder.record((String)"UserRecord").fields().name("profile").type((Schema)SchemaBuilder.record((String)"ProfileRecord").fields().name("ts_millis").type(LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().name("ts_micros").type(LogicalTypes.timestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().name("display_name").type().stringType().noDefault().endRecord()).noDefault().name("age").type().intType().noDefault().endRecord()).noDefault().name("event_id").type().stringType().noDefault().endRecord();
        List<String> inputCols = Arrays.asList("event_id", "user.profile.ts_millis", "user.profile.ts_micros", "user.profile.display_name", "user.age");
        HoodieIndexDefinition indexDefinition = HoodieIndexDefinition.newBuilder().withVersion(HoodieIndexVersion.V1).withIndexName("column_stats").withIndexType("column_stats").withSourceFields(inputCols).build();
        HoodieTableConfig tableConfig = (HoodieTableConfig)Mockito.mock(HoodieTableConfig.class);
        Mockito.when((Object)tableConfig.getTableInitialVersion()).thenReturn((Object)HoodieTableVersion.NINE);
        List result = HoodieTableMetadataUtil.getValidIndexedColumns((HoodieIndexDefinition)indexDefinition, (Schema)nestedSchema, (HoodieTableConfig)tableConfig);
        Assertions.assertEquals(Arrays.asList("event_id", "user.profile.ts_micros", "user.profile.display_name", "user.age"), (Object)result, (String)"Nested timestamp-millis field should be filtered out");
    }

    @Test
    void testIsTimestampMillisField() {
        Schema timestampMillisSchema = Schema.create((Schema.Type)Schema.Type.LONG);
        LogicalTypes.timestampMillis().addToSchema(timestampMillisSchema);
        Assertions.assertTrue((boolean)HoodieTableMetadataUtil.isTimestampMillisField((Schema)timestampMillisSchema), (String)"Should return true for timestamp-millis");
        Schema localTimestampMillisSchema = Schema.create((Schema.Type)Schema.Type.LONG);
        LogicalTypes.localTimestampMillis().addToSchema(localTimestampMillisSchema);
        Assertions.assertTrue((boolean)HoodieTableMetadataUtil.isTimestampMillisField((Schema)localTimestampMillisSchema), (String)"Should return true for local-timestamp-millis");
        Schema nullableTimestampMillisSchema = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), timestampMillisSchema});
        Assertions.assertTrue((boolean)HoodieTableMetadataUtil.isTimestampMillisField((Schema)nullableTimestampMillisSchema), (String)"Should return true for nullable timestamp-millis");
        Schema timestampMicrosSchema = Schema.create((Schema.Type)Schema.Type.LONG);
        LogicalTypes.timestampMicros().addToSchema(timestampMicrosSchema);
        Assertions.assertFalse((boolean)HoodieTableMetadataUtil.isTimestampMillisField((Schema)timestampMicrosSchema), (String)"Should return false for timestamp-micros");
        Schema longSchema = Schema.create((Schema.Type)Schema.Type.LONG);
        Assertions.assertFalse((boolean)HoodieTableMetadataUtil.isTimestampMillisField((Schema)longSchema), (String)"Should return false for regular long");
        Schema stringSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        Assertions.assertFalse((boolean)HoodieTableMetadataUtil.isTimestampMillisField((Schema)stringSchema), (String)"Should return false for string");
    }
}

