/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.util.stream.Stream;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.metadata.SecondaryIndexKeyUtils;
import org.apache.hudi.metadata.SecondaryIndexPrefixRawKey;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

public class TestSecondaryIndexKeyUtils {
    private static String generateString(String str, int count) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append(str);
        }
        return sb.toString();
    }

    @ParameterizedTest(name="Escape/unescape round-trip: input='{0}', expectedEscaped='{1}'")
    @MethodSource(value={"escapeUnescapeRoundTripTestCases"})
    public void testEscapeUnescapeRoundTrip(String input, String expectedEscaped) {
        String escaped = SecondaryIndexKeyUtils.escapeSpecialChars((String)input);
        Assertions.assertEquals((Object)expectedEscaped, (Object)escaped);
        String unescaped = SecondaryIndexKeyUtils.unescapeSpecialChars((String)escaped);
        if (input == null) {
            Assertions.assertNull((Object)unescaped);
        } else {
            Assertions.assertEquals((Object)input, (Object)unescaped);
        }
    }

    private static Stream<Arguments> escapeUnescapeRoundTripTestCases() {
        return Stream.of(Arguments.of((Object[])new Object[]{null, "\u0000"}), Arguments.of((Object[])new Object[]{"", ""}), Arguments.of((Object[])new Object[]{"normal", "normal"}), Arguments.of((Object[])new Object[]{"with spaces", "with spaces"}), Arguments.of((Object[])new Object[]{"with_underscore", "with_underscore"}), Arguments.of((Object[])new Object[]{"$", "\\$"}), Arguments.of((Object[])new Object[]{"\\", "\\\\"}), Arguments.of((Object[])new Object[]{"\u0000", "\\\u0000"}), Arguments.of((Object[])new Object[]{"$$$", "\\$\\$\\$"}), Arguments.of((Object[])new Object[]{"\\\\", "\\\\\\\\"}), Arguments.of((Object[])new Object[]{"\u0000\u0000\u0000", "\\\u0000\\\u0000\\\u0000"}), Arguments.of((Object[])new Object[]{"$\\", "\\$\\\\"}), Arguments.of((Object[])new Object[]{"\\$", "\\\\\\$"}), Arguments.of((Object[])new Object[]{"$\u0000", "\\$\\\u0000"}), Arguments.of((Object[])new Object[]{"\\$\u0000", "\\\\\\$\\\u0000"}), Arguments.of((Object[])new Object[]{"user$id", "user\\$id"}), Arguments.of((Object[])new Object[]{"path\\to\\file", "path\\\\to\\\\file"}), Arguments.of((Object[])new Object[]{"null\u0000char", "null\\\u0000char"}), Arguments.of((Object[])new Object[]{"$start", "\\$start"}), Arguments.of((Object[])new Object[]{"$start", "\\$start"}), Arguments.of((Object[])new Object[]{"end$", "end\\$"}), Arguments.of((Object[])new Object[]{"mid$dle", "mid\\$dle"}), Arguments.of((Object[])new Object[]{"\\$mixed$\\", "\\\\\\$mixed\\$\\\\"}), Arguments.of((Object[])new Object[]{"all$special\\chars\u0000here", "all\\$special\\\\chars\\\u0000here"}), Arguments.of((Object[])new Object[]{"\u7528\u6237$ID", "\u7528\u6237\\$ID"}), Arguments.of((Object[])new Object[]{"\u8bb0\u5f55\\123", "\u8bb0\u5f55\\\\123"}), Arguments.of((Object[])new Object[]{"\ud83d\ude00$emoji\\test\u0000", "\ud83d\ude00\\$emoji\\\\test\\\u0000"}), Arguments.of((Object[])new Object[]{"end_with_backslash\\", "end_with_backslash\\\\"}), Arguments.of((Object[])new Object[]{"\\start_with_backslash", "\\\\start_with_backslash"}), Arguments.of((Object[])new Object[]{"$$$$\\\\\\\\\\\\\\\\", "\\$\\$\\$\\$\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"}), Arguments.of((Object[])new Object[]{"\u0000\u0000$$$\\\\\\", "\\\u0000\\\u0000\\$\\$\\$\\\\\\\\\\\\"}));
    }

    @Test
    public void testUnescapeSpecialScenarios() {
        Assertions.assertEquals((Object)"test", (Object)SecondaryIndexKeyUtils.unescapeSpecialChars((String)"test\\"));
        Assertions.assertEquals((Object)"\\", (Object)SecondaryIndexKeyUtils.unescapeSpecialChars((String)"\\\\\\"));
        Assertions.assertEquals((Object)"a", (Object)SecondaryIndexKeyUtils.unescapeSpecialChars((String)"\\a"));
        Assertions.assertEquals((Object)"test", (Object)SecondaryIndexKeyUtils.unescapeSpecialChars((String)"\\test"));
        Assertions.assertEquals((Object)"ab", (Object)SecondaryIndexKeyUtils.unescapeSpecialChars((String)"\\a\\b"));
    }

    @ParameterizedTest(name="Get unescaped secondary key: input='{0}', expected='{1}'")
    @MethodSource(value={"getUnescapedSecondaryKeyTestCases"})
    public void testGetUnescapedSecondaryKeyFromSecondaryIndexKey(String encodedKey, String expectedSecondaryKey) {
        String actualSecondaryKey = SecondaryIndexKeyUtils.getUnescapedSecondaryKeyFromSecondaryIndexKey((String)encodedKey);
        Assertions.assertEquals((Object)expectedSecondaryKey, (Object)actualSecondaryKey);
    }

    private static Stream<Arguments> getUnescapedSecondaryKeyTestCases() {
        return Stream.of(Arguments.of((Object[])new Object[]{"key$value", "key"}), Arguments.of((Object[])new Object[]{"$value", ""}), Arguments.of((Object[])new Object[]{"key$", "key"}), Arguments.of((Object[])new Object[]{"$", ""}), Arguments.of((Object[])new Object[]{"key\\$part$value", "key\\$part"}), Arguments.of((Object[])new Object[]{"\\$start$value", "\\$start"}), Arguments.of((Object[])new Object[]{"end\\$$value", "end\\$"}), Arguments.of((Object[])new Object[]{"\\$$value", "\\$"}), Arguments.of((Object[])new Object[]{"\\\\$value", "\\\\"}), Arguments.of((Object[])new Object[]{"\\$\\$$value", "\\$\\$"}), Arguments.of((Object[])new Object[]{"key\\\\\\$part$value", "key\\\\\\$part"}), Arguments.of((Object[])new Object[]{"user\\$id\\\\test$record123", "user\\$id\\\\test"}), Arguments.of((Object[])new Object[]{"\\\u0000\\$\\\\$value", "\\\u0000\\$\\\\"}), Arguments.of((Object[])new Object[]{"escaped\\$dollar\\\\backslash$record", "escaped\\$dollar\\\\backslash"}), Arguments.of((Object[])new Object[]{"\u7528\u6237\\$ID$\u8bb0\u5f55123", "\u7528\u6237\\$ID"}), Arguments.of((Object[])new Object[]{"\ud83d\ude00\\$emoji$test", "\ud83d\ude00\\$emoji"}), Arguments.of((Object[])new Object[]{"a$b$c", "a"}), Arguments.of((Object[])new Object[]{"a\\$b$c$d", "a\\$b"}), Arguments.of((Object[])new Object[]{"\\$\\$\\$$real", "\\$\\$\\$"}), Arguments.of((Object[])new Object[]{TestSecondaryIndexKeyUtils.generateString("a", 1000) + "$" + TestSecondaryIndexKeyUtils.generateString("b", 1000), TestSecondaryIndexKeyUtils.generateString("a", 1000)}), Arguments.of((Object[])new Object[]{TestSecondaryIndexKeyUtils.generateString("\\$", 100) + "$value", TestSecondaryIndexKeyUtils.generateString("\\$", 100)}));
    }

    @Test
    public void testGetSecondaryKeyFromSecondaryIndexKeySmokeTests() {
        String key1 = "user\\$id$record123";
        Assertions.assertEquals((Object)"user$id", (Object)SecondaryIndexKeyUtils.getSecondaryKeyFromSecondaryIndexKey((String)key1));
        String key2 = "\u0000$record123";
        Assertions.assertNull((Object)SecondaryIndexKeyUtils.getSecondaryKeyFromSecondaryIndexKey((String)key2));
        String key3 = "\\\\\\$test\\\u0000$value";
        Assertions.assertEquals((Object)"\\$test\u0000", (Object)SecondaryIndexKeyUtils.getSecondaryKeyFromSecondaryIndexKey((String)key3));
        String key4 = "$record";
        Assertions.assertEquals((Object)"", (Object)SecondaryIndexKeyUtils.getSecondaryKeyFromSecondaryIndexKey((String)key4));
    }

    @ParameterizedTest(name="Key construction round-trip: secondaryKey='{0}', recordKey='{1}'")
    @MethodSource(value={"keyConstructionRoundTripTestCases"})
    public void testKeyConstructionRoundTrip(String secondaryKey, String recordKey) {
        String constructedKey = SecondaryIndexKeyUtils.constructSecondaryIndexKey((String)secondaryKey, (String)recordKey);
        Assertions.assertEquals((Object)new SecondaryIndexPrefixRawKey(secondaryKey).encode(), (Object)SecondaryIndexKeyUtils.getUnescapedSecondaryKeyPrefixFromSecondaryIndexKey((String)constructedKey));
        String extractedSecondary = SecondaryIndexKeyUtils.getSecondaryKeyFromSecondaryIndexKey((String)constructedKey);
        String extractedRecord = SecondaryIndexKeyUtils.getRecordKeyFromSecondaryIndexKey((String)constructedKey);
        if (secondaryKey == null) {
            Assertions.assertNull((Object)extractedSecondary);
        } else {
            Assertions.assertEquals((Object)secondaryKey, (Object)extractedSecondary);
        }
        if (recordKey == null) {
            Assertions.assertNull((Object)extractedRecord);
        } else {
            Assertions.assertEquals((Object)recordKey, (Object)extractedRecord);
        }
        Pair secondaryRecordPair = SecondaryIndexKeyUtils.getSecondaryKeyRecordKeyPair((String)constructedKey);
        Pair recordSecondaryPair = SecondaryIndexKeyUtils.getRecordKeySecondaryKeyPair((String)constructedKey);
        if (secondaryKey == null) {
            Assertions.assertNull((Object)secondaryRecordPair.getLeft());
            Assertions.assertNull((Object)recordSecondaryPair.getRight());
        } else {
            Assertions.assertEquals((Object)secondaryKey, (Object)secondaryRecordPair.getLeft());
            Assertions.assertEquals((Object)secondaryKey, (Object)recordSecondaryPair.getRight());
        }
        if (recordKey == null) {
            Assertions.assertNull((Object)secondaryRecordPair.getRight());
            Assertions.assertNull((Object)recordSecondaryPair.getLeft());
        } else {
            Assertions.assertEquals((Object)recordKey, (Object)secondaryRecordPair.getRight());
            Assertions.assertEquals((Object)recordKey, (Object)recordSecondaryPair.getLeft());
        }
    }

    private static Stream<Arguments> keyConstructionRoundTripTestCases() {
        return Stream.of(Arguments.of((Object[])new Object[]{"user_id", "record_123"}), Arguments.of((Object[])new Object[]{"", ""}), Arguments.of((Object[])new Object[]{"simple", "simple"}), Arguments.of((Object[])new Object[]{null, "record123"}), Arguments.of((Object[])new Object[]{"secondary123", null}), Arguments.of((Object[])new Object[]{null, null}), Arguments.of((Object[])new Object[]{"", "record_123"}), Arguments.of((Object[])new Object[]{"user_id", ""}), Arguments.of((Object[])new Object[]{"user$id", "record$123"}), Arguments.of((Object[])new Object[]{"path\\to\\file", "another\\path"}), Arguments.of((Object[])new Object[]{"null\u0000char", "another\u0000null"}), Arguments.of((Object[])new Object[]{"$", "$"}), Arguments.of((Object[])new Object[]{"\\", "\\"}), Arguments.of((Object[])new Object[]{"\u0000", "\u0000"}), Arguments.of((Object[])new Object[]{"user\\\\id", "record\\\\123"}), Arguments.of((Object[])new Object[]{"user\\$id\\0", "record\\$123\\0"}), Arguments.of((Object[])new Object[]{"\\$\\0\\", "\\$\\0\\"}), Arguments.of((Object[])new Object[]{"mixed$\\special\u0000", "chars$\\here\u0000"}), Arguments.of((Object[])new Object[]{"\\$\\0", "\\$\\0"}), Arguments.of((Object[])new Object[]{"\u7528\u6237ID", "\u8bb0\u5f55123"}), Arguments.of((Object[])new Object[]{"\ud83d\ude00$emoji", "test\\value"}), Arguments.of((Object[])new Object[]{"user\\$id", "rec\\$123"}), Arguments.of((Object[])new Object[]{"\\\\\\$\u0000", "\\\\\\$\u0000"}));
    }

    @ParameterizedTest(name="Invalid key format: '{0}'")
    @ValueSource(strings={"", "no_delimiter", "\u0000", "\\\u0000", "\\\\", "\\", "key\\$key", "key\\\\\\$key"})
    public void testInvalidKeyFormats(String invalidKey) {
        Assertions.assertThrows(IllegalStateException.class, () -> SecondaryIndexKeyUtils.getSecondaryKeyFromSecondaryIndexKey((String)invalidKey));
        Assertions.assertThrows(IllegalStateException.class, () -> SecondaryIndexKeyUtils.getRecordKeyFromSecondaryIndexKey((String)invalidKey));
    }

    @Test
    public void testBoundaryConditions() {
        StringBuilder longSecondaryKeyBuilder = new StringBuilder();
        StringBuilder longRecordKeyBuilder = new StringBuilder();
        for (int i = 0; i < 1000; ++i) {
            longSecondaryKeyBuilder.append('a');
            longRecordKeyBuilder.append('b');
        }
        String longSecondaryKey = longSecondaryKeyBuilder.toString();
        String longRecordKey = longRecordKeyBuilder.toString();
        String constructedKey = SecondaryIndexKeyUtils.constructSecondaryIndexKey((String)longSecondaryKey, (String)longRecordKey);
        Assertions.assertEquals((Object)(longSecondaryKey + "$" + longRecordKey), (Object)constructedKey);
        String extractedSecondaryKey = SecondaryIndexKeyUtils.getSecondaryKeyFromSecondaryIndexKey((String)constructedKey);
        Assertions.assertEquals((Object)longSecondaryKey, (Object)extractedSecondaryKey);
        String extractedRecordKey = SecondaryIndexKeyUtils.getRecordKeyFromSecondaryIndexKey((String)constructedKey);
        Assertions.assertEquals((Object)longRecordKey, (Object)extractedRecordKey);
        String onlySpecialChars = "\\$\\0";
        constructedKey = SecondaryIndexKeyUtils.constructSecondaryIndexKey((String)onlySpecialChars, (String)onlySpecialChars);
        Assertions.assertEquals((Object)"\\\\\\$\\\\0$\\\\\\$\\\\0", (Object)constructedKey);
        extractedSecondaryKey = SecondaryIndexKeyUtils.getSecondaryKeyFromSecondaryIndexKey((String)constructedKey);
        Assertions.assertEquals((Object)onlySpecialChars, (Object)extractedSecondaryKey);
        extractedRecordKey = SecondaryIndexKeyUtils.getRecordKeyFromSecondaryIndexKey((String)constructedKey);
        Assertions.assertEquals((Object)onlySpecialChars, (Object)extractedRecordKey);
    }
}

