/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.tableformat;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.versioning.v2.ActiveTimelineV2;
import org.apache.hudi.common.table.timeline.versioning.v2.InstantComparatorV2;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.tableformat.TestTableFormat;

public class TestActiveTimeline
extends ActiveTimelineV2 {
    public TestActiveTimeline(HoodieTableMetaClient metaClient, Set<String> includedExtensions, boolean applyLayoutFilters) {
        this.setInstants(this.getInstantsFromFileSystem(metaClient, includedExtensions, applyLayoutFilters));
        this.metaClient = metaClient;
    }

    public TestActiveTimeline(HoodieTableMetaClient metaClient) {
        this(metaClient, Collections.unmodifiableSet(VALID_EXTENSIONS_IN_ACTIVE_TIMELINE), true);
    }

    public TestActiveTimeline(HoodieTableMetaClient metaClient, boolean applyLayoutFilters) {
        this(metaClient, Collections.unmodifiableSet(VALID_EXTENSIONS_IN_ACTIVE_TIMELINE), applyLayoutFilters);
    }

    public TestActiveTimeline() {
    }

    protected List<HoodieInstant> getInstantsFromFileSystem(HoodieTableMetaClient metaClient, Set<String> includedExtensions, boolean applyLayoutFilters) {
        Map<Pair, HoodieInstant> instantsInTestTableFormat = TestTableFormat.getRecordedInstants(metaClient.getBasePath().toString()).stream().collect(Collectors.toMap(instant -> Pair.of((Object)instant.requestedTime(), (Object)instant.getAction()), instant -> instant));
        List instantsFromHoodieTimeline = super.getInstantsFromFileSystem(metaClient, includedExtensions, applyLayoutFilters);
        List inflightInstantsInTestTableFormat = instantsFromHoodieTimeline.stream().filter(hoodieInstant -> !instantsInTestTableFormat.containsKey(Pair.of((Object)hoodieInstant.requestedTime(), (Object)hoodieInstant.getAction()))).map(instant -> {
            if (instant.isCompleted()) {
                return new HoodieInstant(HoodieInstant.State.INFLIGHT, instant.getAction(), instant.requestedTime(), instant.getCompletionTime(), InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR);
            }
            return instant;
        }).collect(Collectors.toList());
        List completedInstantsInTestTableFormat = instantsInTestTableFormat.values().stream().filter(instantsFromHoodieTimeline::contains).collect(Collectors.toList());
        return Stream.concat(completedInstantsInTestTableFormat.stream(), inflightInstantsInTestTableFormat.stream()).sorted(InstantComparatorV2.REQUESTED_TIME_BASED_COMPARATOR).collect(Collectors.toList());
    }
}

